/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.SecondaryCapture;
import com.tiani.jvision.vis.VisData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SeqFactory {
    public static void captureViews(List<VisData> list, SCType sCType) {
        Object object;
        if (Product.isCDViewer() || sCType != SCType.FullScreen && list.isEmpty()) {
            return;
        }
        IDisplaySet iDisplaySet = null;
        DataManager dataManager = DataManager.getInstance();
        ISeriesData iSeriesData = null;
        IPatientRepresentation iPatientRepresentation = null;
        if (sCType == SCType.Append) {
            iSeriesData = list.get(0).getFrameData().getMainFrame().getParent();
            iPatientRepresentation = dataManager.getPatientRepresentation(iSeriesData.getParent().getParent().getKey());
            object = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
            int n = ((IDisplaySet[])object).length - 1;
            while (n >= 0) {
                IDisplaySet iDisplaySet2 = object[n];
                if (iDisplaySet2.isSecondaryCapture() && !iDisplaySet2.isSecondaryCaptureSaved()) {
                    iDisplaySet = iDisplaySet2;
                    break;
                }
                --n;
            }
            if (iDisplaySet != null) {
                iSeriesData = iDisplaySet.getOneObject().getParent();
            }
        }
        object = null;
        object = sCType == SCType.FullScreen ? new SecondaryCapture() : new SecondaryCapture(list, View.OverlayMode.PRINT_OVERLAY_ALL_AND_ROI, true);
        if (sCType == SCType.Append && iDisplaySet != null) {
            iSeriesData = iDisplaySet.getOneObject().getParent();
            object.putSCSeries(iSeriesData.getParent(), iSeriesData);
        }
        object.run();
        Collection<ISeriesData> collection = object.getSeriesData();
        if (collection.isEmpty()) {
            return;
        }
        if (collection.size() > 1 && sCType == SCType.Append) {
            sCType = SCType.Normal;
        }
        iSeriesData = collection.iterator().next();
        if (sCType == SCType.Append && iDisplaySet != null) {
            dataManager.removeDisplaySet(new IDisplaySet[]{iDisplaySet}, SplitAndSortChangeType.INVALIDATION, false, false);
            iSeriesData.setSecondaryCaptureSaved(false);
        }
        dataManager.addSeriesToDisplay(Collections.singletonList(iSeriesData), null);
        JVision2.getMainFrame().repaintSeriesPalettes();
    }

    public static Collection<ISeriesData> captureViewsAsSeriesData(List<VisData> list, View.OverlayMode overlayMode) {
        SecondaryCapture secondaryCapture = new SecondaryCapture(list, overlayMode, false);
        secondaryCapture.run();
        return secondaryCapture.getSeriesData();
    }

    public static enum SCType {
        Normal,
        Append,
        FullScreen;

    }
}

