/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main.windowing;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.jvision.main.windowing.WindowingValue;
import com.tiani.jvision.main.windowing.WindowingValueList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WindowingValuesManager {
    private static final String NAME_KEY = "name";
    private static final String INDEX_KEY = "index";
    private static final String CENTER_KEY = "center";
    private static final String WIDTH_KEY = "width";
    public static final WindowingValuesManager instance = new WindowingValuesManager();
    private WindowingValueList valuesList = new WindowingValueList();
    private List<String> configProviderIDs = new ArrayList<String>();

    private WindowingValuesManager() {
        this.read();
    }

    public WindowingValueList getWindowingValues() {
        return this.valuesList;
    }

    private void read() {
        IConfigurationList iConfigurationList = Config.impaxee.jvision.windowingPresets.getList();
        Set set = iConfigurationList.getChildrenItems().entrySet();
        this.configProviderIDs.clear();
        for (Map.Entry entry : set) {
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            String string = iConfigurationProvider.getString(NAME_KEY);
            int n = (int)iConfigurationProvider.getLong(INDEX_KEY);
            int n2 = (int)iConfigurationProvider.getLong(CENTER_KEY);
            int n3 = (int)iConfigurationProvider.getLong(WIDTH_KEY);
            WindowingValue windowingValue = new WindowingValue(string, n2, n3);
            this.valuesList.set(n, windowingValue);
            if (n >= this.configProviderIDs.size()) {
                int n4 = n - this.configProviderIDs.size();
                int n5 = 0;
                while (n5 <= n4) {
                    this.configProviderIDs.add(null);
                    ++n5;
                }
            }
            this.configProviderIDs.set(n, (String)entry.getKey());
        }
    }

    public void write() {
        IConfigurationList iConfigurationList = Config.impaxee.jvision.windowingPresets.getList();
        Collection collection = iConfigurationList.getChildrenItems().values();
        for (IConfigurationProvider iConfigurationProvider : collection) {
            int n = (int)iConfigurationProvider.getLong(INDEX_KEY);
            WindowingValue windowingValue = this.valuesList.getValue(n);
            if (windowingValue == null) continue;
            iConfigurationProvider.setString(NAME_KEY, windowingValue.getName());
            iConfigurationProvider.setLong(CENTER_KEY, (long)windowingValue.getCenter());
            iConfigurationProvider.setLong(WIDTH_KEY, (long)windowingValue.getWidth());
        }
    }

    public void resetWindowingValues(int n) {
        String string = this.configProviderIDs.get(n);
        IConfigurationList iConfigurationList = Config.impaxee.jvision.windowingPresets.getList();
        iConfigurationList.remove(string);
        ConfigurationProviderFactory.getAdministrationFactory().updateSubtree(Config.impaxee.jvision.windowingPresets.getKey());
        iConfigurationList = Config.impaxee.jvision.windowingPresets.getList();
        Set set = iConfigurationList.getChildrenItems().entrySet();
        for (Map.Entry entry : set) {
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            int n2 = (int)iConfigurationProvider.getLong(INDEX_KEY);
            if (n != n2) continue;
            String string2 = iConfigurationProvider.getString(NAME_KEY);
            int n3 = (int)iConfigurationProvider.getLong(CENTER_KEY);
            int n4 = (int)iConfigurationProvider.getLong(WIDTH_KEY);
            WindowingValue windowingValue = new WindowingValue(string2, n3, n4);
            this.valuesList.set(n2, windowingValue);
        }
    }
}

