/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.overlay.IAreaOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.PolygonPainter;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.RotationHandle;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Polygon;
import java.util.Collections;

abstract class AbstractEllipseOverlay
extends StatisticsPresentationObject
implements IGraphicObjectContainer,
IAreaOverlay {
    protected double[] m;
    protected int[] xc;
    protected int[] yc;
    protected ImageRegion ir = new ImageRegion(this);

    AbstractEllipseOverlay() {
        super("Ellipse");
        this.m = new double[2];
        this.m[1] = 0.0;
        this.m[0] = 0.0;
    }

    @Override
    public boolean isROI() {
        return true;
    }

    final void makeHandles(boolean bl) {
        this.handles = new PresentationHandle[bl ? 6 : 5];
        this.handles[0] = new PresentationHandle(0, 0);
        this.handles[1] = new PresentationHandle(0, 0);
        this.handles[2] = new PresentationHandle(0, 0);
        this.handles[3] = new PresentationHandle(0, 0);
        this.handles[4] = new TranslationHandle(0, 0);
        this.translationHandleIndex = 4;
        if (bl) {
            this.handles[5] = new RotationHandle(0, 0);
        }
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder, boolean bl) {
        PolygonPainter.paintShape(bufferedImageHolder, this, this.xc, this.yc, bl);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        if (this.setPointImpl(n, dArray)) {
            return n + 1;
        }
        TextOverlay textOverlay = this.createAnnotation();
        if (textOverlay != null) {
            textOverlay.setVisible(AbstractEllipseOverlay.getTextAnnotationLevel().isTextAnnotationVisible());
        }
        return -1;
    }

    abstract boolean setPointImpl(int var1, double[] var2);

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(110, "ROI");
    }

    @Override
    public boolean supportsHistogram() {
        return true;
    }

    @Override
    public void createBoundingShape() {
        this.toScreen();
        Polygon polygon = new Polygon(this.xc, this.yc, this.xc.length);
        if (!this.isSolid()) {
            int n = this.xc.length - 1;
            while (n >= 0) {
                polygon.addPoint(this.xc[n], this.yc[n]);
                --n;
            }
        }
        this.outBounds = Collections.singletonList(polygon);
    }
}

