/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.overlay.AbstractImageOverlay;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;

public abstract class AbstractImageMaskOverlay
extends AbstractImageOverlay {
    protected SoftReference<BufferedImage> maskImage;

    public AbstractImageMaskOverlay(boolean bl) {
        super(bl);
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        block9: {
            if (!this.isVisible()) {
                return;
            }
            try {
                BufferedImage bufferedImage;
                BufferedImage bufferedImage2 = bufferedImage = this.maskImage == null ? null : this.maskImage.get();
                if (bufferedImage == null) {
                    bufferedImage = this.createMaskImage();
                }
                if (bufferedImage == null) break block9;
                Graphics2D graphics2D = bufferedImageHolder.graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                try {
                    graphics2D.setTransform(this.getCurrentAffineTransform());
                    Object object = null;
                    Object object2 = null;
                    if (this.renderImageAntialised()) {
                        object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                        object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    if (this.renderImageAntialised()) {
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
                    }
                }
                finally {
                    graphics2D.setTransform(affineTransform);
                }
            }
            catch (Exception exception) {
                log.error("Showing mask overlay failed.", (Throwable)exception);
                this.setActive(false);
            }
        }
    }

    private BufferedImage createMaskImage() {
        BufferedImage bufferedImage = this.createMaskImageImpl();
        if (bufferedImage != null) {
            this.maskImage = new SoftReference<BufferedImage>(bufferedImage);
        }
        return bufferedImage;
    }

    protected boolean renderImageAntialised() {
        return false;
    }

    protected void clearMaskImage() {
        this.maskImage = null;
    }

    protected abstract BufferedImage createMaskImageImpl();

    protected AffineTransform getCurrentAffineTransform() {
        return this.getImageState().getImageToScreenAffineTransform(null);
    }
}

