/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.BMPShutter;
import com.tiani.jvision.overlay.BinBMPShutter;
import com.tiani.jvision.overlay.OverlayTransformationUtils;
import com.tiani.jvision.overlay.PolygonOverlay;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.List;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

abstract class AbstractMarkerPolygonOverlay
extends PolygonOverlay {
    protected final Vector2d horizontalOrientationVector;
    protected final Vector2d verticalOrientationVector;

    AbstractMarkerPolygonOverlay(double[] dArray, double[] dArray2, PolygonPointIndices polygonPointIndices, AnnotationUnits annotationUnits, boolean bl) {
        super(dArray, dArray2, annotationUnits, bl);
        if (polygonPointIndices == null) {
            this.horizontalOrientationVector = new Vector2d(1.0, 0.0);
            this.verticalOrientationVector = new Vector2d(0.0, 1.0);
        } else {
            this.horizontalOrientationVector = new Vector2d(dArray[polygonPointIndices.topEdge] - dArray[polygonPointIndices.topLeft], dArray2[polygonPointIndices.topEdge] - dArray2[polygonPointIndices.topLeft]);
            this.verticalOrientationVector = new Vector2d(dArray[polygonPointIndices.leftEdge] - dArray[polygonPointIndices.topLeft], dArray2[polygonPointIndices.leftEdge] - dArray2[polygonPointIndices.topLeft]);
            this.horizontalOrientationVector.normalize();
            this.verticalOrientationVector.normalize();
        }
    }

    public AbstractMarkerPolygonOverlay() {
        this.horizontalOrientationVector = new Vector2d(1.0, 0.0);
        this.verticalOrientationVector = new Vector2d(0.0, 1.0);
    }

    abstract boolean isResizable();

    abstract PolygonPointIndices getPolygonPointIndices();

    @Override
    protected void makeHandles(boolean bl) {
        this.handles = new PresentationHandle[this.isResizable() ? 2 : 1];
        this.handles[0] = new TranslationHandle(0, 0);
        if (this.isResizable()) {
            this.handles[1] = new PresentationHandle(20, 20);
        }
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        View view = this.getView();
        if (!(view instanceof ImgView2)) {
            return -1;
        }
        this.horizontalOrientationVector.set((Tuple2d)OverlayTransformationUtils.getNormalizedHorizontalOrientationVector(this));
        this.verticalOrientationVector.set((Tuple2d)OverlayTransformationUtils.getNormalizedVerticalOrientationVector(this));
        this.createPolygon((double)Math.min(view.getImageInformation().getRows(), view.getImageInformation().getColumns()) / 20.0, dArray);
        this.setSolid(true);
        this.closed = true;
        this.pointCount = this.xp.length;
        this.makeHandles(true);
        this.toScreen();
        return -1;
    }

    private double getOverlayWidth(double d) {
        int n = this.getView().getImageInformation().getColumns();
        double d2 = (double)n / 50.0;
        if (d < d2) {
            return d2;
        }
        double d3 = (double)n / 2.0;
        if (d > d3) {
            return d3;
        }
        return d;
    }

    @Override
    protected void toScreen() {
        if (this.pointCount == 0) {
            return;
        }
        double[] dArray = new double[2];
        this.cx = 0;
        this.cy = 0;
        int n = 100000;
        int n2 = 100000;
        int n3 = -100000;
        int n4 = -100000;
        int n5 = 0;
        while (n5 < this.pointCount) {
            dArray[0] = this.xp[n5];
            dArray[1] = this.yp[n5];
            dArray = this.toScreen(dArray);
            this.xpi[n5] = (int)dArray[0];
            this.ypi[n5] = (int)dArray[1];
            this.cx += this.xpi[n5];
            this.cy += this.ypi[n5];
            if (this.xpi[n5] > n4) {
                n4 = this.xpi[n5];
            }
            if (this.ypi[n5] > n3) {
                n3 = this.ypi[n5];
            }
            if (this.xpi[n5] < n2) {
                n2 = this.xpi[n5];
            }
            if (this.ypi[n5] < n) {
                n = this.ypi[n5];
            }
            ++n5;
        }
        this.cx /= this.pointCount;
        this.cy /= this.pointCount;
        if (this.handles != null) {
            if (this.handles.length > 0) {
                this.handles[0].setPosition(this.cx, this.cy);
            }
            if (this.handles.length > 1) {
                PolygonPointIndices polygonPointIndices = this.getPolygonPointIndices();
                this.handles[1].setPosition(this.xpi[polygonPointIndices.bottomRight], this.ypi[polygonPointIndices.bottomRight]);
            }
        }
        this.translationHandleIndex = 0;
        this.bounds.x = n2 - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = n - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = n4 - n2 + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = n3 - n + 2 * PresentationHandle.HANDLE_SIZE;
        if (this.isShutter()) {
            if (this.shutterMask == null) {
                this.shutterMask = new BMPShutter(this.shutterValue);
            }
            this.shutterMask.update(this);
        }
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
        if (this.isHandleOutsideView(dArray)) {
            return;
        }
        if (!this.isCompleted() && n == this.pointCount) {
            --n;
        }
        if (n == 0) {
            double[] dArray2 = this.toImage(this.cx, this.cy);
            dArray2[0] = dArray[0] - dArray2[0];
            dArray2[1] = dArray[1] - dArray2[1];
            int n2 = 0;
            while (n2 < this.pointCount) {
                int n3 = n2;
                this.xp[n3] = this.xp[n3] + dArray2[0];
                int n4 = n2++;
                this.yp[n4] = this.yp[n4] + dArray2[1];
            }
        } else if (n == 1 && this.isResizable()) {
            PolygonPointIndices polygonPointIndices = this.getPolygonPointIndices();
            double[] dArray3 = new double[]{(this.xp[polygonPointIndices.topLeft] + this.xp[polygonPointIndices.bottomRight]) / 2.0, (this.yp[polygonPointIndices.topLeft] + this.yp[polygonPointIndices.bottomRight]) / 2.0};
            double d = new Vector2d(dArray[0] - this.xp[polygonPointIndices.topLeft], dArray[1] - this.yp[polygonPointIndices.topLeft]).dot(this.horizontalOrientationVector);
            this.createPolygon(this.getOverlayWidth(d), dArray3);
        }
        this.toScreen();
        this.setSaved(false);
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.pointCount == 0) {
            return;
        }
        if (this.isShutter() && (!this.isSelected() && this.isCompleted() || this.shutterMask instanceof BinBMPShutter)) {
            this.shutterMask.applyShutter(bufferedImageHolder.getImageArray(), bufferedImageHolder.width, bufferedImageHolder.height);
        }
        if (bufferedImageHolder.graphics.getComposite() instanceof AlphaComposite) {
            bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        Color color = bufferedImageHolder.graphics.getColor();
        bufferedImageHolder.graphics.setColor(solidOutlineColor);
        bufferedImageHolder.graphics.drawPolygon(this.xpi, this.ypi, this.pointCount);
        bufferedImageHolder.graphics.setColor(color);
        bufferedImageHolder.graphics.fillPolygon(this.xpi, this.ypi, this.pointCount);
        bufferedImageHolder.graphics.setPaintMode();
    }

    @Override
    public List<GraphicObject> storeROI() {
        List<GraphicObject> list = super.storeROI();
        for (GraphicObject graphicObject : list) {
            graphicObject.setTianiSubType(this.getType());
        }
        return list;
    }

    abstract void createPolygon(double var1, double[] var3);

    abstract TianiSubType getType();

    @Override
    public boolean supportsHistogram() {
        return false;
    }

    static class PolygonPointIndices {
        final int topLeft;
        final int bottomRight;
        final int topEdge;
        final int leftEdge;

        PolygonPointIndices(int n, int n2, int n3, int n4) {
            this.topLeft = n;
            this.bottomRight = n2;
            this.topEdge = n3;
            this.leftEdge = n4;
        }
    }
}

