/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PolygonOverlay;
import com.tiani.jvision.vis.VisData;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;

public abstract class AbstractOverlayCreationDataAction
extends AbstractPDataAction {
    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentImage};
    }

    protected static PolygonOverlay createPolygonOverlay(double[] dArray, double[] dArray2, Color color) {
        PolygonOverlay polygonOverlay = new PolygonOverlay(dArray, dArray2, AnnotationUnits.Pixel, false, false, true);
        polygonOverlay.setEditable(false);
        polygonOverlay.initSaved(true);
        if (color != null) {
            polygonOverlay.setColor(color);
        }
        return polygonOverlay;
    }

    protected abstract class AbstractOverlayCreationAction
    extends AbstractPDataAction.AbstractInnerPAction {
        protected AbstractOverlayCreationAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        private View getView() {
            List<VisData> list = this.scope != null ? AbstractOverlayCreationDataAction.getVisDatas(this.scope) : this.provider.getVisDatas();
            if (list != null && list.size() == 1) {
                return list.get(0).getView();
            }
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            View view = this.getView();
            if (view == null) {
                return false;
            }
            Collection<? extends Overlay> collection = this.getOverlaysToBeAdded(view);
            if (collection != null) {
                for (Overlay overlay : collection) {
                    view.addOverlay(overlay);
                }
                if (!collection.isEmpty()) {
                    view.invalidate();
                    view.repaint();
                }
            }
            return true;
        }

        protected abstract Collection<? extends Overlay> getOverlaysToBeAdded(View var1);
    }
}

