/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CenterlineOverlay
extends AbstractRegionSpacingOverlay
implements IGraphicObjectContainer {
    private static final double LINE_OVERLENGTH = 0.25;
    private double[] a = new double[2];
    private double[] b = new double[2];
    private double[] c = new double[2];
    private double[] d = new double[2];
    private int asx;
    private int asy;
    private int bsx;
    private int bsy;
    private int csx;
    private int csy;
    private int dsx;
    private int dsy;
    private int cl1x;
    private int cl1y;
    private int cl2x;
    private int cl2y;

    public CenterlineOverlay() {
        super(TianiSubType.Centerline.toString(), AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_EQUAL_PIXEL_SPACING);
    }

    public CenterlineOverlay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, AnnotationUnits annotationUnits) {
        this();
        this.a[0] = d;
        this.a[1] = d2;
        this.b[0] = d3;
        this.b[1] = d4;
        this.c[0] = d5;
        this.c[1] = d6;
        this.d[0] = d7;
        this.d[1] = d8;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    private void makeHandles() {
        this.handles = new PresentationHandle[5];
        this.handles[0] = new PresentationHandle(this.asx, this.asy);
        this.handles[1] = new PresentationHandle(this.bsx, this.bsy);
        this.handles[2] = new PresentationHandle(this.csx, this.csy);
        this.handles[3] = new PresentationHandle(this.dsx, this.dsy);
        this.handles[4] = new TranslationHandle((this.asx + this.bsx + this.csx + this.dsx) / 4, (this.asy + this.bsy + this.csy + this.dsy) / 4);
        this.translationHandleIndex = 4;
    }

    private void setHandles() {
        this.handles[0].setPosition(this.asx, this.asy);
        this.handles[1].setPosition(this.bsx, this.bsy);
        this.handles[2].setPosition(this.csx, this.csy);
        this.handles[3].setPosition(this.dsx, this.dsy);
        this.handles[4].setPosition((this.cl1x + this.cl2x) / 2, (this.cl1y + this.cl2y) / 2);
    }

    @Override
    public boolean supportsProfile() {
        return false;
    }

    @Override
    public double[] getXCoordinates() {
        return new double[]{this.a[0], this.b[0], this.c[0], this.d[0]};
    }

    @Override
    public double[] getYCoordinates() {
        return new double[]{this.a[1], this.b[1], this.c[1], this.d[1]};
    }

    @Override
    public int getPointCount() {
        return 4;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return true;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        CenterlineOverlay centerlineOverlay = (CenterlineOverlay)iTransformableOverlay;
        this.a = iOverlayPointModifier.convert(centerlineOverlay.a);
        this.b = iOverlayPointModifier.convert(centerlineOverlay.b);
        this.c = iOverlayPointModifier.convert(centerlineOverlay.c);
        this.d = iOverlayPointModifier.convert(centerlineOverlay.d);
    }

    @Override
    void toScreenImpl() {
        double[] dArray = this.toScreen(this.a);
        this.asx = (int)dArray[0];
        this.asy = (int)dArray[1];
        double[] dArray2 = this.toScreen(this.b);
        this.bsx = (int)dArray2[0];
        this.bsy = (int)dArray2[1];
        double[] dArray3 = this.toScreen(this.c);
        this.csx = (int)dArray3[0];
        this.csy = (int)dArray3[1];
        double[] dArray4 = this.toScreen(this.d);
        this.dsx = (int)dArray4[0];
        this.dsy = (int)dArray4[1];
        this.cl1x = (this.asx + this.bsx) / 2;
        this.cl1y = (this.asy + this.bsy) / 2;
        this.cl2x = (this.csx + this.dsx) / 2;
        this.cl2y = (this.csy + this.dsy) / 2;
        int n = Math.abs(this.cl2x - this.cl1x);
        int n2 = Math.abs(this.cl2y - this.cl1y);
        if (this.cl1x > this.cl2x) {
            this.cl1x = (int)((double)this.cl1x + (double)n * 0.25);
            this.cl2x = (int)((double)this.cl2x - (double)n * 0.25);
        } else {
            this.cl1x = (int)((double)this.cl1x - (double)n * 0.25);
            this.cl2x = (int)((double)this.cl2x + (double)n * 0.25);
        }
        if (this.cl1y > this.cl2y) {
            this.cl1y = (int)((double)this.cl1y + (double)n2 * 0.25);
            this.cl2y = (int)((double)this.cl2y - (double)n2 * 0.25);
        } else {
            this.cl1y = (int)((double)this.cl1y - (double)n2 * 0.25);
            this.cl2y = (int)((double)this.cl2y + (double)n2 * 0.25);
        }
        this.setHandles();
    }

    @Override
    double calculateMeasurementResult() {
        return 0.0;
    }

    @Override
    List<IOverlayInformation> updateAnnotation() {
        return Collections.emptyList();
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 2: {
                ++n2;
                break;
            }
            case 3: {
                this.handleDragged(1, dArray);
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 2;
                ++n2;
                break;
            }
            case 4: {
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 3;
                ++n2;
                break;
            }
            case 5: {
                this.handleDragged(3, dArray);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.a[0] = dArray[0];
                this.a[1] = dArray[1];
                break;
            }
            case 1: {
                this.b[0] = dArray[0];
                this.b[1] = dArray[1];
                break;
            }
            case 2: {
                this.c[0] = dArray[0];
                this.c[1] = dArray[1];
                if (this.isCompleted()) break;
                this.d[0] = dArray[0];
                this.d[1] = dArray[1];
                break;
            }
            case 3: {
                this.d[0] = dArray[0];
                this.d[1] = dArray[1];
                break;
            }
            case 4: {
                double d = (this.a[0] + this.b[0] + this.c[0] + this.d[0]) / 4.0;
                double d2 = (this.a[1] + this.b[1] + this.c[1] + this.d[1]) / 4.0;
                double d3 = dArray[0] - d;
                double d4 = dArray[1] - d2;
                this.a[0] = this.a[0] + d3;
                this.a[1] = this.a[1] + d4;
                this.b[0] = this.b[0] + d3;
                this.b[1] = this.b[1] + d4;
                this.c[0] = this.c[0] + d3;
                this.c[1] = this.c[1] + d4;
                this.d[0] = this.d[0] + d3;
                this.d[1] = this.d[1] + d4;
            }
        }
        this.toScreen();
        this.setSaved(false);
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            bufferedImageHolder.graphics.drawLine(this.asx - 2, this.asy - 3, this.asx + 4, this.asy + 3);
            bufferedImageHolder.graphics.drawLine(this.asx - 2, this.asy + 3, this.asx + 4, this.asy - 3);
            bufferedImageHolder.graphics.drawLine(this.bsx - 2, this.bsy - 3, this.bsx + 4, this.bsy + 3);
            bufferedImageHolder.graphics.drawLine(this.bsx - 2, this.bsy + 3, this.bsx + 4, this.bsy - 3);
            bufferedImageHolder.graphics.drawLine(this.csx - 2, this.csy - 3, this.csx + 4, this.csy + 3);
            bufferedImageHolder.graphics.drawLine(this.csx - 2, this.csy + 3, this.csx + 4, this.csy - 3);
            bufferedImageHolder.graphics.drawLine(this.dsx - 2, this.dsy - 3, this.dsx + 4, this.dsy + 3);
            bufferedImageHolder.graphics.drawLine(this.dsx - 2, this.dsy + 3, this.dsx + 4, this.dsy - 3);
            bufferedImageHolder.graphics.drawLine(this.asx - 4, this.asy - 3, this.asx + 2, this.asy + 3);
            bufferedImageHolder.graphics.drawLine(this.asx - 4, this.asy + 3, this.asx + 2, this.asy - 3);
            bufferedImageHolder.graphics.drawLine(this.bsx - 4, this.bsy - 3, this.bsx + 2, this.bsy + 3);
            bufferedImageHolder.graphics.drawLine(this.bsx - 4, this.bsy + 3, this.bsx + 2, this.bsy - 3);
            bufferedImageHolder.graphics.drawLine(this.csx - 4, this.csy - 3, this.csx + 2, this.csy + 3);
            bufferedImageHolder.graphics.drawLine(this.csx - 4, this.csy + 3, this.csx + 2, this.csy - 3);
            bufferedImageHolder.graphics.drawLine(this.dsx - 4, this.dsy - 3, this.dsx + 2, this.dsy + 3);
            bufferedImageHolder.graphics.drawLine(this.dsx - 4, this.dsy + 3, this.dsx + 2, this.dsy - 3);
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.asx - 3, this.asy - 3, this.asx + 3, this.asy + 3);
        bufferedImageHolder.graphics.drawLine(this.asx - 3, this.asy + 3, this.asx + 3, this.asy - 3);
        bufferedImageHolder.graphics.drawLine(this.bsx - 3, this.bsy - 3, this.bsx + 3, this.bsy + 3);
        bufferedImageHolder.graphics.drawLine(this.bsx - 3, this.bsy + 3, this.bsx + 3, this.bsy - 3);
        bufferedImageHolder.graphics.drawLine(this.csx - 3, this.csy - 3, this.csx + 3, this.csy + 3);
        bufferedImageHolder.graphics.drawLine(this.csx - 3, this.csy + 3, this.csx + 3, this.csy - 3);
        bufferedImageHolder.graphics.drawLine(this.dsx - 3, this.dsy - 3, this.dsx + 3, this.dsy + 3);
        bufferedImageHolder.graphics.drawLine(this.dsx - 3, this.dsy + 3, this.dsx + 3, this.dsy - 3);
        if (this.isCompleted() || this.initStep > 3) {
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                if (Math.abs(this.cl1x - this.cl2x) <= Math.abs(this.cl1y - this.cl2y)) {
                    bufferedImageHolder.graphics.drawLine(this.cl1x - 1, this.cl1y, this.cl2x - 1, this.cl2y);
                    bufferedImageHolder.graphics.drawLine(this.cl1x + 1, this.cl1y, this.cl2x + 1, this.cl2y);
                } else {
                    bufferedImageHolder.graphics.drawLine(this.cl1x, this.cl1y - 1, this.cl2x, this.cl2y - 1);
                    bufferedImageHolder.graphics.drawLine(this.cl1x, this.cl1y + 1, this.cl2x, this.cl2y + 1);
                }
                bufferedImageHolder.graphics.setColor(this.objCol);
            }
            bufferedImageHolder.graphics.drawLine(this.cl1x, this.cl1y, this.cl2x, this.cl2y);
        }
    }

    @Override
    public void createBoundingShape() {
        this.toScreen();
        this.outBounds = new ArrayList();
        this.outBounds.add(this.createBoundingLine(this.cl1x, this.cl1y, this.cl2x, this.cl2y));
        this.outBounds.add(new Polygon(new int[]{this.asx - 3, this.asx + 3, this.asx + 3, this.asx - 3}, new int[]{this.asy - 3, this.asy + 3, this.asy + 3, this.asy - 3}, 4));
        this.outBounds.add(new Polygon(new int[]{this.bsx - 3, this.bsx + 3, this.bsx + 3, this.bsx - 3}, new int[]{this.bsy - 3, this.bsy + 3, this.bsy + 3, this.bsy - 3}, 4));
        this.outBounds.add(new Polygon(new int[]{this.csx - 3, this.csx + 3, this.csx + 3, this.csx - 3}, new int[]{this.csy - 3, this.csy + 3, this.csy + 3, this.csy - 3}, 4));
        this.outBounds.add(new Polygon(new int[]{this.dsx - 3, this.dsx + 3, this.dsx + 3, this.dsx - 3}, new int[]{this.dsy - 3, this.dsy + 3, this.dsy + 3, this.dsy - 3}, 4));
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            CenterlineOverlay centerlineOverlay = (CenterlineOverlay)presentationObject;
            centerlineOverlay.a = ReferencedObjectsCloning.clone(this.a);
            centerlineOverlay.b = ReferencedObjectsCloning.clone(this.b);
            centerlineOverlay.c = ReferencedObjectsCloning.clone(this.c);
            centerlineOverlay.d = ReferencedObjectsCloning.clone(this.d);
        }
        catch (Exception exception) {
            log.error("Failed to clone a CenterlineOverlay object", (Throwable)exception);
        }
        return presentationObject;
    }

    @Override
    public boolean isROI() {
        return true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(3);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.Centerline);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        double[] dArray = this.toImage(new double[]{this.cl1x, this.cl1y});
        double[] dArray2 = this.toImage(new double[]{this.cl2x, this.cl2y});
        graphicObject.setGraphicData(new float[]{(float)dArray[0], (float)dArray[1], (float)dArray2[0], (float)dArray2[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        arrayList.add(this.createPointGO(this.a[0], this.a[1]));
        arrayList.add(this.createPointGO(this.b[0], this.b[1]));
        arrayList.add(this.createPointGO(this.c[0], this.c[1]));
        arrayList.add(this.createPointGO(this.d[0], this.d[1]));
        return arrayList;
    }

    private GraphicObject createPointGO(double d, double d2) {
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.Centerline);
        graphicObject.setGraphicType(GraphicType.Point);
        graphicObject.setGraphicData(new float[]{(float)d, (float)d2});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(1));
        return graphicObject;
    }
}

