/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.image.ICalibrationData;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.overlay.AxisAlignedEllipseOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.LRShutter;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;

public class CircleOverlay
extends AxisAlignedEllipseOverlay
implements ICalibrationData {
    private double[] tmp;

    public CircleOverlay() {
    }

    public CircleOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, boolean bl) {
        super(d, d2, 0.0, 0.0, annotationUnits, bl);
        this.tmp = new double[]{d3, d4};
    }

    public double getRadius() {
        return this.r1;
    }

    public double[] getCenter() {
        return this.m;
    }

    @Override
    protected void toScreen() {
        IImageState iImageState;
        this.lazyInitPointOnCircumference();
        this.mkPolyline();
        if (this.ownedCompanions != null && this.ownedCompanions.length > 0 && this.ownedCompanions[0] != null && this.spacingType == AnnotationUnits.Pixel && this.shapeChanged && (iImageState = this.getImageState()) != null && iImageState.getWindow() != null) {
            this.shapeChanged = false;
            double d = Math.PI * (3.0 * this.r1 * this.getDataPixelSizeX() + 3.0 * this.r2 * this.getDataPixelSizeY() - Math.sqrt((this.r1 * this.getDataPixelSizeX() + 3.0 * this.r2 * this.getDataPixelSizeY()) * (this.r2 * this.getDataPixelSizeY() + 3.0 * this.r1 * this.getDataPixelSizeX())));
            double d2 = this.getArea();
            double d3 = 2.0 * this.r1 * this.getDataPixelSizeX();
            IImageRegionProperties iImageRegionProperties = this.updateHistogram(this.ir);
            ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>();
            arrayList.add(this.createAreaInformation(d2));
            arrayList.add(this.createOverlayInformation(OverlayInformationID.PERIMETER, d));
            arrayList.add(this.createOverlayInformation(OverlayInformationID.DIAMETER, d3));
            this.setNonEditableAnnotation(arrayList, iImageRegionProperties);
        }
        if (this.isShutter()) {
            if (this.shutterMask == null) {
                this.shutterMask = new LRShutter(this.shutterValue);
            }
            this.shutterMask.update(this);
        }
    }

    private void lazyInitPointOnCircumference() {
        if (this.tmp != null) {
            this.setPointOnCircumference(this.tmp);
            this.tmp = null;
        }
    }

    @Override
    public boolean isROI() {
        return !this.isShutter();
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.isShutter() && !this.isSelected() && this.isCompleted()) {
            ((LRShutter)this.shutterMask).applyShutter(bufferedImageHolder.getImageArray(), bufferedImageHolder.width, bufferedImageHolder.height);
            super.paintShape(bufferedImageHolder);
        } else {
            super.paintShape(bufferedImageHolder);
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.setPointOnCircumference(dArray);
                this.toScreen();
                break;
            }
            case 4: {
                this.m = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 5: {
                this.handleDragged(1, dArray);
                this.handleDragged(2, dArray);
            }
        }
        this.setSaved(false);
    }

    void setPointOnCircumference(double[] dArray) {
        double d;
        double d2;
        double[] dArray2;
        double[] dArray3;
        if (this.spacingType == AnnotationUnits.Pixel) {
            dArray3 = this.m;
            dArray2 = dArray;
            d2 = this.getDataPixelSizeX();
            d = this.getDataPixelSizeY();
        } else {
            dArray3 = this.toScreen(this.m);
            dArray2 = this.toScreen(dArray);
            d2 = this.getPixelSizeX();
            d = this.getPixelSizeY();
        }
        double d3 = (dArray2[0] - dArray3[0]) * d2;
        double d4 = (dArray2[1] - dArray3[1]) * d;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        this.r1 = d5 / d2;
        this.r2 = d5 / d;
    }

    @Override
    boolean setPointImpl(int n, double[] dArray) {
        switch (n) {
            case 1: {
                this.handleDragged(4, dArray);
                return true;
            }
            case 2: {
                this.activeHandleIndex = 1;
                return true;
            }
            case 3: {
                this.handleDragged(1, dArray);
                return false;
            }
        }
        return false;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        this.lazyInitPointOnCircumference();
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.Angle);
        graphicObject.setGraphicType(GraphicType.Circle);
        graphicObject.setGraphicData(new float[]{(float)this.m[0], (float)this.m[1], (float)(this.m[0] + this.r1), (float)this.m[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            presentationObject.shapeChanged = true;
            super.cloneReferences(presentationObject);
            CircleOverlay circleOverlay = (CircleOverlay)presentationObject;
            circleOverlay.ir = new ImageRegion(circleOverlay);
            circleOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.m), ReferencedObjectsCloning.clone(this.xc), ReferencedObjectsCloning.clone(this.yc));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    @Override
    public double getOriginalLength() {
        return 2.0 * this.r1 * this.getDataPixelSizeX();
    }

    @Override
    public String getOriginalUnit() {
        return this.dimensionUnit();
    }

    @Override
    public Point3d getCalibrationData(double d) {
        return new Point3d(2.0 * this.r1, 0.0, d);
    }
}

