/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.overlay.ICleanable;
import com.tiani.jvision.overlay.IVolumeProjection;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.curve.CurvePolyLine;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Iterator;

public class CurvePainter
implements ICleanable {
    private static final int DASH_LENGTH = 4;
    private static final int GAP_LENGTH = 4;
    private static final int DASH_GAP_MODE = 8;
    private static final int DASH_GAP_MODE_LIMIT = 3;
    private int[] scrCurveX = new int[500];
    private int[] scrCurveY = new int[500];
    private boolean[] isCurveInPlane = new boolean[500];
    private int imgPointsCount;

    @Override
    public void cleanUp() {
        this.scrCurveX = null;
        this.scrCurveY = null;
        this.isCurveInPlane = null;
    }

    public Rectangle update(CurvePolyLine curvePolyLine, IVolumeProjection iVolumeProjection) {
        this.imgPointsCount = curvePolyLine.getCount();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        if (this.scrCurveX.length < this.imgPointsCount) {
            this.scrCurveX = new int[this.imgPointsCount + 500];
            this.scrCurveY = new int[this.imgPointsCount + 500];
            this.isCurveInPlane = new boolean[this.imgPointsCount + 500];
        }
        VisibilityChecker visibilityChecker = new VisibilityChecker(curvePolyLine, iVolumeProjection);
        double[] dArray = new double[2];
        int n5 = 0;
        int n6 = this.imgPointsCount;
        int n7 = 0;
        while (n7 < n6) {
            iVolumeProjection.volumeToScreen(curvePolyLine.xPoint[n7], curvePolyLine.yPoint[n7], curvePolyLine.zPoint[n7], dArray);
            this.scrCurveX[n5] = (int)dArray[0];
            this.scrCurveY[n5] = (int)dArray[1];
            if (n5 > 0 && this.scrCurveX[n5] == this.scrCurveX[n5 - 1] && this.scrCurveY[n5] == this.scrCurveY[n5 - 1]) {
                --this.imgPointsCount;
            } else {
                this.isCurveInPlane[n5] = visibilityChecker.isCurvePointInPlane(n7);
                if (this.scrCurveX[n5] > n4) {
                    n4 = this.scrCurveX[n5];
                }
                if (this.scrCurveX[n5] < n2) {
                    n2 = this.scrCurveX[n5];
                }
                if (this.scrCurveY[n5] > n3) {
                    n3 = this.scrCurveY[n5];
                }
                if (this.scrCurveY[n5] < n) {
                    n = this.scrCurveY[n5];
                }
                ++n5;
            }
            ++n7;
        }
        return new Rectangle(n2, n, n4 - n2, n3 - n);
    }

    public void paint(BufferedImageHolder bufferedImageHolder, PresentationObject presentationObject, boolean bl, SnapHandleMode snapHandleMode) {
        int n = this.imgPointsCount;
        if (bl) {
            if (bufferedImageHolder.graphics.getComposite() instanceof AlphaComposite) {
                bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            bufferedImageHolder.graphics.fillPolygon(this.scrCurveX, this.scrCurveY, n);
            Color color = bufferedImageHolder.graphics.getColor();
            bufferedImageHolder.graphics.setColor(PresentationObject.solidOutlineColor);
            bufferedImageHolder.graphics.drawPolygon(this.scrCurveX, this.scrCurveY, n);
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.setPaintMode();
        } else {
            int n2;
            if (presentationObject.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                n2 = 1;
                while (n2 < n) {
                    if (this.isCurveInPlane[n2] || n2 % 8 <= 3) {
                        if (this.scrCurveX[n2] != this.scrCurveX[n2 - 1] && Math.abs(this.scrCurveY[n2] - this.scrCurveY[n2 - 1]) / Math.abs(this.scrCurveX[n2] - this.scrCurveX[n2 - 1]) < 1) {
                            bufferedImageHolder.graphics.drawLine(this.scrCurveX[n2 - 1], this.scrCurveY[n2 - 1] - 1, this.scrCurveX[n2], this.scrCurveY[n2] - 1);
                            bufferedImageHolder.graphics.drawLine(this.scrCurveX[n2 - 1], this.scrCurveY[n2 - 1] + 1, this.scrCurveX[n2], this.scrCurveY[n2] + 1);
                        } else {
                            bufferedImageHolder.graphics.drawLine(this.scrCurveX[n2 - 1] - 1, this.scrCurveY[n2 - 1], this.scrCurveX[n2] - 1, this.scrCurveY[n2]);
                            bufferedImageHolder.graphics.drawLine(this.scrCurveX[n2 - 1] + 1, this.scrCurveY[n2 - 1], this.scrCurveX[n2] + 1, this.scrCurveY[n2]);
                        }
                    }
                    ++n2;
                }
                bufferedImageHolder.graphics.setColor(presentationObject.objCol);
                if (snapHandleMode != SnapHandleMode.OFF && n > 0) {
                    n2 = presentationObject.getSnapHandleSize();
                    int n3 = snapHandleMode == SnapHandleMode.FIRST_POINT ? 0 : n - 1;
                    Rectangle rectangle = new Rectangle(this.scrCurveX[n3] - (n2 >> 1), this.scrCurveY[n3] - (n2 >> 1), n2, n2);
                    bufferedImageHolder.graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Color color = bufferedImageHolder.graphics.getColor();
                    bufferedImageHolder.graphics.setColor(Color.black);
                    bufferedImageHolder.graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                    bufferedImageHolder.graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                    bufferedImageHolder.graphics.setColor(color);
                    if (rectangle.contains(presentationObject.lastx, presentationObject.lasty)) {
                        bufferedImageHolder.graphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 3, rectangle.height - 3);
                    }
                }
            }
            n2 = 1;
            while (n2 < n) {
                if (this.isCurveInPlane[n2] || n2 % 8 <= 3) {
                    bufferedImageHolder.graphics.drawLine(this.scrCurveX[n2 - 1], this.scrCurveY[n2 - 1], this.scrCurveX[n2], this.scrCurveY[n2]);
                }
                ++n2;
            }
        }
    }

    public Polygon createBoundingShape(boolean bl) {
        Polygon polygon = new Polygon(this.scrCurveX, this.scrCurveY, this.scrCurveX.length);
        if (!bl) {
            int n = this.scrCurveX.length - 1;
            while (n >= 0) {
                polygon.addPoint(this.scrCurveX[n], this.scrCurveY[n]);
                --n;
            }
        }
        return polygon;
    }

    public static enum SnapHandleMode {
        OFF,
        FIRST_POINT,
        LAST_POINT;

    }

    private static class VisibilityChecker {
        private final CurvePolyLine imgPoints;
        private final IVolumeProjection projection;
        private final Iterator<Integer> controlPointIndices;
        private int nextControlPointIndex;
        private boolean isNextControlPointInPlane;
        private boolean isCurveSegmentInPlane = true;

        VisibilityChecker(CurvePolyLine curvePolyLine, IVolumeProjection iVolumeProjection) {
            this.imgPoints = curvePolyLine;
            this.projection = iVolumeProjection;
            this.controlPointIndices = curvePolyLine.getControlPointIndices().iterator();
            this.readNextControlPoint();
            if (this.nextControlPointIndex < 0) {
                this.isCurveSegmentInPlane = true;
            }
        }

        boolean isCurvePointInPlane(int n) {
            while (n > this.nextControlPointIndex && this.nextControlPointIndex >= 0) {
                this.readNextControlPoint();
            }
            boolean bl = n == this.nextControlPointIndex ? this.isNextControlPointInPlane : this.isCurveSegmentInPlane;
            return bl;
        }

        private void readNextControlPoint() {
            if (this.controlPointIndices.hasNext()) {
                this.nextControlPointIndex = this.controlPointIndices.next();
                boolean bl = this.isNextControlPointInPlane;
                this.isNextControlPointInPlane = this.projection.isInPlane(this.imgPoints.xPoint[this.nextControlPointIndex], this.imgPoints.yPoint[this.nextControlPointIndex], this.imgPoints.zPoint[this.nextControlPointIndex]);
                this.isCurveSegmentInPlane = bl && this.isNextControlPointInPlane;
            } else {
                this.nextControlPointIndex = -1;
                this.isCurveSegmentInPlane = false;
            }
        }
    }
}

