/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayAngleInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector2d;

public class DoubleCenterlineOverlay
extends AbstractRegionSpacingOverlay
implements IGraphicObjectContainer {
    private static final double LINE_OVERLENGTH = 0.25;
    private static final double RAD_TO_DEGREE = 57.29577951308232;
    private double[][] a;
    private double[][] b;
    private double[][] c;
    private double[][] d;
    private int[] asx = new int[2];
    private int[] asy = new int[2];
    private int[] bsx = new int[2];
    private int[] bsy = new int[2];
    private int[] csx = new int[2];
    private int[] csy = new int[2];
    private int[] dsx = new int[2];
    private int[] dsy = new int[2];
    private int[] cl1x = new int[2];
    private int[] cl1y = new int[2];
    private int[] cl2x = new int[2];
    private int[] cl2y = new int[2];
    private Vector2d is;
    private double startAngle;
    private double arcAngle;
    private int radius;

    public DoubleCenterlineOverlay() {
        super(TianiSubType.DoubleCenterline.toString(), AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_EQUAL_PIXEL_SPACING);
        this.a = new double[2][2];
        this.b = new double[2][2];
        this.c = new double[2][2];
        this.d = new double[2][2];
    }

    public DoubleCenterlineOverlay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, AnnotationUnits annotationUnits) {
        this();
        this.a[0][0] = d;
        this.a[0][1] = d2;
        this.b[0][0] = d3;
        this.b[0][1] = d4;
        this.c[0][0] = d5;
        this.c[0][1] = d6;
        this.d[0][0] = d7;
        this.d[0][1] = d8;
        this.a[1][0] = d9;
        this.a[1][1] = d10;
        this.b[1][0] = d11;
        this.b[1][1] = d12;
        this.c[1][0] = d13;
        this.c[1][1] = d14;
        this.d[1][0] = d15;
        this.d[1][1] = d16;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    private void makeHandles() {
        this.handles = new PresentationHandle[9];
        this.handles[0] = new PresentationHandle(this.asx[0], this.asy[0]);
        this.handles[1] = new PresentationHandle(this.bsx[0], this.bsy[0]);
        this.handles[2] = new PresentationHandle(this.csx[0], this.csy[0]);
        this.handles[3] = new PresentationHandle(this.dsx[0], this.dsy[0]);
        this.handles[4] = new PresentationHandle(this.asx[1], this.asy[1]);
        this.handles[5] = new PresentationHandle(this.bsx[1], this.bsy[1]);
        this.handles[6] = new PresentationHandle(this.csx[1], this.csy[1]);
        this.handles[7] = new PresentationHandle(this.dsx[1], this.dsy[1]);
        this.handles[8] = new TranslationHandle((this.asx[0] + this.bsx[0] + this.csx[0] + this.dsx[0] + this.asx[1] + this.bsx[1] + this.csx[1] + this.dsx[1]) / 8, (this.asy[0] + this.bsy[0] + this.csy[0] + this.dsy[0] + this.asy[1] + this.bsy[1] + this.csy[1] + this.dsy[1]) / 8);
        this.translationHandleIndex = 8;
    }

    private void setHandles() {
        this.handles[0].setPosition(this.asx[0], this.asy[0]);
        this.handles[1].setPosition(this.bsx[0], this.bsy[0]);
        this.handles[2].setPosition(this.csx[0], this.csy[0]);
        this.handles[3].setPosition(this.dsx[0], this.dsy[0]);
        this.handles[4].setPosition(this.asx[1], this.asy[1]);
        this.handles[5].setPosition(this.bsx[1], this.bsy[1]);
        this.handles[6].setPosition(this.csx[1], this.csy[1]);
        this.handles[7].setPosition(this.dsx[1], this.dsy[1]);
        this.handles[8].setPosition((this.asx[0] + this.bsx[0] + this.csx[0] + this.dsx[0] + this.asx[1] + this.bsx[1] + this.csx[1] + this.dsx[1]) / 8, (this.asy[0] + this.bsy[0] + this.csy[0] + this.dsy[0] + this.asy[1] + this.bsy[1] + this.csy[1] + this.dsy[1]) / 8);
    }

    @Override
    public boolean supportsProfile() {
        return false;
    }

    @Override
    public double[] getXCoordinates() {
        return new double[]{this.a[0][0], this.b[0][0], this.c[0][0], this.d[0][0], this.a[1][0], this.b[1][0], this.c[1][0], this.d[1][0]};
    }

    @Override
    public double[] getYCoordinates() {
        return new double[]{this.a[0][1], this.b[0][1], this.c[0][1], this.d[0][1], this.a[1][1], this.b[1][1], this.c[1][1], this.d[1][1]};
    }

    @Override
    public int getPointCount() {
        return 8;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return true;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        DoubleCenterlineOverlay doubleCenterlineOverlay = (DoubleCenterlineOverlay)iTransformableOverlay;
        this.a[0] = iOverlayPointModifier.convert(doubleCenterlineOverlay.a[0]);
        this.b[0] = iOverlayPointModifier.convert(doubleCenterlineOverlay.b[0]);
        this.c[0] = iOverlayPointModifier.convert(doubleCenterlineOverlay.c[0]);
        this.d[0] = iOverlayPointModifier.convert(doubleCenterlineOverlay.d[0]);
        this.a[1] = iOverlayPointModifier.convert(doubleCenterlineOverlay.a[1]);
        this.b[1] = iOverlayPointModifier.convert(doubleCenterlineOverlay.b[1]);
        this.c[1] = iOverlayPointModifier.convert(doubleCenterlineOverlay.c[1]);
        this.d[1] = iOverlayPointModifier.convert(doubleCenterlineOverlay.d[1]);
    }

    private void extendCenterlineToPoint(int n, int n2, int n3) {
        double d = Math.abs(this.cl1x[n] - n2);
        if (d == 0.0) {
            double d2 = Math.abs(this.cl1y[n] - n3);
            if (d2 == 0.0) {
                this.cl1x[n] = n2;
                this.cl1y[n] = n3;
            } else {
                double d3 = Math.abs(this.cl2y[n] - n3);
                if (d2 < d3) {
                    this.cl1x[n] = n2;
                    this.cl1y[n] = n3;
                } else {
                    this.cl2x[n] = n2;
                    this.cl2y[n] = n3;
                }
            }
        } else {
            double d4 = Math.abs(this.cl2x[n] - n2);
            if (d < d4) {
                this.cl1x[n] = n2;
                this.cl1y[n] = n3;
            } else {
                this.cl2x[n] = n2;
                this.cl2y[n] = n3;
            }
        }
    }

    @Override
    void toScreenImpl() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 2) {
            double[] dArray = this.toScreen(this.a[n3]);
            this.asx[n3] = (int)dArray[0];
            this.asy[n3] = (int)dArray[1];
            double[] dArray2 = this.toScreen(this.b[n3]);
            this.bsx[n3] = (int)dArray2[0];
            this.bsy[n3] = (int)dArray2[1];
            double[] dArray3 = this.toScreen(this.c[n3]);
            this.csx[n3] = (int)dArray3[0];
            this.csy[n3] = (int)dArray3[1];
            double[] dArray4 = this.toScreen(this.d[n3]);
            this.dsx[n3] = (int)dArray4[0];
            this.dsy[n3] = (int)dArray4[1];
            this.cl1x[n3] = (this.asx[n3] + this.bsx[n3]) / 2;
            this.cl1y[n3] = (this.asy[n3] + this.bsy[n3]) / 2;
            this.cl2x[n3] = (this.csx[n3] + this.dsx[n3]) / 2;
            this.cl2y[n3] = (this.csy[n3] + this.dsy[n3]) / 2;
            n2 = Math.abs(this.cl2x[n3] - this.cl1x[n3]);
            n = Math.abs(this.cl2y[n3] - this.cl1y[n3]);
            if (this.cl1x[n3] > this.cl2x[n3]) {
                int n4 = n3;
                this.cl1x[n4] = (int)((double)this.cl1x[n4] + (double)n2 * 0.25);
                int n5 = n3;
                this.cl2x[n5] = (int)((double)this.cl2x[n5] - (double)n2 * 0.25);
            } else {
                int n6 = n3;
                this.cl1x[n6] = (int)((double)this.cl1x[n6] - (double)n2 * 0.25);
                int n7 = n3;
                this.cl2x[n7] = (int)((double)this.cl2x[n7] + (double)n2 * 0.25);
            }
            if (this.cl1y[n3] > this.cl2y[n3]) {
                int n8 = n3;
                this.cl1y[n8] = (int)((double)this.cl1y[n8] + (double)n * 0.25);
                int n9 = n3;
                this.cl2y[n9] = (int)((double)this.cl2y[n9] - (double)n * 0.25);
            } else {
                int n10 = n3;
                this.cl1y[n10] = (int)((double)this.cl1y[n10] - (double)n * 0.25);
                int n11 = n3;
                this.cl2y[n11] = (int)((double)this.cl2y[n11] + (double)n * 0.25);
            }
            ++n3;
        }
        if (this.isCompleted()) {
            this.is = this.intersectLine(this.cl1x[0], this.cl1y[0], this.cl2x[0], this.cl2y[0], this.cl1x[1], this.cl1y[1], this.cl2x[1], this.cl2y[1]);
            if (this.is != null) {
                this.radius = (this.width + this.height) / 50;
                double d = Math.atan2(this.is.y - (double)this.cl2y[0], (double)this.cl2x[0] - this.is.x);
                double d2 = Math.atan2(this.is.y - (double)this.cl2y[1], (double)this.cl2x[1] - this.is.x);
                this.startAngle = Math.min(d, d2);
                this.arcAngle = Math.abs(d - d2);
                if (this.arcAngle > Math.PI) {
                    this.startAngle = Math.max(d, d2);
                    this.arcAngle = Math.PI * 2 - this.arcAngle;
                }
                if (this.is.x >= 0.0 && this.is.x < (double)this.width && this.is.y >= 0.0 && this.is.y < (double)this.height) {
                    int n12 = (int)Math.round(this.is.x + (double)this.radius * Math.cos(d));
                    n2 = (int)Math.round(this.is.y - (double)this.radius * Math.sin(d));
                    n = (int)Math.round(this.is.x + (double)this.radius * Math.cos(d2));
                    int n13 = (int)Math.round(this.is.y - (double)this.radius * Math.sin(d2));
                    if (!this.isWithin(n12, this.cl1x[0], this.cl2x[0]) || !this.isWithin(n2, this.cl1y[0], this.cl2y[0])) {
                        this.extendCenterlineToPoint(0, n12, n2);
                    }
                    if (!this.isWithin((int)this.is.x, this.cl1x[0], this.cl2x[0]) || !this.isWithin((int)this.is.y, this.cl1y[0], this.cl2y[0])) {
                        this.extendCenterlineToPoint(0, (int)this.is.x, (int)this.is.y);
                    }
                    if (!this.isWithin(n, this.cl1x[1], this.cl2x[1]) || !this.isWithin(n13, this.cl1y[1], this.cl2y[1])) {
                        this.extendCenterlineToPoint(1, n, n13);
                    }
                    if (!this.isWithin((int)this.is.x, this.cl1x[1], this.cl2x[1]) || !this.isWithin((int)this.is.y, this.cl1y[1], this.cl2y[1])) {
                        this.extendCenterlineToPoint(1, (int)this.is.x, (int)this.is.y);
                    }
                }
            }
        }
        this.setHandles();
    }

    @Override
    double calculateMeasurementResult() {
        double d;
        IImageInformation iImageInformation = this.getImageInformation();
        if (ImageDef.hasPixelAspectRatioOtherThan1to1(iImageInformation)) {
            return this.arcAngle * 57.29577951308232;
        }
        double d2 = (this.a[0][0] + this.b[0][0]) / 2.0;
        double d3 = (this.a[0][1] + this.b[0][1]) / 2.0;
        double d4 = (this.c[0][0] + this.d[0][0]) / 2.0;
        double d5 = (this.c[0][1] + this.d[0][1]) / 2.0;
        double d6 = (this.a[1][0] + this.b[1][0]) / 2.0;
        double d7 = (this.a[1][1] + this.b[1][1]) / 2.0;
        double d8 = (this.c[1][0] + this.d[1][0]) / 2.0;
        double d9 = (this.c[1][1] + this.d[1][1]) / 2.0;
        Vector2d vector2d = this.intersectLine(d2, d3, d4, d5, d6, d7, d8, d9);
        if (vector2d == null) {
            return 0.0;
        }
        double d10 = this.getDataPixelSizeX();
        double d11 = this.getDataPixelSizeY();
        double d12 = Math.atan2((vector2d.y - d5) * d11, (d4 - vector2d.x) * d10);
        double d13 = Math.abs(d12 - (d = Math.atan2((vector2d.y - d9) * d11, (d8 - vector2d.x) * d10)));
        if (d13 > Math.PI) {
            d13 = Math.PI * 2 - d13;
        }
        if (Math.abs(d13 - this.arcAngle) > 0.03) {
            d13 = Math.PI - d13;
        }
        return d13 * 57.29577951308232;
    }

    @Override
    List<IOverlayInformation> updateAnnotation() {
        double d = this.getMeasurementResult();
        OverlayAngleInformation overlayAngleInformation = new OverlayAngleInformation(OverlayInformationID.MANDATORY, d, 180.0 - d);
        return Collections.singletonList(overlayAngleInformation);
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, "");
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 2: {
                ++n2;
                break;
            }
            case 3: {
                this.handleDragged(1, dArray);
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 2;
                ++n2;
                break;
            }
            case 4: {
                this.handleDragged(2, dArray);
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 3;
                ++n2;
                break;
            }
            case 5: {
                this.handleDragged(3, dArray);
                this.activeHandleIndex = 4;
                ++n2;
                break;
            }
            case 6: {
                this.handleDragged(4, dArray);
                this.handleDragged(5, dArray);
                this.handleDragged(6, dArray);
                this.handleDragged(7, dArray);
                this.activeHandleIndex = 5;
                ++n2;
                break;
            }
            case 7: {
                this.handleDragged(5, dArray);
                this.handleDragged(6, dArray);
                this.handleDragged(7, dArray);
                this.activeHandleIndex = 6;
                ++n2;
                break;
            }
            case 8: {
                this.handleDragged(6, dArray);
                this.handleDragged(7, dArray);
                this.activeHandleIndex = 7;
                ++n2;
                break;
            }
            case 9: {
                this.handleDragged(7, dArray);
                TextOverlay textOverlay = this.getAnnotation();
                if (textOverlay == null) {
                    textOverlay = this.createAnnotation();
                }
                textOverlay.setAnchor(this.a[0][0], this.a[0][1]);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        if (n == 8) {
            double d = (this.a[0][0] + this.b[0][0] + this.c[0][0] + this.d[0][0] + this.a[1][0] + this.b[1][0] + this.c[1][0] + this.d[1][0]) / 8.0;
            double d2 = (this.a[0][1] + this.b[0][1] + this.c[0][1] + this.d[0][1] + this.a[1][1] + this.b[1][1] + this.c[1][1] + this.d[1][1]) / 8.0;
            double d3 = dArray[0] - d;
            double d4 = dArray[1] - d2;
            int n2 = 0;
            while (n2 < 2) {
                double[] dArray2 = this.a[n2];
                dArray2[0] = dArray2[0] + d3;
                double[] dArray3 = this.b[n2];
                dArray3[0] = dArray3[0] + d3;
                double[] dArray4 = this.c[n2];
                dArray4[0] = dArray4[0] + d3;
                double[] dArray5 = this.d[n2];
                dArray5[0] = dArray5[0] + d3;
                double[] dArray6 = this.a[n2];
                dArray6[1] = dArray6[1] + d4;
                double[] dArray7 = this.b[n2];
                dArray7[1] = dArray7[1] + d4;
                double[] dArray8 = this.c[n2];
                dArray8[1] = dArray8[1] + d4;
                double[] dArray9 = this.d[n2];
                dArray9[1] = dArray9[1] + d4;
                ++n2;
            }
        } else {
            int n3 = n % 4;
            int n4 = n / 4;
            switch (n3) {
                case 0: {
                    this.a[n4][0] = dArray[0];
                    this.a[n4][1] = dArray[1];
                    break;
                }
                case 1: {
                    this.b[n4][0] = dArray[0];
                    this.b[n4][1] = dArray[1];
                    break;
                }
                case 2: {
                    this.c[n4][0] = dArray[0];
                    this.c[n4][1] = dArray[1];
                    if (this.isCompleted()) break;
                    this.d[n4][0] = dArray[0];
                    this.d[n4][1] = dArray[1];
                    break;
                }
                case 3: {
                    this.d[n4][0] = dArray[0];
                    this.d[n4][1] = dArray[1];
                }
            }
        }
        this.toScreen();
        this.setSaved(false);
    }

    private Vector2d intersectLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        if (d9 == 0.0) {
            return null;
        }
        double d10 = ((d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5)) / d9;
        double d11 = ((d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5)) / d9;
        return new Vector2d(d + d10 * (d3 - d), d6 + d11 * (d8 - d6));
    }

    private boolean isWithin(int n, int n2, int n3) {
        if (n3 > n2) {
            return n2 <= n && n <= n3;
        }
        return n3 <= n && n <= n2;
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.isCompleted() && this.is != null && this.is.x >= 0.0 && this.is.x < (double)this.width && this.is.y >= 0.0 && this.is.y < (double)this.height) {
            bufferedImageHolder.graphics.drawArc((int)this.is.x - this.radius, (int)this.is.y - this.radius, 2 * this.radius, 2 * this.radius, (int)(this.startAngle * 57.29577951308232), (int)(this.arcAngle * 57.29577951308232));
        }
        int n = 0;
        while (n < 2) {
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.drawLine(this.asx[n] - 2, this.asy[n] - 3, this.asx[n] + 4, this.asy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.asx[n] - 2, this.asy[n] + 3, this.asx[n] + 4, this.asy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.bsx[n] - 2, this.bsy[n] - 3, this.bsx[n] + 4, this.bsy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.bsx[n] - 2, this.bsy[n] + 3, this.bsx[n] + 4, this.bsy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.csx[n] - 2, this.csy[n] - 3, this.csx[n] + 4, this.csy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.csx[n] - 2, this.csy[n] + 3, this.csx[n] + 4, this.csy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.dsx[n] - 2, this.dsy[n] - 3, this.dsx[n] + 4, this.dsy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.dsx[n] - 2, this.dsy[n] + 3, this.dsx[n] + 4, this.dsy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.asx[n] - 4, this.asy[n] - 3, this.asx[n] + 2, this.asy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.asx[n] - 4, this.asy[n] + 3, this.asx[n] + 2, this.asy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.bsx[n] - 4, this.bsy[n] - 3, this.bsx[n] + 2, this.bsy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.bsx[n] - 4, this.bsy[n] + 3, this.bsx[n] + 2, this.bsy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.csx[n] - 4, this.csy[n] - 3, this.csx[n] + 2, this.csy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.csx[n] - 4, this.csy[n] + 3, this.csx[n] + 2, this.csy[n] - 3);
                bufferedImageHolder.graphics.drawLine(this.dsx[n] - 4, this.dsy[n] - 3, this.dsx[n] + 2, this.dsy[n] + 3);
                bufferedImageHolder.graphics.drawLine(this.dsx[n] - 4, this.dsy[n] + 3, this.dsx[n] + 2, this.dsy[n] - 3);
                bufferedImageHolder.graphics.setColor(this.objCol);
            }
            bufferedImageHolder.graphics.drawLine(this.asx[n] - 3, this.asy[n] - 3, this.asx[n] + 3, this.asy[n] + 3);
            bufferedImageHolder.graphics.drawLine(this.asx[n] - 3, this.asy[n] + 3, this.asx[n] + 3, this.asy[n] - 3);
            bufferedImageHolder.graphics.drawLine(this.bsx[n] - 3, this.bsy[n] - 3, this.bsx[n] + 3, this.bsy[n] + 3);
            bufferedImageHolder.graphics.drawLine(this.bsx[n] - 3, this.bsy[n] + 3, this.bsx[n] + 3, this.bsy[n] - 3);
            bufferedImageHolder.graphics.drawLine(this.csx[n] - 3, this.csy[n] - 3, this.csx[n] + 3, this.csy[n] + 3);
            bufferedImageHolder.graphics.drawLine(this.csx[n] - 3, this.csy[n] + 3, this.csx[n] + 3, this.csy[n] - 3);
            bufferedImageHolder.graphics.drawLine(this.dsx[n] - 3, this.dsy[n] - 3, this.dsx[n] + 3, this.dsy[n] + 3);
            bufferedImageHolder.graphics.drawLine(this.dsx[n] - 3, this.dsy[n] + 3, this.dsx[n] + 3, this.dsy[n] - 3);
            if (this.isCompleted() || this.initStep >= 4 && n == 0 || this.initStep >= 8) {
                if (this.isUseOutlineFont()) {
                    bufferedImageHolder.graphics.setColor(Color.black);
                    if (Math.abs(this.cl1x[n] - this.cl2x[n]) <= Math.abs(this.cl1y[n] - this.cl2y[n])) {
                        bufferedImageHolder.graphics.drawLine(this.cl1x[n] - 1, this.cl1y[n], this.cl2x[n] - 1, this.cl2y[n]);
                        bufferedImageHolder.graphics.drawLine(this.cl1x[n] + 1, this.cl1y[n], this.cl2x[n] + 1, this.cl2y[n]);
                    } else {
                        bufferedImageHolder.graphics.drawLine(this.cl1x[n], this.cl1y[n] - 1, this.cl2x[n], this.cl2y[n] - 1);
                        bufferedImageHolder.graphics.drawLine(this.cl1x[n], this.cl1y[n] + 1, this.cl2x[n], this.cl2y[n] + 1);
                    }
                    bufferedImageHolder.graphics.setColor(this.objCol);
                }
                bufferedImageHolder.graphics.drawLine(this.cl1x[n], this.cl1y[n], this.cl2x[n], this.cl2y[n]);
            }
            ++n;
        }
    }

    @Override
    public void createBoundingShape() {
        this.outBounds = new ArrayList();
        int n = 0;
        while (n < 2) {
            this.outBounds.add(this.createBoundingLine(this.cl1x[n], this.cl1y[n], this.cl2x[n], this.cl2y[n]));
            this.outBounds.add(new Polygon(new int[]{this.asx[n] - 3, this.asx[n] + 3, this.asx[n] + 3, this.asx[n] - 3}, new int[]{this.asy[n] - 3, this.asy[n] + 3, this.asy[n] + 3, this.asy[n] - 3}, 4));
            this.outBounds.add(new Polygon(new int[]{this.bsx[n] - 3, this.bsx[n] + 3, this.bsx[n] + 3, this.bsx[n] - 3}, new int[]{this.bsy[n] - 3, this.bsy[n] + 3, this.bsy[n] + 3, this.bsy[n] - 3}, 4));
            this.outBounds.add(new Polygon(new int[]{this.csx[n] - 3, this.csx[n] + 3, this.csx[n] + 3, this.csx[n] - 3}, new int[]{this.csy[n] - 3, this.csy[n] + 3, this.csy[n] + 3, this.csy[n] - 3}, 4));
            this.outBounds.add(new Polygon(new int[]{this.dsx[n] - 1, this.dsx[n] + 1, this.dsx[n] + 1, this.dsx[n] - 1}, new int[]{this.dsy[n] - 3, this.dsy[n] + 3, this.dsy[n] + 3, this.dsy[n] - 3}, 4));
            ++n;
        }
    }

    private double[][] clonePoints(double[][] dArray) {
        double[][] dArray2 = new double[2][2];
        dArray2[0][0] = dArray[0][0];
        dArray2[0][1] = dArray[0][1];
        dArray2[1][0] = dArray[1][0];
        dArray2[1][1] = dArray[1][1];
        return dArray2;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            DoubleCenterlineOverlay doubleCenterlineOverlay = (DoubleCenterlineOverlay)presentationObject;
            doubleCenterlineOverlay.a = this.clonePoints(this.a);
            doubleCenterlineOverlay.b = this.clonePoints(this.b);
            doubleCenterlineOverlay.c = this.clonePoints(this.c);
            doubleCenterlineOverlay.d = this.clonePoints(this.d);
            doubleCenterlineOverlay.asx = ReferencedObjectsCloning.clone(this.asx);
            doubleCenterlineOverlay.asy = ReferencedObjectsCloning.clone(this.asy);
            doubleCenterlineOverlay.bsx = ReferencedObjectsCloning.clone(this.bsx);
            doubleCenterlineOverlay.bsy = ReferencedObjectsCloning.clone(this.bsy);
            doubleCenterlineOverlay.csx = ReferencedObjectsCloning.clone(this.csx);
            doubleCenterlineOverlay.csy = ReferencedObjectsCloning.clone(this.csy);
            doubleCenterlineOverlay.dsx = ReferencedObjectsCloning.clone(this.dsx);
            doubleCenterlineOverlay.dsy = ReferencedObjectsCloning.clone(this.dsy);
            doubleCenterlineOverlay.cl1x = ReferencedObjectsCloning.clone(this.cl1x);
            doubleCenterlineOverlay.cl1y = ReferencedObjectsCloning.clone(this.cl1y);
            doubleCenterlineOverlay.cl2x = ReferencedObjectsCloning.clone(this.cl2x);
            doubleCenterlineOverlay.cl2y = ReferencedObjectsCloning.clone(this.cl2y);
        }
        catch (Exception exception) {
            log.error("Failed to clone a DoubleCenterlineOverlay object", (Throwable)exception);
        }
        return presentationObject;
    }

    @Override
    public boolean isROI() {
        return true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(3);
        int n = 0;
        while (n < 2) {
            GraphicObject graphicObject = this.createGraphicObject();
            graphicObject.setTianiSubType(TianiSubType.DoubleCenterline);
            graphicObject.setGraphicType(GraphicType.PolyLine);
            double[] dArray = this.toImage(new double[]{this.cl1x[n], this.cl1y[n]});
            double[] dArray2 = this.toImage(new double[]{this.cl2x[n], this.cl2y[n]});
            graphicObject.setGraphicData(new float[]{(float)dArray[0], (float)dArray[1], (float)dArray2[0], (float)dArray2[1]});
            graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
            arrayList.add(graphicObject);
            ++n;
        }
        n = 0;
        while (n < 2) {
            arrayList.add(this.createPointGO(this.a[n][0], this.a[n][1]));
            arrayList.add(this.createPointGO(this.b[n][0], this.b[n][1]));
            arrayList.add(this.createPointGO(this.c[n][0], this.c[n][1]));
            arrayList.add(this.createPointGO(this.d[n][0], this.d[n][1]));
            ++n;
        }
        return arrayList;
    }

    private GraphicObject createPointGO(double d, double d2) {
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.DoubleCenterline);
        graphicObject.setGraphicType(GraphicType.Point);
        graphicObject.setGraphicData(new float[]{(float)d, (float)d2});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(1));
        return graphicObject;
    }
}

