/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.LayeredView;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.overlay.EditTextOverlay2;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EditTextContainerOverlay2
extends PresentationObject {
    private Map<String, EditTextOverlay2> text = new LinkedHashMap<String, EditTextOverlay2>(4);

    public EditTextContainerOverlay2() {
        super("Edit Text Container");
    }

    @Override
    public boolean isRemoveable() {
        return false;
    }

    public void add(EditTextOverlay2 editTextOverlay2, String string) {
        if (this.text.containsKey(string)) {
            return;
        }
        this.calcPositionsForAdd(editTextOverlay2);
        this.text.put(string, editTextOverlay2);
    }

    public void remove(String string) {
        EditTextOverlay2 editTextOverlay2 = this.text.remove(string);
        if (editTextOverlay2 != null) {
            this.calcPositionsForRemove(editTextOverlay2);
            if (this.owner != null) {
                this.getView().removeOverlay(editTextOverlay2);
            }
        }
    }

    @Override
    public void presentationObjectAdded(View view) {
        super.presentationObjectAdded(view);
        if (this.owner == null) {
            return;
        }
        List<Overlay> list = this.getView().getPresentationObjects();
        for (EditTextOverlay2 editTextOverlay2 : this.text.values()) {
            if (list.contains(editTextOverlay2)) continue;
            if (this.owner instanceof LayeredView) {
                ((LayeredView)this.owner).addGlobalOverlay(editTextOverlay2);
                continue;
            }
            this.getView().addOverlay(editTextOverlay2);
        }
        this.recalcPositions();
    }

    @Override
    public void presentationObjectRemoved(View view) {
        if (this.owner == null) {
            return;
        }
        List<Overlay> list = this.getView().getPresentationObjects();
        for (EditTextOverlay2 editTextOverlay2 : this.text.values()) {
            if (!list.contains(editTextOverlay2)) continue;
            this.getView().removeOverlay(editTextOverlay2);
        }
        super.presentationObjectRemoved(view);
    }

    private void recalcPositions() {
        if (this.owner == null) {
            return;
        }
        Rectangle rectangle = this.getView().getBounds();
        Iterator<EditTextOverlay2> iterator = this.text.values().iterator();
        int n = this.text.size() - 1;
        while (iterator.hasNext()) {
            EditTextOverlay2 editTextOverlay2 = iterator.next();
            Rectangle rectangle2 = editTextOverlay2.getTextArea();
            double d = -((double)rectangle2.height) / (double)rectangle.height;
            editTextOverlay2.setPosition((1.0 - (double)rectangle2.width / (double)rectangle.width) / 2.0, 1.0 + (double)n * d, AnnotationUnits.Display);
            --n;
        }
    }

    private void calcPositionsForRemove(EditTextOverlay2 editTextOverlay2) {
        if (this.owner == null) {
            return;
        }
        double[] dArray = editTextOverlay2.getPosition();
        Rectangle rectangle = this.getView().getBounds();
        Rectangle rectangle2 = editTextOverlay2.getTextArea();
        double d = (double)rectangle2.height / (double)rectangle.height;
        for (EditTextOverlay2 editTextOverlay22 : this.text.values()) {
            double[] dArray2 = editTextOverlay22.getPosition();
            if (!(dArray2[1] < dArray[1])) continue;
            editTextOverlay22.move(0.0, d);
        }
    }

    private void calcPositionsForAdd(EditTextOverlay2 editTextOverlay2) {
        if (this.owner == null) {
            return;
        }
        Rectangle rectangle = this.getView().getBounds();
        Rectangle rectangle2 = editTextOverlay2.getTextArea();
        double d = -((double)rectangle2.height) / (double)rectangle.height;
        Iterator<EditTextOverlay2> iterator = this.text.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().move(0.0, d);
        }
        editTextOverlay2.setPosition((1.0 - (double)rectangle2.width / (double)rectangle.width) / 2.0, 1.0, AnnotationUnits.Display);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        return 0;
    }

    @Override
    public PresentationObject cloneAll() {
        return null;
    }

    @Override
    public void setSize(int n, int n2, IImageState iImageState) {
        super.setSize(n, n2, iImageState);
        this.recalcPositions();
        this.recalcPositions();
    }

    public void setVisibilityOfAll(boolean bl) {
        Iterator<EditTextOverlay2> iterator = this.text.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setVisible(bl);
        }
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
    }
}

