/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.overlay.AbstractEllipseOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.PointToLineProjection;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TranslationHandle;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;

public class EllipseOverlay
extends AbstractEllipseOverlay {
    private static final int MAJOR_AXIS_HANDLE_INDEX1 = 0;
    private static final int MAJOR_AXIS_HANDLE_INDEX2 = 1;
    private static final int MINOR_AXIS_HANDLE_INDEX1 = 2;
    private static final int MINOR_AXIS_HANDLE_INDEX2 = 3;
    private static final int TRANSLATION_HANDLE_INDEX = 4;
    private static final int ROTATION_HANDLE_INDEX = 5;
    private static final int MAJOR_AXIS_CREATION_HANDLE_INDEX = 6;
    private double[] p = new double[2];
    private double[] q = new double[2];
    private double mx;
    private double my;
    private double px;
    private double py;
    private double qx;
    private double qy;
    private double a;
    private double b;
    private double a2screen;
    private double b2screen;
    private double cosTheta;
    private double sinTheta;

    public EllipseOverlay() {
        this.setTheta(0.0);
    }

    public EllipseOverlay(double d, double d2, double d3, double d4, double d5, double d6, AnnotationUnits annotationUnits, boolean bl) {
        this();
        this.setState(PresentationObject.OverlayState.Solid, bl);
        this.m[0] = d;
        this.m[1] = d2;
        this.p[0] = d3;
        this.p[1] = d4;
        this.q[0] = d5;
        this.q[1] = d6;
        this.setSpacing(annotationUnits);
        this.makeHandles();
        this.setEditable(!Product.isCDViewer());
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    private void calculateTheta() {
        this.setTheta(this.getTheta());
    }

    private double getTheta() {
        return Math.atan2(this.py - this.my, this.px - this.mx);
    }

    private void setTheta(double d) {
        this.cosTheta = Math.cos(d);
        this.sinTheta = Math.sin(d);
    }

    protected void makeHandles() {
        this.makeHandles(true);
    }

    private void mkPolyline() {
        double d;
        double[] dArray = this.toScreen(this.m);
        this.mx = dArray[0];
        this.my = dArray[1];
        dArray = this.toScreen(this.p);
        this.px = dArray[0];
        this.py = dArray[1];
        dArray = this.toScreen(this.q);
        this.qx = dArray[0];
        this.qy = dArray[1];
        this.calculateTheta();
        this.a = this.calculateLength(this.p, (int)this.px, (int)this.py, this.m, (int)this.mx, (int)this.my);
        this.b = this.calculateLength(this.q, (int)this.qx, (int)this.qy, this.m, (int)this.mx, (int)this.my);
        double d2 = Math.sqrt((this.px - this.mx) * (this.px - this.mx) + (this.py - this.my) * (this.py - this.my));
        double d3 = Math.sqrt((this.qx - this.mx) * (this.qx - this.mx) + (this.qy - this.my) * (this.qy - this.my));
        this.a2screen = d2 * d2;
        this.b2screen = d3 * d3;
        if (this.handles != null) {
            this.handles[0].setPosition((int)this.px, (int)this.py);
            this.handles[1].setPosition((int)(2.0 * this.mx - this.px), (int)(2.0 * this.my - this.py));
            this.handles[2].setPosition((int)this.qx, (int)this.qy);
            this.handles[3].setPosition((int)(2.0 * this.mx - this.qx), (int)(2.0 * this.my - this.qy));
            this.handles[this.translationHandleIndex].setPosition((int)this.mx, (int)this.my);
            d = 1.5 * (double)TranslationHandle.TRANSLATIONHANDLE_SIZE / d2;
            if (d > 0.5) {
                d += 1.0;
            }
            this.handles[5].setPosition((int)(this.mx + (this.px - this.mx) * d), (int)(this.my + (this.py - this.my) * d));
        }
        d = EllipseOverlay.estimateCircumference(d2, d3);
        int n = Math.max(10, (int)(d / 10.0));
        if (this.xc == null || this.xc.length != n) {
            this.xc = new int[n];
            this.yc = new int[n];
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        while (n6 < n) {
            double d4 = Math.PI * 2 / (double)(n - 1) * (double)n6;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            this.xc[n6] = (int)(this.mx + (d2 * d5 * this.cosTheta - d3 * d6 * this.sinTheta));
            this.yc[n6] = (int)(this.my + (d2 * d5 * this.sinTheta + d3 * d6 * this.cosTheta));
            if (n2 > this.xc[n6]) {
                n2 = this.xc[n6];
            }
            if (n3 < this.xc[n6]) {
                n3 = this.xc[n6];
            }
            if (n4 > this.yc[n6]) {
                n4 = this.yc[n6];
            }
            if (n5 < this.yc[n6]) {
                n5 = this.yc[n6];
            }
            ++n6;
        }
        this.bounds.x = n2 - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = n4 - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = n3 - n2 + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = n5 - n4 + 2 * PresentationHandle.HANDLE_SIZE;
    }

    @Override
    protected void toScreen() {
        this.mkPolyline();
        IImageState iImageState = this.getImageState();
        if (this.ownedCompanions != null && this.ownedCompanions[0] != null && this.spacingType == AnnotationUnits.Pixel && this.shapeChanged && iImageState != null && iImageState.getWindow() != null) {
            this.shapeChanged = false;
            double d = EllipseOverlay.estimateCircumference(this.a, this.b);
            double d2 = this.getArea();
            String string = this.dimensionUnit();
            IImageRegionProperties iImageRegionProperties = this.updateHistogram(this.ir);
            ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>();
            OverlayInformation overlayInformation = new OverlayInformation(OverlayInformationID.DIAMETER, 2.0 * this.a, string, 2.0 * this.b, string, new OverlayInformation(OverlayInformationID.DIAMETER_ELLIPSE_EXTENDED, d / Math.PI, string));
            arrayList.add(this.createAreaInformation(d2));
            arrayList.add(this.createOverlayInformation(OverlayInformationID.PERIMETER, d));
            arrayList.add(overlayInformation);
            this.setNonEditableAnnotation(arrayList, iImageRegionProperties);
        }
    }

    @Override
    public double getArea() {
        return Math.PI * this.a * this.b;
    }

    @Override
    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    protected void handleInteraction(int n, double[] dArray) {
        double[] dArray2 = this.toScreen(dArray);
        double d = dArray2[0];
        double d2 = dArray2[1];
        switch (n) {
            case 1: {
                d = 2.0 * this.mx - d;
                d2 = 2.0 * this.my - d2;
            }
            case 0: {
                PointToLineProjection pointToLineProjection = PointToLineProjection.project(this.mx, this.my, this.mx + this.cosTheta, this.my + this.sinTheta, d, d2);
                if (pointToLineProjection == null) break;
                this.p = this.toImage(new double[]{pointToLineProjection.getX(), pointToLineProjection.getY()});
                break;
            }
            case 3: {
                d = 2.0 * this.mx - d;
                d2 = 2.0 * this.my - d2;
            }
            case 2: {
                PointToLineProjection pointToLineProjection = PointToLineProjection.project(this.mx, this.my, this.mx + this.sinTheta, this.my - this.cosTheta, d, d2);
                if (pointToLineProjection == null) break;
                this.q = this.toImage(new double[]{pointToLineProjection.getX(), pointToLineProjection.getY()});
                break;
            }
            case 4: {
                double d3 = dArray[0] - this.m[0];
                double d4 = dArray[1] - this.m[1];
                this.m = (double[])dArray.clone();
                this.p[0] = this.p[0] + d3;
                this.p[1] = this.p[1] + d4;
                this.q[0] = this.q[0] + d3;
                this.q[1] = this.q[1] + d4;
                break;
            }
            case 5: {
                double d5 = Math.atan2(d2 - this.my, d - this.mx);
                double d6 = this.getTheta() - d5;
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                Matrix2d matrix2d = new Matrix2d(d7, d8, -d8, d7);
                this.p = this.toImage(this.rotatePoint(this.px, this.py, matrix2d));
                this.q = this.toImage(this.rotatePoint(this.qx, this.qy, matrix2d));
                break;
            }
            case 6: {
                this.p = (double[])dArray.clone();
            }
        }
        this.toScreen();
        this.setSaved(false);
    }

    private double[] rotatePoint(double d, double d2, Matrix2d matrix2d) {
        double[] dArray = new double[]{d, d2};
        dArray[0] = dArray[0] - this.mx;
        dArray[1] = dArray[1] - this.my;
        matrix2d.transform(dArray);
        dArray[0] = dArray[0] + this.mx;
        dArray[1] = dArray[1] + this.my;
        return dArray;
    }

    @Override
    boolean setPointImpl(int n, double[] dArray) {
        switch (n) {
            case 1: {
                this.m = (double[])dArray.clone();
                this.p = (double[])dArray.clone();
                this.q = (double[])dArray.clone();
                break;
            }
            case 2: {
                this.activeHandleIndex = 6;
                break;
            }
            case 3: {
                this.activeHandleIndex = 2;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isInside(int n, int n2) {
        double d;
        double[] dArray = this.toScreen(new double[]{n, n2});
        double d2 = (dArray[0] - this.mx) * this.cosTheta + (dArray[1] - this.my) * this.sinTheta;
        return d2 * d2 / this.a2screen + (d = (dArray[1] - this.my) * this.cosTheta - (dArray[0] - this.mx) * this.sinTheta) * d / this.b2screen <= 1.0;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            presentationObject.shapeChanged = true;
            super.cloneReferences(presentationObject);
            EllipseOverlay ellipseOverlay = (EllipseOverlay)presentationObject;
            ellipseOverlay.ir = new ImageRegion(ellipseOverlay);
            ellipseOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.m), ReferencedObjectsCloning.clone(this.p), ReferencedObjectsCloning.clone(this.q), ReferencedObjectsCloning.clone(this.xc), ReferencedObjectsCloning.clone(this.yc));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    private void setClonedParameters(double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2) {
        this.m = dArray;
        this.p = dArray2;
        this.q = dArray3;
        this.xc = nArray;
        this.yc = nArray2;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        EllipseOverlay ellipseOverlay = (EllipseOverlay)iTransformableOverlay;
        this.m = iOverlayPointModifier.convert(ellipseOverlay.m);
        this.p = iOverlayPointModifier.convert(ellipseOverlay.p);
        this.q = iOverlayPointModifier.convert(ellipseOverlay.q);
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        float f = (float)(2.0 * this.m[0] - this.p[0]);
        float f2 = (float)(2.0 * this.m[1] - this.p[1]);
        float f3 = (float)(2.0 * this.m[0] - this.q[0]);
        float f4 = (float)(2.0 * this.m[1] - this.q[1]);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setGraphicType(GraphicType.Ellipse);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(4));
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1], f, f2, (float)this.q[0], (float)this.q[1], f3, f4});
        arrayList.add(graphicObject);
        return arrayList;
    }

    private static double estimateCircumference(double d, double d2) {
        return Math.PI * (3.0 * d + 3.0 * d2 - Math.sqrt((d + 3.0 * d2) * (d2 + 3.0 * d)));
    }
}

