/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.jvision.overlay.OutlineFontFactory;
import com.tiani.jvision.overlay.OverlayFontConfig;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Map;

public class FontSet {
    private static final Map<FontSetKey, FontSet> cache = new Hashtable<FontSetKey, FontSet>();
    public final Font font;
    public final FontMetrics fm;
    public final Font largeFont;
    public final FontMetrics largeFm;
    public final OutlineFont outlineFont;
    public final OutlineFont largeOutlineFont;

    static {
        cache.put(new FontSetKey(OverlayFontConfig.displayFont.getName(), OverlayFontConfig.displayFont.getStyle(), OverlayFontConfig.displayFont.getSize()), new FontSet(OverlayFontConfig.displayFont, OverlayFontConfig.displayfm, OverlayFontConfig.largeDisplayFont, OverlayFontConfig.largeDisplayFM, OverlayFontConfig.mapDisplayFont, OverlayFontConfig.mapLargeDisplayFont));
    }

    FontSet(Font font, FontMetrics fontMetrics, Font font2, FontMetrics fontMetrics2, OutlineFont outlineFont, OutlineFont outlineFont2) {
        this.font = font;
        this.fm = fontMetrics;
        this.largeFont = font2;
        this.largeFm = fontMetrics2;
        this.outlineFont = outlineFont;
        this.largeOutlineFont = outlineFont2;
    }

    FontSet(Font font, Graphics graphics) {
        this.font = font;
        this.fm = graphics.getFontMetrics(font);
        this.largeFont = AwtFontFactory.getFont(font, (int)Math.round((double)font.getSize() * 1.5));
        this.largeFm = graphics.getFontMetrics(this.largeFont);
        this.outlineFont = OutlineFontFactory.createOutlineFont(font, this.fm);
        this.largeOutlineFont = OutlineFontFactory.createOutlineFont(this.largeFont, this.largeFm);
    }

    public static FontSet getInstance(Font font, Graphics graphics) {
        FontSetKey fontSetKey = new FontSetKey(font.getName(), font.getStyle(), font.getSize());
        FontSet fontSet = cache.get(fontSetKey);
        if (fontSet == null) {
            fontSet = new FontSet(font, graphics);
            cache.put(fontSetKey, fontSet);
        }
        return fontSet;
    }

    private static class FontSetKey {
        private String name;
        private int style = -1;
        private int size;

        FontSetKey(String string, int n, int n2) {
            this.name = string;
            this.size = n2;
            this.style = n;
        }

        public boolean equals(Object object) {
            if (object instanceof FontSetKey) {
                FontSetKey fontSetKey = (FontSetKey)object;
                return fontSetKey.size == this.size && fontSetKey.style == this.style && fontSetKey.name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.size + this.style + this.name.hashCode();
        }
    }
}

