/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.overlay.OutlineFontFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public class GraphicsWrapper
extends Graphics {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    protected BufferedImageHolder bih;
    protected Graphics2D g;
    protected int xo;
    protected int yo;
    protected OutlineFont mapf;
    protected int width = 0;
    protected int height = 0;
    protected int alignment = 0;

    public GraphicsWrapper(BufferedImageHolder bufferedImageHolder, int n, int n2, int n3, int n4, int n5) {
        this(bufferedImageHolder, n, n2);
        this.width = n3;
        this.height = n4;
        this.alignment = n5;
    }

    public GraphicsWrapper(BufferedImageHolder bufferedImageHolder, int n, int n2) {
        this.bih = bufferedImageHolder;
        this.g = (Graphics2D)this.bih.graphics.create();
        this.xo = n;
        this.yo = n2;
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.g.drawString(attributedCharacterIterator, n + this.xo, n2 + this.yo);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.g.clearRect(n + this.xo, n2 + this.yo, n3, n4);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n + this.xo, n2 + this.yo, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.copyArea(n + this.xo, n2 + this.yo, n3, n4, n5, n6);
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n + this.xo, n2 + this.yo, n3, n4, n5, n6);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n + this.xo, n2 + this.yo, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.g.drawImage(image, n + this.xo, n2 + this.yo, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.g.drawImage(image, n + this.xo, n2 + this.yo, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n + this.xo, n2 + this.yo, n3, n4, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.g.drawImage(image, n + this.xo, n2 + this.yo, n3 + this.xo, n4 + this.yo, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n + this.xo, n2 + this.yo, n3 + this.xo, n4 + this.yo, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n + this.xo, n2 + this.yo, n3 + this.xo, n4 + this.yo);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.g.drawOval(n + this.xo, n2 + this.yo, n3, n4);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + this.xo;
            int n4 = n2++;
            nArray2[n4] = nArray2[n4] + this.yo;
        }
        this.g.drawPolygon(nArray, nArray2, n);
        n2 = 0;
        while (n2 < n) {
            int n5 = n2;
            nArray[n5] = nArray[n5] - this.xo;
            int n6 = n2++;
            nArray2[n6] = nArray2[n6] - this.yo;
        }
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + this.xo;
            int n4 = n2++;
            nArray2[n4] = nArray2[n4] + this.yo;
        }
        this.g.drawPolyline(nArray, nArray2, n);
        n2 = 0;
        while (n2 < n) {
            int n5 = n2;
            nArray[n5] = nArray[n5] - this.xo;
            int n6 = n2++;
            nArray2[n6] = nArray2[n6] - this.yo;
        }
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawRoundRect(n + this.xo, n2 + this.yo, n3, n4, n5, n6);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        if (this.mapf != null) {
            if (this.alignment == 1) {
                this.mapf.drawBytes(string.toCharArray(), (IImageHolder)this.bih, n + this.xo + (this.width - this.mapf.getFontMetrics().bytesWidth(string.getBytes(), 0, string.length())), n2 + this.yo);
            } else if (this.alignment == 2) {
                this.mapf.drawBytes(string.toCharArray(), (IImageHolder)this.bih, n + this.xo + (this.width - this.mapf.getFontMetrics().bytesWidth(string.getBytes(), 0, string.length())) / 2, n2 + this.yo);
            } else {
                this.mapf.drawBytes(string.toCharArray(), (IImageHolder)this.bih, n + this.xo, n2 + this.yo);
            }
        } else {
            this.g.drawString(string, n + this.xo, n2 + this.yo);
        }
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        if (this.mapf != null) {
            if (this.alignment == 1) {
                this.mapf.drawBytes(cArray, this.g.getColor(), n, n2, (IImageHolder)this.bih, n3 + this.xo + (this.width - this.mapf.getFontMetrics().charsWidth(cArray, n, n2)), n4 + this.yo);
            } else if (this.alignment == 2) {
                this.mapf.drawBytes(cArray, this.g.getColor(), n, n2, (IImageHolder)this.bih, n3 + this.xo + (this.width - this.mapf.getFontMetrics().charsWidth(cArray, n, n2)) / 2, n4 + this.yo);
            } else {
                this.mapf.drawBytes(cArray, this.g.getColor(), n, n2, (IImageHolder)this.bih, n3 + this.xo, n4 + this.yo);
            }
        } else {
            this.g.drawChars(cArray, n, n2, n3 + this.xo, n4 + this.yo);
        }
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        if (this.mapf != null) {
            if (this.alignment == 1) {
                this.mapf.drawBytes(new String(byArray).toCharArray(), this.g.getColor(), n, n2, (IImageHolder)this.bih, n3 + this.xo + (this.width - this.mapf.getFontMetrics().bytesWidth(byArray, n, n2)), n4 + this.yo);
            } else if (this.alignment == 2) {
                this.mapf.drawBytes(new String(byArray).toCharArray(), this.g.getColor(), n, n2, (IImageHolder)this.bih, n3 + this.xo + (this.width - this.mapf.getFontMetrics().bytesWidth(byArray, n, n2)) / 2, n4 + this.yo);
            } else {
                this.mapf.drawBytes(new String(byArray).toCharArray(), this.g.getColor(), n, n2, (IImageHolder)this.bih, n3 + this.xo, n4 + this.yo);
            }
        } else {
            this.g.drawBytes(byArray, n, n2, n3 + this.xo, n4 + this.yo);
        }
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n + this.xo, n2 + this.yo, n3, n4, n5, n6);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.g.fillOval(n + this.xo, n2 + this.yo, n3, n4);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + this.xo;
            int n4 = n2++;
            nArray2[n4] = nArray2[n4] + this.yo;
        }
        this.g.fillPolygon(nArray, nArray2, n);
        n2 = 0;
        while (n2 < n) {
            int n5 = n2;
            nArray[n5] = nArray[n5] - this.xo;
            int n6 = n2++;
            nArray2[n6] = nArray2[n6] - this.yo;
        }
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n + this.xo, n2 + this.yo, n3, n4);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n + this.xo, n2 + this.yo, n3, n4, n5, n6);
    }

    @Override
    public Shape getClip() {
        return this.g.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        Rectangle rectangle = this.g.getClipBounds();
        if (rectangle != null) {
            rectangle.x -= this.xo;
            rectangle.y -= this.yo;
        }
        return rectangle;
    }

    @Override
    public Font getFont() {
        return this.g.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics();
    }

    @Override
    public void setClip(Shape shape) {
        this.g.setClip(shape);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n + this.xo, n2 + this.yo, n3, this.height);
    }

    @Override
    public void setColor(Color color) {
        this.g.setColor(color);
    }

    @Override
    public void setFont(Font font) {
        this.g.setFont(font);
        this.height = this.g.getFontMetrics().getHeight();
        this.mapf = OutlineFontFactory.createOutlineFont(font, this.g.getFontMetrics(font));
    }

    @Override
    public void setPaintMode() {
        this.g.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.g.setXORMode(color);
    }

    @Override
    public void translate(int n, int n2) {
        this.g.translate(n, n2);
    }

    @Override
    public Color getColor() {
        return this.g.getColor();
    }
}

