/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.overlay.AbstractLengthOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayTransformationUtils;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Vector2d;

public class HorizontalDistanceOverlay
extends AbstractLengthOverlay
implements IGraphicObjectContainer {
    private static final double LINE_OVERLENGTH = 0.1;
    protected double[] p = new double[2];
    protected double[] q = new double[2];
    private int psx1;
    private int psy1;
    private int psx2;
    private int psy2;
    private int qsx1;
    private int qsy1;
    private int qsx2;
    private int qsy2;
    private double[] cl1;
    private double[] cl2;
    private int clx1;
    private int cly1;
    private int clx2;
    private int cly2;
    private double[] horizontalOrientationVector;

    public HorizontalDistanceOverlay() {
        super("Horizontal Distance", AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY);
        this.p[1] = 0.0;
        this.p[0] = 0.0;
        this.q[1] = 0.0;
        this.q[0] = 0.0;
        this.cl1 = new double[2];
        this.cl2 = new double[2];
        this.setHorizontalOrientationVector(1.0, 0.0);
    }

    public HorizontalDistanceOverlay(double d, double d2, double d3, double d4, double d5, double d6, AnnotationUnits annotationUnits) {
        this();
        this.p[0] = d;
        this.p[1] = d2;
        this.q[0] = d5;
        this.q[1] = d6;
        this.setSpacing(annotationUnits);
        this.makeHandles();
        this.setHorizontalOrientationVector(new Vector2d(d3 - d, d4 - d2));
    }

    private void makeHandles() {
        this.handles = new PresentationHandle[3];
        this.handles[0] = new PresentationHandle(this.psx1, this.psy1);
        this.handles[1] = new PresentationHandle(this.qsx2, this.qsy2);
        this.handles[2] = new TranslationHandle((this.psx1 + this.qsx2) / 2, (this.psy1 + this.qsy2) / 2);
        this.translationHandleIndex = 2;
    }

    private void setHandles() {
        this.handles[0].setPosition(this.psx1, this.psy1);
        this.handles[1].setPosition(this.qsx2, this.qsy2);
        this.handles[2].setPosition((this.psx1 + this.qsx2) / 2, (this.psy1 + this.qsy2) / 2);
    }

    private void setHorizontalOrientationVector(Vector2d vector2d) {
        vector2d.normalize();
        this.setHorizontalOrientationVector(vector2d.x, vector2d.y);
    }

    private void setHorizontalOrientationVector(double d, double d2) {
        this.horizontalOrientationVector = new double[]{d, d2};
    }

    @Override
    public double[] getXCoordinates() {
        return new double[]{this.p[0], this.q[0]};
    }

    @Override
    public double[] getYCoordinates() {
        return new double[]{this.p[1], this.q[1]};
    }

    @Override
    public int getPointCount() {
        return 2;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }

    @Override
    public boolean supportsProfile() {
        return false;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        HorizontalDistanceOverlay horizontalDistanceOverlay = (HorizontalDistanceOverlay)iTransformableOverlay;
        this.setHorizontalOrientationVector(OverlayTransformationUtils.updateOrientationVector(iOverlayPointModifier, horizontalDistanceOverlay.horizontalOrientationVector[0], horizontalDistanceOverlay.horizontalOrientationVector[1], 1000.0));
        this.p = iOverlayPointModifier.convert(horizontalDistanceOverlay.p);
        this.q = iOverlayPointModifier.convert(horizontalDistanceOverlay.q);
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.q = new double[2];
        this.p = new double[2];
        this.makeHandles();
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.p[0] = dArray[0];
                this.p[1] = dArray[1];
                break;
            }
            case 1: {
                this.q[0] = dArray[0];
                this.q[1] = dArray[1];
                TextOverlay textOverlay = this.getAnnotation();
                if (textOverlay == null || this.isCompleted()) break;
                textOverlay.setAnchor(this.p[0], this.p[1]);
                break;
            }
            case 2: {
                double d = (this.p[0] + this.q[0]) / 2.0;
                double d2 = (this.p[1] + this.q[1]) / 2.0;
                double d3 = dArray[0] - d;
                double d4 = dArray[1] - d2;
                this.p[0] = this.p[0] + d3;
                this.p[1] = this.p[1] + d4;
                this.q[0] = this.q[0] + d3;
                this.q[1] = this.q[1] + d4;
            }
        }
        this.toScreen();
        this.setSaved(false);
    }

    private List<double[]> calculateOverlayPoints() {
        double[] dArray = this.toScreen(this.p);
        this.psx1 = (int)dArray[0];
        this.psy1 = (int)dArray[1];
        dArray = this.toScreen(this.q);
        this.qsx2 = (int)dArray[0];
        this.qsy2 = (int)dArray[1];
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray = this.toScreen(dArray);
        Vector2d vector2d = new Vector2d(this.toScreen(this.horizontalOrientationVector));
        vector2d.x -= dArray[0];
        vector2d.y -= dArray[1];
        vector2d.normalize();
        double d = (double)(this.qsx2 - this.psx1) * vector2d.x + (double)(this.qsy2 - this.psy1) * vector2d.y;
        double d2 = d / 2.0;
        double d3 = d2 + d * 0.1;
        double d4 = d2 * vector2d.x;
        double d5 = d2 * vector2d.y;
        double d6 = d3 * vector2d.x;
        double d7 = d3 * vector2d.y;
        double[] dArray2 = new double[]{(double)this.psx1 + d6, (double)this.psy1 + d7};
        double[] dArray3 = new double[]{(double)this.qsx2 - d6, (double)this.qsy2 - d7};
        double[] dArray4 = new double[]{(double)this.psx1 + d4, (double)this.psy1 + d5};
        double[] dArray5 = new double[]{(double)this.qsx2 - d4, (double)this.qsy2 - d5};
        this.psx2 = (int)dArray2[0];
        this.psy2 = (int)dArray2[1];
        this.qsx1 = (int)dArray3[0];
        this.qsy1 = (int)dArray3[1];
        this.clx1 = (int)dArray4[0];
        this.cly1 = (int)dArray4[1];
        this.clx2 = (int)dArray5[0];
        this.cly2 = (int)dArray5[1];
        dArray2 = this.toImage(dArray2);
        dArray3 = this.toImage(dArray3);
        this.cl1 = this.toImage(dArray4);
        this.cl2 = this.toImage(dArray5);
        return Arrays.asList(this.p, dArray2, dArray3, this.q, this.cl1, this.cl2);
    }

    @Override
    void toScreenImpl() {
        this.calculateOverlayPoints();
        this.setHandles();
    }

    @Override
    double calculateMeasurementResult() {
        return this.calculateLength(this.cl1, this.clx1, this.cly1, this.cl2, this.clx2, this.cly2);
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, "");
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.setHorizontalOrientationVector(OverlayTransformationUtils.getHorizontalOrientationVector(this));
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                if (!this.hasAnnotation()) {
                    this.createAnnotation();
                }
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 2: {
                ++n2;
                this.activeHandleIndex = 1;
                break;
            }
            case 3: {
                this.handleDragged(1, dArray);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
        Stroke stroke = bufferedImageHolder.graphics.getStroke();
        bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_STROKE);
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            if (this.clx1 != this.clx2 && Math.abs((double)(this.cly1 - this.cly2) / (double)(this.clx1 - this.clx2)) < 1.0) {
                bufferedImageHolder.graphics.drawLine(this.clx1, this.cly1 - 1, this.clx2, this.cly2 - 1);
                bufferedImageHolder.graphics.drawLine(this.clx1, this.cly1 + 1, this.clx2, this.cly2 + 1);
            } else {
                bufferedImageHolder.graphics.drawLine(this.clx1 - 1, this.cly1, this.clx2 - 1, this.cly2);
                bufferedImageHolder.graphics.drawLine(this.clx1 + 1, this.cly1, this.clx2 + 1, this.cly2);
            }
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.clx1, this.cly1, this.clx2, this.cly2);
        bufferedImageHolder.graphics.setStroke(stroke);
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            if (this.psx1 != this.psx2 && Math.abs((double)(this.psy1 - this.psy2) / (double)(this.psx1 - this.psx2)) < 1.0) {
                bufferedImageHolder.graphics.drawLine(this.psx1, this.psy1 - 1, this.psx2, this.psy2 - 1);
                bufferedImageHolder.graphics.drawLine(this.psx1, this.psy1 + 1, this.psx2, this.psy2 + 1);
                bufferedImageHolder.graphics.drawLine(this.qsx1, this.qsy1 - 1, this.qsx2, this.qsy2 - 1);
                bufferedImageHolder.graphics.drawLine(this.qsx1, this.qsy1 + 1, this.qsx2, this.qsy2 + 1);
            } else {
                bufferedImageHolder.graphics.drawLine(this.psx1 - 1, this.psy1, this.psx2 - 1, this.psy2);
                bufferedImageHolder.graphics.drawLine(this.psx1 + 1, this.psy1, this.psx2 + 1, this.psy2);
                bufferedImageHolder.graphics.drawLine(this.qsx1 - 1, this.qsy1, this.qsx2 - 1, this.qsy2);
                bufferedImageHolder.graphics.drawLine(this.qsx1 + 1, this.qsy1, this.qsx2 + 1, this.qsy2);
            }
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.psx1, this.psy1, this.psx2, this.psy2);
        bufferedImageHolder.graphics.drawLine(this.qsx1, this.qsy1, this.qsx2, this.qsy2);
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            HorizontalDistanceOverlay horizontalDistanceOverlay = (HorizontalDistanceOverlay)presentationObject;
            horizontalDistanceOverlay.p = ReferencedObjectsCloning.clone(this.p);
            horizontalDistanceOverlay.q = ReferencedObjectsCloning.clone(this.q);
            horizontalDistanceOverlay.cl1 = ReferencedObjectsCloning.clone(this.cl1);
            horizontalDistanceOverlay.cl2 = ReferencedObjectsCloning.clone(this.cl2);
            horizontalDistanceOverlay.setHorizontalOrientationVector(this.horizontalOrientationVector[0], this.horizontalOrientationVector[1]);
        }
        catch (Exception exception) {
            log.error("Failed to clone a HorizontalDistanceOverlay object", (Throwable)exception);
        }
        return presentationObject;
    }

    @Override
    public void createBoundingShape() {
        this.toScreen();
        this.outBounds = new ArrayList();
        this.outBounds.add(this.createBoundingLine(this.psx1, this.psy1, this.psx2, this.psy2));
        this.outBounds.add(this.createBoundingLine(this.qsx1, this.qsy1, this.qsx2, this.qsy2));
        this.outBounds.add(this.createBoundingLine(this.clx1, this.cly1, this.clx2, this.cly2));
    }

    @Override
    public boolean isROI() {
        return true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        List<double[]> list = this.calculateOverlayPoints();
        int n = 3;
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(n);
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = list.get(2 * n2);
            double[] dArray2 = list.get(2 * n2 + 1);
            GraphicObject graphicObject = this.createGraphicObject();
            graphicObject.setTianiSubType(TianiSubType.HorizontalDistance);
            graphicObject.setGraphicType(GraphicType.PolyLine);
            graphicObject.setGraphicData(new float[]{(float)dArray[0], (float)dArray[1], (float)dArray2[0], (float)dArray2[1]});
            graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
            arrayList.add(graphicObject);
            ++n2;
        }
        return arrayList;
    }
}

