/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.image.ICalibrationData;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.AbstractSingleLineOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.TextOverlay;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;

public class LengthOverlay
extends AbstractSingleLineOverlay
implements IGraphicObjectContainer,
ICalibrationData {
    private static final String OVERLAY_NAME = "Length";

    public LengthOverlay() {
        super(OVERLAY_NAME, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY);
    }

    public LengthOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        super(OVERLAY_NAME, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY, d, d2, d3, d4, annotationUnits);
    }

    @Override
    double calculateMeasurementResult() {
        return this.calculateLength(this.p, this.pxi, this.pyi, this.q, this.qxi, this.qyi);
    }

    public double getLength() {
        return this.getMeasurementResult();
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, " ");
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.Length);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1], (float)this.q[0], (float)this.q[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public double getOriginalLength() {
        return this.getLength();
    }

    @Override
    public String getOriginalUnit() {
        return this.dimensionUnit();
    }

    @Override
    public Point3d getCalibrationData(double d) {
        return new Point3d(this.q[0] - this.p[0], this.q[1] - this.p[1], d);
    }
}

