/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.math.GeomUtil;
import com.tiani.jvision.info.IImageState;
import java.awt.Color;

public class LocalizerLineOverlay
implements Comparable<LocalizerLineOverlay> {
    private float px;
    private float py;
    private float qx;
    private float qy;
    private int pxi;
    private int pyi;
    private int qxi;
    private int qyi;
    private int imgNr = 0;
    private int frameNr = -1;

    public LocalizerLineOverlay(double d, double d2, double d3, double d4, int n, int n2) {
        this.px = (float)d;
        this.py = (float)d2;
        this.qx = (float)d3;
        this.qy = (float)d4;
        this.imgNr = n;
        this.frameNr = n2;
    }

    public String getAnnotation() {
        if (this.frameNr >= 0) {
            StringBuilder stringBuilder = new StringBuilder(8);
            stringBuilder.append(this.imgNr).append('/').append(this.frameNr);
            return stringBuilder.toString();
        }
        return Integer.toString(this.imgNr);
    }

    public int getImageNumber() {
        return this.imgNr;
    }

    public int getFrameNumer() {
        return this.frameNr;
    }

    int[] getScreenCoordinates() {
        int[] nArray = new int[]{this.pxi, this.pyi, this.qxi, this.qyi};
        return nArray;
    }

    final void paint(BufferedImageHolder bufferedImageHolder, IImageState iImageState) {
        this.updateCoordinates(iImageState);
        Color color = bufferedImageHolder.graphics.getColor();
        bufferedImageHolder.graphics.setColor(Color.lightGray);
        bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi, this.qxi, this.qyi);
        bufferedImageHolder.graphics.setColor(color);
    }

    public boolean isOnLocalizerLine(int n, int n2) {
        double d = Math.abs(GeomUtil.getSignedDistanceFromLine((double)this.pxi, (double)this.pyi, (double)this.qxi, (double)this.qyi, (double)n, (double)n2));
        double d2 = GeomUtil.getPerpendicularPositionOnLine((int)this.pxi, (int)this.pyi, (int)this.qxi, (int)this.qyi, (int)n, (int)n2);
        return d <= 5.0 && d2 >= 0.0 && d2 <= 1.0;
    }

    void updateCoordinates(IImageState iImageState) {
        double[] dArray = new double[2];
        iImageState.imageToScreen(this.px, this.py, dArray, null);
        this.pxi = (int)(dArray[0] + 0.5);
        this.pyi = (int)(dArray[1] + 0.5);
        iImageState.imageToScreen(this.qx, this.qy, dArray, null);
        this.qxi = (int)(dArray[0] + 0.5);
        this.qyi = (int)(dArray[1] + 0.5);
    }

    protected LocalizerLineOverlay copy() {
        return new LocalizerLineOverlay(this.px, this.py, this.qx, this.qy, this.imgNr, this.frameNr);
    }

    @Override
    public int compareTo(LocalizerLineOverlay localizerLineOverlay) {
        int n = this.imgNr - localizerLineOverlay.imgNr;
        if (n == 0) {
            return this.frameNr - localizerLineOverlay.frameNr;
        }
        return n;
    }
}

