/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.tiani.jvision.overlay.MagneticPath;
import com.tiani.jvision.overlay.MagneticPathSegment;
import com.tiani.jvision.overlay.curve.AbstractCurve;
import com.tiani.jvision.overlay.curve.CurvePolyLine;
import com.tiani.jvision.overlay.curve.ICurve;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Point3f;

public class MagneticContour
extends AbstractCurve {
    private MagneticPath activePath;
    private MagneticPathSegment activeSegment;

    public MagneticContour() {
    }

    public MagneticContour(MagneticContour magneticContour) {
        super(magneticContour);
    }

    @Override
    public ICurve copy() {
        return new MagneticContour(this);
    }

    @Override
    public void interpolate(CurvePolyLine curvePolyLine, float f, float f2, float f3, float f4) {
        curvePolyLine.clear();
        this.addSegment(this.activeSegment, curvePolyLine);
        this.addPath(this.activePath, curvePolyLine);
        if (curvePolyLine.getCount() == 0 && this.getCount() > 0) {
            Point3f point3f = this.getPoint(0);
            curvePolyLine.add(point3f.x, point3f.y, point3f.z);
        }
    }

    private void addPath(MagneticPath magneticPath, CurvePolyLine curvePolyLine) {
        if (magneticPath != null) {
            LinkedList<MagneticPathSegment> linkedList = magneticPath.getSegments();
            for (MagneticPathSegment magneticPathSegment : linkedList) {
                this.addSegment(magneticPathSegment, curvePolyLine);
            }
        }
    }

    private void addSegment(MagneticPathSegment magneticPathSegment, CurvePolyLine curvePolyLine) {
        if (magneticPathSegment != null) {
            List<Point> list = magneticPathSegment.getPathPoints();
            for (Point point : list) {
                curvePolyLine.add(point.x, point.y, 0.0f);
            }
        }
    }

    public void setActiveSegment(MagneticPathSegment magneticPathSegment) {
        this.activeSegment = magneticPathSegment;
    }

    public void setActivePath(MagneticPath magneticPath) {
        this.activePath = magneticPath;
    }

    void clearActiveSegment() {
        this.activeSegment = null;
    }

    void notifyMouseMoved() {
        this.onModification();
    }
}

