/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.InvisiblePresentationHandle;
import com.tiani.jvision.overlay.MagneticContour;
import com.tiani.jvision.overlay.MagneticContourPixelNode;
import com.tiani.jvision.overlay.MagneticPath;
import com.tiani.jvision.overlay.MagneticPathSegment;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.curve.CurveOverlay;
import com.tiani.jvision.renderer.ILeafRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MagneticContourOverlay
extends CurveOverlay {
    private static final double ONE_OVER_SQRT_TWO = 1.0 / Math.sqrt(2.0);
    public static final String ADD_MAGNETIC_CONTOUR_MARKER_NAME = "ADD_MAGNETIC_CONTOUR_MARKER";
    public static final String SUBTRACT_MAGNETIC_CONTOUR_MARKER_NAME = "SUBTRACT_MAGNETIC_CONTOUR_MARKER";
    public static final Color ADD_MAGNETIC_CONTOUR_MARKER_COLOR = Color.GREEN;
    public static final Color SUBTRACT_MAGNETIC_CONTOUR_MARKER_COLOR = Color.RED;
    private static final int INIT_TIMEOUT = 15;
    private static final int BORDER_COSTS = 35;
    private int costWidth;
    private int costHeight;
    private double image2Cost;
    private MagneticContourPixelNode[][] costsMatrix;
    private CountDownLatch isCostsMatrixInitialized = new CountDownLatch(1);
    private Point seedPoint;
    private Point mouseLocation;
    private Point firstPoint;
    private MagneticPath activePath;
    private volatile boolean isBusy = false;
    private volatile boolean inited = false;
    private MagneticContour magneticContour;

    public MagneticContourOverlay() {
        this(new MagneticContour());
    }

    public MagneticContourOverlay(double[] dArray, double[] dArray2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super(dArray, dArray2, annotationUnits, bl, bl2);
        this.closed = true;
    }

    public MagneticContourOverlay(MagneticContour magneticContour) {
        super(magneticContour);
        this.setState(PresentationObject.OverlayState.ShowHandles, true);
        this.magneticContour = magneticContour;
    }

    private void init() {
        try {
            boolean bl;
            if (!this.inited) {
                this.initImpl();
            }
            if (!(bl = this.isCostsMatrixInitialized.await(15L, TimeUnit.SECONDS))) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void initImpl() {
        this.inited = true;
        BufferedImage bufferedImage = this.getBufferedImageHolder();
        if (bufferedImage != null) {
            final WritableRaster writableRaster = bufferedImage.getRaster();
            this.costWidth = bufferedImage.getWidth();
            this.costHeight = bufferedImage.getHeight();
            this.costsMatrix = new MagneticContourPixelNode[this.costWidth][this.costHeight];
            int n = 0;
            while (n < this.costHeight) {
                int n2 = 0;
                while (n2 < this.costWidth) {
                    this.costsMatrix[n2][n] = new MagneticContourPixelNode(n2, n);
                    ++n2;
                }
                ++n;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MagneticContourOverlay.this.computeLinkCosts(((DataBufferInt)writableRaster.getDataBuffer()).getData());
                }
            }, "Init Costmatrix").start();
        }
    }

    public MagneticContourOverlay(Color color) {
        this.setColor(color);
    }

    protected BufferedImage getBufferedImageHolder() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        View view = visData.getView();
        Renderer renderer = view.getRenderer().clone();
        IImageInformation iImageInformation = view.getImageInformation();
        if (iImageInformation.is3D()) {
            int n = iImageInformation.getColumns();
            this.image2Cost = Math.round((double)view.getcwidth() / (double)n);
            if (this.image2Cost < 1.0) {
                this.image2Cost = 1.0;
            }
            n = (int)((double)view.getcwidth() / this.image2Cost);
            int n2 = (int)((double)view.getcheight() / this.image2Cost);
            RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(view.getcwidth(), view.getcheight());
            if (renderer instanceof ILeafRenderer) {
                ((ILeafRenderer)((Object)renderer)).removeAllROIs();
            }
            renderer.paint(rGBBufferedImageHolder, rGBBufferedImageHolder.getWidth(), rGBBufferedImageHolder.getHeight(), rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline, false);
            if (this.image2Cost == 1.0) {
                return rGBBufferedImageHolder.getImage();
            }
            RGBBufferedImageHolder rGBBufferedImageHolder2 = new RGBBufferedImageHolder(n, n2);
            Graphics2D graphics2D = rGBBufferedImageHolder2.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(rGBBufferedImageHolder.getImage(), 0, 0, n, n2, null);
            graphics2D.dispose();
            return rGBBufferedImageHolder2.getImage();
        }
        this.image2Cost = 1.0;
        RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(iImageInformation.getColumns(), iImageInformation.getRows());
        renderer.handleTEvent(new TEvent(138), null, 0, null);
        renderer.paint(rGBBufferedImageHolder, rGBBufferedImageHolder.getWidth(), rGBBufferedImageHolder.getHeight(), rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline, false);
        return rGBBufferedImageHolder.getImage();
    }

    protected void finishROICreation() {
    }

    @Override
    public List<GraphicObject> storeROI() {
        int n;
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        float[] fArray = this.samImg.getImgPointsRef().getXPoints();
        float[] fArray2 = this.samImg.getImgPointsRef().getYPoints();
        int n2 = n = this.samImg.getImgPointsRef().getCount();
        if (this.closed) {
            ++n2;
        }
        float[] fArray3 = new float[n2 * 2];
        int n3 = 0;
        while (n3 < n) {
            fArray3[n3 * 2] = fArray[n3];
            fArray3[n3 * 2 + 1] = fArray2[n3];
            ++n3;
        }
        if (this.closed) {
            fArray3[n * 2] = fArray[0];
            fArray3[n * 2 + 1] = fArray2[0];
        }
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.MagneticContour);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n2));
        graphicObject.setGraphicData(fArray3);
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public int getSnapHandleSize() {
        return SMALL_SNAP_HANDLE_SIZE;
    }

    @Override
    protected boolean isSnapHandleAtStart() {
        return false;
    }

    @Override
    protected void makeHandles() {
        if (this.magneticContour != null) {
            int n = this.magneticContour.getCount();
            if (n == 0) {
                this.handles = new PresentationHandle[]{new InvisiblePresentationHandle(0, 0)};
                return;
            }
            this.handles = new PresentationHandle[n + 1];
            this.scrCenterX = 0;
            this.scrCenterY = 0;
            int n2 = 0;
            while (n2 < n) {
                this.handles[n2] = n2 == 0 || n2 == 1 ? new InvisiblePresentationHandle(this.scrPointX[n2], this.scrPointY[n2]) : new PresentationHandle(this.scrPointX[n2], this.scrPointY[n2]);
                this.scrCenterX += this.scrPointX[n2];
                this.scrCenterY += this.scrPointY[n2];
                ++n2;
            }
            this.scrCenterX /= n;
            this.scrCenterY /= n;
            InvisiblePresentationHandle invisiblePresentationHandle = new InvisiblePresentationHandle(this.scrCenterX, this.scrCenterY);
            this.handles[n] = invisiblePresentationHandle;
        }
    }

    /*
     * Unable to fully structure code
     */
    private MagneticPathSegment getActiveSegment() {
        block4: {
            if (this.firstPoint == null) {
                return null;
            }
            if (this.seedPoint == null) {
                this.setSeedPoint(this.firstPoint);
            }
            if (this.seedPoint == null || this.mouseLocation == null || this.costsMatrix == null) break block4;
            var1_1 = this.image2Point(this.mouseLocation);
            if (var1_1 == null) {
                return null;
            }
            var2_2 = var1_1.x;
            var3_3 = var1_1.y;
            var4_4 = this.costsMatrix[var2_2][var3_3];
            var5_5 = new ArrayList<Point>();
            var6_6 = this.cost2Image(var4_4);
            var5_5.add(var6_6);
            if (var6_6.getX() != this.seedPoint.getX() || var6_6.getY() != this.seedPoint.getY()) ** GOTO lbl21
            return new MagneticPathSegment(this.cost2Image(this.seedPoint), var5_5);
lbl-1000:
            // 1 sources

            {
                var4_4 = var4_4.getPreviousNode();
                var5_5.add(this.cost2Image(var4_4));
lbl21:
                // 2 sources

                ** while (var4_4.getPreviousNode() != null)
            }
lbl22:
            // 1 sources

            return new MagneticPathSegment(this.cost2Image(this.seedPoint), var5_5);
        }
        return null;
    }

    private Point cost2Image(MagneticContourPixelNode magneticContourPixelNode) {
        return new Point((int)Math.round((double)magneticContourPixelNode.getX() * this.image2Cost), (int)Math.round((double)magneticContourPixelNode.getY() * this.image2Cost));
    }

    private Point cost2Image(Point point) {
        return new Point((int)Math.round(point.getX() * this.image2Cost), (int)Math.round(point.getY() * this.image2Cost));
    }

    private Point image2Point(Point point) {
        if (point == null) {
            return null;
        }
        Point point2 = new Point((int)Math.round((double)point.x / this.image2Cost), (int)Math.round((double)point.y / this.image2Cost));
        if (point2.x < 0 || point2.y < 0 || point2.x >= this.costWidth || point2.y >= this.costHeight) {
            return null;
        }
        return point2;
    }

    private void setMouseLocation(double d, double d2) {
        this.mouseLocation = new Point((int)d, (int)d2);
    }

    private void closePath() {
        if (!this.isBusy && this.activePath != null && this.activePath.getSegments().size() > 1) {
            Point point = this.activePath.getSeedPoint();
            this.setMouseLocation(point.getX(), point.getY());
            this.activePath.addSegment(this.getActiveSegment());
            this.cancelPath();
            this.costsMatrix = null;
            this.isCostsMatrixInitialized = new CountDownLatch(1);
            this.firstPoint = null;
        }
    }

    void removeSegmentFromPath(MagneticPath magneticPath, MagneticPathSegment magneticPathSegment) {
        MagneticPathSegment magneticPathSegment2;
        if (!this.isBusy && magneticPath != null && magneticPathSegment != null && (magneticPathSegment2 = magneticPath.removeSegment(magneticPathSegment)) != null) {
            MagneticPathSegment magneticPathSegment3;
            MagneticPathSegment magneticPathSegment4 = magneticPath.getNextSegment(magneticPathSegment2);
            this.activePath = magneticPath;
            this.setSeedPoint(magneticPathSegment2.getStartPoint());
            if (magneticPathSegment4 != null) {
                this.setMouseLocation(magneticPathSegment4.getStartPoint().getX(), magneticPathSegment4.getStartPoint().getY());
            }
            if ((magneticPathSegment3 = this.getActiveSegment()) != null) {
                magneticPathSegment2.setPathPoints(magneticPathSegment3.getPathPoints());
            }
            this.cancelPath();
        }
    }

    private void computeLinkCosts(int[] nArray) {
        int n;
        this.isBusy = true;
        double d = 0.0;
        int n2 = 1;
        while (n2 < this.costHeight - 1) {
            n = 1;
            while (n < this.costWidth - 1) {
                double d2 = this.computeLinkGradient(nArray, n, n2, 0);
                this.costsMatrix[n][n2].setLinkCosts(0, d2);
                this.costsMatrix[n][n2 - 1].setLinkCosts(4, d2);
                d = Math.max(d2, d);
                d2 = this.computeLinkGradient(nArray, n, n2, 6);
                this.costsMatrix[n][n2].setLinkCosts(6, d2);
                this.costsMatrix[n - 1][n2].setLinkCosts(2, d2);
                d = Math.max(d2, d);
                d2 = this.computeLinkGradient(nArray, n, n2, 7);
                this.costsMatrix[n][n2].setLinkCosts(7, d2);
                this.costsMatrix[n - 1][n2 - 1].setLinkCosts(3, d2);
                d = Math.max(d2, d);
                d2 = this.computeLinkGradient(nArray, n, n2, 1);
                this.costsMatrix[n][n2].setLinkCosts(1, d2);
                this.costsMatrix[n + 1][n2 - 1].setLinkCosts(5, d2);
                d = Math.max(d2, d);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.costHeight) {
            n = 0;
            while (n < this.costWidth) {
                int n3 = 0;
                while (n3 < 8) {
                    double d3 = d - this.costsMatrix[n][n2].getLinkCosts(n3);
                    if (n3 % 2 == 0) {
                        d3 *= ONE_OVER_SQRT_TWO;
                    }
                    this.costsMatrix[n][n2].setLinkCosts(n3, d3);
                    ++n3;
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.costWidth) {
            this.costsMatrix[n2][0].setLinkCosts(2, 35.0);
            this.costsMatrix[n2][0].setLinkCosts(6, 35.0);
            this.costsMatrix[n2][this.costHeight - 1].setLinkCosts(2, 35.0);
            this.costsMatrix[n2][this.costHeight - 1].setLinkCosts(6, 35.0);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.costHeight) {
            this.costsMatrix[0][n2].setLinkCosts(4, 35.0);
            this.costsMatrix[0][n2].setLinkCosts(0, 35.0);
            this.costsMatrix[this.costWidth - 1][n2].setLinkCosts(4, 35.0);
            this.costsMatrix[this.costWidth - 1][n2].setLinkCosts(0, 35.0);
            ++n2;
        }
        this.isCostsMatrixInitialized.countDown();
        this.isBusy = false;
    }

    private double computeLinkGradient(int[] nArray, int n, int n2, int n3) {
        double d;
        MagneticContourPixelNode magneticContourPixelNode = this.costsMatrix[n][n2];
        if (n3 % 2 == 0) {
            MagneticContourPixelNode magneticContourPixelNode2 = magneticContourPixelNode.getNeighbor((n3 + 7) % 8, this.costsMatrix);
            MagneticContourPixelNode magneticContourPixelNode3 = magneticContourPixelNode.getNeighbor((n3 + 6) % 8, this.costsMatrix);
            MagneticContourPixelNode magneticContourPixelNode4 = magneticContourPixelNode.getNeighbor((n3 + 1) % 8, this.costsMatrix);
            MagneticContourPixelNode magneticContourPixelNode5 = magneticContourPixelNode.getNeighbor((n3 + 2) % 8, this.costsMatrix);
            d = Math.abs((this.getSample(nArray, magneticContourPixelNode4) + this.getSample(nArray, magneticContourPixelNode5) - this.getSample(nArray, magneticContourPixelNode2) - this.getSample(nArray, magneticContourPixelNode3)) / 4);
        } else {
            MagneticContourPixelNode magneticContourPixelNode6 = magneticContourPixelNode.getNeighbor(n3 - 1, this.costsMatrix);
            MagneticContourPixelNode magneticContourPixelNode7 = magneticContourPixelNode.getNeighbor((n3 + 1) % 8, this.costsMatrix);
            d = Math.abs((this.getSample(nArray, magneticContourPixelNode7) - this.getSample(nArray, magneticContourPixelNode6)) / 2);
        }
        return d;
    }

    private int getSample(int[] nArray, MagneticContourPixelNode magneticContourPixelNode) {
        return nArray[magneticContourPixelNode.getX() + magneticContourPixelNode.getY() * this.costWidth] & 0xFF;
    }

    @Override
    public void select(boolean bl) {
        super.select(bl);
        this.setState(PresentationObject.OverlayState.ShowHandles, !this.isCompleted());
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        if (this.isCompleted()) {
            return;
        }
        this.init();
        int n2 = this.magneticContour.getCount();
        this.handles[n2] = new InvisiblePresentationHandle(0, 0);
        this.setMouseLocation((int)dArray[0], (int)dArray[1]);
        this.magneticContour.setActiveSegment(this.getActiveSegment());
        this.magneticContour.notifyMouseMoved();
        this.toScreen();
        this.setSaved(false);
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        this.init();
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        double[] dArray2 = this.toScreen(dArray);
        double d = dArray2[0];
        double d2 = dArray2[1];
        int n2 = this.magneticContour.getCount();
        int n3 = this.getSnapHandleSize() / 2;
        if (n2 > 2) {
            boolean bl = this.closed = Math.abs((double)this.scrPointX[n2 - 1] - d) < (double)n3 && Math.abs((double)this.scrPointY[n2 - 1] - d2) < (double)n3;
        }
        if (n2 > 2 && (this.closed || Math.abs((double)this.scrPointX[1] - d) < (double)n3 && Math.abs((double)this.scrPointY[1] - d2) < (double)n3)) {
            this.closePath();
            this.magneticContour.clearActiveSegment();
            this.closed = true;
            this.magneticContour.removeLastPoint();
            this.magneticContour.setClosed(true);
            this.makeHandles();
            this.setState(PresentationObject.OverlayState.ShowHandles, false);
            this.afterInteractiveGeneration();
            this.finishROICreation();
            return -1;
        }
        int n4 = (int)dArray[0];
        int n5 = (int)dArray[1];
        this.handles = Arrays.copyOf(this.handles, this.handles.length + 1);
        this.magneticContour.addPoint(n4, n5, 0.0f);
        this.addSeedPoint(n4, n5, true);
        this.magneticContour.clearActiveSegment();
        this.magneticContour.setActivePath(this.activePath);
        n2 = this.magneticContour.getCount();
        if (n2 > 2) {
            PresentationHandle presentationHandle = this.handles[n2 - 1];
            this.handles[n2 - 1] = new PresentationHandle(presentationHandle.getX(), presentationHandle.getY());
        }
        this.handles[n2] = new InvisiblePresentationHandle(0, 0);
        this.toScreen();
        this.activeHandleIndex = n2 - 1;
        return n + 1;
    }

    private void setSeedPoint(Point point) {
        this.init();
        if (this.firstPoint == null) {
            this.firstPoint = point;
        }
        this.isBusy = true;
        Point point2 = this.seedPoint = point;
        int n = 0;
        while (n < this.costHeight) {
            int n2 = 0;
            while (n2 < this.costWidth) {
                this.costsMatrix[n2][n].setState(MagneticContourPixelNode.State.INITIALIZED);
                ++n2;
            }
            ++n;
        }
        MagneticContourPixelNode magneticContourPixelNode = this.costsMatrix[point2.x][point2.y];
        magneticContourPixelNode.setTotalCosts(0.0);
        magneticContourPixelNode.setPreviousNode(null);
        PriorityQueue<MagneticContourPixelNode> priorityQueue = new PriorityQueue<MagneticContourPixelNode>();
        priorityQueue.add(magneticContourPixelNode);
        while (!priorityQueue.isEmpty()) {
            MagneticContourPixelNode magneticContourPixelNode2 = (MagneticContourPixelNode)priorityQueue.poll();
            magneticContourPixelNode2.setState(MagneticContourPixelNode.State.EXPANDED);
            int n3 = 0;
            while (n3 < 8) {
                MagneticContourPixelNode magneticContourPixelNode3 = magneticContourPixelNode2.getNeighbor(n3, this.costsMatrix);
                if (magneticContourPixelNode3 != null) {
                    if (MagneticContourPixelNode.State.INITIALIZED == magneticContourPixelNode3.getState()) {
                        magneticContourPixelNode3.setPreviousNode(magneticContourPixelNode2);
                        magneticContourPixelNode3.setTotalCosts(magneticContourPixelNode2.getTotalCosts() + magneticContourPixelNode2.getLinkCosts(n3));
                        magneticContourPixelNode3.setState(MagneticContourPixelNode.State.ACTIVE);
                        priorityQueue.add(magneticContourPixelNode3);
                    } else if (MagneticContourPixelNode.State.ACTIVE == magneticContourPixelNode3.getState() && magneticContourPixelNode2.getTotalCosts() + magneticContourPixelNode2.getLinkCosts(n3) < magneticContourPixelNode3.getTotalCosts()) {
                        magneticContourPixelNode3.setPreviousNode(magneticContourPixelNode2);
                        magneticContourPixelNode3.setTotalCosts(magneticContourPixelNode2.getTotalCosts() + magneticContourPixelNode2.getLinkCosts(n3));
                    }
                }
                ++n3;
            }
        }
        this.isBusy = false;
    }

    void addSeedPoint(int n, int n2, boolean bl) {
        if (!this.isBusy) {
            this.init();
            this.setMouseLocation(n, n2);
            if (this.mouseLocation != null) {
                if (this.seedPoint == null) {
                    this.activePath = new MagneticPath(this.mouseLocation);
                } else {
                    this.activePath.addSegment(this.getActiveSegment());
                }
                final Point point = this.image2Point(this.mouseLocation);
                if (point == null) {
                    return;
                }
                if (bl) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MagneticContourOverlay.this.setSeedPoint(point);
                        }
                    }, "Set seed point").start();
                } else {
                    this.setSeedPoint(point);
                }
            }
        }
    }

    private void cancelPath() {
        this.activePath = null;
        this.seedPoint = null;
    }

    @Override
    protected void paintHandles(BufferedImageHolder bufferedImageHolder) {
        if (bufferedImageHolder != null && this.showHandles() && this.handles != null) {
            PresentationHandle[] presentationHandleArray = this.handles;
            int n = this.handles.length;
            int n2 = 0;
            while (n2 < n) {
                PresentationHandle presentationHandle = presentationHandleArray[n2];
                if (this.isColorUserDefined()) {
                    bufferedImageHolder.graphics.setColor(this.objCol);
                }
                presentationHandle.paint(bufferedImageHolder.graphics);
                ++n2;
            }
        }
    }
}

