/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

public class MagneticContourPixelNode
implements Comparable<MagneticContourPixelNode> {
    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHWEST = 5;
    public static final int WEST = 6;
    public static final int NORTHWEST = 7;
    private int x;
    private int y;
    private double[] linkCosts;
    private double totalCosts;
    private State state;
    private MagneticContourPixelNode previousNode;

    public MagneticContourPixelNode(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.linkCosts = new double[8];
    }

    @Override
    public int compareTo(MagneticContourPixelNode magneticContourPixelNode) {
        return (int)Math.ceil(this.totalCosts - magneticContourPixelNode.totalCosts);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((MagneticContourPixelNode)object) == 0;
    }

    public int hashCode() {
        return (int)this.totalCosts;
    }

    public MagneticContourPixelNode getNeighbor(int n, MagneticContourPixelNode[][] magneticContourPixelNodeArray) {
        int n2 = -1;
        int n3 = -1;
        switch (n) {
            case 0: {
                n2 = this.x;
                n3 = this.y - 1;
                break;
            }
            case 1: {
                n2 = this.x + 1;
                n3 = this.y - 1;
                break;
            }
            case 2: {
                n2 = this.x + 1;
                n3 = this.y;
                break;
            }
            case 3: {
                n2 = this.x + 1;
                n3 = this.y + 1;
                break;
            }
            case 4: {
                n2 = this.x;
                n3 = this.y + 1;
                break;
            }
            case 5: {
                n2 = this.x - 1;
                n3 = this.y + 1;
                break;
            }
            case 6: {
                n2 = this.x - 1;
                n3 = this.y;
                break;
            }
            case 7: {
                n2 = this.x - 1;
                n3 = this.y - 1;
            }
        }
        if (n2 >= 0 && n2 < magneticContourPixelNodeArray.length && n3 >= 0 && n3 < magneticContourPixelNodeArray[0].length) {
            return magneticContourPixelNodeArray[n2][n3];
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setLinkCosts(int n, double d) {
        this.linkCosts[n] = d;
    }

    public double getLinkCosts(int n) {
        return this.linkCosts[n];
    }

    double[] getLinkCosts() {
        return this.linkCosts;
    }

    public void setPreviousNode(MagneticContourPixelNode magneticContourPixelNode) {
        this.previousNode = magneticContourPixelNode;
    }

    public MagneticContourPixelNode getPreviousNode() {
        return this.previousNode;
    }

    public void setTotalCosts(double d) {
        this.totalCosts = d;
    }

    public double getTotalCosts() {
        return this.totalCosts;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INITIALIZED,
        ACTIVE,
        EXPANDED;

    }
}

