/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.tiani.jvision.overlay.MagneticPathSegment;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;

public class MagneticPath {
    private Point seedPoint;
    private LinkedList<MagneticPathSegment> segments;

    public MagneticPath(Point point) {
        this.seedPoint = point;
        this.segments = new LinkedList();
    }

    public Point getSeedPoint() {
        return this.seedPoint;
    }

    void setSeedPoint(Point point) {
        this.seedPoint = point;
    }

    public LinkedList<MagneticPathSegment> getSegments() {
        return this.segments;
    }

    void setSegments(LinkedList<MagneticPathSegment> linkedList) {
        this.segments = linkedList;
    }

    public void addSegment(MagneticPathSegment magneticPathSegment) {
        if (magneticPathSegment != null) {
            this.segments.addFirst(magneticPathSegment);
        }
    }

    void insertSegmentAfter(MagneticPathSegment magneticPathSegment, MagneticPathSegment magneticPathSegment2) {
        int n = this.segments.indexOf(magneticPathSegment);
        this.segments.add(n, magneticPathSegment2);
    }

    public MagneticPathSegment removeSegment(MagneticPathSegment magneticPathSegment) {
        MagneticPathSegment magneticPathSegment2 = this.getPreviousSegment(magneticPathSegment);
        this.segments.remove(magneticPathSegment);
        return magneticPathSegment2;
    }

    public Point removeLastSegment() {
        if (!this.segments.isEmpty()) {
            MagneticPathSegment magneticPathSegment = this.segments.removeFirst();
            return magneticPathSegment.getStartPoint();
        }
        return null;
    }

    public MagneticPathSegment getNextSegment(MagneticPathSegment magneticPathSegment) {
        Iterator iterator = this.segments.iterator();
        MagneticPathSegment magneticPathSegment2 = this.segments.getLast();
        while (iterator.hasNext()) {
            MagneticPathSegment magneticPathSegment3 = (MagneticPathSegment)iterator.next();
            if (magneticPathSegment3 == magneticPathSegment) {
                return magneticPathSegment2;
            }
            magneticPathSegment2 = magneticPathSegment3;
        }
        return null;
    }

    MagneticPathSegment getPreviousSegment(MagneticPathSegment magneticPathSegment) {
        Iterator iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            MagneticPathSegment magneticPathSegment2 = (MagneticPathSegment)iterator.next();
            if (magneticPathSegment2 != magneticPathSegment) continue;
            if (iterator.hasNext()) {
                return (MagneticPathSegment)iterator.next();
            }
            return this.segments.getFirst();
        }
        return null;
    }
}

