/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.jvision.overlay.MagnifierOverlay;
import com.tiani.jvision.toptoolbar.MagnifierAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class MagnifierActions
implements PActionProvider {
    public static final String AUTO_WINDOW = "MAGNIFIER_AUTO_WINDOW";
    public static final String MAGNIFIER_SUBMENU = "MAGNIFIER_SETTINGS";
    private static final String MAGNIFIER_SIZE_PREFIX = "MAGNIFIER_SIZE_";
    private static final String MAGNIFIER_SIZE_LARGER = "MAGNIFIER_SIZE_LARGER";
    private static final String MAGNIFIER_SIZE_SMALLER = "MAGNIFIER_SIZE_SMALLER";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        ArrayList<PAction> arrayList2 = new ArrayList<PAction>();
        AutoWindowMagnifierAction autoWindowMagnifierAction = new AutoWindowMagnifierAction();
        arrayList.add(autoWindowMagnifierAction);
        arrayList2.add(autoWindowMagnifierAction);
        arrayList2.add(new MagnifierSizeSelection(new SizeInfo("200 x 200", 200)));
        arrayList2.add(new MagnifierSizeSelection(new SizeInfo("300 x 300", 300)));
        arrayList2.add(new MagnifierSizeSelection(new SizeInfo("400 x 400", 400)));
        arrayList2.add(new MagnifierSizeSelection(new SizeInfo("500 x 500", 500)));
        arrayList2.add(new MagnifierSizeSelection(new SizeInfo("600 x 600", 600)));
        arrayList2.add(new MagnifierSizeSelection(new SizeInfo("700 x 700", 700)));
        arrayList.add(new MagnifierGroupAction(arrayList2));
        arrayList.add(new MagnifierSizeChange(true));
        arrayList.add(new MagnifierSizeChange(false));
        return arrayList;
    }

    private MagnifierOverlay getOverlay() {
        return MagnifierAction.getActiveMagnifier();
    }

    private class AutoWindowMagnifierAction
    extends SelectablePAction {
        private AutoWindowMagnifierAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("MagnifierOverlay.AutoWindow");
        }

        @Override
        protected boolean isEnabledImpl() {
            return MagnifierAction.isMagnifierEnabled();
        }

        @Override
        public boolean isSelected() {
            return Config.impaxee.jvision.DISPLAY.MagnifyingGlassAutoWindow.get();
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getID() {
            return MagnifierActions.AUTO_WINDOW;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MagnifierOverlay magnifierOverlay = MagnifierActions.this.getOverlay();
            if (magnifierOverlay == null) {
                MagnifierOverlay.configureAutoWindow(!this.isSelected());
            } else {
                magnifierOverlay.setAutoWindow(!this.isSelected());
            }
            return true;
        }
    }

    private static class MagnifierGroupAction
    extends CompoundAbstractPAction {
        public MagnifierGroupAction(List<PAction> list) {
            this.init(list);
        }

        @Override
        public String getCaption() {
            return Messages.getString("MagnifierOverlay.MagnifierSettings");
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getID() {
            return MagnifierActions.MAGNIFIER_SUBMENU;
        }

        @Override
        protected boolean isEnabledImpl() {
            return MagnifierAction.isMagnifierEnabled();
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }
    }

    private class MagnifierSizeChange
    extends AbstractPAction {
        private boolean larger;

        public MagnifierSizeChange(boolean bl) {
            this.larger = bl;
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getCaption() {
            if (this.larger) {
                return Messages.getString("MagnifierActions.EnlargeMagnifier");
            }
            return Messages.getString("MagnifierActions.ReduceMagnifier");
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (this.larger) {
                return new KeyShortcut(106);
            }
            return new KeyShortcut(111);
        }

        @Override
        public String getID() {
            if (this.larger) {
                return MagnifierActions.MAGNIFIER_SIZE_LARGER;
            }
            return MagnifierActions.MAGNIFIER_SIZE_SMALLER;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MagnifierOverlay magnifierOverlay = MagnifierActions.this.getOverlay();
            int n = (int)Config.impaxee.jvision.DISPLAY.MagnifyingGlassSize.get();
            if ((n += (this.larger ? 1 : -1) * 100) >= 200 && n <= 800) {
                if (magnifierOverlay != null) {
                    magnifierOverlay.setExtent(n);
                    magnifierOverlay.getView().repaint();
                } else {
                    MagnifierOverlay.configureExtent(n);
                }
                return true;
            }
            return false;
        }
    }

    private class MagnifierSizeSelection
    extends SelectablePAction {
        private SizeInfo sizeInfo;

        public MagnifierSizeSelection(SizeInfo sizeInfo) {
            this.sizeInfo = sizeInfo;
        }

        @Override
        public boolean isSelected() {
            return Config.impaxee.jvision.DISPLAY.MagnifyingGlassSize.get() == (long)this.sizeInfo.extend;
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getCaption() {
            return this.sizeInfo.name;
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getID() {
            return MagnifierActions.MAGNIFIER_SIZE_PREFIX + this.sizeInfo.extend;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MagnifierOverlay magnifierOverlay = MagnifierActions.this.getOverlay();
            if (magnifierOverlay != null) {
                magnifierOverlay.setExtent(this.sizeInfo.extend);
            } else {
                MagnifierOverlay.configureExtent(this.sizeInfo.extend);
            }
            return true;
        }
    }

    private static class SizeInfo {
        private String name;
        private int extend;

        public SizeInfo(String string, int n) {
            this.name = string;
            this.extend = n;
        }
    }
}

