/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.overlay.AbstractLengthOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayTransformationUtils;
import com.tiani.jvision.overlay.PointToLineProjection;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import com.tiani.jvision.overlay.placement.IPositioningPoint;
import com.tiani.jvision.overlay.placement.LabelPlacementManager;
import com.tiani.jvision.overlay.placement.PositioningPoint;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;

public class NormalDistanceOverlay
extends AbstractLengthOverlay
implements IGraphicObjectContainer {
    private double[] p;
    private double[] q;
    private double[] s;
    private int d1x;
    private int d1y;
    private int d2x;
    private int d2y;
    private int pxi;
    private int pyi;
    private int qxi;
    private int qyi;
    private int sxi;
    private int syi;
    private int rxi;
    private int ryi;
    private PointToLineProjection.Location projectionLocation = PointToLineProjection.Location.WITHIN_LINE;
    private boolean isDataPointValid;

    public NormalDistanceOverlay() {
        super("NormalDistance", AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_EQUAL_PIXEL_SPACING);
        this.createDataPointArrays();
        this.q[1] = 0.0;
        this.q[0] = 0.0;
        this.p[1] = 0.0;
        this.p[0] = 0.0;
        this.s[0] = 0.0;
        this.s[1] = 0.0;
    }

    public NormalDistanceOverlay(double d, double d2, double d3, double d4, double d5, double d6, AnnotationUnits annotationUnits) {
        this();
        this.p[0] = d;
        this.p[1] = d2;
        this.q[0] = d3;
        this.q[1] = d4;
        this.s[0] = d5;
        this.s[1] = d6;
        this.isDataPointValid = true;
        this.setSpacing(annotationUnits);
        this.makeHandles();
        this.setEditable(!Product.isCDViewer());
    }

    private void createDataPointArrays() {
        this.q = new double[2];
        this.p = new double[2];
        this.s = new double[2];
    }

    @Override
    public double[] getXCoordinates() {
        return new double[]{this.p[0], this.q[0], this.s[0]};
    }

    @Override
    public double[] getYCoordinates() {
        return new double[]{this.p[1], this.q[1], this.s[1]};
    }

    @Override
    public int getPointCount() {
        return 3;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.createDataPointArrays();
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return true;
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[4];
        this.handles[0] = new PresentationHandle(this.pxi, this.pyi);
        this.handles[1] = new PresentationHandle(this.qxi, this.qyi);
        this.handles[2] = new PresentationHandle(this.sxi, this.syi);
        this.handles[3] = new TranslationHandle((this.pxi + this.qxi) / 2, (this.pyi + this.qyi) / 2);
        this.translationHandleIndex = 3;
    }

    @Override
    double calculateMeasurementResult() {
        IImageInformation iImageInformation = this.getImageInformation();
        if (ImageDef.hasPixelAspectRatioOtherThan1to1(iImageInformation)) {
            return Double.NaN;
        }
        double d = this.calculateLength(this.p, this.pxi, this.pyi, this.q, this.qxi, this.qyi);
        double d2 = this.calculateLength(this.q, this.qxi, this.qyi, this.s, this.sxi, this.syi);
        double d3 = this.calculateLength(this.s, this.sxi, this.syi, this.p, this.pxi, this.pyi);
        double d4 = d * d;
        double d5 = d2 * d2;
        double d6 = d3 * d3;
        return Math.sqrt(2.0 * (d4 * d5 + d5 * d6 + d6 * d4) - (d4 * d4 + d5 * d5 + d6 * d6)) / (2.0 * d);
    }

    @Override
    void toScreenImpl() {
        double[] dArray = this.toScreen(this.p);
        this.pxi = (int)dArray[0];
        this.pyi = (int)dArray[1];
        dArray = this.toScreen(this.q);
        this.qxi = (int)dArray[0];
        this.qyi = (int)dArray[1];
        dArray = this.toScreen(this.s);
        this.sxi = (int)dArray[0];
        this.syi = (int)dArray[1];
        this.handles[0].setPosition(this.pxi, this.pyi);
        this.handles[1].setPosition(this.qxi, this.qyi);
        this.handles[2].setPosition(this.sxi, this.syi);
        PointToLineProjection pointToLineProjection = PointToLineProjection.project(this.pxi, this.pyi, this.qxi, this.qyi, this.sxi, this.syi);
        if (pointToLineProjection != null) {
            this.rxi = (int)(pointToLineProjection.getX() + 0.5);
            this.ryi = (int)(pointToLineProjection.getY() + 0.5);
            this.projectionLocation = pointToLineProjection.getLocation();
        } else {
            this.projectionLocation = PointToLineProjection.Location.WITHIN_LINE;
        }
        double[] dArray2 = new double[]{(this.p[0] + this.q[0]) / 2.0, (this.p[1] + this.q[1]) / 2.0};
        dArray2 = this.toScreen(dArray2);
        this.handles[this.translationHandleIndex].setPosition((int)dArray2[0], (int)dArray2[1]);
        int n = Math.min(Math.min(this.pxi, this.qxi), this.sxi);
        int n2 = Math.max(Math.max(this.pxi, this.qxi), this.sxi);
        int n3 = Math.min(Math.min(this.pyi, this.qyi), this.syi);
        int n4 = Math.max(Math.max(this.pyi, this.qyi), this.syi);
        this.bounds.x = n - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = n3 - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = n2 - n + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = n4 - n3 + 2 * PresentationHandle.HANDLE_SIZE;
        double[] dArray3 = new double[]{this.q[0] - this.p[0], this.q[1] - this.p[1]};
        double d = Math.sqrt((this.pxi - this.qxi) * (this.pxi - this.qxi) + (this.pyi - this.qyi) * (this.pyi - this.qyi));
        if (d > 0.0) {
            dArray3[0] = dArray3[0] / d;
            dArray3[1] = dArray3[1] / d;
            double[] dArray4 = new double[]{-dArray3[1], dArray3[0]};
            double[] dArray5 = new double[]{this.s[0] + dArray4[0] * 5.0 - dArray3[0] * 5.0, this.s[1] + dArray4[1] * 5.0 - dArray3[1] * 5.0};
            dArray5 = this.toScreen(dArray5);
            this.d1x = (int)dArray5[0] - this.sxi;
            this.d1y = (int)dArray5[1] - this.syi;
            dArray5[0] = this.s[0] + dArray4[0] * 5.0 + dArray3[0] * 5.0;
            dArray5[1] = this.s[1] + dArray4[1] * 5.0 + dArray3[1] * 5.0;
            dArray5 = this.toScreen(dArray5);
            this.d2x = (int)dArray5[0] - this.sxi;
            this.d2y = (int)dArray5[1] - this.syi;
        }
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            if (this.pxi != this.qxi && Math.abs(this.pyi - this.qyi) / Math.abs(this.pxi - this.qxi) < 1) {
                bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi - 1, this.qxi, this.qyi - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi + 1, this.qxi, this.qyi + 1);
            } else {
                bufferedImageHolder.graphics.drawLine(this.pxi - 1, this.pyi, this.qxi - 1, this.qyi);
                bufferedImageHolder.graphics.drawLine(this.pxi + 1, this.pyi, this.qxi + 1, this.qyi);
            }
            if (this.isDataPointValid) {
                if (this.d1x != 0 && Math.abs(this.d1y) / Math.abs(this.d1x) < 1) {
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d1x, this.syi - this.d1y - 1, this.sxi + this.d1x, this.syi + this.d1y - 1);
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d2x - 1, this.syi - this.d2y, this.sxi + this.d2x - 1, this.syi + this.d2y);
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d1x, this.syi - this.d1y + 1, this.sxi + this.d1x, this.syi + this.d1y + 1);
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d2x + 1, this.syi - this.d2y, this.sxi + this.d2x + 1, this.syi + this.d2y);
                } else {
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d2x, this.syi - this.d2y - 1, this.sxi + this.d2x, this.syi + this.d2y - 1);
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d1x - 1, this.syi - this.d1y, this.sxi + this.d1x - 1, this.syi + this.d1y);
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d2x, this.syi - this.d2y + 1, this.sxi + this.d2x, this.syi + this.d2y + 1);
                    bufferedImageHolder.graphics.drawLine(this.sxi - this.d1x + 1, this.syi - this.d1y, this.sxi + this.d1x + 1, this.syi + this.d1y);
                }
            }
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.pxi, this.pyi, this.qxi, this.qyi);
        if (this.isDataPointValid) {
            bufferedImageHolder.graphics.drawLine(this.sxi - this.d1x, this.syi - this.d1y, this.sxi + this.d1x, this.syi + this.d1y);
            bufferedImageHolder.graphics.drawLine(this.sxi - this.d2x, this.syi - this.d2y, this.sxi + this.d2x, this.syi + this.d2y);
            Color color = bufferedImageHolder.graphics.getColor();
            Stroke stroke = bufferedImageHolder.graphics.getStroke();
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_OUTLINE_STROKE);
                this.paintProjectionLines(bufferedImageHolder);
            }
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_STROKE);
            this.paintProjectionLines(bufferedImageHolder);
            bufferedImageHolder.graphics.setStroke(stroke);
        }
    }

    private void paintProjectionLines(BufferedImageHolder bufferedImageHolder) {
        bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi, this.sxi, this.syi);
        switch (this.projectionLocation) {
            case BEFORE_LINE_START: {
                bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi, this.pxi, this.pyi);
                break;
            }
            case AFTER_LINE_END: {
                bufferedImageHolder.graphics.drawLine(this.rxi, this.ryi, this.qxi, this.qyi);
                break;
            }
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.p = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 1: {
                this.q = OverlayTransformationUtils.snapToAxisIfRequested(this, this.p, dArray);
                this.toScreen();
                break;
            }
            case 2: {
                this.s = (double[])dArray.clone();
                this.isDataPointValid = true;
                TextOverlay textOverlay = this.getAnnotation();
                if (textOverlay != null) {
                    ArrayList<IPositioningPoint> arrayList = new ArrayList<IPositioningPoint>(2);
                    arrayList.add(new PositioningPoint(this.toScreen(this.s), 0));
                    arrayList.add(new PositioningPoint(this.toScreen(this.q), 1));
                    arrayList.add(new PositioningPoint(this.toScreen(this.p), 1));
                    Rectangle rectangle = textOverlay.getBoundingBox();
                    LabelPlacementManager labelPlacementManager = new LabelPlacementManager(this.getView(), arrayList, this.getTextSpacing(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), textOverlay, this);
                    double[] dArray2 = this.toImage(labelPlacementManager.getBestFit());
                    textOverlay.setAnchor(dArray2[0], dArray2[1]);
                }
                this.toScreen();
                break;
            }
            case 3: {
                if (!this.isCompleted()) {
                    this.handleDragged(2, dArray);
                    return;
                }
                double d = dArray[0] - (this.q[0] + this.p[0]) / 2.0;
                double d2 = dArray[1] - (this.q[1] + this.p[1]) / 2.0;
                this.p[0] = this.p[0] + d;
                this.p[1] = this.p[1] + d2;
                this.q[0] = this.q[0] + d;
                this.q[1] = this.q[1] + d2;
                this.s[0] = this.s[0] + d;
                this.s[1] = this.s[1] + d2;
                this.toScreenOnTranslation();
            }
        }
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 2: {
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 3: {
                if (!this.hasAnnotation()) {
                    this.createAnnotation();
                }
                this.handleDragged(2, dArray);
                this.activeHandleIndex = 2;
                ++n2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, " ");
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(2);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.NormalDistance);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1], (float)this.q[0], (float)this.q[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.NormalDistance);
        graphicObject.setGraphicType(GraphicType.Point);
        graphicObject.setGraphicData(new float[]{(float)this.s[0], (float)this.s[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(1));
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            NormalDistanceOverlay normalDistanceOverlay = (NormalDistanceOverlay)presentationObject;
            normalDistanceOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.p), ReferencedObjectsCloning.clone(this.q), ReferencedObjectsCloning.clone(this.s));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    private void setClonedParameters(double[] dArray, double[] dArray2, double[] dArray3) {
        this.p = dArray;
        this.q = dArray2;
        this.s = dArray3;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        NormalDistanceOverlay normalDistanceOverlay = (NormalDistanceOverlay)iTransformableOverlay;
        this.p = iOverlayPointModifier.convert(normalDistanceOverlay.p);
        this.q = iOverlayPointModifier.convert(normalDistanceOverlay.q);
        this.s = iOverlayPointModifier.convert(normalDistanceOverlay.s);
    }

    @Override
    public void createBoundingShape() {
        this.toScreen();
        this.outBounds = new ArrayList(4);
        this.outBounds.add(this.createBoundingLine(this.pxi, this.pyi, this.qxi, this.qyi));
        this.outBounds.add(this.createBoundingLine(this.sxi, this.syi, this.rxi, this.ryi));
        switch (this.projectionLocation) {
            case BEFORE_LINE_START: {
                this.outBounds.add(this.createBoundingLine(this.pxi, this.pyi, this.rxi, this.ryi));
                break;
            }
            case AFTER_LINE_END: {
                this.outBounds.add(this.createBoundingLine(this.qxi, this.qyi, this.rxi, this.ryi));
                break;
            }
        }
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }
}

