/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageInformationProvider;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.info.IImageStateProvider;
import com.tiani.jvision.overlay.FontSet;
import com.tiani.jvision.overlay.OverlayFontConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.exception.CloneFailedException;

public abstract class Overlay
implements Cloneable,
IImageInformationProvider,
IImageStateProvider {
    protected static final ALogger log = ALogger.getLogger(Overlay.class);
    public static final int SNAP_HANDLE_SIZE = 16;
    public static final int SMALL_SNAP_HANDLE_SIZE = GUI.getScaledDiagnosticInt((int)7);
    private static final int printFFactor = (int)Config.impaxee.jvision.MAPPING.PrintFontScale.get();
    private static final double printMaximumFontRealSize = (double)Config.impaxee.jvision.MAPPING.MaximumPrintFontSize.get() / 72.0;
    private static final int printMaximumFontSize = (int)Config.impaxee.jvision.MAPPING.MaximumPrintFontSize.get();
    public static final String LABEL_DEFAULT = "__JV_DEFAULT__";
    public static final String LABEL_BURN = "__JV_BURN__";
    public static final String LABEL_DELETED = "__JV_DELETED__";
    public static final String LABEL_UNSAVED = "__JV_UNSAVED__";
    protected static final int default_min_size = (int)Config.impaxee.jvision.MAPPING.MinimumSize.get();
    private static final FontSet DEFAULT_FONT = FontSet.getInstance(OverlayFontConfig.displayFont, null);
    public static final int MIN_FONT_SIZE = 10;
    protected boolean visible = true;
    protected View owner;
    protected int width;
    protected int height;
    protected String layerLabel = "__JV_UNSAVED__";
    private Stack<FontSet> fontSetStack = null;
    protected float printScalingFactor = -1.0f;

    public static int calculateFontSize(Rectangle rectangle, double d) {
        int n = Math.max(10, rectangle.width / printFFactor);
        if ((double)n / d > printMaximumFontRealSize) {
            n = printMaximumFontSize;
        }
        return n;
    }

    public abstract void paint(BufferedImageHolder var1);

    public void drawString(String string, BufferedImageHolder bufferedImageHolder, int n, int n2) {
        this.drawBytes(string.toCharArray(), bufferedImageHolder, n, n2);
    }

    public void drawBytes(char[] cArray, BufferedImageHolder bufferedImageHolder, int n, int n2) {
        if (this.isUseOutlineFont()) {
            this.getCurrentOutlineFont().drawBytes(cArray, (IImageHolder)bufferedImageHolder, n, n2);
        } else {
            bufferedImageHolder.graphics.drawChars(cArray, 0, cArray.length, n, n2);
        }
    }

    public void drawString(String string, Color color, BufferedImageHolder bufferedImageHolder, int n, int n2) {
        this.drawBytes(string.toCharArray(), color, bufferedImageHolder, n, n2);
    }

    public void drawBytes(char[] cArray, Color color, BufferedImageHolder bufferedImageHolder, int n, int n2) {
        if (this.isUseOutlineFont()) {
            this.getCurrentOutlineFont().drawBytes(cArray, color, (IImageHolder)bufferedImageHolder, n, n2);
        } else {
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.drawChars(cArray, 0, cArray.length, n, n2);
        }
    }

    public int getViewWidth() {
        return this.width;
    }

    public int getViewHeight() {
        return this.height;
    }

    protected int getMinSize() {
        return default_min_size;
    }

    @Override
    public IImageState getImageState() {
        return null;
    }

    public void setImageState(IImageState iImageState) {
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2, IImageState iImageState) {
        this.width = n;
        this.height = n2;
    }

    protected boolean isLargeSize() {
        if (this.printScalingFactor == -1.0f) {
            return this.width > 800 && this.height > 800;
        }
        return false;
    }

    public boolean setFont(Font font, Graphics graphics) {
        if (this.getCurrentFontSet().font == font) {
            return false;
        }
        this.setNewFontSet(FontSet.getInstance(font, graphics));
        return true;
    }

    public void resetFont(Font font, Graphics graphics) {
        this.resetToOldFontSet();
    }

    public void setPrintFont(Graphics graphics, Rectangle rectangle, double d) {
        int n = Overlay.calculateFontSize(rectangle, d);
        Font font = AwtFontFactory.getFont(OverlayFontConfig.printFName, OverlayFontConfig.printFStyle, n);
        int n2 = this.getCurrentFontSet().font.getSize();
        if (this.setFont(font, graphics)) {
            this.printScalingFactor = (float)font.getSize() / (float)n2;
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setStroke(new BasicStroke(n / 8));
        }
    }

    public void resetPrintFont() {
        this.resetFont(null, null);
        this.printScalingFactor = -1.0f;
    }

    private FontSet getCurrentFontSet() {
        if (this.fontSetStack == null || this.fontSetStack.isEmpty()) {
            return DEFAULT_FONT;
        }
        return this.fontSetStack.peek();
    }

    private void setNewFontSet(FontSet fontSet) {
        if (this.fontSetStack == null) {
            this.fontSetStack = new Stack();
        }
        this.fontSetStack.push(fontSet);
    }

    private void resetToOldFontSet() {
        if (this.fontSetStack != null && this.fontSetStack.size() >= 1) {
            this.fontSetStack.pop();
        }
    }

    protected FontMetrics getCurrentFontMetrics() {
        return this.isLargeSize() ? this.getCurrentFontSet().largeFm : this.getCurrentFontSet().fm;
    }

    protected Font getCurrentFont() {
        return this.isLargeSize() ? this.getCurrentFontSet().largeFont : this.getCurrentFontSet().font;
    }

    protected OutlineFont getCurrentOutlineFont() {
        return this.isLargeSize() ? this.getCurrentFontSet().largeOutlineFont : this.getCurrentFontSet().outlineFont;
    }

    public Overlay clone() {
        try {
            return (Overlay)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneFailedException("Cloning overlay failed", (Throwable)cloneNotSupportedException);
        }
    }

    public int getFontHeight() {
        return this.getCurrentFontMetrics().getHeight();
    }

    public int getSnapHandleSize() {
        return 16;
    }

    public void setOwner(View view) {
        this.owner = view;
    }

    public View getView() {
        return this.owner;
    }

    @Override
    public IImageInformation getImageInformation() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getImageInformation();
    }

    public void presentationObjectAdded(View view) {
        if (this.owner == null) {
            this.setOwner(view);
        }
    }

    public void presentationObjectRemoved(View view) {
        this.setOwner(null);
    }

    public void resetCachedValues() {
        if (this.owner != null) {
            this.owner.getImageState().updated();
        }
    }

    public String getLayerLabel() {
        return this.layerLabel;
    }

    public void setLayerLabel(String string) {
        this.layerLabel = string;
    }

    public boolean isUnsavedROI() {
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean captureAsRGB() {
        return false;
    }

    protected boolean isUseOutlineFont() {
        return true;
    }

    public static <U extends Overlay> List<U> filter(Class<U> clazz, List<Overlay> list) {
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        for (Overlay overlay : list) {
            if (!clazz.isInstance(overlay)) continue;
            arrayList.add(overlay);
        }
        return arrayList;
    }

    public static <U extends Overlay> U find(Class<U> clazz, List<Overlay> list) {
        for (Overlay overlay : list) {
            if (!clazz.isInstance(overlay)) continue;
            return (U)overlay;
        }
        return null;
    }

    public boolean intersects(Rectangle rectangle) {
        return false;
    }
}

