/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.PresentationObject;

public class OverlayInformation
implements IOverlayInformation {
    private String mainDescription;
    private String firstSideDescription;
    private String secondSideDescription;
    private String firstUnit;
    private String secondUnit;
    private double firstValue = Double.NaN;
    private double secondValue = Double.NaN;
    private IOverlayInformation additionalInformation;
    private OverlayInformationID id;

    public OverlayInformation(OverlayInformationID overlayInformationID) {
        this.id = overlayInformationID;
        this.mainDescription = overlayInformationID.toString();
    }

    public OverlayInformation(OverlayInformationID overlayInformationID, double d, String string) {
        this.id = overlayInformationID;
        this.setDescription(null);
        this.firstValue = d;
        this.firstUnit = string;
    }

    public OverlayInformation(OverlayInformationID overlayInformationID, String string, double d, String string2) {
        this.setMinimumInformation(overlayInformationID, string, d, string2);
    }

    public OverlayInformation(OverlayInformationID overlayInformationID, String string, double d, String string2, IOverlayInformation iOverlayInformation) {
        this.setMinimumInformation(overlayInformationID, string, d, string2);
        this.additionalInformation = iOverlayInformation;
    }

    public OverlayInformation(OverlayInformationID overlayInformationID, double d, String string, double d2, String string2) {
        this.setMinimumInformation(overlayInformationID, null, d, string);
        this.setSecondaryInformation(d2, string2);
    }

    public OverlayInformation(OverlayInformationID overlayInformationID, double d, String string, double d2, String string2, IOverlayInformation iOverlayInformation) {
        this.setMinimumInformation(overlayInformationID, null, d, string);
        this.setSecondaryInformation(d2, string2);
        this.additionalInformation = iOverlayInformation;
    }

    private void setMinimumInformation(OverlayInformationID overlayInformationID, String string, double d, String string2) {
        this.id = overlayInformationID;
        this.firstValue = d;
        this.firstUnit = string2;
        this.setDescription(string);
        this.setSideDescriptions();
    }

    private void setDescription(String string) {
        this.mainDescription = this.id != null && this.id.toString() != null ? this.id.toString() : string;
    }

    private void setSideDescriptions() {
        if (this.id.getFirstSideDescription() != null) {
            this.firstSideDescription = this.id.getFirstSideDescription();
        }
        if (this.id.getSecondSideDescription() != null) {
            this.secondSideDescription = this.id.getSecondSideDescription();
        }
    }

    public void setSecondaryInformation(double d, String string) {
        this.secondValue = d;
        this.secondUnit = string;
    }

    public void setPrimaryInformation(double d, String string) {
        this.firstValue = d;
        this.firstUnit = string;
    }

    @Override
    public boolean hasSecondaryInformation() {
        return !Double.isNaN(this.secondValue);
    }

    @Override
    public boolean hasAdditionalInformation() {
        return this.additionalInformation != null;
    }

    @Override
    public boolean hasFirstSideDescription() {
        return this.firstSideDescription != null;
    }

    @Override
    public boolean hasSecondSideDescription() {
        return this.secondSideDescription != null;
    }

    @Override
    public String getDescription() {
        return this.mainDescription;
    }

    @Override
    public double getFirstValue() {
        return this.firstValue;
    }

    @Override
    public double getSecondValue() {
        return this.secondValue;
    }

    @Override
    public String getFirstUnit() {
        return this.firstUnit;
    }

    @Override
    public String getSecondUnit() {
        return this.secondUnit;
    }

    @Override
    public String getFirstSideDescription() {
        return this.firstSideDescription;
    }

    @Override
    public String getSecondSideDescription() {
        return this.secondSideDescription;
    }

    @Override
    public IOverlayInformation getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    public OverlayInformationID getID() {
        return this.id;
    }

    @Override
    public void appendInformationText(StringBuilder stringBuilder) {
        if (this.getDescription() != null) {
            stringBuilder.append(this.getDescription());
            stringBuilder.append(" = ");
        }
        stringBuilder.append(this.getFormattedValue(this.getFirstValue()));
        if (this.hasSecondaryInformation()) {
            stringBuilder.append(' ');
            stringBuilder.append('/');
            stringBuilder.append(' ');
            stringBuilder.append(this.getFormattedValue(this.getSecondValue()));
            stringBuilder.append(' ');
            stringBuilder.append(this.getUnit(this.getSecondUnit()));
        } else {
            stringBuilder.append(' ');
            stringBuilder.append(this.getUnit(this.getFirstUnit()));
        }
        if (this.hasAdditionalInformation()) {
            if (this.additionalInformation.getDescription() == null) {
                stringBuilder.append(' ');
                stringBuilder.append('(');
                stringBuilder.append(this.getFormattedValue(this.additionalInformation.getFirstValue()));
                stringBuilder.append(' ');
                stringBuilder.append(this.getUnit(this.additionalInformation.getFirstUnit()));
                stringBuilder.append(')');
            } else {
                stringBuilder.append(' ');
                stringBuilder.append(this.additionalInformation.getDescription());
                stringBuilder.append(' ');
                stringBuilder.append(this.getFormattedValue(this.additionalInformation.getFirstValue()));
                stringBuilder.append(' ');
                stringBuilder.append(this.additionalInformation.getFirstUnit());
            }
        }
    }

    private String getFormattedValue(double d) {
        return Double.isNaN(d) ? "-" : PresentationObject.formatValue(d);
    }

    private String getUnit(String string) {
        return string == null ? "" : string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendInformationText(stringBuilder);
        return stringBuilder.toString();
    }
}

