/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.OverlayTransformationException;
import com.tiani.jvision.overlay.PresentationObject;
import javax.vecmath.Vector2d;

class OverlayTransformationUtils {
    private static final boolean IS_SNAPPING_ACTIVE = Config.impaxee.jvision.MEASUREMENT.AllowLengthMeasurementSnapping.get();

    private OverlayTransformationUtils() {
    }

    static Vector2d getNormalizedHorizontalOrientationVector(PresentationObject presentationObject) {
        Vector2d vector2d = OverlayTransformationUtils.getHorizontalOrientationVector(presentationObject);
        vector2d.normalize();
        return vector2d;
    }

    static Vector2d getNormalizedVerticalOrientationVector(PresentationObject presentationObject) {
        Vector2d vector2d = OverlayTransformationUtils.getVerticalOrientationVector(presentationObject);
        vector2d.normalize();
        return vector2d;
    }

    static Vector2d getHorizontalOrientationVector(PresentationObject presentationObject) {
        return OverlayTransformationUtils.convertOrientationVectorToImage(presentationObject, 1.0, 0.0);
    }

    static Vector2d getVerticalOrientationVector(PresentationObject presentationObject) {
        return OverlayTransformationUtils.convertOrientationVectorToImage(presentationObject, 0.0, 1.0);
    }

    static Vector2d convertOrientationVectorToImage(PresentationObject presentationObject, double d, double d2) {
        return OverlayTransformationUtils.updateOrientationVector(presentationObject::toImageExact, d, d2, 1.0);
    }

    static Vector2d convertOrientationVectorToScreen(PresentationObject presentationObject, double d, double d2) {
        return OverlayTransformationUtils.updateOrientationVector(presentationObject::toScreenExact, d, d2, 1.0);
    }

    static Vector2d updateOrientationVector(IOverlayPointModifier iOverlayPointModifier, double d, double d2, double d3) {
        double[] dArray = new double[2];
        double[] dArray2 = (double[])dArray.clone();
        dArray2[0] = dArray2[0] + d * d3;
        dArray2[1] = dArray2[1] + d2 * d3;
        dArray = iOverlayPointModifier.convert(dArray);
        dArray2 = iOverlayPointModifier.convert(dArray2);
        dArray2[0] = dArray2[0] - dArray[0];
        dArray2[1] = dArray2[1] - dArray[1];
        int n = 0;
        while (n < dArray2.length) {
            if (DoubleEquals.equals((double)dArray2[n], (double)0.0)) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return new Vector2d(dArray2);
    }

    static double updateXAxisLength(IOverlayPointModifier iOverlayPointModifier, double d, boolean bl) throws OverlayTransformationException {
        return OverlayTransformationUtils.updateLength(iOverlayPointModifier, d, 0, bl);
    }

    static double updateYAxisLength(IOverlayPointModifier iOverlayPointModifier, double d, boolean bl) throws OverlayTransformationException {
        return OverlayTransformationUtils.updateLength(iOverlayPointModifier, d, 1, bl);
    }

    private static double updateLength(IOverlayPointModifier iOverlayPointModifier, double d, int n, boolean bl) throws OverlayTransformationException {
        double[] dArray = new double[2];
        double[] dArray2 = (double[])dArray.clone();
        int n2 = n;
        dArray2[n2] = dArray2[n2] + d;
        dArray = iOverlayPointModifier.convert(dArray);
        dArray2 = iOverlayPointModifier.convert(dArray2);
        dArray2[0] = dArray2[0] - dArray[0];
        dArray2[1] = dArray2[1] - dArray[1];
        if (!bl && !DoubleEquals.equals((double)dArray2[1 - n], (double)0.0)) {
            throw new OverlayTransformationException("An overlay copy requiring a rotation is unsupported.");
        }
        return new Vector2d(dArray2).length();
    }

    public static double[] snapToAxisIfRequested(PresentationObject presentationObject, double[] dArray, double[] dArray2) {
        if (IS_SNAPPING_ACTIVE) {
            if (ModifierKeys.isAlt()) {
                return OverlayTransformationUtils.snapToAxis(presentationObject, dArray, dArray2, 1);
            }
            if (ModifierKeys.isShift()) {
                return OverlayTransformationUtils.snapToAxis(presentationObject, dArray, dArray2, 0);
            }
        }
        return (double[])dArray2.clone();
    }

    private static double[] snapToAxis(PresentationObject presentationObject, double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = presentationObject.toScreen(dArray2);
        dArray3[n] = presentationObject.toScreen(dArray)[n];
        return presentationObject.toImage(dArray3);
    }
}

