/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Graphics;

public class PresentationHandle
implements Cloneable {
    public static final int HANDLE_SIZE = GUI.getScaledDiagnosticInt((int)4) - GUI.getScaledDiagnosticInt((int)4) % 2;
    protected int x;
    protected int y;

    public PresentationHandle(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void paint(Graphics graphics) {
        this.paintHandle(graphics, true);
    }

    protected int getHandleSizeX() {
        return HANDLE_SIZE;
    }

    protected int getHandleSizeY() {
        return HANDLE_SIZE;
    }

    protected void paintHandle(Graphics graphics, boolean bl) {
        int n = this.x - (this.getHandleSizeX() >> 1);
        int n2 = this.y - (this.getHandleSizeY() >> 1);
        int n3 = this.getHandleSizeX() + 1;
        int n4 = this.getHandleSizeY() + 1;
        if (bl) {
            graphics.fillRect(n, n2, n3, n4);
        } else {
            graphics.drawRect(n, n2, n3, n4);
        }
        if (this.isOutlined()) {
            Color color = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.drawRect(n - 1, n2 - 1, n3 + 2, n4 + 2);
            if (!bl && n3 > 2 && n4 > 2) {
                graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
            }
            graphics.setColor(color);
        }
    }

    protected boolean isOutlined() {
        return false;
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean mousePressed(int n, int n2) {
        return this.x - this.getHandleSizeX() <= n && n <= this.x + this.getHandleSizeX() && this.y - this.getHandleSizeY() <= n2 && n2 <= this.y + this.getHandleSizeY();
    }

    public boolean isTranslationHandle() {
        return false;
    }

    public void setHandleSize(int n, int n2) {
    }

    public PresentationHandle clone() {
        try {
            return (PresentationHandle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ALogger.getLogger(PresentationHandle.class).error("Clone not supported.", (Throwable)cloneNotSupportedException);
            throw new IllegalArgumentException();
        }
    }
}

