/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.menu.AbstractCheckBoxMenuItem;
import com.agfa.pacs.impaxee.menu.AbstractStandardMenuItem;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.menu.MenuEntryGroup;
import com.agfa.pacs.impaxee.menu.SeparatorEntry;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.tiani.base.data.ClippingShape;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.IRegionInfoSource;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.Interval;
import com.tiani.jvision.image.PlanarContext;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.overlay.BinBMPShutter;
import com.tiani.jvision.overlay.CircleOverlay;
import com.tiani.jvision.overlay.ColorChooserHandle;
import com.tiani.jvision.overlay.DataProfile;
import com.tiani.jvision.overlay.HistogramOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.ITextObjectContainer;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.OverlayTransformationException;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PolygonOverlay;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.RectangleOverlayMPR;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.Shutter;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.TextAnnotationLevel;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.action.IPresentationObjectAction;
import com.tiani.jvision.overlay.curve.CurveOverlay;
import com.tiani.jvision.overlay.placement.HandlePositioningPoint;
import com.tiani.jvision.overlay.placement.IPositioningPoint;
import com.tiani.jvision.overlay.placement.LabelPlacementManager;
import com.tiani.jvision.overlay.placement.PositioningPoint;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.renderer.RDCRendererRGB;
import com.tiani.jvision.toptoolbar.MagnifierAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;

public abstract class PresentationObject
extends Overlay
implements ClippingShape {
    static final BasicStroke CONNECTION_OUTLINE_STROKE = new BasicStroke(3.0f, 2, 1, 1.0f, new float[]{2.0f, 5.0f}, 0.0f);
    static final BasicStroke CONNECTION_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{1.0f, 6.0f}, 0.0f);
    static final BasicStroke AUXILIARY_LINE_OUTLINE_STROKE = new BasicStroke(3.0f, 2, 1, 1.0f, new float[]{5.0f, 7.0f}, 0.0f);
    static final BasicStroke AUXILIARY_LINE_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{4.0f, 8.0f}, 0.0f);
    static final int DEFAULT_GRAPH_ANNOTATION_WIDTH = 100;
    static final int DEFAULT_GRAPH_ANNOTATION_HEIGHT = 100;
    private static final int textSpacing = 15;
    protected static final Color solidOutlineColor = Color.white;
    private static AtomicInteger roiID = new AtomicInteger(0);
    private static DecimalFormat bigNumber = new DecimalFormat("#");
    protected static DecimalFormat midNumber = new DecimalFormat("#.#");
    private static DecimalFormat smallNumber = new DecimalFormat("0.#");
    private static DecimalFormat verySmallNumber = new DecimalFormat("0.###");
    private static boolean hideAllROIs = false;
    static int pressdx;
    static int pressdy;
    private static long pressTime;
    protected static int initpx;
    private static TextAnnotationLevel annotationLevel;
    protected static int initpy;
    private static boolean isHandleDraggedPrioritized;
    protected int lastx;
    protected int lasty;
    private int pressx;
    private int pressy;
    public Color objCol;
    protected Rectangle bounds;
    protected List<Polygon> outBounds;
    protected IImageState imageState;
    protected AnnotationUnits spacingType = AnnotationUnits.Display;
    protected boolean shapeChanged;
    protected boolean fireing;
    protected boolean mouseOver;
    protected EnumSet<OverlayState> state = EnumSet.of(OverlayState.UseNonEditableText, OverlayState.Editable, OverlayState.AnnotationEnabled);
    protected PresentationHandle[] handles;
    protected Overlay[] ownedCompanions;
    private SyncablePresentationObject companionOwner;
    protected int translationHandleIndex;
    private List<PresentationObject> translationListeners = null;
    protected int initStep = -1;
    private String providerUID;
    protected double[] unitx = new double[]{0.0, 0.0};
    protected double[] unity = new double[]{0.0, 0.0};
    protected int id = roiID.incrementAndGet();
    protected int activeHandleIndex = -1;
    protected Shutter shutterMask;
    protected String name;
    protected PlanarContext context;
    private long lastUpdateStamp;
    protected int shutterValue;

    static {
        pressTime = 0L;
        annotationLevel = TextAnnotationLevel.readDefaultFromConfig();
    }

    public PresentationObject(String string) {
        this.objCol = OverlayConfig.mappingColor;
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.name = string;
    }

    @Override
    public boolean captureAsRGB() {
        return this.isShutter();
    }

    @Override
    public String getLayerLabel() {
        if (super.getLayerLabel().equals("__JV_DELETED__")) {
            return "__JV_DELETED__";
        }
        if (this.isShutter()) {
            return "__JV_BURN__";
        }
        return super.getLayerLabel();
    }

    public boolean isRemoveable() {
        return true;
    }

    public boolean doBackgroundLock() {
        return true;
    }

    protected String dimensionUnit() {
        return this.imageState.getDimensionUnit();
    }

    public boolean isLocal() {
        return this.state.contains((Object)OverlayState.Local);
    }

    protected void setState(OverlayState overlayState, boolean bl) {
        if (bl) {
            this.state.add(overlayState);
        } else {
            this.state.remove((Object)overlayState);
        }
    }

    public final void setLocal(boolean bl) {
        this.setState(OverlayState.Local, bl);
    }

    public boolean isSaved() {
        return this.state.contains((Object)OverlayState.IsSaved);
    }

    public void setSaved(boolean bl) {
        if (!bl) {
            DataSelectionManager.getInstance().setSessionUnsaved();
        }
        this.initSaved(bl);
    }

    public void initSaved(boolean bl) {
        this.setState(OverlayState.IsSaved, bl);
    }

    public String getName() {
        return this.name;
    }

    protected int getTextSpacing() {
        return 15;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<IMenuEntry> getMenuEntries() {
        ArrayList<IMenuEntry> arrayList = new ArrayList<IMenuEntry>(2);
        arrayList.add(new MenuEntryGroup(Messages.getString("PresentationObject.SelectedROI"), this.getMenuEntriesImpl()));
        return arrayList;
    }

    DataProfile createDataProfile() {
        LabelPlacementManager labelPlacementManager = new LabelPlacementManager(this.getView(), this.getPositioningPoints(), this.getTextSpacing(), 100, 100, null, null);
        double[] dArray = labelPlacementManager.getBestFit();
        DataProfile dataProfile = new DataProfile(dArray[0], dArray[1], 100.0, 100.0, AnnotationUnits.Pixel, (PointSequence)((Object)this), OverlayContainer.AnchorPosition.TOPLEFT, false);
        dataProfile.setColor(this.objCol);
        this.addCompanion(dataProfile);
        this.getView().addOverlay(dataProfile);
        return dataProfile;
    }

    public IRegionInfoSource getRegionSource() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getRenderer().getRegionSource();
    }

    public boolean supportsHistogram() {
        return false;
    }

    public boolean supportsProfile() {
        return true;
    }

    HistogramOverlay createHistogramOverlay() {
        if (!this.supportsHistogram()) {
            return null;
        }
        ImageRegion imageRegion = new ImageRegion(this);
        IImageRegionProperties iImageRegionProperties = null;
        IRegionInfoSource iRegionInfoSource = this.getRegionSource();
        if (iRegionInfoSource != null) {
            iImageRegionProperties = iRegionInfoSource.getImageRegionProperties(imageRegion, this.width, this.height, this.getImageState().getCurrentValueMapping());
        }
        if (iImageRegionProperties != null && iImageRegionProperties.getHistogram() != null) {
            LabelPlacementManager labelPlacementManager = new LabelPlacementManager(this.getView(), this.getPositioningPoints(), this.getTextSpacing(), 100, 100, null, null);
            double[] dArray = labelPlacementManager.getBestFit();
            HistogramOverlay histogramOverlay = new HistogramOverlay(iImageRegionProperties.getHistogram(), dArray[0], dArray[1], 100.0, 100.0, AnnotationUnits.Pixel, OverlayContainer.AnchorPosition.TOPLEFT, false);
            histogramOverlay.setAutoScaleX(true);
            histogramOverlay.setColor(this.objCol);
            if (this.owner != null) {
                this.addCompanion(histogramOverlay);
                this.getView().addOverlay(histogramOverlay);
            }
            return histogramOverlay;
        }
        return null;
    }

    @Override
    public IImageState getImageState() {
        return this.imageState;
    }

    @Override
    public void setImageState(IImageState iImageState) {
        this.imageState = iImageState;
    }

    private List<IPositioningPoint> getPositioningPoints() {
        Cloneable cloneable;
        ArrayList<IPositioningPoint> arrayList = new ArrayList<IPositioningPoint>();
        PresentationHandle[] presentationHandleArray = this.handles;
        int n = this.handles.length;
        int n2 = 0;
        while (n2 < n) {
            cloneable = presentationHandleArray[n2];
            arrayList.add(new HandlePositioningPoint((PresentationHandle)cloneable));
            ++n2;
        }
        cloneable = this.getBoundingBox();
        arrayList.add(new PositioningPoint(((Rectangle)cloneable).getX() + ((Rectangle)cloneable).getWidth(), ((Rectangle)cloneable).getY() + ((Rectangle)cloneable).getHeight(), 1));
        arrayList.add(new PositioningPoint(((Rectangle)cloneable).getX(), ((Rectangle)cloneable).getY() + ((Rectangle)cloneable).getHeight(), 1));
        arrayList.add(new PositioningPoint(((Rectangle)cloneable).getX() + ((Rectangle)cloneable).getWidth(), ((Rectangle)cloneable).getY(), 1));
        arrayList.add(new PositioningPoint(((Rectangle)cloneable).getX(), ((Rectangle)cloneable).getY(), 1));
        return arrayList;
    }

    protected IImageRegionProperties updateHistogram(ImageRegion imageRegion) {
        IImageRegionProperties iImageRegionProperties;
        IRegionInfoSource iRegionInfoSource = this.getRegionSource();
        IImageState iImageState = this.getImageState();
        if (imageRegion == null || iRegionInfoSource == null) {
            iImageRegionProperties = IImageRegionProperties.INVALID;
        } else {
            HistogramOverlay histogramOverlay = this.getHistogramOverlay();
            Interval interval = null;
            if (histogramOverlay != null) {
                interval = histogramOverlay.getMarkedInterval();
            }
            iImageRegionProperties = interval != null ? iRegionInfoSource.getImageRegionProperties(imageRegion, this.width, this.height, iImageState.getCurrentValueMapping(), interval.getLowerBound(), interval.getUpperBound()) : iRegionInfoSource.getImageRegionProperties(imageRegion, this.width, this.height, iImageState.getCurrentValueMapping());
            if (histogramOverlay != null && histogramOverlay.isVisible()) {
                histogramOverlay.setHistogram(iImageRegionProperties.getHistogram());
            }
        }
        return iImageRegionProperties;
    }

    public HistogramOverlay getHistogramOverlay() {
        if (this.ownedCompanions != null) {
            int n = 0;
            while (n < this.ownedCompanions.length) {
                if (this.ownedCompanions[n] instanceof HistogramOverlay) {
                    return (HistogramOverlay)this.ownedCompanions[n];
                }
                ++n;
            }
        }
        return null;
    }

    public DataProfile getDataProfilePlot() {
        if (!(this instanceof PointSequence)) {
            return null;
        }
        if (this.ownedCompanions != null) {
            int n = 0;
            while (n < this.ownedCompanions.length) {
                if (this.ownedCompanions[n] instanceof DataProfile) {
                    return (DataProfile)this.ownedCompanions[n];
                }
                ++n;
            }
        }
        return null;
    }

    public TextOverlay getAnnotation() {
        if (this.ownedCompanions == null) {
            return null;
        }
        int n = 0;
        while (n < this.ownedCompanions.length) {
            if (this.ownedCompanions[n] instanceof TextOverlay) {
                return (TextOverlay)this.ownedCompanions[n];
            }
            ++n;
        }
        return null;
    }

    public TextOverlay getOrCreateAnnotation() {
        TextOverlay textOverlay = this.getAnnotation();
        if (textOverlay == null && (textOverlay = this.createAnnotation()) != null) {
            textOverlay.setVisible(false);
        }
        return textOverlay;
    }

    public boolean hasAnnotation() {
        return this.getAnnotation() != null;
    }

    public void copySetupTo(PresentationObject presentationObject) {
        presentationObject.name = this.name;
        presentationObject.setState(OverlayState.AnnotationEnabled, this.state.contains((Object)OverlayState.AnnotationEnabled));
        presentationObject.setState(OverlayState.Editable, this.state.contains((Object)OverlayState.Editable));
        presentationObject.setState(OverlayState.Shutter, this.state.contains((Object)OverlayState.Shutter));
        presentationObject.setState(OverlayState.AnnotationEnabled, this.state.contains((Object)OverlayState.AnnotationEnabled));
        presentationObject.setState(OverlayState.Solid, this.state.contains((Object)OverlayState.Solid));
    }

    public boolean isPriorityHandle() {
        return false;
    }

    public void setSolid(boolean bl) {
        this.setState(OverlayState.Solid, bl);
    }

    public boolean isSolid() {
        return this.state.contains((Object)OverlayState.Solid);
    }

    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        if (!bl2) {
            this.setSolid(bl);
        } else {
            this.setSolid(false);
        }
        this.setShutterMode(bl2);
        initpx = n;
        initpy = n2;
        this.pressx = n;
        this.pressy = n2;
        this.lastx = n;
        this.lasty = n2;
        this.initStep = 1;
        this.setSpacing(annotationUnits);
        pressdx = 0;
        pressdy = 0;
        this.activeHandleIndex = 1;
        this.setState(OverlayState.Interactive, true);
    }

    @Override
    public void setSize(int n, int n2, IImageState iImageState) {
        super.setSize(n, n2, iImageState);
        this.imageState = iImageState;
        if (this.initStep == 1) {
            this.initStep = this.setPoint(this.initStep, this.toImage(initpx, initpy));
        }
        this.updateUnitVectors();
    }

    private void updateUnitVectors() {
        double[] dArray = new double[]{0.0, 0.0};
        dArray = this.toImageExact(dArray);
        this.unitx[0] = 1.0;
        this.unitx[1] = 0.0;
        this.unitx = this.toImageExact(this.unitx);
        this.unitx[0] = this.unitx[0] - dArray[0];
        this.unitx[1] = this.unitx[1] - dArray[1];
        this.unity[0] = 0.0;
        this.unity[1] = 1.0;
        this.unity = this.toImageExact(this.unity);
        this.unity[0] = this.unity[0] - dArray[0];
        this.unity[1] = this.unity[1] - dArray[1];
    }

    public void setColor(Color color) {
        this.objCol = color;
    }

    public final void setSpacing(AnnotationUnits annotationUnits) {
        this.spacingType = annotationUnits;
    }

    public AnnotationUnits getSpacingType() {
        return this.spacingType;
    }

    public void setContext(PlanarContext planarContext) {
        this.context = planarContext;
    }

    public PlanarContext getContext() {
        return this.context;
    }

    @Override
    public boolean adjustTo(PlanarContext planarContext) {
        if (this.context == null) {
            return false;
        }
        if (this.context.isSame(planarContext)) {
            return true;
        }
        if (!(this instanceof ITransformableOverlay)) {
            log.error("Adjusting overlay " + this + " to new planar context not supported");
            return false;
        }
        ITransformableOverlay iTransformableOverlay = (ITransformableOverlay)((Object)this);
        try {
            iTransformableOverlay.updateOverlayPoints(iTransformableOverlay, dArray -> {
                double[] dArray2 = this.context.screenToVolume(dArray[0], dArray[1]);
                return planarContext.volumeToScreen(dArray2[0], dArray2[1], dArray2[2]);
            });
        }
        catch (OverlayTransformationException overlayTransformationException) {
            log.error("Adjusting overlay " + this + " to new planar context failed", (Throwable)overlayTransformationException);
            return false;
        }
        this.context = new PlanarContext(planarContext);
        return true;
    }

    protected double[] toImageExact(double[] dArray) {
        double[] dArray2 = new double[2];
        this.toImage(dArray, dArray2, false);
        return dArray2;
    }

    protected double[] toImage(double[] dArray) {
        double[] dArray2 = new double[2];
        this.toImage(dArray, dArray2, true);
        return dArray2;
    }

    protected void toImage(double[] dArray, double[] dArray2) {
        this.toImage(dArray, dArray2, true);
    }

    private void toImage(double[] dArray, double[] dArray2, boolean bl) {
        if (this.spacingType == AnnotationUnits.Display) {
            dArray2[0] = dArray[0] / (double)this.width;
            dArray2[1] = dArray[1] / (double)this.height;
        } else {
            IImageState iImageState = this.getImageState();
            if (iImageState != null) {
                iImageState.screenToImage(dArray, dArray2, this.context);
            }
        }
        if (bl && this.isShutter()) {
            dArray2[0] = Math.rint(dArray2[0]);
            dArray2[1] = Math.rint(dArray2[1]);
        }
    }

    protected double[] toImage(int n, int n2) {
        return this.toImage(new double[]{n, n2});
    }

    public double getPixelSizeX() {
        IImageState iImageState = this.getImageState();
        double d = iImageState.getScreenPixelSizeX();
        if (d != 0.0) {
            return d;
        }
        double d2 = iImageState.getColumVectorX();
        double d3 = iImageState.getColumVectorY();
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public double getPixelSizeY() {
        IImageState iImageState = this.getImageState();
        double d = iImageState.getScreenPixelSizeY();
        if (d != 0.0) {
            return d;
        }
        double d2 = iImageState.getRowVectorX();
        double d3 = iImageState.getRowVectorY();
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public double getDataPixelSizeX() {
        double d = this.getImageState().getDataPixelSizeX(this.getContext());
        if (d != 0.0) {
            return d;
        }
        return 1.0;
    }

    public double getDataPixelSizeY() {
        double d = this.getImageState().getDataPixelSizeY(this.getContext());
        if (d != 0.0) {
            return d;
        }
        return 1.0;
    }

    double calculateLength(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4) {
        double d;
        double d2;
        if (this.spacingType == AnnotationUnits.Pixel) {
            d2 = (dArray2[0] - dArray[0]) * this.getDataPixelSizeX();
            d = (dArray2[1] - dArray[1]) * this.getDataPixelSizeY();
        } else {
            d2 = (double)(n - n3) * this.getPixelSizeX();
            d = (double)(n2 - n4) * this.getPixelSizeY();
        }
        return Math.sqrt(d2 * d2 + d * d);
    }

    protected boolean isPixelUnit() {
        SpacingDef spacingDef = this.getImageState().getCurrentSpacingDef();
        return spacingDef != null && spacingDef.getSizeUnit() == SpacingDef.Unit.pix;
    }

    protected double[] toScreenExact(double[] dArray) {
        double[] dArray2 = new double[2];
        this.toScreen(dArray, dArray2, false);
        return dArray2;
    }

    protected double[] toScreen(double[] dArray) {
        double[] dArray2 = new double[2];
        this.toScreen(dArray, dArray2, true);
        return dArray2;
    }

    protected void toScreen(double[] dArray, double[] dArray2) {
        this.toScreen(dArray, dArray2, true);
    }

    private void toScreen(double[] dArray, double[] dArray2, boolean bl) {
        if (this.spacingType == AnnotationUnits.Display) {
            dArray2[0] = dArray[0] * (double)this.width;
            dArray2[1] = dArray[1] * (double)this.height;
        } else {
            IImageState iImageState = this.getImageState();
            if (iImageState != null) {
                iImageState.imageToScreen(dArray, dArray2, this.context);
            }
        }
        if (bl && this.isShutter()) {
            dArray2[0] = Math.rint(dArray2[0]);
            dArray2[1] = Math.rint(dArray2[1]);
        }
    }

    public void select(boolean bl) {
        this.setState(OverlayState.ShowHandles, bl);
        this.setState(OverlayState.Interactive, bl);
    }

    public boolean retainEditModeAfterCompletion() {
        return false;
    }

    public boolean isSelected() {
        return this.state.contains((Object)OverlayState.Interactive);
    }

    public boolean matchDiscardCriteria() {
        if (!this.visible) {
            return true;
        }
        if (this.height < this.getMinSize() && this.width < this.getMinSize()) {
            return !this.isPriorityHandle() && !this.isShowOnSmallViews();
        }
        return false;
    }

    @Override
    public final void paint(BufferedImageHolder bufferedImageHolder) {
        if (this.matchDiscardCriteria()) {
            return;
        }
        if (bufferedImageHolder == null) {
            return;
        }
        if (this.isROI() && hideAllROIs) {
            return;
        }
        this.updateCoordinates();
        bufferedImageHolder.graphics.setColor(this.objCol);
        this.paintShape(bufferedImageHolder);
        this.paintHandles(bufferedImageHolder);
        if (this.mouseOver && ViewMouseHandler.isPaintingConnections()) {
            this.paintConnection(bufferedImageHolder);
        }
    }

    private void paintConnection(BufferedImageHolder bufferedImageHolder) {
        PresentationObject presentationObject = null;
        PresentationObject presentationObject2 = null;
        if (this.hasAnnotation()) {
            presentationObject = this.getAnnotation();
            presentationObject2 = this;
        } else {
            presentationObject = this;
            presentationObject2 = this.companionOwner;
        }
        if (presentationObject2 == null || !presentationObject2.visible || !presentationObject2.isShowConnections() || MagnifierAction.isMagnifierEnabled()) {
            return;
        }
        presentationObject2.paintAdditionalConnections(bufferedImageHolder);
        if (presentationObject != null && presentationObject.visible && presentationObject.isShowConnections()) {
            Object object;
            double d = Double.MAX_VALUE;
            Object object2 = null;
            Point2D point2D = null;
            Rectangle rectangle = presentationObject.getBoundingBox();
            int n = -2;
            int n2 = 0;
            while (n2 < presentationObject2.handles.length) {
                Point2D[] point2DArray;
                object = presentationObject2.handles[n2];
                Point2D[] point2DArray2 = point2DArray = new Point2D[]{new Point2D.Double(rectangle.x, rectangle.y), new Point2D.Double(rectangle.x + rectangle.width, rectangle.y), new Point2D.Double(rectangle.x + rectangle.width, rectangle.y + rectangle.height), new Point2D.Double(rectangle.x + rectangle.width, rectangle.y)};
                int n3 = point2DArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    double d2;
                    Point2D point2D2 = point2DArray2[n4];
                    double d3 = (double)((PresentationHandle)object).x - point2D2.getX();
                    double d4 = d3 * d3 + (d2 = (double)((PresentationHandle)object).y - point2D2.getY()) * d2;
                    if (d4 < d) {
                        object2 = object;
                        point2D = point2D2;
                        n = n2;
                        d = d4;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (object2 != null && point2D != null && d > 0.1) {
                Color color = this.isColorUserDefined() ? this.objCol : bufferedImageHolder.graphics.getColor();
                object = bufferedImageHolder.graphics.getStroke();
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.setStroke(CONNECTION_OUTLINE_STROKE);
                if (this.activeHandleIndex != n) {
                    bufferedImageHolder.graphics.drawLine(((PresentationHandle)object2).x, ((PresentationHandle)object2).y, (int)(point2D.getX() + 0.5), (int)(point2D.getY() + 0.5));
                }
                bufferedImageHolder.graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
                bufferedImageHolder.graphics.setColor(color);
                bufferedImageHolder.graphics.setStroke(CONNECTION_STROKE);
                if (this.activeHandleIndex != n) {
                    bufferedImageHolder.graphics.drawLine(((PresentationHandle)object2).x, ((PresentationHandle)object2).y, (int)(point2D.getX() + 0.5), (int)(point2D.getY() + 0.5));
                }
                bufferedImageHolder.graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
                bufferedImageHolder.graphics.setStroke((Stroke)object);
            }
        }
    }

    void paintAdditionalConnections(BufferedImageHolder bufferedImageHolder) {
    }

    protected void paintHandles(BufferedImageHolder bufferedImageHolder) {
        if (bufferedImageHolder == null) {
            return;
        }
        if (this.showHandles() && this.handles != null) {
            int n = 0;
            while (n < this.handles.length) {
                if (n != this.activeHandleIndex) {
                    PresentationHandle presentationHandle = this.handles[n];
                    if (this.isColorUserDefined()) {
                        bufferedImageHolder.graphics.setColor(this.objCol);
                    }
                    presentationHandle.paint(bufferedImageHolder.graphics);
                }
                ++n;
            }
        }
    }

    public void setEditable(boolean bl) {
        this.setState(OverlayState.Editable, bl);
    }

    public boolean isEditable() {
        return this.state.contains((Object)OverlayState.Editable);
    }

    @Override
    public boolean useBBoxOnly() {
        return false;
    }

    @Override
    public boolean isInside(int n, int n2) {
        return true;
    }

    public String getProviderUID() {
        return this.providerUID;
    }

    public void setProviderUID(String string) {
        this.providerUID = string;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        boolean bl = false;
        if (this.outBounds != null) {
            for (Polygon polygon : this.outBounds) {
                Rectangle rectangle2 = polygon.getBounds();
                if (rectangle2.width == 0 && rectangle2.height == 0) {
                    if (rectangle.intersects(rectangle2.x, rectangle2.y, 0.0, 0.0)) {
                        bl = true;
                        break;
                    }
                } else if (rectangle2.width == 0) {
                    polygon.xpoints[0] = polygon.xpoints[0] + 1;
                    polygon.invalidate();
                } else if (rectangle2.height == 0) {
                    polygon.ypoints[0] = polygon.ypoints[0] + 1;
                    polygon.invalidate();
                }
                if (!polygon.intersects(rectangle)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean inBounds(int n, int n2) {
        int n3 = 6;
        Rectangle rectangle = new Rectangle(n - (n3 >> 1), n2 - (n3 >> 1), n3, n3);
        if (this.outBounds != null && this.outBounds.size() > 0) {
            return this.intersects(rectangle);
        }
        return n >= this.bounds.x && n <= this.bounds.x + this.bounds.width && n2 >= this.bounds.y && n2 <= this.bounds.y + this.bounds.height;
    }

    protected Polygon createBoundingLine(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n3, n};
        int[] nArray2 = new int[]{n2, n4, n2};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    protected void pressedWhileInit(int n, int n2) {
        this.activeHandleIndex = this.initStep - 1;
    }

    protected boolean splitDragged() {
        return true;
    }

    protected void releasedWhileInit(int n, int n2) {
        this.initStep = this.setPoint(this.initStep, this.toImage(initpx, initpy));
        if (this.initStep == 0 && this.getView() != null) {
            this.getView().getVisView().setHRPaintMode(false);
        }
    }

    public boolean acceptsMousePressAt(int n, int n2) {
        return this.mousePressed(n, n2, true);
    }

    public boolean mousePressed(int n, int n2) {
        return this.mousePressed(n, n2, false);
    }

    protected boolean mousePressed(int n, int n2, boolean bl) {
        if (!this.visible) {
            return false;
        }
        pressTime = System.currentTimeMillis();
        this.pressx = n;
        this.pressy = n2;
        this.lastx = n;
        this.lasty = n2;
        if (!this.isCompleted()) {
            initpx = n;
            initpy = n2;
            this.pressedWhileInit(n, n2);
            return true;
        }
        if (!this.isEditable() || !this.inBounds(n, n2)) {
            return false;
        }
        if (this.getView() != null && this.getView().getVisView() != null) {
            this.getView().getVisView().setHRPaintMode(true);
        }
        this.activeHandleIndex = this.getClickedHandleIndex(n, n2);
        if (this.activeHandleIndex >= 0) {
            if (!bl) {
                this.pressHandle(n, n2);
            }
            return true;
        }
        return !this.showHandles();
    }

    public boolean mousePressedAtHandle(int n, int n2) {
        this.activeHandleIndex = this.getClickedHandleIndex(n, n2);
        PresentationObject.setHandleDraggedPrioritized(this.checkHandleDraggedPrioritized());
        if (isHandleDraggedPrioritized) {
            this.pressHandle(n, n2);
        }
        return isHandleDraggedPrioritized;
    }

    protected boolean checkHandleDraggedPrioritized() {
        return this.activeHandleIndex >= 0;
    }

    protected int getClickedHandleIndex(int n, int n2) {
        int n3 = 0;
        if (this.handles != null) {
            PresentationHandle[] presentationHandleArray = this.handles;
            int n4 = this.handles.length;
            int n5 = 0;
            while (n5 < n4) {
                PresentationHandle presentationHandle = presentationHandleArray[n5];
                if (presentationHandle.mousePressed(n, n2)) {
                    return n3;
                }
                ++n3;
                ++n5;
            }
        }
        return -1;
    }

    protected void pressHandle(int n, int n2) {
        PresentationHandle presentationHandle = this.handles[this.activeHandleIndex];
        pressdx = n - presentationHandle.getX();
        pressdy = n2 - presentationHandle.getY();
        this.setState(OverlayState.Interactive, true);
        this.fireMasterSelected(true);
        this.fireInteractionStart();
    }

    public void mouseMovedWhileInit(int n, int n2) {
        this.mouseMovedOrDragged(n, n2);
    }

    public void mouseDragged(int n, int n2) {
        this.mouseMovedOrDragged(n, n2);
    }

    protected void mouseMovedOrDragged(int n, int n2) {
        if (!this.visible) {
            return;
        }
        if (this.getView() != null && this.getView().getVisView() != null) {
            this.getView().getVisView().setHRPaintMode(true);
        }
        if (this.activeHandleIndex >= 0) {
            if (this.activeHandleIndex == this.translationHandleIndex && this.isCompleted()) {
                this.fireTranslation(n, n2);
            }
            this.shapeChanged = true;
            this.handleDragged(this.activeHandleIndex, this.toImage(n - pressdx, n2 - pressdy));
            this.fireInteractionProgress();
        }
        if (!isHandleDraggedPrioritized && !this.isCompleted()) {
            this.lastx = n;
            this.lasty = n2;
            initpx = n;
            initpy = n2;
        }
    }

    public boolean mouseMoved(int n, int n2) {
        boolean bl = this.mouseOver;
        this.mouseOver = this.inBounds(n, n2);
        return bl ^ this.mouseOver;
    }

    public void mouseReleased() {
        if (!this.visible) {
            return;
        }
        if (this.activeHandleIndex >= 0) {
            this.updateLegend();
            this.activeHandleIndex = -1;
        }
        if (!isHandleDraggedPrioritized && !this.isCompleted()) {
            if ((Math.abs(this.pressx - this.lastx) > 10 || Math.abs(this.pressy - this.lasty) > 10) && System.currentTimeMillis() - pressTime > 500L && this.splitDragged()) {
                int n = this.pressx;
                int n2 = this.pressy;
                int n3 = this.lastx;
                int n4 = this.lasty;
                this.lastx = n;
                this.lasty = n2;
                this.mouseReleased();
                this.mousePressed(n3, n4);
                this.lastx = n3;
                this.lasty = n4;
                this.mouseReleased();
                return;
            }
            this.releasedWhileInit(this.lastx, this.lasty);
        }
        PresentationObject.setHandleDraggedPrioritized(false);
        this.updateLegend();
        this.fireMasterSelected(false);
        this.fireInteractionEnd();
        this.lastx = -1;
        this.lasty = -1;
        if (this.isCompleted() && this.getView() != null && this.getView().getVisView() != null) {
            this.getView().getVisView().setHRPaintMode(false);
        }
    }

    public List<PresentationObject> getTranslationListeners() {
        return this.translationListeners;
    }

    private void addTranslationListener(PresentationObject presentationObject) {
        if (this.translationListeners == null) {
            this.translationListeners = new ArrayList<PresentationObject>(2);
        }
        this.translationListeners.add(presentationObject);
    }

    private void removeTranslationListener(PresentationObject presentationObject) {
        if (this.translationListeners != null) {
            this.translationListeners.remove(presentationObject);
        }
    }

    protected void fireInteractionStart() {
    }

    protected void fireInteractionProgress() {
    }

    protected void fireInteractionEnd() {
    }

    protected void fireMasterSelected(boolean bl) {
        if (!this.fireing && this.translationListeners != null) {
            this.fireing = true;
            for (PresentationObject presentationObject : this.translationListeners) {
                presentationObject.masterSelected(bl);
            }
            this.fireing = false;
        }
    }

    public void masterSelected(boolean bl) {
        this.pressx = -1;
        this.pressy = -1;
    }

    protected void fireTranslation(int n, int n2) {
        if (!this.fireing && this.translationListeners != null) {
            this.fireing = true;
            for (PresentationObject presentationObject : this.translationListeners) {
                presentationObject.translationAction(n, n2, this);
            }
            this.fireing = false;
        }
    }

    protected void translationAction(int n, int n2, PresentationObject presentationObject) {
        if (this.fireing) {
            return;
        }
        this.fireTranslation(n, n2);
        PresentationHandle presentationHandle = this.handles[this.translationHandleIndex];
        if (this.pressx == -1) {
            this.lastx = presentationHandle.getX();
            this.lasty = presentationHandle.getY();
            this.pressx = n;
            this.pressy = n2;
        }
        n = n - this.pressx + this.lastx;
        n2 = n2 - this.pressy + this.lasty;
        double[] dArray = this.toImage(n, n2);
        this.handleInteraction(this.translationHandleIndex, dArray);
        if (this.companionOwner != null) {
            this.companionOwner.companionHandleDragged(this.getName(), this.translationHandleIndex, dArray, false);
        }
    }

    public Overlay[] getCompanions() {
        return this.ownedCompanions;
    }

    public static String formatValue(double d, String string) {
        if (Double.isNaN(d)) {
            return "NA";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PresentationObject.formatValue(d));
        if (string != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String formatLiveSyncDistance(double d) {
        return PresentationObject.formatValue(d, true);
    }

    public static String formatValue(double d) {
        return PresentationObject.formatValue(d, false);
    }

    private static String formatValue(double d, boolean bl) {
        double d2 = Math.abs(d);
        if (d2 > 100.0) {
            return bigNumber.format(d);
        }
        if (d2 >= 10.0) {
            return midNumber.format(d);
        }
        if (bl || d2 > 1.5) {
            return smallNumber.format(d);
        }
        return verySmallNumber.format(d);
    }

    public static TextAnnotationLevel getTextAnnotationLevel() {
        return annotationLevel;
    }

    static void setTextAnnotationLevel(TextAnnotationLevel textAnnotationLevel) {
        annotationLevel = textAnnotationLevel;
    }

    protected static boolean isHandleDraggedPrioritized() {
        return isHandleDraggedPrioritized;
    }

    private static void setHandleDraggedPrioritized(boolean bl) {
        isHandleDraggedPrioritized = bl;
    }

    protected void handleDragged(int n, double[] dArray) {
        if (this.companionOwner != null) {
            this.companionOwner.companionHandleDragged(this.getName(), n, dArray, true);
        }
    }

    protected void handleInteraction(int n, double[] dArray) {
    }

    protected void toScreen() {
    }

    private boolean isHandleOutsideView(double d, double d2) {
        return d < 0.0 || d > (double)this.width || d2 < 0.0 || d2 > (double)this.height;
    }

    protected boolean isHandleOutsideView(double[] dArray) {
        double[] dArray2 = this.toScreen(dArray);
        return this.isHandleOutsideView(dArray2[0], dArray2[1]);
    }

    public void updateCoordinates() {
        IImageState iImageState = this.getImageState();
        if (iImageState.getUpdateStamp() > this.lastUpdateStamp) {
            this.toScreen();
            this.updateUnitVectors();
            this.lastUpdateStamp = iImageState.getUpdateStamp();
        }
    }

    protected abstract int setPoint(int var1, double[] var2);

    protected abstract void paintShape(BufferedImageHolder var1);

    public void updateLegend() {
        this.toScreen();
    }

    @Override
    public void resetCachedValues() {
        super.resetCachedValues();
        this.setShapeChanged(true);
        this.updateLegend();
    }

    public Rectangle getBoundingBox() {
        double[] dArray = new double[]{this.bounds.x + PresentationHandle.HANDLE_SIZE, this.bounds.y + PresentationHandle.HANDLE_SIZE};
        double[] dArray2 = new double[]{this.bounds.x + this.bounds.width - PresentationHandle.HANDLE_SIZE, this.bounds.y + this.bounds.height - PresentationHandle.HANDLE_SIZE};
        int n = (int)Math.min(dArray[0], dArray2[0]);
        int n2 = (int)Math.min(dArray[1], dArray2[1]);
        int n3 = (int)Math.max(dArray[0], dArray2[0]) - n;
        int n4 = (int)Math.max(dArray[1], dArray2[1]) - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public Rectangle getImageSpaceBoundingBox() {
        Rectangle rectangle = this.getBoundingBox();
        double[] dArray = new double[]{rectangle.x - 1, rectangle.y - 1};
        double[] dArray2 = new double[]{rectangle.x + rectangle.width + 1, dArray[1]};
        double[] dArray3 = new double[]{dArray2[0], rectangle.y + rectangle.height + 1};
        double[] dArray4 = new double[]{dArray[0], dArray3[1]};
        double[] dArray5 = this.toImage(dArray);
        double[] dArray6 = this.toImage(dArray2);
        double[] dArray7 = this.toImage(dArray3);
        double[] dArray8 = this.toImage(dArray4);
        double d = Math.min(Math.min(dArray5[0], dArray6[0]), Math.min(dArray7[0], dArray8[0]));
        double d2 = Math.max(Math.max(dArray5[0], dArray6[0]), Math.max(dArray7[0], dArray8[0]));
        double d3 = Math.min(Math.min(dArray5[1], dArray6[1]), Math.min(dArray7[1], dArray8[1]));
        double d4 = Math.max(Math.max(dArray5[1], dArray6[1]), Math.max(dArray7[1], dArray8[1]));
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d3);
        int n3 = (int)Math.ceil(d2) - n;
        int n4 = (int)Math.ceil(d4) - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    public void makeAnnotationAt(double d, double d2, int n, String string) {
        if (this.isShutter() || !this.state.contains((Object)OverlayState.AnnotationEnabled)) {
            return;
        }
        if (this.ownedCompanions == null) {
            this.ownedCompanions = new PresentationObject[1];
        }
        if (d + 100.0 > (double)this.width) {
            d = this.bounds.x - 60;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 + (double)n > (double)this.height) {
            d2 = this.bounds.y - n;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        double[] dArray = new double[]{d, d2};
        dArray = this.toImage(dArray);
        this.addCompanion(new TextOverlay(dArray[0], dArray[1], 100.0, n, string, "", this.spacingType, true, null, this));
    }

    protected TextOverlay createAnnotation() {
        return null;
    }

    public TextOverlay makeAnnotation(int n, String string) {
        if (this.isShutter() || !this.state.contains((Object)OverlayState.AnnotationEnabled)) {
            return null;
        }
        int n2 = this.calculateAnnotationWidth(string);
        if (this.isLargeSize()) {
            n = (int)((double)n * 1.875);
            n2 = (int)((double)n2 * 1.875);
        }
        n = GUI.getScaledDiagnosticInt((int)n);
        LabelPlacementManager labelPlacementManager = new LabelPlacementManager(this.getView(), this.getPositioningPoints(), this.getTextSpacing(), n2, n, null, this);
        double[] dArray = labelPlacementManager.getBestFit();
        TextOverlay textOverlay = new TextOverlay(dArray[0], dArray[1], n2, n, string, "", this.spacingType, true, null, this);
        this.addCompanion(textOverlay);
        if (this.owner != null) {
            this.getView().addOverlay(textOverlay);
        }
        return textOverlay;
    }

    protected int calculateAnnotationWidth(String string) {
        return GUI.getScaledDiagnosticInt((int)((int)(9.5 * (double)((int)Config.impaxee.jvision.MAPPING.DisplayFontSize.get()))));
    }

    public void enableAnnotation(boolean bl) {
        this.setState(OverlayState.AnnotationEnabled, bl);
    }

    public void setNonEditableTextEnabled(boolean bl) {
        this.setState(OverlayState.UseNonEditableText, bl);
    }

    public void addAnnotation(TextOverlay textOverlay, boolean bl) {
        this.addCompanion(textOverlay);
        this.setNonEditableTextEnabled(bl);
    }

    public List<IOverlayInformation> getOverlayInformation() {
        return Collections.emptyList();
    }

    public void addCompanion(PresentationObject presentationObject) {
        Overlay[] overlayArray = this.ownedCompanions;
        int n = 1;
        if (overlayArray != null) {
            n = overlayArray.length + 1;
        }
        this.ownedCompanions = new PresentationObject[n];
        if (overlayArray != null) {
            System.arraycopy(overlayArray, 0, this.ownedCompanions, 0, n - 1);
        }
        this.ownedCompanions[n - 1] = presentationObject;
        presentationObject.setID(this.id);
        this.addTranslationListener(presentationObject);
        if (this instanceof SyncablePresentationObject) {
            presentationObject.setCompanionOwner((SyncablePresentationObject)this);
        }
        this.shapeChanged = true;
        if (presentationObject instanceof DataProfile && this instanceof PointSequence) {
            ((DataProfile)presentationObject).setPointSequence((PointSequence)((Object)this));
        }
    }

    private void setCompanionOwner(SyncablePresentationObject syncablePresentationObject) {
        this.companionOwner = syncablePresentationObject;
    }

    public SyncablePresentationObject getCompanionOwner() {
        return this.companionOwner;
    }

    public boolean hasCompanion(PresentationObject presentationObject) {
        if (this.ownedCompanions == null) {
            return false;
        }
        int n = 0;
        while (n < this.ownedCompanions.length) {
            if (this.ownedCompanions[n] == presentationObject) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeCompanion(PresentationObject presentationObject) {
        if (this.ownedCompanions == null || this.ownedCompanions.length < 1) {
            return;
        }
        Overlay[] overlayArray = new Overlay[this.ownedCompanions.length - 1];
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < this.ownedCompanions.length) {
                if (this.ownedCompanions[n2] != presentationObject) {
                    overlayArray[n++] = this.ownedCompanions[n2];
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.error("PresentationObject: ", (Throwable)arrayIndexOutOfBoundsException);
            return;
        }
        this.ownedCompanions = overlayArray;
        this.removeTranslationListener(presentationObject);
        presentationObject.setCompanionOwner(null);
        this.shapeChanged = true;
        this.activeHandleIndex = -1;
    }

    public boolean isROI() {
        return false;
    }

    @Override
    public boolean isUnsavedROI() {
        return this.isVisible() && this.isROI() && !this.isSaved() && (this instanceof ITextObjectContainer || this instanceof IGraphicObjectContainer);
    }

    public GraphicObject createGraphicObject() {
        GraphicObject graphicObject = new GraphicObject();
        graphicObject.setTianiID("TIANI");
        if (this.isEditable()) {
            graphicObject.setTianiROIID(Integer.toString(this.id));
        }
        graphicObject.setGraphicDimensions(2);
        graphicObject.setGraphicFilled(YN.get((boolean)this.isSolid()));
        graphicObject.setGraphicAnnotationUnits(this.spacingType);
        return graphicObject;
    }

    public void setID(int n) {
        this.id = n;
        if (this.id > roiID.get()) {
            roiID.set(this.id);
        }
    }

    public int getID() {
        return this.id;
    }

    public void setShutterMode(boolean bl) {
        if (this instanceof CircleOverlay || this instanceof RectangleOverlayMPR || this instanceof CurveOverlay || this instanceof PolygonOverlay) {
            this.setState(OverlayState.Shutter, bl);
            if (bl) {
                this.objCol = Shutter.OUTLINE_COLOR;
            }
        } else {
            this.setState(OverlayState.Shutter, false);
        }
    }

    public void setShutterValue(int n) {
        this.shutterValue = n;
    }

    public OverlayFrame getOverlayFrame() {
        if (this.shutterMask instanceof BinBMPShutter) {
            return ((BinBMPShutter)this.shutterMask).getOverlayFrame();
        }
        return null;
    }

    public boolean isShutter() {
        return this.state.contains((Object)OverlayState.Shutter);
    }

    public boolean isCompleted() {
        return this.initStep < 0;
    }

    public void dimm(int n, int n2, int n3, int n4, int n5, BufferedImageHolder bufferedImageHolder) {
        if (n < 0) {
            n3 += n;
        }
        if (n2 < 0) {
            n4 += n2;
        }
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        n3 = Math.min(n3, bufferedImageHolder.width - n);
        n4 = Math.min(n4, bufferedImageHolder.height - n2);
        int n6 = n2 * bufferedImageHolder.width + n;
        n5 = (int)((double)n5 * 2.56);
        Object object = bufferedImageHolder.getImageArray();
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = (nArray[n6] >> 16 & 0xFF) * n5;
                    int n10 = (nArray[n6] >> 8 & 0xFF) * n5;
                    int n11 = (nArray[n6] & 0xFF) * n5;
                    nArray[n6++] = (n9 << 8 & 0xFF0000) + (n10 & 0xFF00) + (n11 >> 8 & 0xFF);
                    ++n8;
                }
                n6 += bufferedImageHolder.width - n3;
                ++n7;
            }
        }
    }

    public void cloneReferences(PresentationObject presentationObject) {
        Cloneable cloneable;
        int n = 0;
        Overlay[] overlayArray = null;
        ArrayList<PresentationObject> arrayList = null;
        ArrayList<PresentationObject> arrayList2 = null;
        presentationObject.state = this.state.clone();
        if (this.translationListeners != null) {
            arrayList2 = new ArrayList<PresentationObject>(this.translationListeners);
        }
        if (this.ownedCompanions != null) {
            overlayArray = new Overlay[this.ownedCompanions.length];
            int n2 = 0;
            n = 0;
            while (n < this.ownedCompanions.length) {
                if (this.ownedCompanions[n] != null) {
                    if (this.ownedCompanions[n] instanceof PresentationObject) {
                        cloneable = ((PresentationObject)this.ownedCompanions[n]).cloneAll();
                        if (presentationObject instanceof SyncablePresentationObject) {
                            super.setCompanionOwner((SyncablePresentationObject)presentationObject);
                            ((PresentationObject)cloneable).setID(presentationObject.getID());
                        }
                        if (cloneable != null) {
                            overlayArray[n2] = cloneable;
                            if (this.translationListeners != null && this.translationListeners.indexOf(this.ownedCompanions[n]) >= 0) {
                                if (arrayList == null) {
                                    arrayList = new ArrayList(this.translationListeners.size());
                                }
                                arrayList.add((PresentationObject)cloneable);
                                arrayList2.remove(this.ownedCompanions[n]);
                            }
                            ++n2;
                        } else if (this.translationListeners != null && this.translationListeners.indexOf(this.ownedCompanions[n]) >= 0) {
                            arrayList2.remove(this.ownedCompanions[n]);
                        }
                    } else {
                        overlayArray[n2++] = this.ownedCompanions[n];
                    }
                } else {
                    overlayArray[n2++] = null;
                }
                ++n;
            }
        }
        if (arrayList2 != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<PresentationObject>();
            }
            arrayList.addAll(arrayList2);
        }
        presentationObject.select(false);
        Color color = null;
        if (this.objCol != null) {
            color = new Color((float)this.objCol.getRed() / 255.0f, (float)this.objCol.getGreen() / 255.0f, (float)this.objCol.getBlue() / 255.0f, (float)this.objCol.getAlpha() / 255.0f);
        }
        cloneable = null;
        if (this.bounds != null) {
            cloneable = (Rectangle)this.bounds.clone();
        }
        PresentationHandle[] presentationHandleArray = null;
        if (this.handles != null) {
            presentationHandleArray = new PresentationHandle[this.handles.length];
            n = 0;
            PresentationHandle[] presentationHandleArray2 = this.handles;
            int n3 = this.handles.length;
            int n4 = 0;
            while (n4 < n3) {
                PresentationHandle presentationHandle = presentationHandleArray2[n4];
                presentationHandleArray[n] = presentationHandle instanceof ColorChooserHandle ? new ColorChooserHandle((TextOverlay)presentationObject, presentationHandle.x, presentationHandle.y) : (presentationHandle != null ? presentationHandle.clone() : null);
                ++n;
                ++n4;
            }
        }
        if (presentationObject.shutterMask != null) {
            this.shutterMask = presentationObject.shutterMask.clone();
        }
        presentationObject.setClonedParameters(overlayArray, arrayList, color, (Rectangle)cloneable, presentationHandleArray, ReferencedObjectsCloning.clone(this.unitx), ReferencedObjectsCloning.clone(this.unity));
    }

    public void setClonedParameters(Overlay[] overlayArray, List<PresentationObject> list, Color color, Rectangle rectangle, PresentationHandle[] presentationHandleArray, double[] dArray, double[] dArray2) {
        this.ownedCompanions = overlayArray;
        this.translationListeners = list;
        this.objCol = color;
        this.bounds = rectangle;
        this.handles = presentationHandleArray;
        this.unitx = dArray;
        this.unity = dArray2;
    }

    public abstract PresentationObject cloneAll();

    public PresentationObject copyTo(View view, OverlaySynchronizationMode overlaySynchronizationMode) {
        PresentationObject presentationObject = this.cloneAll();
        this.cloneReferences(presentationObject);
        presentationObject.regenerateID();
        presentationObject.setImageState(view.getImageState());
        presentationObject.setOwner(view);
        Overlay[] overlayArray = presentationObject.getCompanions();
        if (overlayArray != null) {
            Overlay[] overlayArray2 = overlayArray;
            int n = overlayArray.length;
            int n2 = 0;
            while (n2 < n) {
                Overlay overlay = overlayArray2[n2];
                overlay.setImageState(view.getImageState());
                overlay.setOwner(view);
                ++n2;
            }
        }
        return presentationObject;
    }

    public void regenerateID() {
        this.id = roiID.incrementAndGet();
        if (this.ownedCompanions != null) {
            Overlay[] overlayArray = this.ownedCompanions;
            int n = this.ownedCompanions.length;
            int n2 = 0;
            while (n2 < n) {
                Overlay overlay = overlayArray[n2];
                if (overlay instanceof PresentationObject) {
                    ((PresentationObject)overlay).setID(this.id);
                }
                ++n2;
            }
        }
    }

    public boolean isShowOnSmallViews() {
        return false;
    }

    protected final boolean showHandles() {
        return this.state.contains((Object)OverlayState.ShowHandles);
    }

    protected boolean isHandleClicked(int n, int n2) {
        PresentationHandle[] presentationHandleArray = this.handles;
        int n3 = this.handles.length;
        int n4 = 0;
        while (n4 < n3) {
            PresentationHandle presentationHandle = presentationHandleArray[n4];
            if (presentationHandle.mousePressed(n, n2)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public static boolean isHideAllROIs() {
        return hideAllROIs;
    }

    public static void setHideAllROIs(boolean bl) {
        hideAllROIs = bl;
    }

    public void setShapeChanged(boolean bl) {
        this.shapeChanged = bl;
    }

    public boolean annotationParentSelected() {
        if (this.owner != null) {
            PresentationObject presentationObject = this.getView().getSelectedPO();
            if (presentationObject != null) {
                return presentationObject.getAnnotation() == this;
            }
            return false;
        }
        return false;
    }

    public void adjustToRendererPlane(IImageState iImageState) {
        this.setImageState(iImageState);
        this.toScreen();
    }

    public boolean isColorUserDefined() {
        return OverlayConfig.mappingColor != this.objCol;
    }

    private boolean isRGBRenderer() {
        View view = this.getView();
        if (view == null) {
            return false;
        }
        return view.getRenderer() instanceof RDCRendererRGB;
    }

    private List<IMenuEntry> getMenuEntriesImpl() {
        TextOverlay textOverlay;
        boolean bl;
        ArrayList<IMenuEntry> arrayList = new ArrayList<IMenuEntry>();
        boolean bl2 = false;
        boolean bl3 = bl = this.getView() != null && this.getView().getVis().getParent().getPlugin().isDefaultPlugin();
        if (bl) {
            arrayList.add(new CopyToSelectedImages(false, this.companionOwner == null));
            if (this instanceof SyncablePresentationObject) {
                boolean bl4 = ((SyncablePresentationObject)this).isSynchronizationEnabled();
                arrayList.add(new CopyToSelectedImages(true, !bl4));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Messages.getString("PresentationObject.CopyToOtherDisplays"));
                stringBuilder.append(Messages.getString("PresentationObject.WithSynchronization"));
                arrayList.add(new PresentationObjectActionWrapper(stringBuilder.toString(), "OVERLAY_COPY"));
                arrayList.add(new RemoveFromAllImages(bl4 && this.isRemoveable()));
            }
        }
        if (this.getView() != null) {
            arrayList.addAll(this.getView().getMenuEntriesForPO(this));
        }
        if ((textOverlay = this.getOrCreateAnnotation()) != null) {
            bl2 = arrayList.add(new SeparatorEntry());
            arrayList.add(new Annotation());
        }
        if (this.supportsProfile() && this instanceof PointSequence && !this.isRGBRenderer() && bl) {
            if (!bl2) {
                bl2 = arrayList.add(new SeparatorEntry());
            }
            arrayList.add(new Profile());
        }
        if (this.supportsHistogram() && this.spacingType == AnnotationUnits.Pixel && !this.isRGBRenderer()) {
            if (!bl2) {
                bl2 = arrayList.add(new SeparatorEntry());
            }
            arrayList.add(new Histogram());
        }
        return arrayList;
    }

    static IPresentationObjectAction resolveAction(String string) {
        PAction pAction = PActionRegistry.getAction(string);
        if (pAction instanceof IPresentationObjectAction) {
            return (IPresentationObjectAction)pAction;
        }
        return null;
    }

    public boolean isShowConnections() {
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        List<IOverlayInformation> list = this.getOverlayInformation();
        if (!CollectionUtils.isEmpty(list)) {
            stringBuilder.append('[');
            boolean bl = true;
            for (IOverlayInformation iOverlayInformation : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                iOverlayInformation.appendInformationText(stringBuilder);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private class Annotation
    extends AbstractCheckBoxMenuItem {
        public Annotation() {
            super(Messages.getString("PresentationObject.TextAnnotation"), true, PresentationObject.this.getAnnotation().isVisible());
        }

        @Override
        public void menuItemSelected(boolean bl) {
            TextOverlay textOverlay = PresentationObject.this.getAnnotation();
            textOverlay.setVisible(bl);
            textOverlay.setManuallyHidden(!bl);
            if (PresentationObject.this instanceof SyncablePresentationObject) {
                ((SyncablePresentationObject)PresentationObject.this).companionVisibilityChanged(textOverlay, bl);
            }
        }
    }

    private class CopyToSelectedImages
    extends AbstractStandardMenuItem {
        private boolean sync;

        public CopyToSelectedImages(boolean bl, boolean bl2) {
            super(String.valueOf(Messages.getString("PresentationObject.CopyToSelectedImages")) + (bl ? Messages.getString("PresentationObject.WithSynchronization") : ""), true);
            this.sync = bl;
            this.enabled = bl2;
        }

        @Override
        public void menuItemSelected() {
            PresentationObject.this.getView().copyToSelectedVis(PresentationObject.this, this.sync ? OverlaySynchronizationMode.IMAGE_COORDINATES : OverlaySynchronizationMode.OFF);
        }
    }

    private class Histogram
    extends AbstractCheckBoxMenuItem {
        public Histogram() {
            super(Messages.getString("PresentationObject.ValueHistogram"), true, false);
        }

        @Override
        public boolean isChecked() {
            HistogramOverlay histogramOverlay = PresentationObject.this.getHistogramOverlay();
            return histogramOverlay != null && histogramOverlay.isVisible();
        }

        @Override
        public void menuItemSelected(boolean bl) {
            HistogramOverlay histogramOverlay = PresentationObject.this.getHistogramOverlay();
            if (PresentationObject.this.getHistogramOverlay() == null) {
                histogramOverlay = PresentationObject.this.createHistogramOverlay();
            }
            if (histogramOverlay == null) {
                log.warn("Creating histogram overlay failed");
                return;
            }
            histogramOverlay.setVisible(bl);
            if (bl) {
                PresentationObject.this.shapeChanged = true;
                PresentationObject.this.toScreen();
                PresentationObject.this.getView().invalidate();
                PresentationObject.this.getView().repaint();
            }
            if (PresentationObject.this instanceof SyncablePresentationObject) {
                ((SyncablePresentationObject)PresentationObject.this).companionVisibilityChanged(histogramOverlay, bl);
            }
        }
    }

    protected static enum OverlayState {
        Solid,
        Shutter,
        Editable,
        Local,
        Interactive,
        AnnotationEnabled,
        ShowHandles,
        UseNonEditableText,
        IsSaved;

    }

    private class PresentationObjectActionWrapper
    extends AbstractStandardMenuItem {
        private IPresentationObjectAction delegate;

        PresentationObjectActionWrapper(String string, String string2) {
            this(string, PresentationObject.resolveAction(string2));
        }

        PresentationObjectActionWrapper(String string, IPresentationObjectAction iPresentationObjectAction) {
            super(string, iPresentationObjectAction != null && iPresentationObjectAction.isEnabled() && iPresentationObjectAction.isSupported(PresentationObject.this));
            this.delegate = iPresentationObjectAction;
        }

        @Override
        public void menuItemSelected() {
            this.delegate.perform(PresentationObject.this);
        }
    }

    private class Profile
    extends AbstractCheckBoxMenuItem {
        public Profile() {
            super(Messages.getString("PresentationObject.ValueProfile"), true, false);
        }

        @Override
        public boolean isChecked() {
            DataProfile dataProfile = PresentationObject.this.getDataProfilePlot();
            return dataProfile != null && dataProfile.isVisible();
        }

        @Override
        public void menuItemSelected(boolean bl) {
            DataProfile dataProfile = PresentationObject.this.getDataProfilePlot();
            if (dataProfile == null) {
                dataProfile = PresentationObject.this.createDataProfile();
            }
            dataProfile.setVisible(bl);
            PresentationObject.this.shapeChanged = true;
            PresentationObject.this.getView().invalidate();
            PresentationObject.this.getView().repaint();
            if (PresentationObject.this instanceof SyncablePresentationObject) {
                ((SyncablePresentationObject)PresentationObject.this).companionVisibilityChanged(dataProfile, bl);
            }
        }
    }

    private class RemoveFromAllImages
    extends AbstractStandardMenuItem {
        public RemoveFromAllImages(boolean bl) {
            super(Messages.getString("PresentationObject.RemoveFromAllImages"), true);
            this.enabled = bl;
        }

        @Override
        public void menuItemSelected() {
            List<SyncablePresentationObject> list = ((SyncablePresentationObject)PresentationObject.this).getRelatives();
            if (list != null) {
                for (SyncablePresentationObject syncablePresentationObject : list) {
                    View view = syncablePresentationObject.getView();
                    Overlay[] overlayArray = syncablePresentationObject.getCompanions();
                    if (overlayArray != null) {
                        Overlay[] overlayArray2 = overlayArray;
                        int n = overlayArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Overlay overlay = overlayArray2[n2];
                            view.removeOverlay(overlay);
                            ++n2;
                        }
                    }
                    view.removeOverlay(syncablePresentationObject);
                    view.repaint();
                }
            }
        }
    }
}

