/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.rotation.FreeRotationAngle;
import com.agfa.pacs.impaxee.rotation.FreeRotationPreChargeHandler;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.GeomUtil;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.AbstractSingleLineOverlay;

public class StraightenImageLineOverlay
extends AbstractSingleLineOverlay {
    private static final ALogger LOGGER = ALogger.getLogger(StraightenImageLineOverlay.class);

    public StraightenImageLineOverlay() {
        super("Straighten image", AbstractRegionSpacingOverlay.ImageRegionSpacingMode.DISABLED);
    }

    @Override
    double calculateMeasurementResult() {
        return Double.NaN;
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = super.setPoint(n, dArray);
        if (n2 <= 0) {
            View view = this.getView();
            FreeRotationPreChargeHandler freeRotationPreChargeHandler = FreeRotationPreChargeHandler.create(view.getVisView());
            FreeRotationAngle freeRotationAngle = this.computeRotationAngle();
            if (freeRotationPreChargeHandler != null && freeRotationAngle != null) {
                freeRotationPreChargeHandler.applyRotation(freeRotationAngle);
            }
            view.removeOverlay(this);
        }
        return n2;
    }

    private FreeRotationAngle computeRotationAngle() {
        double d;
        int n = this.qxi - this.pxi;
        int n2 = this.qyi - this.pyi;
        if (n < 0) {
            n = -n;
            n2 = -n2;
        }
        if (Double.isNaN(d = GeomUtil.getAngle((double)n, (double)n2, (double)1.0, (double)0.0))) {
            LOGGER.warn("Computing rotation angle from straighten image overlay failed, possible singular line");
            return null;
        }
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return FreeRotationAngle.relative(d);
    }
}

