/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.overlay.OverlaySyncData;
import com.tiani.jvision.overlay.RendererOverlay;
import com.tiani.jvision.renderer.Renderer;

public abstract class SyncableRendererOverlay
extends RendererOverlay
implements ViewEventHandler {
    private final OverlaySyncData sync;

    public SyncableRendererOverlay(String string, Renderer renderer, OverlaySyncData overlaySyncData) {
        super(string, overlaySyncData.position.x, overlaySyncData.position.y, overlaySyncData.position.width, overlaySyncData.position.height, renderer);
        this.sync = overlaySyncData;
    }

    @Override
    public final void paintShape(BufferedImageHolder bufferedImageHolder) {
        this.updateSyncedPos();
        this.paintOverlay(bufferedImageHolder);
    }

    protected void paintOverlay(BufferedImageHolder bufferedImageHolder) {
        super.paintShape(bufferedImageHolder);
    }

    private void updateSyncedPos() {
        if (this.sync.position.x == this.o[0] && this.sync.position.y == this.o[1] && this.sync.position.width == this.w && this.sync.position.height == this.h) {
            return;
        }
        this.o[0] = this.sync.position.x;
        this.o[1] = this.sync.position.y;
        this.w = this.sync.position.width;
        this.h = this.sync.position.height;
        this.toScreen();
    }

    @Override
    public void handleDragged(int n, double[] dArray) {
        super.handleDragged(n, dArray);
        this.sync.position.x = this.o[0];
        this.sync.position.y = this.o[1];
        this.sync.position.width = this.w;
        this.sync.position.height = this.h;
    }

    @Override
    public void mouseReleased() {
        super.mouseReleased();
        if (this.owner != null) {
            this.getView().broadcastUpdate(this.sync);
        }
    }

    @Override
    public void presentationObjectAdded(View view) {
        super.presentationObjectAdded(view);
        view.addViewEventListener(this);
    }

    @Override
    public void presentationObjectRemoved(View view) {
        view.removeViewEventListener(this);
        super.presentationObjectRemoved(view);
        if (!this.sync.isMarkedForDeletion()) {
            this.sync.markForDeletion();
            view.broadcastUpdate(this.sync);
        }
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.id == 71 && object == this.sync) {
            if (this.sync.isMarkedForDeletion()) {
                log.trace("Removing syncable overlay: " + this);
                view.removeOverlay(this);
            }
            view.invalidate();
            view.repaint();
            return true;
        }
        return false;
    }
}

