/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.chart;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import java.awt.Color;

public abstract class ChartAxis {
    protected double min;
    protected double max;
    protected double range;
    protected int imin;
    protected int imax;
    protected int irange;
    protected String label;
    private Color color = OverlayConfig.mappingColor;

    public ChartAxis(String string) {
        this.label = string;
    }

    public ChartAxis(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.range = d2 - d;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setOutputRange(int n, int n2) {
        this.imin = n;
        this.imax = n2;
        this.irange = n2 - n;
    }

    public void setMin(double d) {
        this.min = d;
        this.range = this.max - d;
    }

    public void setMax(double d) {
        this.max = d;
        this.range = d - this.min;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public abstract double map(double var1);

    public void paint(BufferedImageHolder bufferedImageHolder, int n, int n2, int n3, int n4, Overlay overlay) {
        Color color = bufferedImageHolder.graphics.getColor();
        bufferedImageHolder.graphics.setColor(this.color);
        if (this.isDrawingAxisLine()) {
            bufferedImageHolder.graphics.drawLine(n, n2, n3, n4);
        }
        if (this.label != null) {
            String string = String.valueOf(Double.toString(this.min)) + " " + this.label;
            String string2 = String.valueOf(Double.toString(this.max)) + " " + this.label;
            if (n == n3) {
                int n5 = overlay.getFontHeight();
                overlay.drawString(string, this.color, bufferedImageHolder, n - 10, n2 + n5);
                overlay.drawString(string2, this.color, bufferedImageHolder, n3 - 10, n4);
            } else {
                overlay.drawString(string, this.color, bufferedImageHolder, n, n2 + 10);
                overlay.drawString(string2, this.color, bufferedImageHolder, n3, n4 + 10);
            }
        }
        bufferedImageHolder.graphics.setColor(color);
    }

    protected boolean isDrawingAxisLine() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.min) + "-" + this.max + "->" + this.imin + "-" + this.imax;
    }
}

