/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.chart;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.chart.ChartAxis;
import com.tiani.jvision.overlay.chart.ChartDataChannel;
import com.tiani.jvision.overlay.chart.ChartLayout;
import java.util.ArrayList;
import java.util.List;

public class MultiLineChart
extends OverlayContainer {
    protected List<ChartAxis> xAxis;
    protected List<ChartAxis> yAxis;
    protected ChartLayout layout;
    List<ChartDataChannel> channels = new ArrayList<ChartDataChannel>();
    private int dimm = 50;
    private boolean box = true;

    public MultiLineChart(String string) {
        this(string, 0.75, 0.75, 0.2, 0.2, AnnotationUnits.Display, OverlayContainer.AnchorPosition.TOPLEFT);
        super.setOnlyTranslateAnchor(true);
        this.init();
    }

    public MultiLineChart(String string, double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        super(string, d, d2, d3, d4, annotationUnits);
        this.setEditable(true);
        super.setOnlyTranslateAnchor(false);
        this.init();
    }

    public MultiLineChart(String string, double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition) {
        super(string, d, d2, d3, d4, annotationUnits, anchorPosition);
        this.setEditable(true);
        super.setOnlyTranslateAnchor(false);
        this.init();
    }

    private void init() {
        this.layout = new ChartLayout();
        this.xAxis = new ArrayList<ChartAxis>();
        this.yAxis = new ArrayList<ChartAxis>();
    }

    public void addChannel(ChartDataChannel chartDataChannel, ChartAxis chartAxis, ChartAxis chartAxis2) {
        this.channels.add(chartDataChannel);
        this.xAxis.add(chartAxis);
        this.yAxis.add(chartAxis2);
        this.layout.grid(1, this.channels.size());
    }

    public void removeChannel(ChartDataChannel chartDataChannel) {
        int n = this.channels.indexOf(chartDataChannel);
        this.channels.remove(n);
        this.xAxis.remove(n);
        this.yAxis.remove(n);
        this.layout.grid(1, this.channels.size());
    }

    public void dimmBackground(int n) {
        this.dimm = n;
    }

    public void showBox(boolean bl) {
        this.box = bl;
    }

    public void setLayout(ChartLayout chartLayout) {
        this.layout = chartLayout;
    }

    public ChartAxis[] getXAxis() {
        return this.xAxis.toArray(new ChartAxis[this.xAxis.size()]);
    }

    public ChartAxis[] getYAxis() {
        return this.yAxis.toArray(new ChartAxis[this.yAxis.size()]);
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.dimm > 0) {
            this.dimm(this.p0x, this.p0y, this.p1x - this.p0x, this.p3y - this.p0y, this.dimm, bufferedImageHolder);
        }
        if (this.box) {
            super.paintShape(bufferedImageHolder);
        }
        int n = 0;
        while (n < this.channels.size()) {
            ChartAxis chartAxis = this.xAxis.get(n);
            ChartAxis chartAxis2 = this.yAxis.get(n);
            double[][] dArray = this.layout.getValues(n);
            int n2 = this.p0x + (int)((double)(this.p1x - this.p0x) * dArray[0][0]);
            int n3 = this.p0y + (int)((double)(this.p3y - this.p0y) * dArray[0][1]);
            int n4 = this.p0x + (int)((double)(this.p1x - this.p0x) * dArray[1][0]);
            int n5 = this.p3x + (int)((double)(this.p2x - this.p3x) * dArray[2][0]);
            int n6 = this.p1y + (int)((double)(this.p2y - this.p1y) * dArray[2][1]);
            int n7 = this.p3x + (int)((double)(this.p2x - this.p3x) * dArray[3][0]);
            int n8 = this.p1y + (int)((double)(this.p2y - this.p1y) * dArray[3][1]);
            chartAxis.setOutputRange(n2, n4);
            chartAxis2.setOutputRange(n8, n3);
            chartAxis.paint(bufferedImageHolder, n7, n8, n5, n6, this);
            chartAxis2.paint(bufferedImageHolder, n7, n8, n2, n3, this);
            ChartDataChannel chartDataChannel = this.channels.get(n);
            chartDataChannel.setColor(this.layout.getColor(n));
            chartDataChannel.paint(bufferedImageHolder, chartAxis, chartAxis2, this);
            ++n;
        }
    }
}

