/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.logging.ALogger;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.config.mappingfonts.model.enums.WordgroupType;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.demographics.DefaultSubstituteEvaluation;
import com.tiani.jvision.overlay.demographics.ISubstituteEvaluation;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingLineEntry;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractMappingEntry
implements Mapping.ITagEntry {
    private static final ALogger log = ALogger.getLogger(AbstractMappingEntry.class);
    static final String EMPTY_STRING = "";
    static final String VISUAL = "VISUAL";
    private static Map<String, DecimalFormat> formatPool = new Hashtable<String, DecimalFormat>();
    private static final ISubstituteEvaluation defaultSubstitution = new DefaultSubstituteEvaluation();
    protected ExtendedEntryProperties properties = null;
    protected boolean append;
    protected final WordgroupType type;
    private String prefix;

    AbstractMappingEntry(String string, int n, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
        this.prefix = string;
        this.append = bl;
        this.type = wordgroupType;
        int n2 = -1;
        try {
            if (string4 != null && string4.length() > 0) {
                n2 = Integer.parseInt(string4);
            }
        }
        catch (Exception exception) {
            log.warn("attribute maxlength contains invalid characters");
        }
        if (levelOfDetail != null && levelOfDetail == LevelOfDetail.LIMITED) {
            levelOfDetail = null;
        }
        if (string3 != null && string3.equals("#.##")) {
            string3 = null;
        }
        if (n != -1 || font != null || color != null || levelOfDetail != null || n2 != -1 || iSubstituteEvaluation != null || string2 != null || string3 != null) {
            this.properties = new ExtendedEntryProperties(font, AbstractMappingEntry.getDecimalFormat(string3), n2, levelOfDetail, iSubstituteEvaluation, color, n, string2);
        }
    }

    private static DecimalFormat getDecimalFormat(String string) {
        if (string == null) {
            return null;
        }
        DecimalFormat decimalFormat = formatPool.get(string);
        if (decimalFormat == null) {
            try {
                decimalFormat = new DecimalFormat(string);
                formatPool.put(string, decimalFormat);
            }
            catch (Exception exception) {
                log.error("Mapping: Invalid format string for mapping >" + string + "<", (Throwable)exception);
            }
        }
        return decimalFormat;
    }

    protected abstract boolean isValid();

    protected Font getFont(float f) {
        Font font;
        Font font2 = font = this.properties == null ? null : this.properties.font;
        if (font == null) {
            font = Mapping.defaultFont;
        }
        if (f != -1.0f) {
            int n = Math.max(Math.round((float)font.getSize() * f), 10);
            return AwtFontFactory.getFont(font.getName(), font.getStyle(), n);
        }
        return font;
    }

    public boolean isAppend() {
        return this.append;
    }

    protected Color getColor(IEvaluationContext iEvaluationContext) {
        return this.properties == null ? null : this.properties.color;
    }

    protected abstract String getTagAsString();

    protected final ISubstituteEvaluation getSubstitution() {
        if (this.properties == null || this.properties.substituteEvaluation == null) {
            return defaultSubstitution;
        }
        return this.properties.substituteEvaluation;
    }

    protected abstract String getValue(IEvaluationContext var1);

    public MappingLineEntry refreshContent(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry, boolean bl) {
        mappingLineEntry.checkValidEntry(this);
        if (mappingLineEntry.hasContentNotSpecified() || bl) {
            String string = this.getValue(iEvaluationContext);
            if (string != null) {
                mappingLineEntry.setContent(string);
            } else {
                mappingLineEntry.setContent(EMPTY_STRING);
            }
        }
        return mappingLineEntry;
    }

    boolean isRefreshOnEmptyContentEnabled() {
        return false;
    }

    protected boolean levelOfDetailVisible() {
        switch (View.getLevelOfDetailForDemographics()) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case LIMITED: {
                return this.properties == null || this.properties.levelOfDetail != LevelOfDetail.ALL;
            }
        }
        return true;
    }

    protected String formatString(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        int n = string.length();
        if (this.prefix != null) {
            n += this.prefix.length();
        }
        if (this.properties != null && this.properties.postfix != null) {
            n += this.properties.postfix.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        if (this.prefix != null) {
            stringBuilder.append(this.prefix);
        }
        if (this.properties != null) {
            if (this.properties.maxlength > 0 && string.length() > this.properties.maxlength) {
                stringBuilder.append(string, 0, this.properties.maxlength);
            } else {
                stringBuilder.append(string);
            }
        } else {
            stringBuilder.append(string);
        }
        if (this.properties != null && this.properties.postfix != null) {
            stringBuilder.append(this.properties.postfix);
        }
        return stringBuilder.toString();
    }

    protected String formatStrings(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY_STRING;
        }
        String string = stringArray[0];
        if (stringArray.length == 1) {
            return this.formatString(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * stringArray.length + stringArray.length);
        stringBuilder.append(string);
        int n = 1;
        while (n < stringArray.length) {
            stringBuilder.append('\\').append(stringArray[n]);
            ++n;
        }
        return this.formatString(stringBuilder.toString());
    }

    static class ExtendedEntryProperties {
        private final Font font;
        private final DecimalFormat decimalFormat;
        private final int maxlength;
        private final LevelOfDetail levelOfDetail;
        private ISubstituteEvaluation substituteEvaluation;
        private final Color color;
        private int offset;
        private final String postfix;

        public ExtendedEntryProperties(Font font, DecimalFormat decimalFormat, int n, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation, Color color, int n2, String string) {
            this.font = font;
            this.decimalFormat = decimalFormat;
            this.maxlength = n;
            this.levelOfDetail = levelOfDetail;
            this.substituteEvaluation = iSubstituteEvaluation;
            this.color = color;
            this.offset = n2;
            this.postfix = string;
        }

        public ExtendedEntryProperties() {
            this.font = null;
            this.decimalFormat = AbstractMappingEntry.getDecimalFormat(null);
            this.maxlength = -1;
            this.levelOfDetail = null;
            this.substituteEvaluation = null;
            this.color = null;
            this.offset = 0;
            this.postfix = null;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public DecimalFormat getDecimalFormat() {
            return this.decimalFormat;
        }
    }
}

