/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.utils.FontUtils;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.mappingfonts.model.Wordgroup;
import com.tiani.config.mappingfonts.model.enums.FontStyle;
import com.tiani.config.mappingfonts.model.enums.WordgroupType;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.demographics.AbstractMappingEntry;
import com.tiani.jvision.overlay.demographics.DicomTagEntry;
import com.tiani.jvision.overlay.demographics.ISubstituteEvaluation;
import com.tiani.jvision.overlay.demographics.MappingLineEntry;
import com.tiani.jvision.overlay.demographics.NameDicomTagEntry;
import com.tiani.jvision.overlay.demographics.OwnPrivateTagEntry;
import com.tiani.jvision.overlay.demographics.PriorStudyColoring;
import com.tiani.jvision.overlay.demographics.PriorTagEntry;
import com.tiani.jvision.overlay.demographics.QuadMapping;
import com.tiani.jvision.overlay.demographics.SeqDicomTagEntry;
import com.tiani.jvision.overlay.demographics.StringTagEntry;
import com.tiani.jvision.overlay.demographics.SubstituteEvaluationFactory;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.expressions.DataEvaluationContext;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;

public abstract class Mapping
extends Overlay {
    protected static final ALogger log = ALogger.getLogger(Mapping.class);
    private static final DataSelectionManager dsm = DataSelectionManager.getInstance();
    private static final boolean usePriorColoring = Config.impaxee.jvision.MAPPING.ColorizePriorsDemographics.get();
    private static boolean isAnonymousMode = Config.impaxee.jvision.MAPPING.UseAnonymousMode.get();
    private static IConfigurationChangeListener configChangeListener = new IConfigurationChangeListener(){

        public void configurationChanged(String string) {
            if (string != null && string.equals(Config.impaxee.jvision.MAPPING.UseAnonymousMode.getKey()) && isAnonymousMode != Config.impaxee.jvision.MAPPING.UseAnonymousMode.get()) {
                Mapping.setAnonymousMode(Config.impaxee.jvision.MAPPING.UseAnonymousMode.get());
                List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
                for (VisData object2 : list) {
                    object2.getView().updateMapping(true);
                }
                TEvent tEvent = new TEvent(81);
                TEventDispatch.sendEvent(tEvent, null, 20);
            }
        }
    };
    static final Font defaultFont;
    private int minSize = default_min_size;
    protected IEvaluationContext ec;
    private volatile String studyKey;
    protected volatile boolean inited = false;
    protected MappingLineEntry[] paintable;
    protected boolean dirty = true;

    static {
        Config.impaxee.jvision.MAPPING.UseAnonymousMode.registerChangeListener(configChangeListener);
        defaultFont = Mapping.getDefaultFont();
    }

    public Color getMappingColor() {
        return OverlayConfig.mappingColor;
    }

    @Override
    protected OutlineFont getCurrentOutlineFont() {
        return super.getCurrentOutlineFont();
    }

    @Override
    protected FontMetrics getCurrentFontMetrics() {
        return super.getCurrentFontMetrics();
    }

    @Override
    protected Font getCurrentFont() {
        return super.getCurrentFont();
    }

    @Override
    protected boolean isUseOutlineFont() {
        return super.isUseOutlineFont();
    }

    private static Font getDefaultFont() {
        String string = Config.impaxee.jvision.MAPPING.DisplayFontFace.get();
        FontStyle fontStyle = FontUtils.awtFontStyle2MappingFontStyle((int)Config.impaxee.jvision.MAPPING.DisplayFontStyle.get());
        int n = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.MAPPING.DisplayFontSize.get()));
        com.tiani.config.mappingfonts.model.Font font = new com.tiani.config.mappingfonts.model.Font();
        font.setName(string);
        font.setStyle(fontStyle);
        font.setSize(n);
        return QuadMapping.getFont(font);
    }

    Mapping(IEvaluationContext iEvaluationContext) {
        this.ec = iEvaluationContext;
        if (iEvaluationContext != null) {
            this.studyKey = iEvaluationContext.getData().resolveString(0x20000D);
        }
    }

    static boolean isAnonymousMode() {
        return isAnonymousMode;
    }

    private static void setAnonymousMode(boolean bl) {
        isAnonymousMode = bl;
    }

    protected MappingLineEntry[] newContent(AbstractMappingEntry[] abstractMappingEntryArray) {
        if (abstractMappingEntryArray == null || abstractMappingEntryArray.length == 0) {
            return new MappingLineEntry[0];
        }
        ArrayList<MappingLineEntry> arrayList = new ArrayList<MappingLineEntry>(abstractMappingEntryArray.length);
        MappingLineEntry mappingLineEntry = null;
        boolean bl = true;
        int n = 0;
        while (n < abstractMappingEntryArray.length) {
            MappingLineEntry mappingLineEntry2 = abstractMappingEntryArray[n].refreshContent(this.ec, new MappingLineEntry(abstractMappingEntryArray[n], this), true);
            if (!abstractMappingEntryArray[n].append) {
                bl = true;
            }
            if (bl) {
                mappingLineEntry = mappingLineEntry2;
                arrayList.add(mappingLineEntry2);
                bl = false;
            } else {
                mappingLineEntry.append(mappingLineEntry2);
            }
            ++n;
        }
        return arrayList.toArray(new MappingLineEntry[arrayList.size()]);
    }

    public void resetMinimumSize() {
        this.minSize = default_min_size;
    }

    private static AbstractMappingEntry createDicomTagEntry(int n, Wordgroup wordgroup, WordgroupType wordgroupType, int n2, boolean bl, Font font, Color color, ISubstituteEvaluation iSubstituteEvaluation) {
        if (ElementDictionary.vrOf((int)n, null) == VR.PN) {
            return new NameDicomTagEntry(n, wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
        }
        if (PrivateTagDictionary.isPrivateTag((int)n)) {
            if (n == PrivateTagDictionary.studyLoadOrderTag) {
                return new PriorTagEntry(wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getMaxlength(), wordgroup.getLevelOfDetail());
            }
            if (n == -65527) {
                return new StringTagEntry("VISUAL.DISPLAY_SET_TYPE", wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
            }
            return new OwnPrivateTagEntry(n, wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getMaxlength(), wordgroup.getLevelOfDetail());
        }
        return new DicomTagEntry(n, wordgroup.getPrefix(), n2, wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
    }

    public static AbstractMappingEntry createTagEntry(Object object, Wordgroup wordgroup, int n, boolean bl, Font font, Color color) {
        WordgroupType wordgroupType = WordgroupType.STRING;
        if (wordgroup.getRenderedAs() != null) {
            wordgroupType = wordgroup.getRenderedAs().getType();
        }
        ISubstituteEvaluation iSubstituteEvaluation = SubstituteEvaluationFactory.getInstance().getSubstituteEvaluation(wordgroup.getSubstituteEvaluation());
        if (object instanceof Integer) {
            if ((Integer)object == -1) {
                return null;
            }
            return Mapping.createDicomTagEntry((Integer)object, wordgroup, wordgroupType, n, bl, font, color, iSubstituteEvaluation);
        }
        if (object instanceof int[]) {
            return new SeqDicomTagEntry((int[])object, wordgroup.getPrefix(), n, wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.contains(".")) {
                return new StringTagEntry(string, wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
            }
            if (string.contains("\\")) {
                String[] stringArray = string.split("\\\\");
                int[] nArray = new int[stringArray.length];
                if (stringArray.length % 2 != 1) {
                    log.error("Incorrect path length:" + string);
                    return null;
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    nArray[n2] = Mapping.getTagNumber(stringArray[n2]);
                    if (nArray[n2] < 0) {
                        log.error("Could not find tag:" + string);
                        return null;
                    }
                    ++n2;
                }
                return new SeqDicomTagEntry(nArray, wordgroup.getPrefix(), n, wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
            }
            Integer n3 = Mapping.getTagNumber(string);
            if (n3 == null) {
                log.error("Could not find tag:" + string);
                return null;
            }
            return Mapping.createDicomTagEntry(n3, wordgroup, wordgroupType, n, bl, font, color, iSubstituteEvaluation);
        }
        log.warn("Not determined type" + object);
        return null;
    }

    private static Integer getTagNumber(String string) {
        Object object = null;
        if (string.contains(",")) {
            try {
                string = string.replace(",", "");
                return (int)Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Could not parse dicom tag:" + string);
                return null;
            }
        }
        if (Character.isDigit(string.charAt(0))) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Could not parse dicom tag:" + string);
                return null;
            }
        }
        object = TagDictionary.getInstance().isPrivatTag(string) ? TagDictionary.getInstance().getPrivateTagForName(string) : TagDictionary.getInstance().getTagForName(string);
        if (object == null) {
            return null;
        }
        return object.getNumber();
    }

    public void setMinimumSize(int n) {
        this.minSize = n;
    }

    @Override
    protected int getMinSize() {
        return this.minSize;
    }

    String getStudyKey() {
        return this.studyKey;
    }

    protected void refreshContent(MappingLineEntry[] mappingLineEntryArray, boolean bl) {
        if (mappingLineEntryArray != null) {
            int n = 0;
            while (n < mappingLineEntryArray.length) {
                mappingLineEntryArray[n].refreshContent(bl);
                ++n;
            }
        }
    }

    public abstract void updateContent(boolean var1, boolean var2);

    public void updateContent(IEvaluationContext iEvaluationContext, boolean bl, boolean bl2) {
        if (!this.inited) {
            return;
        }
        this.ec = iEvaluationContext;
        if (this.studyKey == null) {
            this.studyKey = this.ec.getData().resolveString(0x20000D);
        }
        this.updateContent(bl, bl2);
    }

    protected abstract int getClipWidth();

    void setDirty() {
        this.dirty = true;
    }

    private void refreshSizes(Graphics2D graphics2D) {
        if (this.paintable == null) {
            this.updateContent(true, false);
            if (this.paintable == null) {
                log.warn("Mapping: Seem to have no valid mapping layout for " + this.getClass());
                return;
            }
        }
        int n = 0;
        while (n < this.paintable.length) {
            this.paintable[n].refreshPaintedDimension(graphics2D);
            int n2 = this.getClipWidth();
            if (n2 > -1) {
                this.paintable[n].clipToWidth(n2);
            }
            ++n;
        }
        this.refreshCoordinates(graphics2D);
    }

    protected abstract void refreshCoordinates(Graphics2D var1);

    @Override
    public void setSize(int n, int n2, IImageState iImageState) {
        boolean bl;
        boolean bl2 = bl = n != this.width || n2 != this.height;
        if (bl) {
            this.dirty = true;
        }
        super.setSize(n, n2, iImageState);
    }

    int getPrintScaledConstant(int n) {
        if (this.printScalingFactor == -1.0f) {
            return n;
        }
        return (int)((double)((float)n * this.printScalingFactor) + 0.5);
    }

    float getPrintScalingFactor() {
        return this.printScalingFactor;
    }

    private boolean canPaint(Graphics2D graphics2D) {
        if (this.dirty && graphics2D != null) {
            this.dirty = false;
            this.refreshSizes(graphics2D);
        }
        return this.width > this.getMinSize() && this.height > this.getMinSize();
    }

    public static Color getMappingColor(IEvaluationContext iEvaluationContext) {
        if (iEvaluationContext instanceof DisplaySetEvaluable) {
            return Mapping.getMappingColor(((DisplaySetEvaluable)iEvaluationContext).getDisplayset().getStudyUID());
        }
        if (iEvaluationContext instanceof DataEvaluationContext) {
            return Mapping.getMappingColor(((DataEvaluationContext)iEvaluationContext).getData().resolveString(0x20000D));
        }
        return null;
    }

    public static Color getMappingColor(String string) {
        if (!PriorStudyColoring.useDifferentColorsForPriors || !usePriorColoring) {
            return null;
        }
        if (string == null) {
            return null;
        }
        StudyType studyType = StudyType.UNKNOWN;
        if (dsm.getActiveHanging() != null && dsm.getActiveHanging().getStudyContainer() != null) {
            studyType = dsm.getActiveHanging().getStudyContainer().getStudyType(string);
        }
        switch (studyType) {
            case BASE_STUDY: 
            case UNKNOWN: {
                return null;
            }
            case FIRST_PRIOR: {
                return PriorStudyColoring.mappingColorPrior1;
            }
            case MERGED: {
                return PriorStudyColoring.mappingColorMergedStudies;
            }
        }
        return PriorStudyColoring.mappingColorPriorX;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        if (this.canPaint(bufferedImageHolder.graphics)) {
            int n = 0;
            while (this.paintable != null && n < this.paintable.length) {
                if (this.paintable[n] != null && this.paintable[n].isValid()) {
                    if (this.isUseOutlineFont()) {
                        this.paintable[n].paint(bufferedImageHolder);
                    } else {
                        this.paintable[n].paint(bufferedImageHolder.graphics);
                    }
                }
                ++n;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.canPaint(graphics2D)) {
            int n = 0;
            while (this.paintable != null && n < this.paintable.length) {
                if (this.paintable[n].isValid()) {
                    this.paintable[n].paint(graphics2D);
                }
                ++n;
            }
        }
    }

    public List<String> getMappingRowsAsStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MappingLineEntry[] mappingLineEntryArray = this.paintable;
        int n = this.paintable.length;
        int n2 = 0;
        while (n2 < n) {
            MappingLineEntry mappingLineEntry = mappingLineEntryArray[n2];
            String string = mappingLineEntry.toString();
            if (!string.isEmpty()) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        if (this.paintable != null) {
            MappingLineEntry[] mappingLineEntryArray = this.paintable;
            int n = this.paintable.length;
            int n2 = 0;
            while (n2 < n) {
                MappingLineEntry mappingLineEntry = mappingLineEntryArray[n2];
                if (mappingLineEntry != null && mappingLineEntry.isValid() && rectangle.intersects(mappingLineEntry.getBoundingBox())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static interface ITagEntry {
        public Integer getTag();
    }
}

