/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.jvision.overlay.demographics.AbstractMappingEntry;
import com.tiani.jvision.overlay.demographics.Mapping;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Objects;

public class MappingLineEntry {
    private static ThreadLocal<Graphics> fontCalculationGraphics = new ThreadLocal<Graphics>(){

        @Override
        protected Graphics initialValue() {
            return new BufferedImage(100, 100, 1).getGraphics();
        }
    };
    private String content;
    private final AbstractMappingEntry tag;
    private int px;
    private int py;
    private MappingLineEntry tail;
    private int paintedWidth;
    private int paintedHeight;
    private int pwPost = 0;
    private Mapping mapping;

    MappingLineEntry(AbstractMappingEntry abstractMappingEntry, Mapping mapping) {
        this.tag = abstractMappingEntry;
        this.mapping = mapping;
    }

    public boolean isValid() {
        return this.tag.isValid() && !this.isContentEmpty() || this.tail != null && this.tail.isValid();
    }

    void checkValidEntry(AbstractMappingEntry abstractMappingEntry) {
        if (this.tag != null && this.tag != abstractMappingEntry) {
            throw new IllegalArgumentException("Mapping entry might have been created from another TagEntry: " + this);
        }
    }

    void append(MappingLineEntry mappingLineEntry) {
        if (this.tail == null) {
            if (!mappingLineEntry.isContentEmpty() && Character.isLetterOrDigit(mappingLineEntry.content.charAt(0))) {
                this.pwPost = 5;
            }
            this.tail = mappingLineEntry;
        } else {
            this.tail.append(mappingLineEntry);
        }
    }

    void refreshContent(boolean bl) {
        this.refreshLocalContent(bl);
        if (this.tail != null) {
            this.tail.refreshContent(bl);
        }
    }

    private void refreshLocalContent(boolean bl) {
        String string = this.content;
        this.tag.refreshContent(this.mapping.ec, this, bl);
        if (!CompareUtils.equals((Object)this.content, (Object)string)) {
            this.mapping.setDirty();
        }
    }

    void clipToWidth(int n) {
        int n2 = this.getPaintedWidth() - n;
        if (n2 > 0) {
            this.refreshContent(true);
            n2 = this.getPaintedWidth() - n;
        }
        if (n2 > 0) {
            n2 += this.mapping.getPrintScaledConstant(15);
        }
        this.cutFromTail(n2);
    }

    private int cutFromTail(int n) {
        if (n <= 0) {
            return n;
        }
        if (this.tail != null && (n = this.tail.cutFromTail(n)) > 0) {
            this.paintedWidth -= this.pwPost;
            n -= this.pwPost;
            this.pwPost = 0;
        }
        if (n > 0) {
            if (n > this.paintedWidth) {
                this.content = "";
                n -= this.paintedWidth;
                this.paintedWidth = 0;
            } else if (this.content != null) {
                int n2 = this.content.length() * n / this.paintedWidth;
                if (this.content.length() - n2 < this.content.length()) {
                    this.content = this.content.substring(0, this.content.length() - n2);
                }
                this.paintedWidth -= n;
                n = 0;
            }
            if (n <= 0) {
                this.content = String.valueOf(this.content) + "...";
                this.paintedWidth += this.mapping.getPrintScaledConstant(15);
            }
        }
        return n;
    }

    void refreshPaintedDimension(Graphics2D graphics2D) {
        if (this.tag.isRefreshOnEmptyContentEnabled() && this.isContentEmpty()) {
            this.refreshLocalContent(true);
        }
        boolean bl = false;
        Font font = this.mapping.getCurrentFont();
        Font font2 = this.havingOtherFontThan(font);
        if (font2 != null) {
            bl = this.mapping.setFont(font2, graphics2D);
        }
        this.paintedWidth = this.content != null ? (this.mapping.isUseOutlineFont() ? this.mapping.getCurrentOutlineFont().stringWidth(this.content) + this.pwPost : this.mapping.getCurrentFontMetrics().stringWidth(this.content) + this.pwPost) : 0;
        this.paintedHeight = this.mapping.getFontHeight();
        if (bl) {
            this.mapping.resetFont(font, graphics2D);
        }
        if (this.tail != null) {
            this.tail.refreshPaintedDimension(graphics2D);
        }
    }

    public int getPaintedWidth() {
        if (this.tail == null) {
            return this.paintedWidth;
        }
        return this.paintedWidth + this.tail.getPaintedWidth();
    }

    public int getPaintedHeight() {
        if (this.tail == null) {
            return this.paintedHeight;
        }
        return Math.max(this.paintedHeight, this.tail.getPaintedHeight());
    }

    private Font havingOtherFontThan(Font font) {
        Font font2 = this.tag.getFont(this.mapping.getPrintScalingFactor());
        return font2 != null && font2 != font ? font2 : null;
    }

    private void beforePaint(Graphics2D graphics2D) {
        Font font = this.havingOtherFontThan(this.mapping.getCurrentFont());
        if (font != null) {
            this.mapping.setFont(font, graphics2D);
        }
    }

    private void afterPaint(BufferedImageHolder bufferedImageHolder, Graphics2D graphics2D) {
        if (this.tail != null) {
            this.tail.px = this.px + this.paintedWidth;
            this.tail.py = this.py;
            if (bufferedImageHolder != null) {
                this.tail.paint(bufferedImageHolder);
            } else {
                this.tail.paint(graphics2D);
            }
        }
    }

    void paint(BufferedImageHolder bufferedImageHolder) {
        if (!this.isValid()) {
            return;
        }
        Graphics2D graphics2D = bufferedImageHolder.graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        this.beforePaint(graphics2D);
        FontMetrics fontMetrics = this.mapping.getCurrentOutlineFont().getFontMetrics();
        Color color2 = this.tag.getColor(this.mapping.ec);
        if (color2 == null) {
            color2 = Mapping.getMappingColor(this.mapping.getStudyKey());
        }
        if (color2 != null) {
            this.mapping.drawString(this.content, color2, bufferedImageHolder, this.px, this.py - fontMetrics.getDescent());
        } else {
            this.mapping.drawString(this.content, bufferedImageHolder, this.px, this.py - fontMetrics.getDescent());
        }
        this.afterPaint(bufferedImageHolder, bufferedImageHolder.graphics);
        if (this.havingOtherFontThan(font) != null) {
            this.mapping.resetFont(font, graphics2D);
        }
        if (color2 != color) {
            graphics2D.setColor(color);
        }
    }

    void paint(Graphics2D graphics2D) {
        if (!this.isValid()) {
            return;
        }
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        this.beforePaint(graphics2D);
        Color color2 = this.tag.getColor(this.mapping.ec);
        graphics2D.setColor(color2 != null ? color2 : this.mapping.getMappingColor());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.drawString(this.content, this.px, this.py - fontMetrics.getDescent());
        this.afterPaint(null, graphics2D);
        if (this.havingOtherFontThan(font) != null) {
            this.mapping.resetFont(font, graphics2D);
        }
        if (color2 != color) {
            graphics2D.setColor(color);
        }
    }

    public String toString() {
        return String.valueOf(this.content == null ? "" : this.content) + (this.tail != null ? this.tail.toString() : "");
    }

    public void setX(int n) {
        this.px = n;
    }

    public void setY(int n) {
        this.py = n;
    }

    public Rectangle getBoundingBox() {
        FontMetrics fontMetrics = this.mapping.getCurrentOutlineFont().getFontMetrics();
        return new Rectangle(this.px, this.py - fontMetrics.getAscent(), this.getPaintedWidth(), this.getPaintedHeight());
    }

    public void setContent(String string) {
        this.content = string;
    }

    boolean hasContentNotSpecified() {
        return this.content == null;
    }

    private boolean isContentEmpty() {
        return this.content == null || this.content.isEmpty();
    }

    public int getExpectedHeight() {
        Graphics graphics = fontCalculationGraphics.get();
        Font font = this.tag.getFont(this.mapping.getPrintScalingFactor());
        if (!Objects.equals(font, graphics.getFont())) {
            graphics.setFont(font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.tail == null) {
            return fontMetrics.getHeight();
        }
        return Math.max(fontMetrics.getHeight(), this.tail.getExpectedHeight());
    }
}

