/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.config.mappingfonts.model.Line;
import com.tiani.config.mappingfonts.model.MappingConfiguration;
import com.tiani.config.mappingfonts.model.Paragraph;
import com.tiani.config.mappingfonts.model.Wordgroup;
import com.tiani.config.mappingfonts.model.enums.FontStyle;
import com.tiani.config.mappingfonts.model.enums.ParagraphLocation;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import com.tiani.gui.util.Fonts;
import com.tiani.jvision.overlay.demographics.AbstractMappingEntry;
import com.tiani.jvision.overlay.demographics.AbstractTagEntry;
import com.tiani.jvision.overlay.demographics.Demographics;
import com.tiani.jvision.overlay.demographics.DemographicsSorter;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingLineEntry;
import com.tiani.util.expressions.BooleanExpression;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QuadMapping
extends Mapping {
    private static final String AUTOSORT_KEY = "autosort";
    private static final String DEFINITION_KEY = "definition";
    private static final String CONDITION_TEXT_KEY = "conditionText";
    private static final String CONDITION_KEY = "condition";
    private static final String NAME_KEY = "name";
    protected static final List<Demographics> demographicsList = new ArrayList<Demographics>();
    private static final String CLAZZ = "Quad";
    private static Demographics defaultDemographics;
    protected AbstractMappingEntry[] tl;
    private AbstractMappingEntry[] bl;
    protected AbstractMappingEntry[] tr;
    private AbstractMappingEntry[] br;
    protected MappingLineEntry[] tlc;
    private MappingLineEntry[] blc;
    private MappingLineEntry[] trc;
    private MappingLineEntry[] brc;
    private boolean autosort;
    private volatile boolean swapLR = false;

    static {
        try {
            IConfigurationList iConfigurationList = Config.impaxee.jvision.MAPPING.demographics.getList();
            QuadMapping.cleanAndCompleteConfigList(iConfigurationList, true);
            defaultDemographics = QuadMapping.configureFromXml(iConfigurationList, CLAZZ);
        }
        catch (Exception exception) {
            Message.error(exception, (Object)"On loading mapping-font XML configurations (Quad)");
        }
    }

    protected QuadMapping(IEvaluationContext iEvaluationContext) {
        super(iEvaluationContext);
    }

    QuadMapping(IEvaluationContext iEvaluationContext, AbstractMappingEntry[] abstractMappingEntryArray, AbstractMappingEntry[] abstractMappingEntryArray2, AbstractMappingEntry[] abstractMappingEntryArray3, AbstractMappingEntry[] abstractMappingEntryArray4, boolean bl) {
        super(iEvaluationContext);
        this.swapLR = bl;
        if (bl) {
            this.tl = abstractMappingEntryArray2;
            this.tr = abstractMappingEntryArray;
            this.bl = abstractMappingEntryArray4;
            this.br = abstractMappingEntryArray3;
        } else {
            this.tl = abstractMappingEntryArray;
            this.tr = abstractMappingEntryArray2;
            this.bl = abstractMappingEntryArray3;
            this.br = abstractMappingEntryArray4;
        }
        this.inited = abstractMappingEntryArray != null || abstractMappingEntryArray2 != null || abstractMappingEntryArray3 != null || abstractMappingEntryArray4 != null;
    }

    public synchronized void swapLR(boolean bl) {
        boolean bl2 = this.swapLR;
        this.swapLR = bl;
        if (this.inited && bl != bl2) {
            AbstractMappingEntry[] abstractMappingEntryArray = this.tl;
            this.tl = this.tr;
            this.tr = abstractMappingEntryArray;
            abstractMappingEntryArray = this.bl;
            this.bl = this.br;
            this.br = abstractMappingEntryArray;
            MappingLineEntry[] mappingLineEntryArray = this.tlc;
            this.tlc = this.trc;
            this.trc = mappingLineEntryArray;
            mappingLineEntryArray = this.blc;
            this.blc = this.brc;
            this.brc = mappingLineEntryArray;
        }
    }

    public static void registerMappings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (!this.inited) {
            Demographics object = null;
            for (Demographics object2 : demographicsList) {
                if (!object2.clazz.equals(this.getClazz())) continue;
                if (object2.booleanExpression == null) {
                    object = object2;
                    continue;
                }
                if (!object2.booleanExpression.evaluate(this.ec)) continue;
                object = object2;
                break;
            }
            if (object != null) {
                QuadMapping quadMapping = this;
                synchronized (quadMapping) {
                    if (this.swapLR) {
                        this.tl = object.tr;
                        this.tr = object.tl;
                        this.bl = object.br;
                        this.br = object.bl;
                    } else {
                        this.tl = object.tl;
                        this.tr = object.tr;
                        this.bl = object.bl;
                        this.br = object.br;
                    }
                }
                this.autosort = object.autosort;
                this.inited = true;
            } else {
                log.warn("No proper demographics found...");
                this.br = null;
                this.bl = null;
                this.tr = null;
                this.tl = null;
            }
        }
        this.inited = true;
        this.updateContent(true, false);
    }

    protected String getClazz() {
        return CLAZZ;
    }

    @Override
    public void updateContent(boolean bl, boolean bl2) {
        if (!this.inited) {
            this.init();
            return;
        }
        if (bl) {
            this.tlc = this.ensureFreshContent(this.tlc, this.tl, bl2);
            this.blc = this.ensureFreshContent(this.blc, this.bl, bl2);
            this.trc = this.ensureFreshContent(this.trc, this.tr, bl2);
            this.brc = this.ensureFreshContent(this.brc, this.br, bl2);
            this.allocatePaintableArray();
            this.dirty = true;
        } else {
            this.refreshContent(this.paintable, bl2);
        }
    }

    private void allocatePaintableArray() {
        if (this.autosort) {
            this.sortInvLength(this.tlc);
            this.sortLength(this.blc);
            this.sortInvLength(this.trc);
            this.sortLength(this.brc);
        }
        this.paintable = new MappingLineEntry[this.tlc.length + this.trc.length + this.blc.length + this.brc.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.tlc.length) {
            this.paintable[n] = this.tlc[n2];
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < this.blc.length) {
            this.paintable[n] = this.blc[n2];
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < this.trc.length) {
            this.paintable[n] = this.trc[n2];
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < this.brc.length) {
            this.paintable[n] = this.brc[n2];
            ++n2;
            ++n;
        }
    }

    private MappingLineEntry[] ensureFreshContent(MappingLineEntry[] mappingLineEntryArray, AbstractMappingEntry[] abstractMappingEntryArray, boolean bl) {
        if (mappingLineEntryArray == null) {
            mappingLineEntryArray = this.newContent(abstractMappingEntryArray);
        } else {
            this.refreshContent(mappingLineEntryArray, bl);
        }
        return mappingLineEntryArray;
    }

    @Override
    protected int getClipWidth() {
        if (this.printScalingFactor == -1.0f) {
            return Math.max(0, this.width / 2 - 10);
        }
        return Math.max(0, this.width / 2 - (int)((double)(10.0f * this.printScalingFactor) + 0.5));
    }

    @Override
    protected void refreshCoordinates(Graphics2D graphics2D) {
        int n;
        this.allocatePaintableArray();
        int n2 = 0;
        int n3 = 5;
        int n4 = 5;
        int n5 = 2;
        int n6 = n = 0;
        int n7 = 0;
        while (n7 < this.tlc.length && n6 >= 0 && n6 < this.height) {
            if (this.paintable[n2].isValid()) {
                this.paintable[n2].setX(n5);
                this.paintable[n2].setY(n6 += this.paintable[n2].getPaintedHeight());
            }
            ++n7;
            ++n2;
        }
        n6 = this.height - this.calculateMappingHeight(this.blc) - n3;
        n7 = 0;
        while (n7 < this.blc.length && n6 >= 0 && n6 < this.height) {
            if (this.paintable[n2].isValid()) {
                this.paintable[n2].setX(n5);
                this.paintable[n2].setY(n6 += this.paintable[n2].getPaintedHeight());
            }
            ++n7;
            ++n2;
        }
        n6 = n;
        n7 = 0;
        while (n7 < this.trc.length && n6 >= 0 && n6 < this.height) {
            if (this.paintable[n2].isValid()) {
                this.paintable[n2].setX(Math.max(0, this.width - this.trc[n7].getPaintedWidth() - n4));
                this.paintable[n2].setY(n6 += this.paintable[n2].getPaintedHeight());
            }
            ++n7;
            ++n2;
        }
        n6 = this.height - this.calculateMappingHeight(this.brc) - n3;
        n7 = 0;
        while (n7 < this.brc.length && n6 >= 0 && n6 < this.height) {
            if (this.paintable[n2] != null && this.paintable[n2].isValid()) {
                this.paintable[n2].setX(Math.max(0, this.width - this.brc[n7].getPaintedWidth() - n4));
                this.paintable[n2].setY(n6 += this.paintable[n2].getPaintedHeight());
            }
            ++n7;
            ++n2;
        }
    }

    private int calculateMappingHeight(MappingLineEntry[] mappingLineEntryArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < mappingLineEntryArray.length) {
            n += mappingLineEntryArray[n2].isValid() ? mappingLineEntryArray[n2].getPaintedHeight() : 0;
            ++n2;
        }
        return n;
    }

    private void sortLength(MappingLineEntry[] mappingLineEntryArray) {
        this.sortLength(mappingLineEntryArray, false);
    }

    private void sortInvLength(MappingLineEntry[] mappingLineEntryArray) {
        this.sortLength(mappingLineEntryArray, true);
    }

    private void sortLength(MappingLineEntry[] mappingLineEntryArray, boolean bl) {
        this.shuttlesort((MappingLineEntry[])mappingLineEntryArray.clone(), mappingLineEntryArray, 0, mappingLineEntryArray.length, bl);
    }

    private void shuttlesort(MappingLineEntry[] mappingLineEntryArray, MappingLineEntry[] mappingLineEntryArray2, int n, int n2, boolean bl) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(mappingLineEntryArray2, mappingLineEntryArray, n, n3, bl);
        this.shuttlesort(mappingLineEntryArray2, mappingLineEntryArray, n3, n2, bl);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(mappingLineEntryArray[n3 - 1], mappingLineEntryArray[n3], bl)) {
            int n6 = n;
            while (n6 < n2) {
                mappingLineEntryArray2[n6] = mappingLineEntryArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            mappingLineEntryArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(mappingLineEntryArray[n4], mappingLineEntryArray[n5], bl) ? mappingLineEntryArray[n4++] : mappingLineEntryArray[n5++];
            ++n7;
        }
    }

    private boolean compare(MappingLineEntry mappingLineEntry, MappingLineEntry mappingLineEntry2, boolean bl) {
        int n = mappingLineEntry.getPaintedWidth();
        int n2 = mappingLineEntry2.getPaintedWidth();
        int n3 = n - n2;
        return bl ? n3 > -1 : n3 < 1;
    }

    protected static Demographics configureFromXml(IConfigurationList iConfigurationList, String string) throws Exception {
        boolean bl = false;
        Demographics demographics2 = null;
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            boolean bl2;
            String string2 = iConfigurationProvider.getText(DEFINITION_KEY);
            if (string2 == null || string2.trim().length() <= 0) continue;
            MappingConfiguration mappingConfiguration = (MappingConfiguration)((Object)new XmlLoader().load(string2, MappingConfiguration.class));
            QuadMapping.scaleFontInMappingConfiguration(mappingConfiguration);
            String string3 = iConfigurationProvider.exists(CONDITION_TEXT_KEY) ? iConfigurationProvider.getText(CONDITION_TEXT_KEY) : (iConfigurationProvider.exists(CONDITION_KEY) ? iConfigurationProvider.getString(CONDITION_KEY) : null);
            BooleanExpression booleanExpression = string3 != null && StringUtils.isNotBlank((CharSequence)string3) ? new BooleanExpression(string3) : null;
            boolean bl3 = bl2 = booleanExpression == null;
            if (bl2) {
                if (bl) {
                    log.error("There can be only one default demographics (there are more than one empty conditions): " + iConfigurationProvider);
                } else {
                    bl = true;
                }
            }
            boolean bl4 = iConfigurationProvider.exists(AUTOSORT_KEY) ? iConfigurationProvider.getBoolean(AUTOSORT_KEY) : false;
            Demographics demographics3 = new Demographics(string, booleanExpression, bl4, QuadMapping.getXmlTagEntries(mappingConfiguration, ParagraphLocation.TOPLEFT), QuadMapping.getXmlTagEntries(mappingConfiguration, ParagraphLocation.TOPRIGHT), QuadMapping.getXmlTagEntries(mappingConfiguration, ParagraphLocation.BOTTOMLEFT), QuadMapping.getXmlTagEntries(mappingConfiguration, ParagraphLocation.BOTTOMRIGHT));
            demographicsList.add(demographics3);
            if (!bl2) continue;
            demographics2 = demographics3;
        }
        Collections.sort(demographicsList, new DemographicsSorter());
        return demographics2;
    }

    private static void scaleFontInMappingConfiguration(MappingConfiguration mappingConfiguration) {
        QuadMapping.scaleFont(mappingConfiguration.getFont());
        Paragraph[] paragraphArray = mappingConfiguration.getParagraphs();
        int n = paragraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            Paragraph paragraph = paragraphArray[n2];
            if (paragraph != null) {
                QuadMapping.scaleFont(paragraph.getFont());
                Line[] lineArray = paragraph.getLines();
                int n3 = lineArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Line line = lineArray[n4];
                    if (line != null) {
                        QuadMapping.scaleFont(line.getFont());
                        Wordgroup[] wordgroupArray = line.getWordgroups();
                        int n5 = wordgroupArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Wordgroup wordgroup = wordgroupArray[n6];
                            if (wordgroup != null) {
                                QuadMapping.scaleFont(wordgroup.getFont());
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static AbstractMappingEntry[] getXmlTagEntries(MappingConfiguration mappingConfiguration, ParagraphLocation paragraphLocation) {
        Paragraph[] paragraphArray = mappingConfiguration.getParagraphs();
        int n = 0;
        while (paragraphArray != null && n < paragraphArray.length) {
            if (paragraphArray[n].getLocation() == paragraphLocation) {
                return QuadMapping.getXmlTagEntries(paragraphArray[n], mappingConfiguration.getFont());
            }
            ++n;
        }
        return new AbstractMappingEntry[0];
    }

    private static AbstractMappingEntry[] getXmlTagEntries(Paragraph paragraph, com.tiani.config.mappingfonts.model.Font font) {
        if (paragraph == null) {
            return new AbstractTagEntry[0];
        }
        ArrayList<AbstractMappingEntry> arrayList = new ArrayList<AbstractMappingEntry>();
        Line[] lineArray = paragraph.getLines();
        int n = 0;
        while (n < lineArray.length) {
            Wordgroup[] wordgroupArray = lineArray[n].getWordgroups();
            int n2 = 0;
            while (n2 < wordgroupArray.length) {
                Wordgroup wordgroup = wordgroupArray[n2];
                com.tiani.config.mappingfonts.model.Font font2 = null;
                font2 = QuadMapping.fontInheritage(wordgroup, lineArray[n], paragraph, font);
                String string = wordgroup.getSubstitute();
                int n3 = -1;
                if (string != null) {
                    String string2;
                    int n4 = string.indexOf(40);
                    if (n4 == -1) {
                        string2 = string;
                    } else {
                        int n5 = string.indexOf(41);
                        string2 = string.substring(0, n4);
                        n3 = Integer.parseInt(string.substring(n4 + 1, n5));
                        if (log.isDebugEnabled()) {
                            log.debug("iTagOffset = " + n3);
                        }
                    }
                    Color color = QuadMapping.getColor(font2 != null ? font2.getColor() : null);
                    AbstractMappingEntry abstractMappingEntry = Mapping.createTagEntry(string2, wordgroup, n3, n2 > 0, QuadMapping.getFont(font2), color);
                    if (abstractMappingEntry != null) {
                        arrayList.add(abstractMappingEntry);
                    } else {
                        log.warn("Could not create Tag Entry:" + string2);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new AbstractMappingEntry[arrayList.size()]);
    }

    private static com.tiani.config.mappingfonts.model.Font fontInheritage(Wordgroup wordgroup, Line line, Paragraph paragraph, com.tiani.config.mappingfonts.model.Font font) {
        String string;
        Integer n;
        FontStyle fontStyle;
        String string2;
        String string3 = wordgroup.getFont() != null && wordgroup.getFont().getName() != null ? wordgroup.getFont().getName() : (line.getFont() != null && line.getFont().getName() != null ? line.getFont().getName() : (paragraph.getFont() != null && paragraph.getFont().getName() != null ? paragraph.getFont().getName() : (string2 = font != null ? font.getName() : null)));
        FontStyle fontStyle2 = wordgroup.getFont() != null && wordgroup.getFont().getStyle() != null ? wordgroup.getFont().getStyle() : (line.getFont() != null && line.getFont().getStyle() != null ? line.getFont().getStyle() : (paragraph.getFont() != null && paragraph.getFont().getStyle() != null ? paragraph.getFont().getStyle() : (fontStyle = font != null ? font.getStyle() : null)));
        Integer n2 = wordgroup.getFont() != null && wordgroup.getFont().getSize() != null ? wordgroup.getFont().getSize() : (line.getFont() != null && line.getFont().getSize() != null ? line.getFont().getSize() : (paragraph.getFont() != null && paragraph.getFont().getSize() != null ? paragraph.getFont().getSize() : (n = font != null ? font.getSize() : null)));
        String string4 = wordgroup.getFont() != null && wordgroup.getFont().getColor() != null ? wordgroup.getFont().getColor() : (line.getFont() != null && line.getFont().getColor() != null ? line.getFont().getColor() : (paragraph.getFont() != null && paragraph.getFont().getColor() != null ? paragraph.getFont().getColor() : (string = font != null ? font.getColor() : null)));
        if (string2 == null && fontStyle == null && n == null && string == null) {
            return null;
        }
        com.tiani.config.mappingfonts.model.Font font2 = new com.tiani.config.mappingfonts.model.Font();
        font2.setName(string2);
        font2.setStyle(fontStyle);
        font2.setSize(n);
        font2.setColor(string);
        return font2;
    }

    static Demographics getDefaultDemographics() {
        return defaultDemographics;
    }

    static Font getFont(com.tiani.config.mappingfonts.model.Font font) {
        if (font == null) {
            return null;
        }
        String string = font.getName() == null ? Fonts.fLabel.getName() : font.getName();
        int n = font.getStyle() == null ? Fonts.fLabel.getStyle() : AwtFontFactory.awtStyleForModelStyle(font.getStyle());
        int n2 = font.getSize() == null ? Fonts.fLabel.getSize() : font.getSize().intValue();
        return AwtFontFactory.getFont(string, n, n2);
    }

    private static Color getColor(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("darkgray")) {
            return Color.darkGray;
        }
        if (string.equals("lightgray")) {
            return Color.lightGray;
        }
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        try {
            if (!string.startsWith("#")) {
                string = "#" + string;
            }
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("color error", (Throwable)numberFormatException);
            return null;
        }
    }

    protected static void cleanAndCompleteConfigList(IConfigurationList iConfigurationList, boolean bl) {
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            if (!iConfigurationProvider.exists(NAME_KEY)) {
                iConfigurationList.remove((String)entry.getKey());
                continue;
            }
            if (!iConfigurationProvider.exists(DEFINITION_KEY)) {
                String string = QuadMapping.createDefaultMappingDefinition();
                iConfigurationProvider.setText(DEFINITION_KEY, string == null ? "<mappingConfiguration></mappingConfiguration>" : string);
            }
            if (!iConfigurationProvider.exists(CONDITION_TEXT_KEY) && !iConfigurationProvider.exists(CONDITION_KEY)) {
                iConfigurationProvider.setText(CONDITION_TEXT_KEY, "");
            }
            if (!bl || iConfigurationProvider.exists(AUTOSORT_KEY)) continue;
            iConfigurationProvider.setBoolean(AUTOSORT_KEY, false);
        }
    }

    private static String createDefaultMappingDefinition() {
        MappingConfiguration mappingConfiguration = new MappingConfiguration();
        Paragraph paragraph = new Paragraph();
        Line line = new Line();
        Wordgroup wordgroup = new Wordgroup();
        wordgroup.setSubstitute(TagDictionary.getInstance().getDicomTag(Integer.valueOf(0x100010)).getName());
        line.addWordgroup(wordgroup);
        paragraph.addLine(line);
        paragraph.setLocation(ParagraphLocation.TOPLEFT);
        mappingConfiguration.addParagraph(paragraph);
        XmlSaver xmlSaver = new XmlSaver((XmlSaveable)mappingConfiguration);
        try {
            return xmlSaver.toXmlString();
        }
        catch (MarshalException | IOException throwable) {
            log.error("Creating default mapping definition failed", throwable);
            return null;
        }
    }

    private static void scaleFont(com.tiani.config.mappingfonts.model.Font font) {
        if (font != null && font.getSize() != null) {
            font.setSize(GUI.getScaledDiagnosticInt((int)font.getSize()));
        }
    }
}

