/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.config.mappingfonts.model.enums.WordgroupType;
import com.tiani.jvision.overlay.demographics.AbstractMappingEntry;
import com.tiani.jvision.overlay.demographics.ISubstituteEvaluation;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Font;
import org.dcm4che3.util.TagUtils;

class SeqDicomTagEntry
extends AbstractMappingEntry {
    private static final ALogger log = ALogger.getLogger(SeqDicomTagEntry.class);
    private int[] tagPath = null;

    SeqDicomTagEntry(int[] nArray, String string, int n, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
        super(string, n, string2, wordgroupType, bl, font, color, string3, string4, levelOfDetail, iSubstituteEvaluation);
        this.tagPath = nArray;
        int n2 = nArray[0];
        if (TagUtils.isPrivateGroup((int)n2) && !PrivateTagDictionary.isPrivateTag((int)n2)) {
            InputStreamDicomDataReader.addRequiredPrivateTag((int)n2);
        }
    }

    @Override
    public boolean isValid() {
        return this.tagPath != null;
    }

    @Override
    public Integer getTag() {
        if (this.tagPath == null) {
            return null;
        }
        return this.tagPath[0];
    }

    @Override
    public String getTagAsString() {
        if (this.tagPath == null) {
            return "Unspecified";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.tagPath.length) {
            stringBuilder.append(TagUtils.toString((int)this.tagPath[n])).append('\\');
            ++n;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Override
    protected String getValue(IEvaluationContext iEvaluationContext) {
        if (!this.isValid()) {
            return "";
        }
        if (!this.levelOfDetailVisible()) {
            return null;
        }
        String string = null;
        try {
            int n;
            int n2 = n = this.properties == null ? -1 : this.properties.getOffset();
            string = n > -1 ? this.formatString(this.getSubstitution().getString(iEvaluationContext, this.tagPath, this.tagPath[this.tagPath.length - 1], n, this.type, this.properties == null ? null : this.properties.getDecimalFormat())) : this.formatStrings(this.getSubstitution().getStrings(iEvaluationContext, this.tagPath, this.tagPath[this.tagPath.length - 1], this.type, this.properties == null ? null : this.properties.getDecimalFormat()));
        }
        catch (Exception exception) {
            log.error("Mapping: Could not resolve tag '" + this.getTagAsString() + "'", (Throwable)exception);
            string = null;
        }
        if (string != null) {
            return string;
        }
        return "";
    }
}

