/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.config.mappingfonts.model.enums.WordgroupType;
import com.tiani.jvision.overlay.demographics.AbstractMappingEntry;
import com.tiani.jvision.overlay.demographics.ISubstituteEvaluation;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingEvaluable;
import com.tiani.jvision.overlay.demographics.MappingLineEntry;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

class StringTagEntry
extends AbstractMappingEntry {
    private static final Set<String> REFRESH_ON_EMPTY_POSTFIXES = new HashSet<String>(Arrays.asList("ZOOM_FACTOR", "TRUE_SIZE_ZOOM_FACTOR"));
    private String tagPrefix = null;
    private String tagPostfix = null;

    StringTagEntry(String string, String string2, String string3, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string4, String string5, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
        super(string2, -1, string3, wordgroupType, bl, font, color, string4, string5, levelOfDetail, iSubstituteEvaluation);
        string = string.toUpperCase(Locale.ENGLISH);
        this.tagPrefix = string.substring(0, string.indexOf(46));
        this.tagPostfix = string.substring(string.indexOf(46) + 1, string.length());
    }

    @Override
    public MappingLineEntry refreshContent(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry, boolean bl) {
        mappingLineEntry.checkValidEntry(this);
        String string = this.getValue(iEvaluationContext);
        if (string != null) {
            mappingLineEntry.setContent(string);
        } else {
            mappingLineEntry.setContent("");
        }
        return mappingLineEntry;
    }

    @Override
    boolean isRefreshOnEmptyContentEnabled() {
        return REFRESH_ON_EMPTY_POSTFIXES.contains(this.tagPostfix);
    }

    @Override
    public boolean isValid() {
        return this.tagPostfix != null && this.tagPostfix.length() > 0;
    }

    @Override
    public Integer getTag() {
        return null;
    }

    @Override
    public String getTagAsString() {
        if (!this.isValid()) {
            return "Unspecified";
        }
        return String.valueOf(this.tagPrefix) + "." + this.tagPostfix;
    }

    @Override
    protected String getValue(IEvaluationContext iEvaluationContext) {
        if (!this.isValid()) {
            return "";
        }
        if (!this.levelOfDetailVisible()) {
            return null;
        }
        if (this.tagPrefix.equals("VISUAL")) {
            if (Mapping.isAnonymousMode() && this.tagPostfix.equals("MPI_ID")) {
                return null;
            }
            try {
                return this.formatString(this.getSubstitution().getString(iEvaluationContext.getVisual(), this.tagPostfix, this.type, this.properties == null ? null : this.properties.getDecimalFormat()));
            }
            catch (Exception exception) {
            }
        } else if (this.tagPrefix.equals("CALC")) {
            try {
                return this.formatString(this.getSubstitution().getString(new MappingEvaluable(iEvaluationContext.getData()), this.tagPostfix, this.type, this.properties == null ? null : this.properties.getDecimalFormat()));
            }
            catch (Exception exception) {}
        }
        return "";
    }
}

