/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.localizer;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.overlay.MiniLocalizerOverlay;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.overlay.localizer.MiniLocalizerSyncData;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalizerManager {
    private static final Map<VisDisplay2, List<Object>> miniLocalizerDisplayVectors = new HashMap<VisDisplay2, List<Object>>();
    private static boolean isFastRepaintInProgress = false;
    private static final MainFrame2 mf = JVision2.getMainFrame();
    private static final ALogger log = ALogger.getLogger(LocalizerManager.class);

    public static MiniLocalizerSyncData getMiniLocalizerSyncData(VisDisplay2 visDisplay2, MiniLocalizerSyncData miniLocalizerSyncData) {
        if (miniLocalizerDisplayVectors.containsKey(visDisplay2)) {
            List<Object> list = miniLocalizerDisplayVectors.get(visDisplay2);
            int n = 0;
            while (n < list.size()) {
                if (((MiniLocalizerSyncData)list.get((int)n)).localizer == miniLocalizerSyncData.localizer) {
                    return (MiniLocalizerSyncData)list.get(n);
                }
                ++n;
            }
            MiniLocalizerSyncData miniLocalizerSyncData2 = new MiniLocalizerSyncData(miniLocalizerSyncData.renderer, miniLocalizerSyncData.localizer, 0.05 + (double)(list.size() - 1) * 0.225, 0.05, 0.2, 0.2);
            list.add(miniLocalizerSyncData2);
            return miniLocalizerSyncData2;
        }
        MiniLocalizerSyncData miniLocalizerSyncData3 = new MiniLocalizerSyncData(miniLocalizerSyncData.renderer, miniLocalizerSyncData.localizer, 0.75, 0.05, 0.2, 0.2);
        ArrayList<MiniLocalizerSyncData> arrayList = new ArrayList<MiniLocalizerSyncData>();
        arrayList.add(miniLocalizerSyncData3);
        miniLocalizerDisplayVectors.put(visDisplay2, arrayList);
        return miniLocalizerSyncData3;
    }

    public static void removeMiniLocalizerFrom(VisDisplay2 visDisplay2, MiniLocalizerOverlay miniLocalizerOverlay) {
        if (miniLocalizerDisplayVectors.containsKey(visDisplay2)) {
            List<Object> list = miniLocalizerDisplayVectors.get(visDisplay2);
            list.remove(miniLocalizerOverlay.getSync());
            if (list.isEmpty()) {
                miniLocalizerDisplayVectors.remove(visDisplay2);
            }
        }
    }

    public static void clear() {
        miniLocalizerDisplayVectors.clear();
    }

    public static void clearDisplay(VisDisplay2 visDisplay2) {
        miniLocalizerDisplayVectors.remove(visDisplay2);
    }

    public static boolean isFastRepaintInProgress() {
        return isFastRepaintInProgress;
    }

    public static void setFastRepaintInProgress(boolean bl) {
        isFastRepaintInProgress = bl;
    }

    private static void sendEmptyLocalizer() {
        for (VisDisplay2 visDisplay2 : mf.getDisplays()) {
            LocalizerManager.sendEmptyLocalizer2Display(visDisplay2);
        }
    }

    private static void sendEmptyLocalizer2Display(VisDisplay2 visDisplay2) {
        for (Vis2 vis2 : visDisplay2.getVisViews()) {
            View view = vis2.getView();
            if (!(view instanceof ImgView2)) continue;
            ((ImgView2)view).localizerHandleUpdate(null, null);
        }
    }

    public static void refreshAllLocalizer() {
        LocalizerManager.sendEmptyLocalizer();
        if (VisData.getLastModified() != null) {
            LocalizerManager.notifyAllLocalizers(VisData.getLastModified().getParent());
        }
    }

    public static void notifyLocalizersOfView(ImgView2 imgView2) {
        if (VisData.getLastModified() == null) {
            return;
        }
        VisData visData = VisData.getLastModified();
        String string = imgView2.getImageInformation().getFrameOfReferenceUID();
        if (string == null) {
            return;
        }
        IImageInformation iImageInformation = visData.getImageInformation();
        if (iImageInformation != null && string.equals(iImageInformation.getFrameOfReferenceUID())) {
            imgView2.localizerHandleUpdate(visData.getParent(), DisplayLocalizerInfo.ParallelityCheckResult.NotChecked);
        }
    }

    public static void notifyAllLocalizers(VisDisplayData visDisplayData) {
        if (!visDisplayData.hasData() || !visDisplayData.getPlugin().isDefaultPlugin()) {
            LocalizerManager.sendEmptyLocalizer();
            return;
        }
        DisplayLocalizerInfo displayLocalizerInfo = visDisplayData.getLocalizerInfo();
        String string = visDisplayData.getDisplaySet().getFrameOfReferenceUID();
        if (string == null) {
            LocalizerManager.sendEmptyLocalizer();
            return;
        }
        for (VisDisplay2 visDisplay2 : mf.getDisplays()) {
            if (visDisplay2.getData() == visDisplayData) {
                LocalizerManager.sendEmptyLocalizer2Display(visDisplay2);
                continue;
            }
            if (!visDisplay2.hasData() || !visDisplay2.getData().getPlugin().isDefaultPlugin()) continue;
            try {
                DisplayLocalizerInfo.ParallelityCheckResult parallelityCheckResult;
                if (string.equals(visDisplay2.getData().getDisplaySet().getFrameOfReferenceUID()) && (parallelityCheckResult = displayLocalizerInfo.checkParallel(visDisplay2.getData())) != DisplayLocalizerInfo.ParallelityCheckResult.Parallel) {
                    for (Vis2 vis2 : visDisplay2.getVisViews()) {
                        ImgView2 imgView2 = (ImgView2)vis2.getView();
                        if (imgView2 == null) continue;
                        imgView2.localizerHandleUpdate(visDisplayData, parallelityCheckResult);
                    }
                    continue;
                }
            }
            catch (Exception exception) {
                log.warn("Error on localizer notifying", (Throwable)exception);
            }
            LocalizerManager.sendEmptyLocalizer2Display(visDisplay2);
        }
    }
}

