/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.placement;

import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.placement.IPositioningPoint;
import com.tiani.jvision.overlay.placement.PositioningPointComparator;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelPlacementManager {
    private View view;
    private List<IPositioningPoint> positioningPoints;
    private int textSpacing;
    private int width;
    private int height;
    private TextOverlay existingAnnotation;
    private PresentationObject newPO;
    private int minIntersects;
    private Rectangle selectedPosition;

    public LabelPlacementManager(View view, List<IPositioningPoint> list, int n, int n2, int n3, TextOverlay textOverlay, PresentationObject presentationObject) {
        this.view = view;
        this.positioningPoints = list;
        this.textSpacing = n;
        this.width = n2;
        this.height = n3;
        this.existingAnnotation = textOverlay;
        this.newPO = presentationObject;
        this.minIntersects = Integer.MAX_VALUE;
        Collections.sort(this.positioningPoints, new PositioningPointComparator());
    }

    public double[] getBestFit() {
        return this.getBestFit(0);
    }

    /*
     * Could not resolve type clashes
     */
    private double[] getBestFit(int n) {
        Rectangle rectangle = this.view.getDisplay().getVisibleRect();
        this.selectedPosition = new Rectangle(this.positioningPoints.get(0).getX(), this.positioningPoints.get(0).getY(), 0, 0);
        List<Overlay> list = this.view.getPresentationObjects();
        for (IPositioningPoint iPositioningPoint : this.positioningPoints) {
            IPositioningPoint.PositioningOrientation[] positioningOrientationArray = IPositioningPoint.PositioningOrientation.values();
            int n2 = positioningOrientationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                List<Object> list2;
                IPositioningPoint.PositioningOrientation positioningOrientation = positioningOrientationArray[n3];
                if (n == 0) {
                    list2 = Collections.singletonList(LabelPlacementManager.getBoxWithOrientation(positioningOrientation, iPositioningPoint, this.textSpacing, this.textSpacing, this.width, this.height));
                } else {
                    list2 = new ArrayList<Rectangle>();
                    int n4 = 0;
                    int n5 = n;
                    while (true) {
                        list2.add(LabelPlacementManager.getBoxWithOrientation(positioningOrientation, iPositioningPoint, this.textSpacing + n4 * 10, this.textSpacing + n5 * 10, this.width, this.height));
                        if (n5 == 0) break;
                        ++n4;
                        --n5;
                    }
                }
                for (Rectangle rectangle2 : list2) {
                    int n6 = 0;
                    if (!rectangle.contains(rectangle2.x, rectangle2.y) || !rectangle.contains(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height)) continue;
                    for (Overlay overlay : list) {
                        if (this.existingAnnotation == overlay || this.newPO == overlay || !overlay.intersects(rectangle2)) continue;
                        ++n6;
                    }
                    if (this.newPO != null) {
                        if (this.newPO instanceof SyncablePresentationObject) {
                            ((SyncablePresentationObject)this.newPO).createBoundingShape();
                        }
                        if (this.newPO.intersects(rectangle2)) {
                            ++n6;
                        }
                    }
                    if (n6 < this.minIntersects) {
                        this.selectedPosition = rectangle2;
                        this.minIntersects = n6;
                    }
                    if (this.minIntersects == 0) break;
                }
                if (this.minIntersects == 0) break;
                ++n3;
            }
            if (this.minIntersects == 0) break;
        }
        if (n < 10 && this.minIntersects > 0) {
            this.getBestFit(n + 1);
        }
        return new double[]{this.selectedPosition.x, this.selectedPosition.y};
    }

    private static Rectangle getBoxWithOrientation(IPositioningPoint.PositioningOrientation positioningOrientation, IPositioningPoint iPositioningPoint, int n, int n2, int n3, int n4) {
        switch (positioningOrientation) {
            case RIGHT_BOTTOM: {
                return new Rectangle(iPositioningPoint.getX() + n, iPositioningPoint.getY() + n2, n3, n4);
            }
            case RIGHT_TOP: {
                return new Rectangle(iPositioningPoint.getX() + n, iPositioningPoint.getY() - n2 - n4, n3, n4);
            }
            case LEFT_TOP: {
                return new Rectangle(iPositioningPoint.getX() - n - n3, iPositioningPoint.getY() - n2 - n4, n3, n4);
            }
            case LEFT_BOTTOM: {
                return new Rectangle(iPositioningPoint.getX() - n - n3, iPositioningPoint.getY() + n2, n3, n4);
            }
        }
        return null;
    }
}

