/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsManager;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.text.MessageFormat;

public class OverlayStatisticsAction
extends AbstractPAction {
    public static final String ID = "OVERLAY_STATISTICS";
    private static final int MAXIMUM_NUMBER_OF_OVERLAYS = 6;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getCaption() {
        return Messages.getString("OverlayStatisticsAction.Caption");
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("OverlayStatisticsAction.ToolTip");
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(71, 1);
    }

    @Override
    public String getGroupName() {
        return MARKUPS_GROUP;
    }

    @Override
    public boolean isEnabled(VisData visData) {
        return super.isEnabled(visData) && !visData.getStudyData().getParent().hasLossyPrefetchedImages() && visData.getParent().getPlugin().isDefaultPlugin();
    }

    @Override
    public boolean perform(Component component) {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null || visData.getView().getMouseHandler().roiCreationInProgress()) {
            return false;
        }
        this.notifyActionPerformed();
        if (visData.getStudyData().getParent().hasLossyPrefetchedImages()) {
            Message.warning(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Title"), Messages.getString("OverlayStatisticsAction.LossyImageWarning.Message"));
            return false;
        }
        if (!visData.getParent().getPlugin().isDefaultPlugin()) {
            Message.warning(Messages.getString("OverlayStatisticsAction.PluginWarning.Title"), Messages.getString("OverlayStatisticsAction.PluginWarning.Message"));
            return false;
        }
        long l = OverlayStatisticsManager.getUsableOverlayCount(visData.getView());
        if (l > 0L) {
            if (l <= 6L) {
                OverlayStatisticsManager.INSTANCE.createSeriesSelectionDialog();
                return true;
            }
            String string = MessageFormat.format(Messages.getString("OverlayStatisticsAction.Dialog.StatisticsCreationNotPossible"), l, 6);
            Message.info(Messages.getString("OverlayStatisticsAction.Dialog.StatisticsCreationNotPossible.Title"), string);
            return false;
        }
        return false;
    }
}

