/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.impl.BusyLayeredPane;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.image.IPresentationObjectCopyListener;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsChart;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsManager;
import com.tiani.util.message.Message;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class OverlayStatisticsChartPanel
implements IPresentationObjectCopyListener {
    private static final int UNSCALED_PADDING = 10;
    private static final int SCALED_PADDING = ComponentFactory.instance.scaleInt(10);
    private final View view;
    private final AtomicInteger remainingOverlaysToBeCopied;
    private final JPanel statisticsChartPanel;
    private final BusyLayeredPane chartPane;
    private final JButton createSCBtn;
    private final JButton copyToClipboardBtn;
    private OverlayStatisticsChart lineChart;
    private volatile boolean isCleanedUp;

    OverlayStatisticsChartPanel(View view, int n) {
        AbstractAction abstractAction = new SaveAction();
        if (!abstractAction.isEnabled()) {
            abstractAction = new CloseAction();
        }
        this.view = view;
        this.remainingOverlaysToBeCopied = new AtomicInteger(n);
        this.statisticsChartPanel = ComponentFactory.instance.createPanel(new BorderLayout());
        this.createSCBtn = ComponentFactory.instance.createButton(abstractAction);
        this.copyToClipboardBtn = ComponentFactory.instance.createButton(Messages.getString("OverlayStatisticsDialog.CopyData"));
        this.chartPane = new BusyLayeredPane((JComponent)this.statisticsChartPanel);
        this.chartPane.setState(BusyLayeredPane.State.BUSY);
        this.chartPane.setOpaque(false);
    }

    Component getUI() {
        return this.chartPane;
    }

    void updateButtonStates() {
        if (this.lineChart != null) {
            this.createSCBtn.setEnabled(!this.lineChart.isInconsistent());
            this.copyToClipboardBtn.setEnabled(!this.lineChart.isInconsistent());
        }
    }

    private JPanel createOptionsPanel() {
        JLabel jLabel = ComponentFactory.instance.createLabel(Messages.getString("OverlayStatisticsDialog.IntensityUnit"));
        final JRadioButton jRadioButton = ComponentFactory.instance.createRadioButton(Messages.getString("OverlayStatisticsDialog.Relative"));
        final JRadioButton jRadioButton2 = ComponentFactory.instance.createRadioButton(Messages.getString("OverlayStatisticsDialog.Absolute"));
        final JCheckBox jCheckBox = ComponentFactory.instance.createCheckBox(Messages.getString("OverlayStatisticsDialog.IncludeSelectedSeries"));
        String string = Messages.getString("OverlayStatisticsDialog.SetReferenceValue");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(string.replaceAll("\\n", "<br>"));
        stringBuilder.append("</html>");
        JLabel jLabel2 = ComponentFactory.instance.createLabel(stringBuilder.toString());
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsChartPanel.this.lineChart.setRelative(jRadioButton.isSelected());
                OverlayStatisticsChartPanel.this.updateButtonStates();
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsChartPanel.this.lineChart.setRelative(!jRadioButton2.isSelected());
                OverlayStatisticsChartPanel.this.updateButtonStates();
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsChartPanel.this.lineChart.includeOwner(jCheckBox.isSelected());
                OverlayStatisticsChartPanel.this.updateButtonStates();
            }
        });
        this.copyToClipboardBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsChartPanel.this.lineChart.copyToClipboard();
            }
        });
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0}, new double[]{-2.0, -2.0});
        tableLayout.setHGap(15);
        TableLayout tableLayout2 = new TableLayout(new double[]{-2.0}, new double[]{-2.0, -2.0, -2.0});
        jRadioButton2.doClick();
        jRadioButton2.setSelected(true);
        jCheckBox.setSelected(true);
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel.add((Component)jLabel, "0,0 ");
        jPanel.add((Component)jRadioButton, "1,0");
        jPanel.add((Component)jRadioButton2, "1,1");
        JPanel jPanel2 = ComponentFactory.instance.createPanel((LayoutManager)tableLayout2);
        jPanel2.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("OverlayStatisticsDialog.ChartOptions")));
        jPanel2.add((Component)jLabel2, "0,0");
        jPanel2.add((Component)jPanel, "0,1");
        jPanel2.add((Component)jCheckBox, "0,2");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        return jPanel2;
    }

    @Override
    public void onPresentationObjectCopied(PresentationObject presentationObject) {
        if (this.remainingOverlaysToBeCopied.decrementAndGet() == 0) {
            this.initStatisticsChartPanel();
        }
    }

    private void initStatisticsChartPanel() {
        if (this.isCleanedUp || this.lineChart != null) {
            return;
        }
        this.lineChart = new OverlayStatisticsChart(this.view);
        JPanel jPanel = ComponentFactory.instance.createPanel(new BorderLayout());
        jPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("OverlayStatisticsDialog.Chart")));
        jPanel.add(this.lineChart.getUI(), "Center");
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new GridLayout(1, 2, SCALED_PADDING, 0));
        jPanel2.setBorder(ComponentFactory.instance.createEmptyBorder(10, 10, 0, 10));
        this.updateButtonStates();
        jPanel2.add(this.createSCBtn);
        jPanel2.add(this.copyToClipboardBtn);
        this.statisticsChartPanel.add((Component)this.createOptionsPanel(), "North");
        this.statisticsChartPanel.add((Component)jPanel, "Center");
        this.statisticsChartPanel.add((Component)jPanel2, "South");
        this.chartPane.setState(BusyLayeredPane.State.DATA);
        if (Product.isRunningAutoTests()) {
            this.createSecondaryCapture();
        }
    }

    private void createSecondaryCapture() {
        if (this.copyToClipboardBtn.isEnabled()) {
            this.copyToClipboardBtn.doClick();
        }
        if (this.createSCBtn.isEnabled()) {
            this.createSCBtn.doClick();
        } else {
            Message.info(this.lineChart.getInconsistencyMessage());
            EventQueue.invokeLater(OverlayStatisticsManager.INSTANCE::closeDialog);
        }
    }

    protected void cleanUp() {
        this.isCleanedUp = true;
        if (this.lineChart != null) {
            this.lineChart.cleanUp();
            this.lineChart = null;
        }
    }

    private static class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Messages.getString("Ok"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OverlayStatisticsManager.INSTANCE.closeDialog();
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Messages.getString("OverlayStatisticsDialog.SaveAsSecondaryCapture.Title"), (Icon)IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_secondarycapture.svg"));
            this.setEnabled(!Product.isCDViewer());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ISeriesData iSeriesData = OverlayStatisticsChartPanel.this.lineChart.createSecondaryCapture();
            if (iSeriesData != null) {
                DataManager.getInstance().addSeriesToDisplay(Collections.singletonList(iSeriesData), JVision2.getMainFrame().getFirstEmptyDisplay());
            }
            OverlayStatisticsManager.INSTANCE.closeDialog();
        }
    }
}

