/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.hap.pacs.data.valuemapping.ISUVData;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingFactory;
import com.agfa.hap.pacs.data.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.FetchableCollection;
import com.agfa.pacs.impaxee.data.fetcher.FetcherUtils;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadLatch;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadListener;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.impl.BooleanExpressionDisplaySetFilter;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.statistics.StatisticsChartDataPoint;
import com.agfa.pacs.impaxee.sync.SynchronizationManager;
import com.agfa.pacs.impaxee.valuemapping.DefaultValueMappingOption;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVMappingFactory;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.IPresentationObjectCopyListener;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsChartPanel;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsDialog;
import com.tiani.jvision.overlay.statistics.SeriesSelectionDialog;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.TemporaryVisDisplay2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.util.message.Message;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OverlayStatisticsManager implements ISelectionListener
{
    INSTANCE;

    private static final BooleanExpressionDisplaySetFilter DISPLAY_SET_FILTER;
    private static final String ROI = "ROI";
    private OverlayStatisticsDialog dialog;
    private View associatedView;
    private TemporaryVisDisplay2 vd;

    static {
        DISPLAY_SET_FILTER = new BooleanExpressionDisplaySetFilter(Config.impaxee.jvision.OVERLAY.Statistics.SupportedDisplaySetCriterion.get());
    }

    private OverlayStatisticsManager() {
        DataSelectionManager.getInstance().addSelectionListener(this);
    }

    void createSeriesSelectionDialog() {
        SeriesSelectionDialog seriesSelectionDialog = new SeriesSelectionDialog(DISPLAY_SET_FILTER);
        if (seriesSelectionDialog.isEmpty()) {
            this.showErrorMessage();
            seriesSelectionDialog = null;
            return;
        }
        if (Product.isRunningAutoTests()) {
            seriesSelectionDialog.createStatistics();
        } else {
            seriesSelectionDialog.setVisible(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    void createStatistics(View view, List<IDisplaySet> list) {
        void var6_20;
        StatisticsChartDataPoint<VisData> statisticsChartDataPoint2;
        Iterator<VisData> iterator;
        Object object3;
        this.checkROINames(view);
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>(list.size());
        ArrayList<VisData> arrayList2 = new ArrayList<VisData>(list.size());
        if (!list.isEmpty()) {
            object3 = new HashMap();
            for (VisScreen2 object22 : JVision2.getMainFrame().getScreens()) {
                for (VisDisplay2 visDisplay2 : object22.getDisplays()) {
                    if (!list.contains(visDisplay2.getData().getDisplaySet())) continue;
                    object3.put(visDisplay2.getData().getDisplaySet(), visDisplay2);
                }
            }
            for (IDisplaySet iDisplaySet : list) {
                if (object3.containsKey(iDisplaySet)) continue;
                VisDisplay2 visDisplay2 = new VisDisplay2(null);
                visDisplay2.initVisDisplay(iDisplaySet, 0, false, ActivationMode.MANUAL);
                arrayList.add(visDisplay2);
            }
            ArrayList<VisDisplay2> arrayList3 = new ArrayList<VisDisplay2>(object3.values());
            arrayList3.addAll(arrayList);
            iterator = view.getVis();
            List<VisData> list2 = SynchronizationManager.getInstance().getCompatibleDisplaySets((VisData)((Object)iterator), (List<VisDisplay2>)arrayList3, SynchronizationManager.CompatibilityMode.SAME_FRAME_OF_REFERENCE);
            if (!list2.contains(iterator)) {
                list2.add(0, (VisData)((Object)iterator));
            }
            for (StatisticsChartDataPoint<VisData> statisticsChartDataPoint2 : StatisticsChartDataPoint.createSortedList(list2)) {
                arrayList2.add(statisticsChartDataPoint2.getData());
            }
        }
        object3 = this.createDisplaySet(arrayList2);
        for (VisDisplay2 visDisplay2 : arrayList) {
            visDisplay2.clearByUser();
            visDisplay2.cleanUp();
        }
        if (object3 != null) {
            this.vd = new TemporaryVisDisplay2((IDisplaySet)object3);
            this.vd.setHotRegionsEnabled(true);
            this.vd.setMouseWheelZoomEnabled(true);
            for (VisData visData : this.vd.getVis()) {
                visData.setSelected(false);
            }
            IImageDownloadLatch iImageDownloadLatch = FetcherUtils.prioritizeDownload((IDisplaySet)object3, new IImageDownloadListener[0]);
            if (Product.isRunningAutoTests()) {
                iImageDownloadLatch.await(Long.MAX_VALUE);
            }
        }
        if (SUVUtil.isSUVActive(view)) {
            iterator = SUVUtil.getSUVDataForFrame(view.getDisplay(), view.getFrameData());
            SUVMappingFactory sUVMappingFactory = new SUVMappingFactory((ISUVData)iterator);
        } else if (view.getImageState().getCurrentValueMapping() instanceof RealWorldValueMapping) {
            IValueMappingFactory iValueMappingFactory = (IValueMappingFactory)view.getImageState().getCurrentValueMapping();
        } else {
            DefaultValueMappingOption defaultValueMappingOption = new DefaultValueMappingOption(null);
        }
        iterator = new TEvent(120);
        TEventDispatch.sendEventToVis(this.vd, iterator, var6_20, 16);
        List<StatisticsPresentationObject> list3 = OverlayStatisticsManager.getUsableOverlays(view);
        statisticsChartDataPoint2 = new OverlayStatisticsChartPanel(view, this.vd.getVis().size() * list3.size());
        this.copyOverlays(list3, (IPresentationObjectCopyListener)((Object)statisticsChartDataPoint2));
        this.vd.setNavigationPosition(0, new VisDisplay2.NavigationPositionOption[0]);
        this.showDialog(view, (OverlayStatisticsChartPanel)((Object)statisticsChartDataPoint2));
        for (VisData visData : this.vd.getVis()) {
            visData.getView().updateGeometry();
        }
    }

    static List<StatisticsPresentationObject> getUsableOverlays(View view) {
        return OverlayStatisticsManager.getUsableOverlayStream(view).collect(Collectors.toList());
    }

    static long getUsableOverlayCount(View view) {
        return OverlayStatisticsManager.getUsableOverlayStream(view).count();
    }

    private static Stream<StatisticsPresentationObject> getUsableOverlayStream(View view) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<StatisticsPresentationObject> stream = view.getOverlayStream(StatisticsPresentationObject.class);){
            return stream.filter(StatisticsPresentationObject::isUsableForStatisticsDiagram);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void copyOverlays(List<StatisticsPresentationObject> list, IPresentationObjectCopyListener iPresentationObjectCopyListener) {
        for (StatisticsPresentationObject statisticsPresentationObject : list) {
            statisticsPresentationObject.getOrCreateAnnotation();
            statisticsPresentationObject.getView().copyToDestinations(statisticsPresentationObject, OverlaySynchronizationMode.WORLD_COORDINATES, this.vd.getVis(), StatisticsPresentationObjectHandler.LISTENER, iPresentationObjectCopyListener);
        }
    }

    static void updateTextAnnotation(PresentationObject presentationObject) {
        presentationObject.setNonEditableTextEnabled(false);
        presentationObject.resetCachedValues();
        TextOverlay textOverlay = presentationObject.getAnnotation();
        if (textOverlay != null && !textOverlay.isVisible()) {
            textOverlay.setVisible(true);
        }
    }

    private IDisplaySet createDisplaySet(List<VisData> list) {
        if (list.isEmpty()) {
            return null;
        }
        FetchableCollection fetchableCollection = new FetchableCollection();
        for (VisData visData : list) {
            fetchableCollection.addImageFrame(visData.getParent().getDisplaySet(), visData.getFrameData());
        }
        return HangingFactory.getInstance().newTemporaryDisplaySet(fetchableCollection, DataSelectionManager.getInstance().getCurrentPatient().getDecompositionRuntime());
    }

    private void showErrorMessage() {
        Message.info(Messages.getString("OverlayStatisticsManager.Error.NoDestination.Title"), Messages.getString("OverlayStatisticsManager.Error.NoDestination.Msg"));
    }

    private void showDialog(View view, OverlayStatisticsChartPanel overlayStatisticsChartPanel) {
        this.closeDialog();
        this.associatedView = view;
        this.associatedView.getDisplay().setPOStatisticsVisibility(true);
        this.dialog = new OverlayStatisticsDialog(this.vd, overlayStatisticsChartPanel);
        this.dialog.addWindowListener(new CloseListener());
        this.dialog.setVisible(true);
    }

    private void checkROINames(View view) {
        ArrayList arrayList = new ArrayList();
        int n = 1;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<StatisticsPresentationObject> stream = OverlayStatisticsManager.getUsableOverlayStream(view);){
            stream.forEach(statisticsPresentationObject -> {
                String string = statisticsPresentationObject.getOrCreateAnnotation().getTextArea().getText();
                String string2 = this.getROIName(arrayList, string, n);
                arrayList.add(string2);
                if (!string.equals(string2)) {
                    statisticsPresentationObject.getAnnotation().getTextArea().setText(string2);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        view.invalidate();
        view.repaint();
    }

    private String getROIName(ArrayList<String> arrayList, String string, int n) {
        if (arrayList.contains(string)) {
            String string2 = ROI + n;
            return this.getROIName(arrayList, string2, ++n);
        }
        arrayList.add(string);
        return string;
    }

    public void closeDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.resetDialog();
        }
    }

    void resetDialog() {
        if (this.associatedView != null && this.associatedView.getDisplay() != null) {
            this.associatedView.getDisplay().setPOStatisticsVisibility(false);
        }
        if (this.dialog != null) {
            this.dialog.cleanUp();
        }
        this.dialog = null;
        this.associatedView = null;
        if (this.vd != null) {
            this.vd.clear(true, false);
            this.vd.cleanUp();
            this.vd = null;
        }
    }

    @Override
    public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
        if (this.dialog != null && this.associatedView != null) {
            this.dialog.setVisible(visDisplayData != null && (visDisplayData.getVisDisplay() == this.associatedView.getDisplay() || visDisplayData.getVisDisplay() == this.vd));
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            OverlayStatisticsManager.this.resetDialog();
        }
    }

    private static enum StatisticsPresentationObjectHandler implements IPresentationObjectCopyListener
    {
        LISTENER;


        @Override
        public void onPresentationObjectCopied(PresentationObject presentationObject) {
            ((StatisticsPresentationObject)presentationObject).setRemovable(false);
            OverlayStatisticsManager.updateTextAnnotation(presentationObject);
        }
    }
}

