/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector3d;

public class OverlayStatisticsUtils {
    private OverlayStatisticsUtils() {
    }

    public static List<IDisplaySet> searchForCompatibleSeries(IImageInformation iImageInformation, Iterable<IDisplaySet> iterable) {
        String string = iImageInformation.getFrameOfReferenceUID();
        String string2 = iImageInformation.getModality();
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        if (string == null || string2 == null || vector3d == null) {
            return Collections.emptyList();
        }
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        for (IDisplaySet iDisplaySet : iterable) {
            IImageInformation iImageInformation2 = iDisplaySet.getOneObject().getImageInformation();
            if (!string.equals(iDisplaySet.getFrameOfReferenceUID()) || !string2.equals(iImageInformation2.getModality()) || iImageInformation2.getPlaneNormalUV() == null || !DisplayLocalizerInfo.isParallel(vector3d, iImageInformation2.getPlaneNormalUV())) continue;
            arrayList.add(iDisplaySet);
        }
        return arrayList;
    }
}

