/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.DisplaySetCalculationData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IDisplaySetFilter;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.tiani.base.data.IImageInformation;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.gui.dialog.ImageAreaDialog;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsManager;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SeriesSelectionDialog
extends ImageAreaDialog {
    private View view = AbstractPDataAction.getCurrentImage().getView();
    private SeriesTableModel tableModel;
    private static final Icon displayedIcon = IAIconFactory.DEFAULT_FACTORY.loadIcon("displayed.svg");
    private static final Icon notDisplayedIcon = IAIconFactory.DEFAULT_FACTORY.loadIcon("notDisplayed.svg");
    private JButton createChartBtn;
    private JButton selectAllBtn;
    private JButton selectNoneBtn;

    SeriesSelectionDialog(IDisplaySetFilter iDisplaySetFilter) {
        super(Messages.getString("SeriesSelectionDialog.Title"), true);
        this.createDialog(iDisplaySetFilter);
        GUIMessageHandler.centerSizedWindow(this);
    }

    private void createDialog(IDisplaySetFilter iDisplaySetFilter) {
        JComponent jComponent;
        OverlayStatisticsManager.INSTANCE.closeDialog();
        this.tableModel = new SeriesTableModel(iDisplaySetFilter);
        if (this.tableModel.isEmpty()) {
            return;
        }
        JTable jTable = ComponentFactory.instance.createTable(this.tableModel);
        jTable.setCellSelectionEnabled(false);
        jTable.getTableHeader().addMouseMotionListener(new HeaderTooltips());
        TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(Boolean.class);
        if (tableCellRenderer instanceof JCheckBox) {
            jComponent = (JCheckBox)((Object)tableCellRenderer);
            ComponentFactory.instance.scaleCheckBox((JCheckBox)jComponent);
        }
        TableColumnResizer.resize(jTable);
        jComponent = new JScrollPane(jTable, 20, 30);
        this.createChartBtn = ComponentFactory.instance.createButton(Messages.getString("PresentationObject.CreateStatisticsGraph"));
        this.selectAllBtn = ComponentFactory.instance.createButton(Messages.getString("SelectAll"));
        this.selectNoneBtn = ComponentFactory.instance.createButton(Messages.getString("DeselectAll"));
        this.addListeners();
        JPanel jPanel = ComponentFactory.instance.createPanel(new GridBagLayout());
        jPanel.setBorder(SwingUtilities2.createEmptyBorder((int)20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.selectAllBtn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.selectNoneBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.createChartBtn, gridBagConstraints);
        this.add(jPanel);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setModal(true);
        if (this.getSize().height > 0 && this.getSize().width > 0) {
            this.setMinimumSize(this.getSize());
        }
        SwingUtilities2.centerOnWindow((Window)this.getOwner(), (Window)this);
        this.setSize(GUI.getScaledDiagnosticDimension((int)700, (int)400));
        this.setMinimumSize(GUI.getScaledDiagnosticDimension((int)500, (int)350));
    }

    boolean isEmpty() {
        return this.tableModel.isEmpty();
    }

    void createStatistics() {
        try {
            CursorUtil.setWaitCursor((Component)this);
            this.removeOverlays();
            OverlayStatisticsManager.INSTANCE.createStatistics(this.view, this.tableModel.getSelectedData());
        }
        finally {
            CursorUtil.resetWaitCursor((Component)this);
            this.dispose();
        }
    }

    private void addListeners() {
        this.createChartBtn.addActionListener(actionEvent -> this.createStatistics());
        this.selectAllBtn.addActionListener(actionEvent -> this.tableModel.selectAll(true));
        this.selectNoneBtn.addActionListener(actionEvent -> this.tableModel.selectAll(false));
    }

    private void removeOverlays() {
        List<Overlay> list = this.view.getOverlays();
        for (Overlay overlay : list) {
            SyncablePresentationObject syncablePresentationObject;
            if (!(overlay instanceof SyncablePresentationObject) || !(syncablePresentationObject = (SyncablePresentationObject)overlay).isSynchronizationEnabled()) continue;
            syncablePresentationObject.removeFromSynclist();
        }
    }

    private static class HeaderTooltips
    extends MouseMotionAdapter {
        private TableColumn curCol = null;

        private HeaderTooltips() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TableColumn tableColumn = null;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getTable().getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n >= 0) {
                tableColumn = tableColumnModel.getColumn(n);
            }
            if (tableColumn != null && tableColumn != this.curCol) {
                jTableHeader.setToolTipText((String)tableColumn.getHeaderValue());
                this.curCol = tableColumn;
            }
        }
    }

    private class SeriesTableModel
    extends AbstractTableModel {
        private Object[][] rowData;
        private String[] columnNames = new String[]{"", Messages.getString("SeriesSelectionDialog.AcquisitionTime"), Messages.getString("SeriesSelectionDialog.SeriesNo"), Messages.getString("ConditionPanel.SeriesDescription"), Messages.getString("SeriesSelectionDialog.Frames"), Messages.getString("SeriesSelectionDialog.Displayed")};
        private List<IDisplaySet> displaySets;
        private int originalSeriesRow = -1;

        SeriesTableModel(IDisplaySetFilter iDisplaySetFilter) {
            List<IDisplaySet> list = new DisplaySetCalculationData(SeriesSelectionDialog.this.view.getDisplay()).getAllDisplaySets();
            if (iDisplaySetFilter != null) {
                list = list.stream().filter(iDisplaySetFilter).collect(Collectors.toList());
            }
            this.displaySets = OverlayStatisticsUtils.searchForCompatibleSeries(SeriesSelectionDialog.this.view.getVis().getImageInformation(), list);
            if (this.displaySets == null || this.displaySets.isEmpty()) {
                return;
            }
            IDisplaySet iDisplaySet = SeriesSelectionDialog.this.view.getDisplayData().getDisplaySet();
            this.rowData = new Object[this.displaySets.size()][6];
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            int n = 0;
            while (n < this.displaySets.size()) {
                IImageInformation iImageInformation = this.displaySets.get(n).getOneObject().getImageInformation();
                String string = iImageInformation.getAcquisitionDateTime() != null ? simpleDateFormat.format(iImageInformation.getAcquisitionDateTimeMillis()) : "";
                this.rowData[n][0] = Boolean.TRUE;
                this.rowData[n][1] = string;
                this.rowData[n][2] = iImageInformation.getDataset().getString(0x200011);
                this.rowData[n][3] = iImageInformation.getDataset().getString(528446);
                this.rowData[n][4] = this.displaySets.get(n).getTotalFrameCount();
                Object object = this.rowData[n][5] = this.displaySets.get(n).isDisplayedInImageArea() ? displayedIcon : notDisplayedIcon;
                if (this.displaySets.get(n) == iDisplaySet) {
                    this.originalSeriesRow = n;
                }
                ++n;
            }
        }

        protected boolean isEmpty() {
            return this.rowData == null;
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.rowData[0].length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.rowData.length <= n || this.rowData[0].length <= n2) {
                return null;
            }
            return this.rowData[n][n2];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            if (n == 5) {
                return Icon.class;
            }
            Object object = this.getValueAt(0, n);
            return object == null ? Object.class : object.getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return n != this.originalSeriesRow;
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n != this.originalSeriesRow) {
                this.rowData[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        protected List<IDisplaySet> getSelectedData() {
            ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
            int n = 0;
            while (n < this.rowData.length) {
                Boolean bl;
                if (this.getValueAt(n, 0) instanceof Boolean && (bl = (Boolean)this.getValueAt(n, 0)).booleanValue()) {
                    arrayList.add(this.displaySets.get(n));
                }
                ++n;
            }
            return arrayList;
        }

        private void selectAll(boolean bl) {
            int n = 0;
            while (n < this.rowData.length) {
                this.setValueAt(bl, n, 0);
                ++n;
            }
        }
    }

    private static class TableColumnResizer {
        private TableColumnResizer() {
        }

        public static void resize(JTable jTable) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = 17;
            if (jTable.getRowCount() > 0) {
                n = Math.max(jTable.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)jTable, (Object)jTable.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height + jTable.getIntercellSpacing().height + 4, n);
            }
            jTable.setRowHeight(n);
            int n2 = 0;
            while (n2 < jTable.getColumnCount()) {
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                tableColumn.setPreferredWidth(TableColumnResizer.getMaxColWidth(jTable, n2));
                ++n2;
            }
        }

        private static int getMaxColWidth(JTable jTable, int n) {
            int n2 = 5;
            int n3 = 5;
            int n4 = 5;
            String string = jTable.getModel().getColumnName(n);
            JLabel jLabel = ComponentFactory.instance.createLabel(string);
            Font font = jLabel.getFont();
            FontMetrics fontMetrics = jLabel.getFontMetrics(font);
            n4 = SwingUtilities.computeStringWidth(fontMetrics, string);
            int n5 = 0;
            while (n5 < jTable.getRowCount()) {
                Object object = jTable.getValueAt(n5, n);
                if (object != null) {
                    n3 = Math.max(jTable.getCellRenderer((int)n5, (int)n).getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)n5, (int)n).getPreferredSize().width + jTable.getIntercellSpacing().width, n2);
                    n2 = Math.max(n3, n4);
                }
                ++n5;
            }
            return n2;
        }
    }
}

