/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.WaitForImagesUtil;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.runtime.MultiPatientHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeActionProvider;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.TEventHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.patinfo.hanging.HangingController;
import com.tiani.jvision.toptoolbar.StoreTemporarySessions;
import com.tiani.jvision.vis.VisDisplayData;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;

public class DataSelectionManager {
    private static final DataSelectionManager instance = new DataSelectionManager();
    private static final ALogger log = ALogger.getLogger(DataSelectionManager.class);
    public static final int STUDY_RESEND_OVERRIDE = 678954;
    private final boolean captureSnapshotStatus = Config.impaxee.jvision.HANGMAN.CaptureSnapshotStatus.get();
    private List<IDataSelectionListener> listeners;
    private DataManager dm = DataManager.getInstance();
    private PAction escapeMouseMode;
    private List<ISelectionListener> selectionListeners;
    private IPatientRepresentation currentPatient;
    private AbstractSnapshotRuntime currentSnapshot;
    private MyActiveImageEventHandler myActiveImageEventHandler;
    private boolean isMultiPatientCompareActive;
    private MultiPatientHangingProtocolRuntime multiPatientHangingProtocolRuntime;
    private boolean blockCapturing = false;

    public static DataSelectionManager getInstance() {
        return instance;
    }

    private DataSelectionManager() {
        this.listeners = new CopyOnWriteArrayList<IDataSelectionListener>();
        this.selectionListeners = new CopyOnWriteArrayList<ISelectionListener>();
        DataManager.getInstance().addListener(new MapCleaningDataManagerListener());
        this.addListener(new LoadPriorityUpdaterListener());
        this.myActiveImageEventHandler = new MyActiveImageEventHandler();
        TEventDispatch.addListener(this.myActiveImageEventHandler);
    }

    private MultiPatientHangingProtocolRuntime getMultiPatientHangingProtocolRuntime() {
        if (this.multiPatientHangingProtocolRuntime == null) {
            this.multiPatientHangingProtocolRuntime = new MultiPatientHangingProtocolRuntime(this.getMultiPatientHPId());
        }
        return this.multiPatientHangingProtocolRuntime;
    }

    public String getMultiPatientHPId() {
        return "--" + Messages.getString("DataSelectionManager.MultiPatientHangingName") + "--";
    }

    public void displayCurrentPatient(String string) {
        IPatientRepresentation iPatientRepresentation = null;
        if (string != null) {
            iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(string);
        }
        if (iPatientRepresentation == null) {
            return;
        }
        boolean bl = iPatientRepresentation == DataSelectionManager.getInstance().getCurrentPatient();
        DataManager.getInstance().refreshHangings(iPatientRepresentation, true, !bl || iPatientRepresentation.getActiveHanging() == null || DataManager.NEW_STUDIES_GET_ACTIVATED);
        this.setCurrentPatient(iPatientRepresentation);
    }

    public IPatientRepresentation getCurrentPatient() {
        return this.currentPatient;
    }

    public boolean isCurrentPatient(IPatientData iPatientData) {
        if (iPatientData == null || this.currentPatient == null) {
            return false;
        }
        return iPatientData.equals(this.currentPatient.getPatientData());
    }

    public void patientClicked(IPatientRepresentation iPatientRepresentation, int n) {
        this.notifyPatientClicked(iPatientRepresentation.getPatientData(), n);
    }

    private void handleMouseMode() {
        if (this.escapeMouseMode == null) {
            this.escapeMouseMode = PActionRegistry.getAction(MouseModeActionProvider.NORMAL_MOUSE_MODE);
        }
        this.escapeMouseMode.perform(null);
    }

    public boolean setCurrentPatient(IPatientRepresentation iPatientRepresentation) {
        boolean bl = Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get();
        if (iPatientRepresentation == null && bl) {
            IPatientRepresentation iPatientRepresentation2 = this.currentPatient;
            this.currentPatient = null;
            if (iPatientRepresentation2 != null) {
                this.notifyNewPatientSelected(iPatientRepresentation2, null);
                this.myActiveImageEventHandler.setStudyUIDLastActive(null);
                this.handleMouseMode();
            }
            this.clearCurrentSnapshot();
            return true;
        }
        if (this.currentPatient != iPatientRepresentation) {
            boolean bl2;
            this.captureCurrentHangup(false);
            this.handleAutomaticSessionStorage(this.currentPatient, bl);
            IPatientRepresentation iPatientRepresentation3 = this.currentPatient;
            this.currentPatient = iPatientRepresentation;
            if (this.isPatientCompareOrPatientMergeActive()) {
                Config.impaxee.jvision.MAPPING.UseAnonymousMode.set(false);
            }
            IHanging iHanging = null;
            boolean bl3 = true;
            this.notifyNewPatientSelected(iPatientRepresentation3, iPatientRepresentation);
            if (iPatientRepresentation != null) {
                boolean bl4 = iPatientRepresentation.hasUncheckedStudyContainers();
                iHanging = iPatientRepresentation.getActiveHanging();
                if (bl4 && (iHanging = DataManager.getInstance().refreshHangings(iPatientRepresentation, true, iHanging == null || DataManager.NEW_STUDIES_GET_ACTIVATED && !(iHanging instanceof Session))) == null) {
                    bl3 = false;
                }
                if (this.isMultiPatientCompareActive) {
                    if (!iPatientRepresentation.containsHanging(this.multiPatientHangingProtocolRuntime)) {
                        iPatientRepresentation.addHanging(this.multiPatientHangingProtocolRuntime);
                        this.multiPatientHangingProtocolRuntime.addPatient(iPatientRepresentation);
                        iHanging = this.multiPatientHangingProtocolRuntime;
                    }
                    iPatientRepresentation.setActiveHanging(null);
                    this.myActiveImageEventHandler.setStudyUIDLastActive(null);
                }
            }
            String string = iHanging != null ? iHanging.getIdentifier() : null;
            this.clearCurrentSnapshot();
            if (iPatientRepresentation3 != null) {
                this.handleMouseMode();
            }
            if (bl3 && iPatientRepresentation != null) {
                iPatientRepresentation.setActiveHanging(null);
                this.setActiveHanging(iPatientRepresentation, string);
            }
            if (iPatientRepresentation3 != null && !(bl2 = Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) && !this.isMultiPatientCompareActive && this.dm.getPatientCount() > 2) {
                for (IPatientRepresentation iPatientRepresentation4 : this.dm.getPatientRepresentations()) {
                    if (iPatientRepresentation4 == iPatientRepresentation || iPatientRepresentation4 == null) continue;
                    iPatientRepresentation4.getPatientData().storeToCache();
                }
            }
            return true;
        }
        return false;
    }

    private void handleAutomaticSessionStorage(IPatientRepresentation iPatientRepresentation, boolean bl) {
        if (iPatientRepresentation == null) {
            return;
        }
        if (!bl && !this.isMultiPatientCompareActive && StoreTemporarySessions.isActivated() && DataManager.getInstance().getPatientRepresentations().contains(iPatientRepresentation)) {
            iPatientRepresentation.createTemporarySession();
        } else {
            iPatientRepresentation.removeTemporarySession();
        }
    }

    private void captureCurrentHangup(boolean bl) {
        if (this.blockCapturing) {
            return;
        }
        IHanging iHanging = this.getActiveHanging();
        boolean bl2 = iHanging instanceof UserDefinedHangingProtocolRuntime;
        if (!bl || !bl2) {
            AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot();
            if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).capture();
            }
            if (abstractSnapshotRuntime != null && bl2) {
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setClearCachedDSAfterFirstUse(true);
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setHangingApplied(true);
            }
        }
    }

    public String getActiveStudyUID() {
        return this.myActiveImageEventHandler != null ? this.myActiveImageEventHandler.getStudyUIDLastActive() : null;
    }

    public IHanging getActiveHanging() {
        return this.getActiveHanging(this.getCurrentPatient());
    }

    public IHanging getActiveHanging(IPatientRepresentation iPatientRepresentation) {
        if (iPatientRepresentation == null) {
            return null;
        }
        return iPatientRepresentation.getActiveHanging();
    }

    public void setActiveHanging(IPatientRepresentation iPatientRepresentation, String string) {
        IHanging iHanging = iPatientRepresentation != null ? iPatientRepresentation.getHanging(string) : null;
        this.setActiveHanging(iPatientRepresentation, iHanging, true, false);
    }

    public boolean setActiveHanging(IPatientRepresentation iPatientRepresentation, IHanging iHanging, boolean bl, boolean bl2) {
        return this.setActiveHanging(iPatientRepresentation, iHanging, bl, bl2, false);
    }

    public boolean setActiveHanging(IPatientRepresentation iPatientRepresentation, IHanging iHanging, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (iHanging != null && !HangingUtil.belongsToPatient(iPatientRepresentation, iHanging)) {
            throw new IllegalArgumentException("Hanging must belong to given patient");
        }
        IHanging iHanging2 = null;
        if (iPatientRepresentation != null) {
            iHanging2 = iPatientRepresentation.getActiveHanging();
        }
        boolean bl5 = bl4 = iHanging2 != iHanging;
        if (bl4 && iPatientRepresentation != null) {
            this.captureCurrentHangup(!this.captureSnapshotStatus);
            iPatientRepresentation.setActiveHanging(iHanging);
            if (iPatientRepresentation == this.getCurrentPatient() && iHanging != null) {
                AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot(iHanging);
                if (abstractSnapshotRuntime == null) {
                    abstractSnapshotRuntime = iHanging.getSnapshotModel().size() > 0 ? iHanging.getSnapshotModel().get(0) : null;
                }
                this.setActiveSnapshot(iHanging, abstractSnapshotRuntime != null ? abstractSnapshotRuntime.getName() : null, bl3);
                if (bl) {
                    this.notifyNewHangingCaseSelected(iPatientRepresentation, iHanging2, iHanging, bl2);
                }
            } else if (iHanging != null && iHanging.getSnapshotModel().getSelectedIndex() < 0) {
                iHanging.getSnapshotModel().select(0);
            }
        }
        return bl4;
    }

    public AbstractSnapshotRuntime getActiveSnapshot() {
        return this.getActiveSnapshot(this.getActiveHanging());
    }

    public AbstractSnapshotRuntime getActiveSnapshot(IHanging iHanging) {
        if (iHanging == null) {
            return null;
        }
        return iHanging.getSnapshotModel().getSelectedSnapshot();
    }

    public void setActiveSnapshot(IHanging iHanging, String string, boolean bl) {
        this.setActiveSnapshot(iHanging, iHanging.getSnapshotModel().get(string), true, bl);
    }

    public void setActiveSnapshot(IHanging iHanging, AbstractSnapshotRuntime abstractSnapshotRuntime, boolean bl, boolean bl2) {
        if (this.getActiveSnapshot() != abstractSnapshotRuntime) {
            this.captureCurrentHangup(!this.captureSnapshotStatus);
        }
        iHanging.getSnapshotModel().select(abstractSnapshotRuntime);
        this.hangup(bl, bl2);
    }

    public void setSessionUnsaved() {
        if (this.currentPatient != null) {
            IHangingSession iHangingSession;
            boolean bl = false;
            IHanging iHanging = this.currentPatient.getActiveHanging();
            if (iHanging instanceof IHangingSession && (iHangingSession = (IHangingSession)iHanging).isSaved()) {
                iHangingSession.setSaved(false);
                bl = true;
            }
            if (bl) {
                HangingController.getInstance().repaintViews();
            }
        }
    }

    public void setSessionsUnsaved() {
        if (this.currentPatient != null) {
            boolean bl = false;
            for (IHangingSession iHangingSession : this.currentPatient.getSessions()) {
                if (!iHangingSession.isSaved()) continue;
                iHangingSession.setSaved(false);
                bl = true;
            }
            if (bl) {
                EventUtil.invoke(HangingController.getInstance()::repaintViews);
            }
        }
    }

    public void setBlockCapturing(boolean bl) {
        this.blockCapturing = bl;
    }

    public void clearCurrentSnapshot() {
        this.currentSnapshot = null;
    }

    private void hangup(boolean bl, final boolean bl2) {
        AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot();
        if (abstractSnapshotRuntime == this.currentSnapshot) {
            return;
        }
        this.currentSnapshot = abstractSnapshotRuntime;
        if (!Product.isHeadless()) {
            HangupAction hangupAction = new HangupAction(bl);
            if (bl && hangupAction.getHangingAction() != null || hangupAction.getSnapshotAction() != null) {
                HangingCaseDisplay.prepareWaitForHP();
                Thread thread = new Thread(hangupAction);
                thread.setDaemon(true);
                thread.start();
            }
            Runnable runnable = this.currentSnapshot != null ? new Runnable(){

                @Override
                public void run() {
                    JVision2.getMainFrame().clearAllDisplays();
                    JComponent jComponent = JVision2.getMainFrame().getJVisionContentPane();
                    jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                    JVision2.getMainFrame().hangup(DataSelectionManager.this.getActiveHanging(), DataSelectionManager.this.currentSnapshot != null ? DataSelectionManager.this.currentSnapshot.getName() : null, bl2);
                }
            } : new Runnable(){

                @Override
                public void run() {
                    JVision2.getMainFrame().clearAllDisplays();
                }
            };
            this.executeInEventThread(runnable);
        }
    }

    public final void addListener(IDataSelectionListener iDataSelectionListener) {
        if (!this.listeners.contains(iDataSelectionListener)) {
            this.listeners.add(iDataSelectionListener);
        }
    }

    public void removeListener(IDataSelectionListener iDataSelectionListener) {
        this.listeners.remove(iDataSelectionListener);
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        if (!this.selectionListeners.contains(iSelectionListener)) {
            this.selectionListeners.add(iSelectionListener);
        }
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionListeners.remove(iSelectionListener);
    }

    private void notifyNewPatientSelected(final IPatientRepresentation iPatientRepresentation, final IPatientRepresentation iPatientRepresentation2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = DataSelectionManager.this.dm.getPatientPosition(iPatientRepresentation2);
                IPatientRepresentation iPatientRepresentation3 = null;
                if (n != -1) {
                    iPatientRepresentation3 = DataSelectionManager.this.dm.getPatientOnPosition(n + 1);
                }
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.newPatientSelected(DataSelectionManager.this, iPatientRepresentation, iPatientRepresentation2, iPatientRepresentation3);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyNewHangingCaseSelected(final IPatientRepresentation iPatientRepresentation, final IHanging iHanging, final IHanging iHanging2, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl2 = bl;
                if (!bl2) {
                    bl2 = DataSelectionManager.this.isMultiPatientCompareActive || iHanging instanceof Session || iHanging2 instanceof Session;
                }
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.newHangingCaseSelected(iPatientRepresentation, iHanging, iHanging2, bl2);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyNewActiveStudySelected(final IStudyData iStudyData) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.newActiveStudySelected(iStudyData);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyPatientClicked(final IPatientData iPatientData, final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.patientClicked(iPatientData, n);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyPriorsChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.priorsChanged();
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyLastModifiedChanged(final int n, final VisDisplayData visDisplayData) {
        Object object;
        IDisplaySet iDisplaySet;
        if (this.currentPatient != null && (iDisplaySet = (object = this.currentPatient.getDecompositionRuntime()).getDisplaySetByID(n)) != null) {
            iDisplaySet.setIsActive(false, false);
        }
        if (visDisplayData != null && visDisplayData.getDisplaySet() != null) {
            visDisplayData.getDisplaySet().setIsActive(true, false);
        }
        object = new Runnable(){

            @Override
            public void run() {
                for (ISelectionListener iSelectionListener : DataSelectionManager.this.selectionListeners) {
                    iSelectionListener.lastModifiedChanged(n, visDisplayData);
                }
            }
        };
        this.executeInEventThread((Runnable)object);
    }

    public void notifyLoadingPriorsInProgress(final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.notifyPriorStudyLoadingInProgress(bl);
                }
            }
        };
        try {
            EventUtil.invoke((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void executeInEventThread(Runnable runnable) {
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void reHangup() {
        IHanging iHanging = this.getActiveHanging();
        AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot(iHanging);
        if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
            ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setHangingApplied(false);
        }
        this.clearCurrentSnapshot();
        this.setActiveSnapshot(iHanging, abstractSnapshotRuntime, false, false);
    }

    public boolean isPatientCompareOrPatientMergeActive() {
        if (this.isMultiPatientCompareActive) {
            return true;
        }
        if (this.currentPatient == null) {
            return false;
        }
        return PatientMergeUtilities.getPatientMergeStatus((Attributes)this.currentPatient.getPatientData().getQueryObject().getAttributes()) != PatientMergeUtilities.PatientMergeStatus.NotMerged;
    }

    public boolean isMultiPatientCompareActive() {
        return this.isMultiPatientCompareActive;
    }

    public void setMultiPatientCompareActive(boolean bl) {
        this.isMultiPatientCompareActive = bl;
        MultiPatientHangingProtocolRuntime multiPatientHangingProtocolRuntime = this.getMultiPatientHangingProtocolRuntime();
        if (bl) {
            Config.impaxee.jvision.MAPPING.UseAnonymousMode.set(false);
            if (this.currentPatient != null) {
                multiPatientHangingProtocolRuntime.getHangingDefinition().getSnapshot(0).capture();
                this.currentPatient.addHanging(multiPatientHangingProtocolRuntime);
                multiPatientHangingProtocolRuntime.addPatient(this.currentPatient);
                this.setActiveHanging(this.currentPatient, multiPatientHangingProtocolRuntime, true, true);
            }
        } else {
            IHanging iHanging = this.getActiveHanging();
            for (IPatientRepresentation iPatientRepresentation : this.dm.getPatientRepresentations()) {
                iPatientRepresentation.removeHanging(multiPatientHangingProtocolRuntime.getIdentifier());
                multiPatientHangingProtocolRuntime.removePatient(iPatientRepresentation);
                if (iPatientRepresentation == this.currentPatient || iPatientRepresentation.getActiveHanging() != null || iPatientRepresentation.countHangings() <= 0) continue;
                iPatientRepresentation.setActiveHanging(iPatientRepresentation.getHanging(0));
            }
            if (iHanging == multiPatientHangingProtocolRuntime) {
                this.setActiveHanging(this.currentPatient, this.currentPatient.getDefaultHanging(), true, true);
            }
            DataManager.getInstance().removeListener(this.multiPatientHangingProtocolRuntime);
            this.multiPatientHangingProtocolRuntime = null;
        }
        PActionRegistry.getAction("SHOW_TEXT_AREA").fireEnabledChanged();
    }

    private class HangupAction
    implements Runnable {
        private boolean hangingChanged;

        public HangupAction(boolean bl) {
            this.hangingChanged = bl;
        }

        public String getHangingAction() {
            String string;
            IHanging iHanging = DataSelectionManager.this.getActiveHanging();
            if (iHanging instanceof IHangingProtocolDefinition && (string = ((IHangingProtocolDefinition)((Object)iHanging)).getActionID()) != null && string.length() > 0) {
                return string;
            }
            return null;
        }

        public String getSnapshotAction() {
            String string;
            String string2 = string = DataSelectionManager.this.currentSnapshot != null ? DataSelectionManager.this.currentSnapshot.getActionID() : null;
            if (string != null && string.length() > 0) {
                return string;
            }
            return null;
        }

        @Override
        public void run() {
            String string;
            log.debug("Waiting for hangup complete before triggering configured actions");
            HangingCaseDisplay.waitForHP(10000L);
            WaitForImagesUtil.awaitImages(5000L);
            if (this.hangingChanged && (string = this.getHangingAction()) != null) {
                try {
                    log.info("Triggering configured HP action: " + string);
                    PActionRegistry.getAction(string).performSynchronouslyOnAWT(null);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("Configured action " + string + " for hanging was not found in action registry");
                }
            }
            if ((string = this.getSnapshotAction()) != null) {
                try {
                    log.info("Triggering configured snapshot action: " + string);
                    PActionRegistry.getAction(string).performSynchronouslyOnAWT(null);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("Configured action " + string + " for snapshot was not found in action registry");
                }
            }
        }
    }

    public static class LoadPriorityUpdaterListener
    extends DataSelectionListenerAdapter {
        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            if (iPatientRepresentation != null && iPatientRepresentation != iPatientRepresentation3 && !DataSelectionManager.getInstance().isMultiPatientCompareActive()) {
                iPatientRepresentation.setLoadPriority(null);
            }
            if (iPatientRepresentation2 != null) {
                iPatientRepresentation2.setLoadPriority((byte)5);
            }
            if (iPatientRepresentation3 != null) {
                iPatientRepresentation3.setLoadPriority((byte)6);
            }
        }
    }

    private class MapCleaningDataManagerListener
    extends DataManagerListenerAdapter {
        private MapCleaningDataManagerListener() {
        }

        @Override
        public void patientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
            IPatientRepresentation iPatientRepresentation2 = DataSelectionManager.this.getCurrentPatient();
            if (iPatientRepresentation.equals(iPatientRepresentation2)) {
                DataSelectionManager.this.setCurrentPatient(null);
            }
            DataSelectionManager.this.myActiveImageEventHandler.setStudyUIDLastActive(null);
        }

        @Override
        public void hangingStateRemoved(IHanging iHanging) {
            DataSelectionManager.this.myActiveImageEventHandler.setStudyUIDLastActive(null);
        }
    }

    private class MyActiveImageEventHandler
    implements TEventHandler {
        private String studyUIDLastActive;

        private MyActiveImageEventHandler() {
        }

        @Override
        public void handleTEvent(TEvent tEvent, Object object, int n) {
            if (tEvent.id == 53) {
                boolean bl = tEvent.interactionModifier == 678954;
                try {
                    View view = (View)object;
                    if (view.getVis() == null) {
                        return;
                    }
                    IStudyData iStudyData = view.getVis().getStudyData();
                    if (iStudyData.getParent().getStudies().contains(iStudyData)) {
                        String string = iStudyData.getKey();
                        if (this.studyUIDLastActive != null && this.studyUIDLastActive.equals(string) && !bl) {
                            return;
                        }
                        this.studyUIDLastActive = string;
                        log.info("Trigger SetActiveStudyEvent for " + string);
                        DataSelectionManager.this.notifyNewActiveStudySelected(iStudyData);
                    }
                }
                catch (Exception exception) {
                    log.error("SetActiveStudyEvent failed", (Throwable)exception);
                }
            }
        }

        public String getStudyUIDLastActive() {
            return this.studyUIDLastActive;
        }

        public void setStudyUIDLastActive(String string) {
            this.studyUIDLastActive = string;
        }
    }
}

