/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.imagednd.ImageDragAndDropManager;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.DisplaySetUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.iconprovider.DisplaySetIconProviderFactory;
import com.agfa.pacs.impaxee.iconprovider.IDisplaySetIconProvider;
import com.agfa.pacs.impaxee.keyimages.KeyImageDisplaySetExpansion;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.dicomobject.presentationstate.FramePresentationStateProviderContainer;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.IStudyStatusListener;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import com.tiani.base.data.TokenOwner;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorLabel;
import com.tiani.jvision.dnd.SeqTransferable;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabelPopup;
import com.tiani.jvision.patinfo.FastDisplaySetReplaceMode;
import com.tiani.jvision.patinfo.SeqLabelMapping;
import com.tiani.jvision.patinfo.TToken;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytMainVariable;
import com.tiani.jvision.vis.layout.LytScreen;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JViewport;

public class DisplaySetLabel
extends MultiMonitorLabel
implements TokenListener,
IObjectListener,
IDisplaySet.ILoadCountListener,
DragGestureListener,
IStudyStatusListener {
    private static final int DEFAULT_TOKEN_SIZE = 64;
    private static final ALogger log = ALogger.getLogger(DisplaySetLabel.class);
    public static final int tokenSize = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.SEQPANEL.TokenSize.get()));
    static final int infoHeight = (int)Config.impaxee.jvision.SEQPANEL.FontSize.get();
    private static final boolean showTooltips = Config.impaxee.jvision.SEQLABEL.ShowTooltips.get();
    private static final Color HIGHLIGHT_COLOR = GuiUtil.isOnColorMonitor() ? new Color(167, 176, 193) : new Color(180, 180, 180);
    private static final Color BORDER_COLOR = GuiUtil.isOnColorMonitor() ? new Color(125, 132, 145) : new Color(140, 140, 140);
    private static final PIcon ICON_DIAG = IAIconFactory.DEFAULT_FACTORY.loadIcon("606_okay.svg");
    private static final PIcon ICON_PR = IAIconFactory.DEFAULT_FACTORY.loadIcon("neutral_presstate_hr.svg");
    private static final PIcon ICON_SEEN = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_seen.svg");
    private static final PIcon ICON_SEQ_NOTSAVED = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_notsaved.svg");
    private static final PIcon ICON_LOSSY = IAIconFactory.DEFAULT_FACTORY.loadIcon("jpeglossy.svg");
    private static final PIcon ICON_SECCAPTURE = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_secondarycapture.svg");
    private static final PIcon ICON_4D = IAIconFactory.DEFAULT_FACTORY.loadIcon("4d.svg");
    private static final int MINIMUM_WIDTH = 350;
    private static final int MINIMUM_WIDTH_HORIZONTAL = GUI.getScaledDiagnosticInt((int)145);
    private static final int ICON_OFFSET = 2;
    private static final int VERTICAL_QUADRATIC_ICON_OFFSET = 6;
    private static final Color VERY_DARK_GRAY = new Color(40, 35, 10);
    private static final int IMAGE_COUNT_PADDING = GUI.getScaledDiagnosticInt((int)3);
    private static final int IMAGE_COUNT_OFFSET = GUI.getScaledDiagnosticInt((int)5);
    private static final int REMOVE_SYMBOL_PADDING = IMAGE_COUNT_PADDING;
    private static final int REMOVE_SYMBOL_DIM = GUI.getScaledDiagnosticInt((int)13);
    private static final int COLLAPSE_SYMBOL_PADDING = GUI.getScaledDiagnosticInt((int)3);
    private static final int COLLAPSE_SYMBOL_DIM = REMOVE_SYMBOL_DIM;
    private static final int EXPAND_SYMBOL_PADDING = REMOVE_SYMBOL_PADDING;
    private static final int EXPAND_SYMBOL_DIM = REMOVE_SYMBOL_DIM;
    private static final Color darkBackgroundColor = new Color(30, 30, 30);
    private static final Color cMono = new Color(154, 154, 154);
    private static final Font MAPPING_FONT = AwtFontFactory.getFont(Config.impaxee.jvision.MAPPING.DisplayFontFace.get(), (int)Config.impaxee.jvision.MAPPING.DisplayFontStyle.get(), GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.MAPPING.DisplayFontSize.get())));
    private static final FastDisplaySetReplaceMode REPLACE_MODE = FastDisplaySetReplaceMode.valueOf(Config.impaxee.jvision.SEQPANEL.FastDisplaySetReplace.get());
    private IDisplaySet displaySet;
    private boolean isActive;
    private Rectangle lastModRect = new Rectangle(0, 0, tokenSize, tokenSize);
    private DragSource dndSource;
    private int preferredHeight;
    private int parentWidth = 0;
    private static final BufferedImage BUFFERED_IMAGE = DisplaySetLabel.createBufferedImage();
    private Map<TokenOwner, TToken> tokens;
    private SeqLabelMapping mapping;
    private int headerHeight;
    private PrivateMouseListener privateMouseListener;
    private Rectangle removeSymbolBounds;
    private Rectangle collapseSymbolBounds;
    private Rectangle expandSymbolBounds;
    private boolean isMouseOverRemoveSymbol;
    private boolean isMouseOverCollapseSymbol;
    private boolean isMouseOverExpandSymbol;
    private boolean hasPR;
    private boolean isDeletableByUser;
    private String tooltip;

    DisplaySetLabel(IDisplaySet iDisplaySet) {
        this.displaySet = iDisplaySet;
        this.isDeletableByUser = !(iDisplaySet instanceof ISessionDisplaySet);
        this.createDragSource();
        if (iDisplaySet.isNotEmpty()) {
            this.mapping = new SeqLabelMapping(new DisplaySetEvaluable(iDisplaySet));
            iDisplaySet.addLoadCountListener(this);
            this.privateMouseListener = new PrivateMouseListener();
            this.addMouseListener(this.privateMouseListener);
            this.addMouseMotionListener(this.privateMouseListener);
            this.init();
            if (iDisplaySet.getOneObject().getParent().containsDerivedImages()) {
                this.updateTokens();
            }
        }
        if (iDisplaySet.isNotEmpty()) {
            this.getStudyDataOfFirstFrame().addListener(this);
            ISeriesData iSeriesData = iDisplaySet.getOneObject().getParent();
            FramePresentationStateProviderContainer framePresentationStateProviderContainer = iSeriesData.getParent().getFramePresentationStateProviderContainer();
            this.hasPR = framePresentationStateProviderContainer.isSeriesReferencedByExtPresState(iSeriesData.getSeriesInstanceUID());
        }
    }

    private static BufferedImage createBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(MAPPING_FONT);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds("0000", graphics2D);
        int n = (int)rectangle2D.getHeight();
        int n2 = (int)rectangle2D.getWidth();
        int n3 = n2 + IMAGE_COUNT_PADDING * 2;
        int n4 = n + IMAGE_COUNT_PADDING * 2;
        bufferedImage = new BufferedImage(n3, n4, 1);
        graphics2D = bufferedImage.createGraphics();
        int n5 = n3 * n4;
        graphics2D.setColor(HIGHLIGHT_COLOR);
        int n6 = 0;
        while (n6 < n5) {
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(0, n6, n6, 0);
            n6 += 8;
        }
        return bufferedImage;
    }

    private void updateHeight() {
        this.headerHeight = 2 + this.mapping.getExpectedHeight();
        this.removeSymbolBounds = new Rectangle(REMOVE_SYMBOL_PADDING, this.headerHeight + REMOVE_SYMBOL_PADDING, REMOVE_SYMBOL_DIM, REMOVE_SYMBOL_DIM);
        this.collapseSymbolBounds = new Rectangle(COLLAPSE_SYMBOL_PADDING, this.headerHeight + REMOVE_SYMBOL_PADDING + COLLAPSE_SYMBOL_PADDING + REMOVE_SYMBOL_DIM, COLLAPSE_SYMBOL_DIM, COLLAPSE_SYMBOL_DIM);
        this.expandSymbolBounds = new Rectangle(EXPAND_SYMBOL_PADDING, this.headerHeight + REMOVE_SYMBOL_PADDING + COLLAPSE_SYMBOL_PADDING + REMOVE_SYMBOL_DIM, EXPAND_SYMBOL_DIM, EXPAND_SYMBOL_DIM);
        Modes.PaletteOrientation paletteOrientation = JVision2.getMainFrame().getPaletteOrientation();
        this.preferredHeight = paletteOrientation.isHorizontal() ? Math.max(tokenSize + this.headerHeight, LytMainVariable.getCommanderWidth(paletteOrientation) - GUI.getScaledDiagnosticInt((int)60)) : tokenSize + this.headerHeight;
    }

    void postGUIInit() {
        int n = this.getVisibleToken();
        IFrameObjectData[] iFrameObjectDataArray = this.displaySet.getObjects();
        if (!iFrameObjectDataArray[n].isStartedBeingLoaded()) {
            iFrameObjectDataArray[n].getMainFrame().addListener(this);
        }
    }

    private void init() {
        this.setCursor(new Cursor(12));
        if (this.mapping != null) {
            this.mapping.updateContent(true, false);
            this.updateHeight();
            if (showTooltips) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("<html>");
                for (String string : this.mapping.getMappingRowsAsStrings()) {
                    stringBuilder.append(string).append("<br>");
                }
                stringBuilder.append("</html>");
                this.tooltip = stringBuilder.toString();
            }
        }
    }

    private List<PIcon> initDisplaySetIcons() {
        ArrayList<PIcon> arrayList = new ArrayList<PIcon>();
        for (IDisplaySetIconProvider iDisplaySetIconProvider : DisplaySetIconProviderFactory.getInstance().getDisplaySetIconProviders()) {
            PIcon pIcon = iDisplaySetIconProvider.getIcon(this.getDisplaySet());
            if (pIcon == null) continue;
            arrayList.add(pIcon);
        }
        return arrayList;
    }

    private void createDragSource() {
        this.dndSource = new DragSource();
        this.dndSource.createDefaultDragGestureRecognizer(this, 0x40000000, this);
    }

    public Rectangle getLastModRect() {
        return this.lastModRect;
    }

    public int getImageWidth() {
        return Math.max(tokenSize, JVision2.getMainFrame().getPaletteOrientation().isHorizontal() ? MINIMUM_WIDTH_HORIZONTAL : 350);
    }

    public IDisplaySet getDisplaySet() {
        return this.displaySet;
    }

    @Override
    public void notifyLoadCountChange() {
        this.repaint();
    }

    private int getVisibleToken() {
        IFrameObjectData[] iFrameObjectDataArray;
        if (this.findViewport() != null && (iFrameObjectDataArray = this.displaySet.getObjects()).length > 2 && !Config.impaxee.jvision.SEQLABEL.UseFirstImagesForTokens.get()) {
            return iFrameObjectDataArray.length / 2;
        }
        return 0;
    }

    private JViewport findViewport() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                return (JViewport)container;
            }
            container = container.getParent();
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        IDisplaySetContainerRuntime iDisplaySetContainerRuntime;
        int n;
        int n2;
        IFrameObjectData[] iFrameObjectDataArray;
        IFrameObjectData iFrameObjectData;
        TToken tToken;
        if (!this.isVisible() || this.getParent() == null || !this.getParent().isVisible()) {
            return;
        }
        int n3 = this.getBounds().width;
        Color color = this.getCurrentMappingColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.displaySet.isBeingLoaded()) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(darkBackgroundColor);
        }
        graphics2D.fillRect(0, 0, n3, this.preferredHeight);
        if (this.getParent() == null) {
            return;
        }
        Object object = null;
        if (tokenSize != 64) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        Composite composite = null;
        if (!this.displaySet.isBeingLoaded()) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.35f));
        }
        if (!(tToken = this.getToken(iFrameObjectData = (iFrameObjectDataArray = this.displaySet.getObjects())[n2 = this.getVisibleToken()])).getTokenData().isFinalToken()) {
            iFrameObjectData.setRawDataContainerToken();
            if (iFrameObjectData.getTokenData() instanceof RawDataContainerTokenData) {
                if (this.tokens == null) {
                    this.tokens = new HashMap<TokenOwner, TToken>(6);
                }
                RawDataContainerTokenCreator.getInstance().addTokenData((RawDataContainerTokenData)iFrameObjectData.getTokenData());
                tToken = new TToken(iFrameObjectData.getTokenData(), this);
                this.tokens.put(iFrameObjectData, tToken);
            }
        }
        tToken.getTokenData().paintToken(graphics2D, 0, this.headerHeight, tokenSize, tokenSize, this);
        int n4 = tokenSize + IMAGE_COUNT_PADDING + IMAGE_COUNT_OFFSET;
        int n5 = this.headerHeight + IMAGE_COUNT_OFFSET;
        String string = Integer.toString(this.displaySet.getTotalFrameCount());
        graphics2D.setFont(MAPPING_FONT);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        int n6 = (int)rectangle2D.getHeight();
        int n7 = (int)rectangle2D.getWidth();
        Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds("0000", graphics2D);
        int n8 = (int)rectangle2D2.getHeight();
        int n9 = (int)rectangle2D2.getWidth();
        boolean bl = this.displaySet.isDisplayedInImageArea();
        if (bl) {
            graphics2D.setColor(VERY_DARK_GRAY);
        } else {
            graphics2D.setColor(Color.BLACK);
        }
        int n10 = n9 + IMAGE_COUNT_PADDING * 2;
        int n11 = n8 + IMAGE_COUNT_PADDING * 2;
        int n12 = n4 - IMAGE_COUNT_PADDING;
        int n13 = n5 - IMAGE_COUNT_PADDING;
        int n14 = n12 + n10;
        int n15 = 0;
        if (n14 > n3) {
            n15 = n14 - n3 + 2;
            n12 -= n15;
        }
        graphics2D.fillRect(n12, n13, n10, n11);
        int n16 = (n9 - n7) / 2;
        graphics2D.setColor(color);
        graphics2D.drawString(string, n4 + n16 - n15, n5 + n6 - graphics2D.getFontMetrics().getDescent());
        graphics2D.drawRect(n12, n13, n10, n11);
        if (bl) {
            int n17 = n12;
            n = n13;
            graphics2D.drawRect(n17 + GUI.getScaledInt((int)2), n + GUI.getScaledInt((int)2), n10 - GUI.getScaledInt((int)4), n11 - GUI.getScaledInt((int)4));
            if (JVision2.getMainFrame().getPaletteOrientation().isHorizontal()) {
                n += n11 + GUI.getScaledInt((int)4);
            } else {
                n17 += n10 + GUI.getScaledInt((int)8);
            }
            this.paintMonitorImage(graphics2D, n17, n, n10, n11);
        }
        if (this.isDeletableByUser) {
            if (this.isMouseOverRemoveSymbol) {
                this.paintRemoveSymbol(graphics2D, Color.BLACK, color);
            } else {
                this.paintRemoveSymbol(graphics2D, color, Color.BLACK);
            }
        }
        if ((iDisplaySetContainerRuntime = DisplaySetUtils.getDisplaySetContainerRuntime(this.displaySet)) != null && ((n = (int)(iDisplaySetContainerRuntime.isDisplaySetCollapsable(this.displaySet) ? 1 : 0)) != 0 || iDisplaySetContainerRuntime.isDisplaySetExpandable(this.displaySet))) {
            if (iDisplaySetContainerRuntime.hasOnlyKeyImages(this.displaySet)) {
                this.paintExpandSymbol(graphics2D, cMono, Color.BLACK);
            } else if (iDisplaySetContainerRuntime.isDisplaySetCollapsed(this.displaySet)) {
                if (iDisplaySetContainerRuntime.isDisplaySetExpandable(this.displaySet)) {
                    if (this.isMouseOverCollapseSymbol) {
                        this.paintCollapseSymbol(graphics2D, Color.BLACK, color);
                    } else {
                        this.paintCollapseSymbol(graphics2D, color, Color.BLACK);
                    }
                }
            } else if (n != 0) {
                if (this.isMouseOverExpandSymbol) {
                    this.paintExpandSymbol(graphics2D, Color.BLACK, color);
                } else {
                    this.paintExpandSymbol(graphics2D, color, Color.BLACK);
                }
            }
        }
        if (tokenSize != 64) {
            if (object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            } else {
                graphics2D.getRenderingHints().remove(RenderingHints.KEY_INTERPOLATION);
            }
        }
        if (this.isActive) {
            this.lastModRect.x = 0;
            this.lastModRect.y = 0;
            this.lastModRect.width = tokenSize;
            this.lastModRect.height = tokenSize;
            this.paintLastModBorder(graphics2D);
        }
        if (this.displaySet.isNotEmpty()) {
            int n18;
            PIcon pIcon;
            Object object2;
            Object object3;
            IStudyData iStudyData = this.getStudyDataOfFirstFrame();
            PIcon pIcon2 = this.displaySet.isLossyData() ? ICON_LOSSY : this.displaySet.getOneObject().getStatusIcon();
            if (pIcon2 != null) {
                graphics2D.drawImage(pIcon2.getImage(), GUI.getScaledDiagnosticInt((int)20), this.getSize().height - GUI.getScaledDiagnosticInt((int)65), null);
            }
            if (iStudyData.isDiagnosed()) {
                graphics2D.drawImage(ICON_DIAG.getImage(), GUI.getScaledDiagnosticInt((int)40), this.getSize().height - GUI.getScaledDiagnosticInt((int)55), null);
            }
            if (iStudyData.isSeen()) {
                graphics2D.drawImage(ICON_SEEN.getImage(), GUI.getScaledDiagnosticInt((int)3), this.getSize().height - GUI.getScaledDiagnosticInt((int)45), null);
            }
            int n19 = GUI.getScaledDiagnosticInt((int)20);
            if (this.displaySet.isSecondaryCapture()) {
                object3 = !this.displaySet.isSecondaryCaptureSaved() ? ICON_SEQ_NOTSAVED : ICON_SECCAPTURE;
                graphics2D.drawImage(object3.getImage(), n19, this.getYPosition((PIcon)object3), null);
                n19 += object3.getIconWidth() + 2;
            }
            if (this.hasPR) {
                object3 = ICON_PR.getImage();
                graphics2D.drawImage((Image)object3, n19, this.getYPosition(ICON_PR), null);
                n19 += ICON_PR.getIconWidth() + 2;
            }
            if (!(object3 = this.initDisplaySetIcons()).isEmpty()) {
                object2 = (PIcon)object3.get(0);
                graphics2D.drawImage(object2.getImage(), n19, this.getYPosition((PIcon)object2), null);
                n19 += object2.getIconWidth() + 2;
            }
            if (this.displaySet.is4D()) {
                graphics2D.drawImage(ICON_4D.getImage(), n19, this.getYPosition(ICON_4D) - 6, null);
                n19 += ICON_4D.getIconWidth() + 2;
            }
            if ((object2 = this.displaySet.getStatusIcon()) != null && (pIcon = object2.getSeriesPaletteIcon()) != null) {
                graphics2D.drawImage(pIcon.getImage(), n19, this.getYPosition(pIcon) - 6, null);
            }
            if ((n18 = this.getPriorIndex(this.displaySet.getStudy())) > 0) {
                String string2 = String.valueOf(Messages.getString("StudyTable.Priors")) + n18;
                Rectangle2D rectangle2D3 = graphics2D.getFontMetrics().getStringBounds(string2, graphics2D);
                int n20 = (int)rectangle2D3.getWidth();
                graphics2D.setColor(color);
                graphics2D.drawString(string2, n12 + n10 - n20, this.getHeight() - n20 / 2);
            }
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        if (this.mapping != null) {
            int n21;
            this.mapping.paint(graphics2D);
            int n22 = n21 = this.parentWidth > 0 ? this.parentWidth : this.getWidth();
            if (showTooltips && this.mapping.getPaintedWidth() > n21) {
                this.setToolTipText(this.tooltip);
            }
        }
        super.paint(graphics2D);
    }

    private int getPriorIndex(IStudyData iStudyData) {
        IStudyContainer iStudyContainer;
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null && (iStudyContainer = iHanging.getStudyContainer()) != null) {
            return iStudyContainer.getIndexOfStudy(iStudyData.getKey());
        }
        return -1;
    }

    private void paintMonitorImage(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        if (list.size() > 2) {
            int n5 = 0;
            while (n5 < list.size()) {
                if (this.isDisplayOnScreen(list.get(n5))) {
                    this.paintLayoutScreen(graphics, list.get(n5), n, n2, n3, n4);
                    this.paintScreenNumber(graphics, n5, n, n2, n3);
                    break;
                }
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < list.size()) {
                this.paintLayoutScreen(graphics, list.get(n6), n, n2, n3, n4);
                n += n3 + GUI.getScaledInt((int)4);
                ++n6;
            }
        }
        graphics.setColor(color);
    }

    private boolean isDisplayOnScreen(VisScreen2 visScreen2) {
        LytScreen lytScreen = visScreen2.getLyt();
        int n = lytScreen.getRows();
        int n2 = lytScreen.getCols();
        List<VisDisplay2> list = visScreen2.getDisplays();
        int n3 = 0;
        int n4 = n * n2;
        int n5 = 0;
        while (n5 < n4) {
            VisDisplay2 visDisplay2 = list.get(n3);
            ++n3;
            if (visDisplay2.getData().getDisplaySet() == this.displaySet) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    private void paintScreenNumber(Graphics graphics, int n, int n2, int n3, int n4) {
        String string = String.valueOf(n + 1);
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
        Font font = graphics.getFont();
        Font font2 = font.deriveFont(1);
        graphics.setFont(font2);
        graphics.setColor(Color.WHITE);
        graphics.drawString(string, n2 + n4 + 3, n3 + (int)rectangle2D.getHeight());
        graphics.setFont(font);
    }

    private void paintLayoutScreen(Graphics graphics, VisScreen2 visScreen2, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        LytScreen lytScreen = visScreen2.getLyt();
        int n9 = lytScreen.getRows();
        int n10 = lytScreen.getCols();
        List<VisDisplay2> list = visScreen2.getDisplays();
        Map<Point, Dimension> map = lytScreen.getMergedCells();
        ArrayList<Cell> arrayList = null;
        ArrayList<Cell> arrayList2 = new ArrayList<Cell>();
        if (map != null && !map.isEmpty()) {
            arrayList = new ArrayList<Cell>(map.size());
            for (Map.Entry<Point, Dimension> entry : map.entrySet()) {
                Point point = entry.getKey();
                Dimension dimension = entry.getValue();
                Cell cell = new Cell(point.getX(), point.getY(), dimension.getWidth(), dimension.getHeight());
                arrayList.add(cell);
                n8 = (int)point.getX();
                n7 = (int)point.getY();
                n6 = 0;
                while (n6 < cell.getCellWidth()) {
                    n5 = 0;
                    while (n5 < cell.getCellHeight()) {
                        if ((int)point.getX() != n8 || (int)point.getY() != n7) {
                            arrayList2.add(new Cell(n8, n7));
                        }
                        ++n7;
                        ++n5;
                    }
                    n7 = (int)point.getY();
                    ++n8;
                    ++n6;
                }
            }
        }
        boolean bl = false;
        if (n9 > 5 || n10 > 5) {
            n9 = 1;
            n10 = 1;
            bl = true;
        }
        int n11 = n3 / n10;
        int n12 = n4 / n9;
        int n13 = n10 * n11;
        int n14 = n9 * n12;
        n8 = n2 + n14;
        n7 = (n13 + 2) / 4;
        graphics.setColor(BORDER_COLOR);
        graphics.fillRect(n + n7, n8 + 3, n7 * 2 - 1, GUI.getScaledDiagnosticInt((int)3));
        n6 = 0;
        n5 = n9 * n10;
        int n15 = 0;
        while (n15 < n5) {
            int n16 = n15 % n10;
            int n17 = n15 / n10;
            if (!this.isCellContained(arrayList2, n16, n17)) {
                Set<IDisplaySet> set = this.getDisplaySets(list, bl, n6);
                ++n6;
                int n18 = (int)((double)(n + n16 * n11) + 0.5);
                int n19 = (int)((double)(n2 + n17 * n12) + 0.5);
                int n20 = (int)((double)(n18 + n11) + 0.5) - n18;
                int n21 = (int)((double)(n19 + n12) + 0.5) - n19;
                Cell cell = this.isMergedCell(arrayList, n16, n17);
                if (cell != null) {
                    int n22 = cell.getX();
                    int n23 = cell.getY();
                    if (n22 == n16 && n23 == n17) {
                        n20 *= cell.getCellWidth();
                        n21 *= cell.getCellHeight();
                    }
                }
                graphics.setColor(Color.BLACK);
                graphics.fillRect(n18, n19, n20, n21);
                if (set.contains(this.displaySet)) {
                    if (bl) {
                        graphics.drawImage(BUFFERED_IMAGE, n18, n19, null);
                    } else {
                        graphics.setColor(HIGHLIGHT_COLOR);
                        graphics.fillRect(n18, n19, n20, n21);
                    }
                }
                graphics.setColor(BORDER_COLOR);
                graphics.drawRect(n18, n19, n20, n21);
            }
            ++n15;
        }
    }

    private Set<IDisplaySet> getDisplaySets(List<VisDisplay2> list, boolean bl, int n) {
        if (bl) {
            return list.stream().filter(VisDisplay2::hasData).map(visDisplay2 -> visDisplay2.getData().getDisplaySet()).collect(Collectors.toSet());
        }
        VisDisplay2 visDisplay22 = list.get(n);
        if (visDisplay22.hasData()) {
            return Collections.singleton(visDisplay22.getData().getDisplaySet());
        }
        return Collections.emptySet();
    }

    private boolean isCellContained(List<Cell> list, int n, int n2) {
        for (Cell cell : list) {
            if (cell.getX() != n || cell.getY() != n2) continue;
            return true;
        }
        return false;
    }

    private Cell isMergedCell(List<Cell> list, int n, int n2) {
        if (list != null) {
            for (Cell cell : list) {
                if (cell.getX() != n || cell.getY() != n2) continue;
                return cell;
            }
        }
        return null;
    }

    private int getYPosition(PIcon pIcon) {
        return this.getSize().height - pIcon.getIconHeight();
    }

    private Color getCurrentMappingColor() {
        return this.mapping.getMappingColor();
    }

    private void paintRemoveSymbol(Graphics graphics, Color color, Color color2) {
        graphics.setColor(color2);
        graphics.fillRect(this.removeSymbolBounds.x, this.removeSymbolBounds.y, this.removeSymbolBounds.width, this.removeSymbolBounds.height);
        graphics.setColor(color);
        graphics.drawRect(this.removeSymbolBounds.x, this.removeSymbolBounds.y, this.removeSymbolBounds.width, this.removeSymbolBounds.height);
        int n = this.removeSymbolBounds.x + REMOVE_SYMBOL_PADDING;
        int n2 = this.removeSymbolBounds.y + REMOVE_SYMBOL_PADDING;
        int n3 = this.removeSymbolBounds.x + this.removeSymbolBounds.width - REMOVE_SYMBOL_PADDING;
        int n4 = this.removeSymbolBounds.y + this.removeSymbolBounds.height - REMOVE_SYMBOL_PADDING;
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n, n4, n3, n2);
    }

    private void paintCollapseSymbol(Graphics graphics, Color color, Color color2) {
        Rectangle rectangle = new Rectangle(this.collapseSymbolBounds);
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = 1 + Math.max(1, GUI.getScaledDiagnosticInt((int)2));
        rectangle.x += n;
        rectangle.y += n;
        rectangle.width -= 2 * n;
        rectangle.height -= 2 * n;
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.width);
    }

    private void paintExpandSymbol(Graphics graphics, Color color, Color color2) {
        Rectangle rectangle = new Rectangle(this.expandSymbolBounds);
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = Math.max(1, GUI.getScaledDiagnosticInt((int)2));
        int n2 = 1 + Math.max(0, GUI.getScaledDiagnosticInt((int)2));
        rectangle.x += n2;
        rectangle.y += n2;
        rectangle.width -= 2 * n2;
        rectangle.height -= 2 * n2;
        graphics.fillRect(rectangle.x, (int)(rectangle.getCenterY() - (double)(n / 2) + 0.5), rectangle.width, n);
    }

    public IStudyData getStudyDataOfFirstFrame() {
        return DisplaySetUtils.getStudy(this.displaySet);
    }

    private TToken getToken(TokenOwner tokenOwner) {
        if (this.tokens == null) {
            this.tokens = new HashMap<TokenOwner, TToken>(6);
        }
        if (!this.tokens.containsKey(tokenOwner)) {
            this.tokens.put(tokenOwner, new TToken(tokenOwner.getTokenData(), this));
        } else if (this.tokens.get(tokenOwner).getTokenData() != tokenOwner.getTokenData()) {
            this.tokens.put(tokenOwner, new TToken(tokenOwner.getTokenData(), this));
        }
        return this.tokens.get(tokenOwner);
    }

    @Override
    public void tokenChanged(TokenData tokenData) {
        this.repaint();
    }

    private void paintLastModBorder(Graphics graphics) {
        DisplaySetLabel.paintLastModBorder(graphics, this.lastModRect, this.headerHeight);
    }

    public static void paintLastModBorder(Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3;
        if (graphics == null) {
            return;
        }
        int n4 = rectangle.width - 2;
        int n5 = rectangle.height - 1;
        int n6 = 21;
        float f = (float)n5 / (float)n6;
        int n7 = (int)((float)n4 / f);
        float f2 = (float)n4 / (float)n7;
        int n8 = rectangle.x + 1 + n4 - 1;
        int n9 = rectangle.y + 1 + n5 - 1 + n;
        graphics.setColor(Vis2.COLOR_SELECT);
        graphics.drawRect(rectangle.x + 1, rectangle.y + n, n4, n5);
        graphics.setColor(Vis2.COLOR_LASTMODIFIED);
        int n10 = rectangle.y + n;
        int n11 = n10 + n5;
        int n12 = (int)(2.0f * f2);
        int n13 = (int)f2;
        int n14 = 0;
        while (n14 < n4) {
            n3 = n14 + rectangle.x + 1;
            n2 = n3 + n13;
            if (n2 > n8) {
                n2 = n8;
            }
            graphics.drawLine(n3, n10, n2, n10);
            graphics.drawLine(n3, n11, n2, n11);
            n14 += n12;
        }
        n3 = rectangle.x + 1;
        n2 = n3 + n4;
        n14 = (int)(2.0f * f);
        int n15 = (int)f;
        int n16 = rectangle.y + n;
        int n17 = 0;
        while (n17 < n5) {
            n10 = n17 + n16;
            n11 = n10 + n15;
            if (n11 > n9) {
                n11 = n9;
            }
            graphics.drawLine(n3, n10, n3, n11);
            graphics.drawLine(n2, n10, n2, n11);
            n17 += n14;
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.relayout();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.relayout();
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.relayout();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.relayout();
    }

    private void relayout() {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        if (this.mapping != null) {
            this.mapping.setSize(n, n2, null);
            this.mapping.updateContent(false, false);
            this.updateHeight();
        }
    }

    public void cleanUp() {
        this.removeListeners();
        this.displaySet = null;
        this.dndSource = null;
        this.mapping = null;
        if (this.tokens != null) {
            this.tokens.clear();
        }
        this.tokens = null;
    }

    private void removeListeners() {
        this.displaySet.removeLoadCountListener(this);
        IStudyData iStudyData = this.getStudyDataOfFirstFrame();
        if (iStudyData != null) {
            iStudyData.removeListener(this);
        }
        if (this.privateMouseListener != null) {
            this.removeMouseListener(this.privateMouseListener);
            this.privateMouseListener = null;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    public void updateTokens() {
        IFrameObjectData[] iFrameObjectDataArray = this.displaySet.getObjects();
        LinkedHashSet<IImageObjectData> linkedHashSet = new LinkedHashSet<IImageObjectData>();
        IFrameObjectData iFrameObjectData = iFrameObjectDataArray[this.getVisibleToken()];
        if (!iFrameObjectData.isFullyLoaded() || iFrameObjectData.getTokenData() == null || !iFrameObjectData.getTokenData().isFinalToken()) {
            linkedHashSet.add(iFrameObjectData.getMainFrame());
            iFrameObjectData.setRawDataContainerToken();
        }
        for (IImageObjectData iImageObjectData : linkedHashSet) {
            iImageObjectData.addListener(this);
            DataManager.getInstance().getFetcher().changeToHigherPriority(iImageObjectData, (byte)5);
        }
    }

    @Override
    public int getHeight() {
        return this.preferredHeight;
    }

    void setParentWidth(int n) {
        this.parentWidth = n;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        SeqTransferable seqTransferable = new SeqTransferable(this.displaySet);
        try {
            this.dndSource.startDrag(dragGestureEvent, null, seqTransferable, new PrivateDragSourceListener());
            ImageDragAndDropManager.getInstance().startImageDragAndDrop(dragGestureEvent.getDragSource(), this.createDragAndDropImage(), 0.6f);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            log.warn("Initiating display-set-label drag failed. Trying once more again ...");
            this.createDragSource();
            try {
                this.dndSource.startDrag(dragGestureEvent, null, seqTransferable, new PrivateDragSourceListener());
                ImageDragAndDropManager.getInstance().startImageDragAndDrop(dragGestureEvent.getDragSource(), this.createDragAndDropImage(), 0.6f);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException2) {
                log.error("Initiating displaysetlabel drag failed!", (Throwable)invalidDnDOperationException2);
            }
        }
    }

    private BufferedImage createDragAndDropImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.paint(graphics2D);
        return bufferedImage;
    }

    @Override
    public void studyStateChanged(IStudyData iStudyData) {
        if (this.getStudyDataOfFirstFrame().equals(iStudyData)) {
            this.repaint();
        }
    }

    @Override
    public void lossyObjectFinished(IObjectData iObjectData) {
    }

    @Override
    public void objectFinished(IObjectData iObjectData) {
        if (this.displaySet != null) {
            IFrameObjectData[] iFrameObjectDataArray = ((IImageObjectData)iObjectData).frames();
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                iFrameObjectData.setRawDataContainerToken();
                ++n2;
            }
        }
    }

    private static class Cell {
        private int x;
        private int y;
        private int cellWidth;
        private int cellHeight;

        public Cell(int n, int n2) {
            this(n, n2, 1.0, 1.0);
        }

        public Cell(double d, double d2, double d3, double d4) {
            this.x = (int)d;
            this.y = (int)d2;
            this.cellWidth = (int)d3;
            this.cellHeight = (int)d4;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        int getCellWidth() {
            return this.cellWidth;
        }

        int getCellHeight() {
            return this.cellHeight;
        }
    }

    private static class PrivateDragSourceListener
    extends DragSourceAdapter {
        private PrivateDragSourceListener() {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private class PrivateMouseListener
    extends MouseAdapter {
        private PrivateMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            VisDisplay2 visDisplay2;
            VisData visData;
            if (DisplaySetLabel.this.removeSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY()) && DisplaySetLabel.this.isDeletableByUser) {
                DataManager.getInstance().removeDisplaySet(new IDisplaySet[]{DisplaySetLabel.this.displaySet}, SplitAndSortChangeType.MANUAL_REMOVAL, true, false);
            } else if (DisplaySetLabel.this.collapseSymbolBounds.contains(mouseEvent.getPoint())) {
                KeyImageDisplaySetExpansion.getInstance().toggleExpansionState(DisplaySetLabel.this.displaySet);
            } else if (REPLACE_MODE.isEnabled() && ModifierKeys.isLMB((MouseEvent)mouseEvent) && mouseEvent.getClickCount() == REPLACE_MODE.getClickCount() && (visData = VisData.getLastModified()) != null && (visDisplay2 = visData.getParent().getVisDisplay()).isDragAndDropEnabled()) {
                visDisplay2.initVisDisplay(DisplaySetLabel.this.displaySet, null, true, ActivationMode.MANUAL);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ModifierKeys.isRMB((MouseEvent)mouseEvent)) {
                DisplaySetLabelPopup displaySetLabelPopup = new DisplaySetLabelPopup(DisplaySetLabel.this, DisplaySetLabel.this.isDeletableByUser);
                displaySetLabelPopup.show(DisplaySetLabel.this, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
                boolean bl = false;
                if (DisplaySetLabel.this.removeSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    DisplaySetLabel.this.isMouseOverRemoveSymbol = true;
                    bl = true;
                }
                if (DisplaySetLabel.this.collapseSymbolBounds.contains(mouseEvent.getPoint())) {
                    DisplaySetLabel.this.isMouseOverCollapseSymbol = true;
                    bl = true;
                }
                if (DisplaySetLabel.this.expandSymbolBounds.contains(mouseEvent.getPoint())) {
                    DisplaySetLabel.this.isMouseOverExpandSymbol = true;
                    bl = true;
                }
                if (bl) {
                    DisplaySetLabel.this.repaint();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.checkMousePositionInsideSymbols(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.checkMousePositionInsideSymbols(mouseEvent);
        }

        private void checkMousePositionInsideSymbols(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = DisplaySetLabel.this.removeSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY());
            if (bl4 != DisplaySetLabel.this.isMouseOverRemoveSymbol) {
                DisplaySetLabel.this.isMouseOverRemoveSymbol = bl4;
                bl3 = true;
            }
            if ((bl2 = DisplaySetLabel.this.collapseSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY())) != DisplaySetLabel.this.isMouseOverCollapseSymbol) {
                DisplaySetLabel.this.isMouseOverCollapseSymbol = bl2;
                bl3 = true;
            }
            if ((bl = DisplaySetLabel.this.expandSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY())) != DisplaySetLabel.this.isMouseOverExpandSymbol) {
                DisplaySetLabel.this.isMouseOverExpandSymbol = bl;
                bl3 = true;
            }
            if (bl3) {
                DisplaySetLabel.this.repaint();
            }
        }
    }
}

