/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.actions.impl.SubactionCache;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.sessions.gui.WorklistChooser;
import com.agfa.pacs.impaxee.splitsort.ManualSplitAndSortActionProvider;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.listtext.lta.util.referencedobject.XDSDataInfoNode;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.apache.commons.collections4.CollectionUtils;

class DisplaySetLabelPopup
extends JPopupMenu {
    private static final ALogger log = ALogger.getLogger(DisplaySetLabelPopup.class);
    private IDisplaySet displaySet;
    private DisplaySetLabel parentLabel;
    private boolean showDeleteOption;

    DisplaySetLabelPopup(DisplaySetLabel displaySetLabel, boolean bl) {
        this.parentLabel = displaySetLabel;
        this.displaySet = displaySetLabel.getDisplaySet();
        this.showDeleteOption = bl;
        this.fillMenu();
    }

    private void fillMenu() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new CreateIconsAction());
        PAction pAction = null;
        try {
            pAction = PActionRegistry.getAction("CHECK_STUDIES_FOR_THIN_SLICES");
        }
        catch (ActionNotFoundException actionNotFoundException) {
            log.warn("Action CHECK_STUDIES_FOR_THIN_SLICES not found!");
        }
        if (pAction != null && pAction.isAvailable()) {
            arrayList.add(pAction);
        }
        arrayList.add(new RemoveDisplaySetAction());
        arrayList.add(new RemoveAllDisplaySetsAction());
        arrayList.addAll(ManualSplitAndSortActionProvider.getSeriesPaletteActions(this.displaySet));
        arrayList.add(new StoreSecondaryCapture());
        if (this.isPerformActionAvailable("PRINT")) {
            arrayList.add(new SimpleDataAction("PRINT", PDataScope.CurrentDisplay));
        }
        if (this.isPerformActionAvailable("EXPORT")) {
            arrayList.add(new SimpleDataAction("EXPORT", PDataScope.CurrentDisplay));
        }
        arrayList.add(new DisplaySetStudySubMenu());
        if (this.isPerformActionAvailable("EXPORT")) {
            arrayList.add(new SimpleDataAction("EXPORT", PDataScope.FullStudy));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((PAction)iterator.next()).isAvailable()) continue;
            iterator.remove();
        }
        for (PAction pAction2 : arrayList) {
            try {
                IActionUI iActionUI = ActionUIFactory.createUI(pAction2, ActionUIScope.VisMenu);
                if (iActionUI == null) continue;
                this.add(iActionUI.getComponent());
            }
            catch (ActionNotFoundException actionNotFoundException) {
                log.warn("Creating action-ui for action '" + pAction2.getID() + "' failed! Skipped...");
            }
            catch (Exception exception) {
                log.warn("Creating action-ui for action '" + pAction2.getID() + "' failed! Skipped...", (Throwable)exception);
            }
        }
    }

    private boolean isPerformActionAvailable(String string) {
        IDataAction iDataAction = DataActionFactory.getInstance().getActionForCode(string);
        if (iDataAction == null) {
            return false;
        }
        return iDataAction.isAllowed();
    }

    private IPerform.IPerformContext getContext() {
        return new IPerform.DefaultPerformContext(JVision2.getMainFrame(), null);
    }

    private List<IDataObject> getData(boolean bl, boolean bl2) {
        ArrayList<IDataObject> arrayList = new ArrayList<IDataObject>();
        if (bl) {
            arrayList.add(this.displaySet.getOneObject().getParent().getParent());
        } else {
            CollectionUtils.addAll(arrayList, new TwoDArrayIterator<IFrameObjectData>(this.displaySet.getFrames()));
        }
        if (bl2) {
            boolean bl3 = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IDataObject iDataObject = (IDataObject)iterator.next();
                if (!(iDataObject.getQueryObject().getSource() instanceof XDSDataInfoNode)) continue;
                iterator.remove();
                bl3 = true;
            }
            if (bl3) {
                ComponentFactory.instance.showErrorDialog(Messages.getString("AbstractExportDataAction.XDSRemovedTitle"), Messages.getString("AbstractExportDataAction.XDSRemovedMessage"), null);
            }
        }
        return arrayList;
    }

    private class AddStudyToWorklist
    extends AnonymousPAction {
        private AddStudyToWorklist() {
        }

        @Override
        public boolean isAvailable() {
            return DisplaySetLabelPopup.this.isPerformActionAvailable("ADD_TO_WORKLIST");
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.AddStudyToWorklist");
        }

        @Override
        public boolean perform(Component component) {
            Collection<IWorklistContext> collection;
            this.notifyActionPerformed("SERIES_ADD_TO_WORKLIST");
            IStore iStore = DataManager.getInstance().getDataStore();
            ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>(iStore.getAvailableWorklistContexts());
            WorklistChooser worklistChooser = new WorklistChooser(JVision2.getMainFrame(), arrayList, null);
            if ("OK_OPTION" == worklistChooser.getDialogResult() && (collection = worklistChooser.getSelectedWorklistContexts()) != null && !collection.isEmpty()) {
                EventUtil.invokeNotOnEDT((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
                        arrayList.add(DisplaySetLabelPopup.this.displaySet.getOneObject().getParent().getParent());
                        IPerform iPerform = DataManager.getInstance().getDataPerform("ADD_TO_WORKLIST");
                        if (iPerform != null) {
                            iPerform.perform(new IPerform.DefaultPerformContext(null, collection), arrayList);
                        }
                    }
                });
            }
            return false;
        }
    }

    private class CreateIconsAction
    extends AnonymousPAction {
        private CreateIconsAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.UpdateIcons");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_UPDATE_ICONS");
            DisplaySetLabelPopup.this.parentLabel.updateTokens();
            return false;
        }
    }

    private class DisplaySetStudySubMenu
    extends AnonymousPAction
    implements SubactionCache.ISubactionProvider {
        private final SubactionCache subActionCache = new SubactionCache();

        private DisplaySetStudySubMenu() {
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.Submenu;
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public PAction[] getSubactions() {
            return this.subActionCache.getSubactions(this);
        }

        @Override
        public PAction[] createSubactions() {
            IStudyData iStudyData;
            AddStudyToWorklist addStudyToWorklist;
            ArrayList<AnonymousPAction> arrayList = new ArrayList<AnonymousPAction>();
            if (DisplaySetLabelPopup.this.isPerformActionAvailable("PRINT")) {
                arrayList.add(new SimpleDataAction("PRINT", PDataScope.CurrentStudy));
            }
            if (DisplaySetLabelPopup.this.isPerformActionAvailable("EXPORT")) {
                arrayList.add(new SimpleDataAction("EXPORT", PDataScope.CurrentStudy));
            }
            if ((addStudyToWorklist = new AddStudyToWorklist()).isAvailable()) {
                arrayList.add(addStudyToWorklist);
            }
            if ((iStudyData = DisplaySetLabelPopup.this.parentLabel.getStudyDataOfFirstFrame()) != null && iStudyData.getAvailableNewStudyStates() != null) {
                for (Action action : iStudyData.getAvailableNewStudyStates()) {
                    arrayList.add(new NewStudyStateAction(action));
                }
            }
            return arrayList.toArray(new PAction[arrayList.size()]);
        }

        @Override
        public String getCaption() {
            return Messages.getString("VisPopup.Study");
        }

        @Override
        public boolean perform(Component component) {
            throw new UnsupportedOperationException();
        }

        private class NewStudyStateAction
        extends AnonymousPAction {
            private Action action;

            public NewStudyStateAction(Action action) {
                this.action = action;
            }

            @Override
            public String getCaption() {
                return this.action.getValue("ShortDescription").toString();
            }

            @Override
            public boolean perform(Component component) {
                this.notifyActionPerformed("SERIES_STUDY_STATE");
                this.action.actionPerformed(null);
                return true;
            }
        }
    }

    private class RemoveAllDisplaySetsAction
    extends AnonymousPAction {
        private RemoveAllDisplaySetsAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("SEQPANEL_POPUP_DELETE_ALL");
        }

        @Override
        public boolean isAvailable() {
            return DisplaySetLabelPopup.this.showDeleteOption;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_REMOVE_ALL_DS");
            DataManager.getInstance().removePatient(DisplaySetLabelPopup.this.displaySet.getSplitAndSortRuntime().getPatientRepresentation().getPatientKey(), true, false);
            return true;
        }
    }

    private class RemoveDisplaySetAction
    extends AnonymousPAction {
        private RemoveDisplaySetAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("SEQPANEL_POPUP_DELETE");
        }

        @Override
        public boolean isAvailable() {
            return DisplaySetLabelPopup.this.showDeleteOption;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_REMOVE_DS");
            DataManager.getInstance().removeDisplaySet(new IDisplaySet[]{DisplaySetLabelPopup.this.displaySet}, SplitAndSortChangeType.MANUAL_REMOVAL, true, false);
            return true;
        }
    }

    private class SimpleDataAction
    extends AnonymousPAction {
        private PDataScope scope;
        private String actionCode;

        public SimpleDataAction(String string, PDataScope pDataScope) {
            this.scope = pDataScope;
            this.actionCode = string;
        }

        @Override
        public String getCaption() {
            String string = this.actionCode == "PRINT" ? Messages.getString("DisplaySetLabelPopup.PrintStudy") : (this.actionCode == "EXPORT" ? Messages.getString("DisplaySetLabelPopup.ExportStudy") : DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform(this.actionCode).toString());
            if (this.scope == PDataScope.FullStudy) {
                string = String.valueOf(string) + " " + Messages.getString("Export.FullStudy");
            }
            return string;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_ACTION_" + this.actionCode);
            IPerform iPerform = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform(this.actionCode);
            if (this.scope == PDataScope.FullStudy) {
                IDataInfo iDataInfo = DisplaySetLabelPopup.this.displaySet.getOneObject().getParent().getParent().getQueryObject();
                return iPerform.performOnData(DisplaySetLabelPopup.this.getContext(), Collections.singletonList(iDataInfo)).getReturnCode() == 0;
            }
            List list = DisplaySetLabelPopup.this.getData(this.scope == PDataScope.CurrentStudy, this.actionCode.equals("EXPORT"));
            if (list.size() > 0) {
                return iPerform.perform(DisplaySetLabelPopup.this.getContext(), list).getReturnCode() == 0;
            }
            return false;
        }
    }

    private class StoreSecondaryCapture
    extends AnonymousPAction {
        private StoreSecondaryCapture() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.ExportSCDirect");
        }

        @Override
        public boolean isAvailable() {
            if (DisplaySetLabelPopup.this.displaySet.isSecondaryCaptureSaved()) {
                return false;
            }
            return StorageLicense.canStoreSC();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_STORE_SC");
            IPerform iPerform = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform("EXPORT_SC_DIRECT");
            if (iPerform == null) {
                return false;
            }
            if (iPerform.perform(DisplaySetLabelPopup.this.getContext(), Arrays.asList(DisplaySetLabelPopup.this.parentLabel.getDisplaySet().getObjects())).getReturnCode() < 0) {
                Message.warning(Messages.getString("SecondaryCapture.SaveFailed.Title"), Messages.getString("SecondaryCapture.SaveFailed.Message"));
                return false;
            }
            DisplaySetLabelPopup.this.displaySet.setSecondaryCaptureSaved(true);
            List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
            for (VisData visData : list) {
                visData.getView().updateMapping(true);
            }
            DisplaySetLabelPopup.this.parentLabel.invalidate();
            JVision2.getMainFrame().repaintSeriesPalettes();
            return true;
        }
    }
}

