/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.patinfo.DisplaySetScrollPane;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.patinfo.PatScrollPane;
import com.tiani.jvision.patinfo.hanging.HangingController;
import com.tiani.jvision.patinfo.studies.StudyDividerPanel;
import com.tiani.jvision.patinfo.studies.StudyTableController;
import com.tiani.jvision.patinfo.studies.StudyTablePanel;
import com.tiani.jvision.seriespalette.SeriesPalette;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.dcm4che3.data.PersonName;

public class DisplaySetPanel
extends JPanel
implements IDataSelectionListener,
ISelectionListener,
IConfigurationChangeListener {
    private static final int TAB_PATIENTS = 1;
    private static final int TAB_DISPLAYSETS = 0;
    private static final ALogger log = ALogger.getLogger(DisplaySetPanel.class);
    private static List<DisplaySetPanel> instances = new ArrayList<DisplaySetPanel>();
    private static final boolean scrollOnFocusChange = Config.impaxee.jvision.SEQPANEL.ScrollOnFocusChange.get();
    private ImageIcon iconSeq = IconUtil.scaleImageIconForDiagnosticMonitor((ImageIcon)new TIcon("/icons/seriesa1.gif"));
    private ImageIcon iconPat = IconUtil.scaleImageIconForDiagnosticMonitor((ImageIcon)new TIcon("/icons/patienta1.gif"));
    private JTabbedPane tabPane;
    private DisplaySetScrollPane displaySetPane;
    private StudyTablePanel studiesPanel;
    private PatScrollPane patPane;
    private StudyDividerPanel dividerPanel;
    private JLabel labelPatName;
    private JLabel loadingIndicator;
    private CurrentPatientLabelPopupListener patPopupListener = new CurrentPatientLabelPopupListener();

    public DisplaySetPanel() {
        instances.add(this);
        DataSelectionManager.getInstance().addListener(this);
        DataSelectionManager.getInstance().addSelectionListener(this);
        this.setLayout(new BorderLayout());
        this.displaySetPane = new DisplaySetScrollPane(this);
        this.patPane = new PatScrollPane(this);
        this.studiesPanel = new StudyTablePanel(this);
        this.labelPatName = new CurrentPatientLabel(this.patPopupListener);
        this.loadingIndicator = ComponentFactory.instance.createLabel(Messages.getString("PriorLoading"));
        this.loadingIndicator.setAlignmentX(0.5f);
        this.loadingIndicator.setVisible(false);
        this.dividerPanel = new StudyDividerPanel(this.labelPatName, this.studiesPanel, this.displaySetPane, this.loadingIndicator, HangingController.createHangingView());
        this.tabPane = ComponentFactory.instance.createTabbedPane();
        Config.impaxee.jvision.MAPPING.UseAnonymousMode.registerChangeListener(this);
        this.tabPane.add((Component)this.dividerPanel, 0);
        Modes.PaletteOrientation paletteOrientation = JVision2.getMainFrame().getPaletteOrientation();
        if (paletteOrientation.isHorizontal()) {
            this.tabPane.setIconAt(0, this.iconSeq);
        } else {
            this.tabPane.setTitleAt(0, Messages.getString("SEQPANEL_SEQ_TITLE"));
        }
        if (!Product.isReducedVersion()) {
            this.tabPane.add((Component)this.patPane, 1);
            if (paletteOrientation.isHorizontal()) {
                this.tabPane.setIconAt(1, this.iconPat);
            } else {
                this.tabPane.setTitleAt(1, Messages.getString("SEQPANEL_PAT_TITLE"));
            }
        }
        if (paletteOrientation.isHorizontal()) {
            this.tabPane.setTabPlacement(2);
        }
        this.add((Component)this.tabPane, "Center");
        this.updateCurPatLabel();
    }

    public StudyTableController getStudyTableController() {
        return this.studiesPanel != null ? this.studiesPanel.getController() : null;
    }

    void activateDisplaySetTab() {
        this.setActiveTab(0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.displaySetPane.paintComponent(graphics);
    }

    public void addTab(String string, Component component) {
        this.tabPane.addTab(string, component);
        this.tabPane.setSelectedComponent(component);
        this.tabPane.revalidate();
    }

    public void addUnselectedTab(String string, Component component) {
        this.tabPane.addTab(string, component);
        this.tabPane.revalidate();
    }

    public void removeTab(Component component) {
        this.tabPane.setSelectedIndex(0);
        this.tabPane.remove(component);
    }

    private void activateTab(int n) {
        this.setActiveTab(n);
    }

    public DisplaySetScrollPane getSeqPane() {
        return this.displaySetPane;
    }

    public PatScrollPane getPatPane() {
        return this.patPane;
    }

    private void makeTheLastModified(IDisplaySet iDisplaySet) {
        if (iDisplaySet == null) {
            return;
        }
        DisplaySetLabel displaySetLabel = this.displaySetPane.getDisplaySetLabel(iDisplaySet);
        if (displaySetLabel == null) {
            return;
        }
        boolean bl = displaySetLabel.isActive();
        displaySetLabel.setIsActive(true);
        if (!this.hasRelevantSeq(displaySetLabel)) {
            IPatientRepresentation iPatientRepresentation = iDisplaySet.getSplitAndSortRuntime().getPatientRepresentation();
            this.patPane.selectedPatientChanged(iPatientRepresentation);
            DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
        }
        int n = this.displaySetPane.getViewport().getViewPosition().x;
        int n2 = this.displaySetPane.getViewport().getViewPosition().y;
        if (scrollOnFocusChange) {
            Rectangle rectangle = displaySetLabel.getBounds();
            rectangle.y += displaySetLabel.getLastModRect().y;
            rectangle.x += displaySetLabel.getLastModRect().x;
            Container container = displaySetLabel.getParent();
            if (container != null) {
                rectangle.y += container.getBounds().y;
                rectangle.x += container.getBounds().x;
            }
            rectangle.y -= this.displaySetPane.getViewport().getViewPosition().y;
            rectangle.x -= this.displaySetPane.getViewport().getViewPosition().x;
            this.displaySetPane.getViewport().scrollRectToVisible(rectangle);
        }
        if (this.dividerPanel.getSeriesPanel().isVisible() && (!bl || n2 != this.displaySetPane.getViewport().getViewPosition().y && n != this.displaySetPane.getViewport().getViewPosition().x)) {
            this.displaySetPane.paintImmediately(0, 0, this.displaySetPane.getBounds().width, this.displaySetPane.getBounds().height);
        }
    }

    private void removeTheLastModified() {
        List<DisplaySetLabel> list = this.displaySetPane.getDisplaySetLabels();
        for (DisplaySetLabel displaySetLabel : list) {
            if (!displaySetLabel.isActive()) continue;
            displaySetLabel.setIsActive(false);
            displaySetLabel.repaint();
            break;
        }
    }

    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void installListeners() {
        this.displaySetPane.installListeners();
    }

    private boolean hasRelevantSeq(DisplaySetLabel displaySetLabel) {
        return this.indexOfRelevant(displaySetLabel) != -1;
    }

    private int indexOfRelevant(DisplaySetLabel displaySetLabel) {
        return this.displaySetPane.getDisplaySetLabels().indexOf(displaySetLabel);
    }

    private void updateCurPatLabel() {
        String string = null;
        if (!Config.impaxee.jvision.MAPPING.UseAnonymousMode.get()) {
            try {
                IPatientData iPatientData;
                IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
                IPatientData iPatientData2 = iPatientData = iPatientRepresentation != null ? iPatientRepresentation.getPatientData() : null;
                if (iPatientData != null) {
                    PersonName personName = new PersonName(iPatientData.resolveString(0x100010), true);
                    string = PersonNameUtilities.personNameToHRReverseShort((PersonName)personName);
                }
            }
            catch (Exception exception) {
                log.warn("Resolving patient named failed!", (Throwable)exception);
            }
        } else {
            string = "";
        }
        this.labelPatName.setText(string);
        this.labelPatName.paintImmediately(0, 0, this.labelPatName.getSize().width, this.labelPatName.getSize().height);
    }

    private void setActiveTab(int n) {
        if (this.tabPane.getTabCount() > n) {
            this.tabPane.setSelectedIndex(n);
        }
    }

    @Override
    public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
        this.removeTheLastModified();
        if (visDisplayData != null) {
            this.makeTheLastModified(visDisplayData.getDisplaySet());
        }
    }

    private boolean isHidden() {
        if (this.getParent() instanceof SeriesPalette) {
            return ((SeriesPalette)this.getParent()).isHidden();
        }
        return true;
    }

    @Override
    public void newActiveStudySelected(IStudyData iStudyData) {
    }

    @Override
    public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
    }

    @Override
    public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
        this.loadingIndicator.setVisible(false);
        this.updateCurPatLabel();
        if (this.isHidden()) {
            return;
        }
        if (!scrollOnFocusChange) {
            this.displaySetPane.getHorizontalScrollBar().setValue(0);
            this.displaySetPane.getVerticalScrollBar().setValue(0);
        }
        this.activateTab(iPatientRepresentation2 != null || DataManager.getInstance().getPatientCount() == 0 ? 0 : 1);
    }

    @Override
    public void patientClicked(IPatientData iPatientData, int n) {
    }

    @Override
    public void notifyPriorStudyLoadingInProgress(boolean bl) {
        this.loadingIndicator.setVisible(bl);
    }

    @Override
    public void priorsChanged() {
        this.repaint();
    }

    public void addTabSelectionListener(ChangeListener changeListener) {
        this.tabPane.addChangeListener(changeListener);
    }

    public void removeTabSelectionListener(ChangeListener changeListener) {
        this.tabPane.removeChangeListener(changeListener);
    }

    public void configurationChanged(String string) {
        this.updateCurPatLabel();
    }

    public static class CurrentPatientLabel
    extends JLabel {
        private CurrentPatientLabel(CurrentPatientLabelPopupListener currentPatientLabelPopupListener) {
            ComponentFactory.instance.scaleFont(this);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setFont(this.getFont().deriveFont(1));
            this.addMouseListener(currentPatientLabelPopupListener);
        }
    }

    private static class CurrentPatientLabelPopupListener
    extends MouseAdapter
    implements ActionListener {
        private static final String REMOVE_PATIENT_COMMAND = "REMOVE";

        private CurrentPatientLabelPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IPatientRepresentation iPatientRepresentation;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && (iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient()) != null) {
                JMenuItem jMenuItem = ComponentFactory.instance.createMenuItem(Messages.getString("SEQPANEL_POPUP_DELETE_PAT"));
                jMenuItem.setActionCommand(REMOVE_PATIENT_COMMAND);
                jMenuItem.addActionListener(this);
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (REMOVE_PATIENT_COMMAND.equals(string)) {
                IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
                try {
                    if (iPatientRepresentation != null) {
                        DataManager.getInstance().removePatient(iPatientRepresentation.getPatientData().getKey(), true, false);
                    }
                }
                catch (Exception exception) {
                    log.error("Removing current patient failed!", (Throwable)exception);
                }
            }
        }
    }
}

