/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DisplaySetListenerAdapter;
import com.agfa.pacs.impaxee.data.manager.IDisplaySetListener;
import com.agfa.pacs.impaxee.hanging.DisplaySetUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.patinfo.DisplaySetLabelGroup;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.patinfo.studies.StudyTableController;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class DisplaySetScrollPane
extends JScrollPane {
    private static final ALogger LOG = ALogger.getLogger(DisplaySetScrollPane.class);
    private DisplaySetPanel seqPanel = null;
    private JPanel panel = null;
    private Map<String, DisplaySetLabelGroup> groups = new LinkedHashMap<String, DisplaySetLabelGroup>();
    private String patientID = null;
    private DisplaySetUpdatingDataSelectionManagerListener dataSelectionListener = new DisplaySetUpdatingDataSelectionManagerListener();
    private IDisplaySetListener displaySetListener = new SeriesPaletteDisplaySetListener();

    DisplaySetScrollPane(DisplaySetPanel displaySetPanel) {
        super(JVision2.getMainFrame().getPaletteOrientation().isHorizontal() ? 21 : 20, JVision2.getMainFrame().getPaletteOrientation().isHorizontal() ? 30 : 31);
        this.seqPanel = displaySetPanel;
        int n = DisplaySetLabel.tokenSize + DisplaySetLabel.infoHeight;
        this.getHorizontalScrollBar().setUnitIncrement(DisplaySetLabel.tokenSize);
        this.getVerticalScrollBar().setUnitIncrement(n);
        this.getHorizontalScrollBar().setBlockIncrement(DisplaySetLabel.tokenSize * 2);
        this.getVerticalScrollBar().setBlockIncrement(n);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                for (DisplaySetLabelGroup displaySetLabelGroup : DisplaySetScrollPane.this.groups.values()) {
                    displaySetLabelGroup.setHighlighted(false);
                }
            }
        });
        this.panel = new JPanel(JVision2.getMainFrame().getPaletteOrientation().isHorizontal() ? new HorizontalLabelGroupLayout() : new RowLayout(0, false, false));
        this.getViewport().add(this.panel);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setDisplaySetLabelsParentWidth();
    }

    public List<DisplaySetLabel> getDisplaySetLabels() {
        ArrayList<DisplaySetLabel> arrayList = new ArrayList<DisplaySetLabel>(32);
        if (this.groups != null) {
            for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
                arrayList.addAll(displaySetLabelGroup.getDisplaySetLabels());
            }
        }
        return arrayList;
    }

    DisplaySetPanel getSequencePanel() {
        return this.seqPanel;
    }

    void installListeners() {
        DataManager.getInstance().addDisplaySetListener(this.displaySetListener);
        DataSelectionManager.getInstance().addListener(this.dataSelectionListener);
        DataSelectionManager.getInstance().addSelectionListener(this.dataSelectionListener);
    }

    DisplaySetLabel getDisplaySetLabel(IDisplaySet iDisplaySet) {
        DisplaySetLabelGroup displaySetLabelGroup = this.findGroupForStudy(iDisplaySet.getStudy());
        return displaySetLabelGroup != null ? displaySetLabelGroup.findDisplaySetLabel(iDisplaySet) : null;
    }

    public void openStudy(IStudyData iStudyData) {
        DisplaySetLabelGroup displaySetLabelGroup = this.groups.get(iStudyData.getKey());
        if (displaySetLabelGroup != null) {
            displaySetLabelGroup.open();
        }
    }

    public boolean isStudyOpen(IStudyData iStudyData) {
        String string = iStudyData.getKey();
        DisplaySetLabelGroup displaySetLabelGroup = this.groups.get(string);
        if (displaySetLabelGroup != null) {
            return displaySetLabelGroup.isOpen();
        }
        return DisplaySetLabelGroup.isOpenByDefault(string);
    }

    public void closeStudy(IStudyData iStudyData) {
        DisplaySetLabelGroup displaySetLabelGroup = this.groups.get(iStudyData.getKey());
        if (displaySetLabelGroup != null) {
            displaySetLabelGroup.close();
        }
    }

    public String getCurrentPatientID() {
        return this.patientID;
    }

    public void jumpToStudy(IStudyData iStudyData, boolean bl) {
        DisplaySetLabelGroup displaySetLabelGroup = null;
        for (DisplaySetLabelGroup displaySetLabelGroup2 : this.groups.values()) {
            if (displaySetLabelGroup2.getStudy().getKey().equals(iStudyData.getKey())) {
                displaySetLabelGroup = displaySetLabelGroup2;
                continue;
            }
            displaySetLabelGroup2.setHighlighted(false);
        }
        if (displaySetLabelGroup != null) {
            displaySetLabelGroup.jumpTo();
            if (bl) {
                displaySetLabelGroup.setHighlighted(true);
            }
        }
    }

    public void reInit() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        this.init(DataSelectionManager.getInstance().getCurrentPatient(), iHanging == null ? null : iHanging.getSplitAndSortRuntime());
    }

    private void init(IPatientRepresentation iPatientRepresentation, ISplitAndSortRuntime iSplitAndSortRuntime) {
        if (iPatientRepresentation == null || !CompareUtils.equals((Object)this.patientID, (Object)iPatientRepresentation.getPatientKey())) {
            this.patientID = iPatientRepresentation == null ? null : iPatientRepresentation.getPatientKey();
            this.initDisplaySetLabels(iPatientRepresentation, iSplitAndSortRuntime);
        }
    }

    void updateDisplaySetLabelGroups(Collection<DisplaySetLabelGroup> collection) {
        for (DisplaySetLabelGroup displaySetLabelGroup : collection) {
            displaySetLabelGroup.updateLayout();
        }
        this.revalidate();
        this.repaint();
    }

    private void initDisplaySetLabels(IPatientRepresentation iPatientRepresentation, ISplitAndSortRuntime iSplitAndSortRuntime) {
        IDisplaySet[] iDisplaySetArray2;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (this.groups != null) {
            for (Map.Entry object2 : this.groups.entrySet()) {
                hashMap.put((String)object2.getKey(), ((DisplaySetLabelGroup)object2.getValue()).isOpen());
            }
        }
        List<DisplaySetLabel> list = this.getDisplaySetLabels();
        HashMap hashMap2 = new HashMap(list.size());
        for (IDisplaySet[] iDisplaySetArray2 : list) {
            hashMap2.put(iDisplaySetArray2.getDisplaySet(), iDisplaySetArray2.isActive());
        }
        this.removeAllDisplaySetLabels();
        if (iPatientRepresentation != null && (iDisplaySetArray2 = iSplitAndSortRuntime.getDisplaySets()) != null) {
            List<String> list2 = this.getStudyOrdering(iPatientRepresentation);
            IDisplaySet[] iDisplaySetArray3 = iDisplaySetArray2;
            int n = iDisplaySetArray2.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplaySet iDisplaySet = iDisplaySetArray3[n2];
                DisplaySetLabel displaySetLabel = this.createDisplaySetLabel(iPatientRepresentation, iDisplaySet);
                if (displaySetLabel != null) {
                    DisplaySetLabelGroup displaySetLabelGroup;
                    Boolean bl = (Boolean)hashMap2.get(iDisplaySet);
                    if (bl != null) {
                        displaySetLabel.setIsActive(bl);
                    }
                    if ((displaySetLabelGroup = this.findGroupForStudy(iDisplaySet.getStudy())) == null) {
                        displaySetLabelGroup = new DisplaySetLabelGroup(this, iSplitAndSortRuntime, iDisplaySet.getStudy());
                        Boolean bl2 = (Boolean)hashMap.get(displaySetLabelGroup.getStudy().getKey());
                        if (bl2 != null) {
                            if (bl2.booleanValue()) {
                                displaySetLabelGroup.open();
                            } else {
                                displaySetLabelGroup.close();
                            }
                        }
                        this.groups.put(iDisplaySet.getStudyUID(), displaySetLabelGroup);
                        List<String> list3 = this.intersection(this.groups.keySet(), list2);
                        this.panel.add((Component)displaySetLabelGroup, list3.indexOf(iDisplaySet.getStudyUID()));
                    }
                    displaySetLabelGroup.addDisplaySetLabel(displaySetLabel);
                    displaySetLabel.postGUIInit();
                }
                ++n2;
            }
            for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
                displaySetLabelGroup.updateLayout();
            }
        }
        this.redraw();
    }

    private List<String> intersection(Set<String> set, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            if (!set.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private DisplaySetLabel createDisplaySetLabel(IPatientRepresentation iPatientRepresentation, IDisplaySet iDisplaySet) {
        if (iPatientRepresentation != null) {
            if (iDisplaySet instanceof ISessionDisplaySet && iDisplaySet.getSplitAndSortRuntime().getPatientRepresentation() != iPatientRepresentation) {
                return null;
            }
            return new DisplaySetLabel(iDisplaySet);
        }
        return null;
    }

    private DisplaySetLabelGroup findGroupForStudy(IStudyData iStudyData) {
        if (iStudyData == null) {
            return null;
        }
        return this.groups.get(iStudyData.getKey());
    }

    private List<String> getStudyOrdering(IPatientRepresentation iPatientRepresentation) {
        return iPatientRepresentation.getDecompositionRuntime().getStudyOrdering();
    }

    private void removeAllDisplaySetLabels() {
        for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
            displaySetLabelGroup.removeAllDisplaySetLabels();
            this.remove(displaySetLabelGroup);
        }
        this.groups.clear();
        this.panel.removeAll();
    }

    public void updateLayout() {
        for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
            displaySetLabelGroup.updateLayout();
        }
        this.redraw();
    }

    private void redraw() {
        this.seqPanel.getTabPane().doLayout();
        this.seqPanel.getTabPane().validate();
        this.seqPanel.getTabPane().repaint();
        this.repaint();
    }

    private void setDisplaySetLabelsParentWidth() {
        int n = 0;
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        if (jScrollBar != null) {
            n = jScrollBar.getWidth();
        }
        if (!JVision2.getMainFrame().getPaletteOrientation().isHorizontal()) {
            int n2 = (int)this.getSize().getWidth() - n;
            if (this.groups != null) {
                for (Map.Entry<String, DisplaySetLabelGroup> entry : this.groups.entrySet()) {
                    DisplaySetLabelGroup displaySetLabelGroup = entry.getValue();
                    List<DisplaySetLabel> list = displaySetLabelGroup.getDisplaySetLabels();
                    for (DisplaySetLabel displaySetLabel : list) {
                        displaySetLabel.setParentWidth(n2);
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
            stringBuilder.append(displaySetLabelGroup.getStudy().getKey()).append(',');
        }
        stringBuilder.append('\n').append(super.toString());
        return stringBuilder.toString();
    }

    private class DisplaySetUpdatingDataSelectionManagerListener
    extends DataSelectionListenerAdapter
    implements ISelectionListener {
        private int previousDisplaySetID;

        private DisplaySetUpdatingDataSelectionManagerListener() {
        }

        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            DisplaySetScrollPane.this.init(iPatientRepresentation2, iPatientRepresentation2 == null ? null : iPatientRepresentation2.getDecompositionRuntime());
        }

        @Override
        public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
            if (iPatientRepresentation != null && iPatientRepresentation.getPatientKey().equals(DisplaySetScrollPane.this.patientID) && (bl || iHanging instanceof Session || iHanging2 instanceof Session)) {
                DisplaySetScrollPane.this.initDisplaySetLabels(iPatientRepresentation, iHanging2.getSplitAndSortRuntime());
            }
        }

        @Override
        public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
            if (n != this.previousDisplaySetID && visDisplayData != null && visDisplayData.getDisplaySet() != null) {
                this.previousDisplaySetID = n;
                try {
                    String string = visDisplayData.getDisplaySet().getOneObject().getParent().getParent().getParent().getKey();
                    if (!Objects.equals(string, DisplaySetScrollPane.this.patientID) && !DataSelectionManager.getInstance().isMultiPatientCompareActive()) {
                        LOG.warn("Patient change in display set, by last modified");
                        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(string);
                        this.newPatientSelected(DataSelectionManager.getInstance(), null, iPatientRepresentation, null);
                    }
                }
                catch (Exception exception) {
                    LOG.error("Error on handling last modified change", (Throwable)exception);
                }
            }
        }
    }

    private static class HorizontalLabelGroupLayout
    implements LayoutManager {
        private HorizontalLabelGroupLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                Dimension dimension = component.getPreferredSize();
                n += dimension.width;
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                ++n4;
            }
            return new Dimension(n += container.getInsets().left + container.getInsets().right, n2 += container.getInsets().top + container.getInsets().bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                Dimension dimension = component.getPreferredSize();
                n += dimension.width;
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                ++n4;
            }
            return new Dimension(n += container.getInsets().left + container.getInsets().right, n2 += container.getInsets().top + container.getInsets().bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = 0;
            Component[] componentArray = container.getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Component component = componentArray[n3];
                Dimension dimension = component.getPreferredSize();
                if (dimension.height > n) {
                    n = dimension.height;
                }
                ++n3;
            }
            int n4 = container.getInsets().left;
            n3 = container.getInsets().top;
            Component[] componentArray2 = container.getComponents();
            int n5 = componentArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                Component component = componentArray2[n6];
                component.setBounds(n4, n3, component.getPreferredSize().width, n);
                n4 += component.getPreferredSize().width;
                ++n6;
            }
        }
    }

    private class SeriesPaletteDisplaySetListener
    extends DisplaySetListenerAdapter {
        private SeriesPaletteDisplaySetListener() {
        }

        @Override
        public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray, SplitAndSortChangeType splitAndSortChangeType) {
            HashSet<DisplaySetLabelGroup> hashSet = new HashSet<DisplaySetLabelGroup>();
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
            int n = iDisplaySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisplaySetLabel displaySetLabel;
                IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                DisplaySetLabelGroup displaySetLabelGroup = DisplaySetScrollPane.this.findGroupForStudy(iDisplaySet.getStudy());
                DisplaySetLabel displaySetLabel2 = displaySetLabel = displaySetLabelGroup != null ? displaySetLabelGroup.findDisplaySetLabel(iDisplaySet) : null;
                if (displaySetLabel != null && displaySetLabelGroup != null) {
                    displaySetLabelGroup.removeDisplaySetLabel(displaySetLabel);
                    if (displaySetLabelGroup.getNumberOfDisplaySetLabels() == 0) {
                        DisplaySetScrollPane.this.groups.remove(iDisplaySet.getStudyUID());
                        DisplaySetScrollPane.this.panel.remove(displaySetLabelGroup);
                        hashSet.remove(displaySetLabelGroup);
                    } else {
                        hashSet.add(displaySetLabelGroup);
                    }
                }
                ++n2;
            }
            DisplaySetScrollPane.this.updateDisplaySetLabelGroups(hashSet);
        }

        @Override
        public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list, SplitAndSortChangeType splitAndSortChangeType) {
            if (!iPatientRepresentation.getPatientKey().equals(DisplaySetScrollPane.this.patientID)) {
                return;
            }
            HashSet<DisplaySetLabelGroup> hashSet = new HashSet<DisplaySetLabelGroup>();
            List list2 = DisplaySetScrollPane.this.getStudyOrdering(iPatientRepresentation);
            for (IDisplaySet iDisplaySet : list) {
                DisplaySetLabel displaySetLabel;
                IStudyData iStudyData = DisplaySetUtils.getStudy(iDisplaySet);
                DisplaySetLabelGroup displaySetLabelGroup = DisplaySetScrollPane.this.findGroupForStudy(iStudyData);
                if (displaySetLabelGroup != null) {
                    iDisplaySet = displaySetLabelGroup.findDisplaySet(iDisplaySet);
                }
                if ((displaySetLabel = DisplaySetScrollPane.this.createDisplaySetLabel(iPatientRepresentation, iDisplaySet)) == null) continue;
                if (displaySetLabelGroup == null && iStudyData != null) {
                    Object object;
                    displaySetLabelGroup = new DisplaySetLabelGroup(DisplaySetScrollPane.this, iDisplaySet.getSplitAndSortRuntime(), iStudyData);
                    if (DisplaySetScrollPane.this.seqPanel != null && (object = DisplaySetScrollPane.this.seqPanel.getStudyTableController()) != null && ((StudyTableController)object).isStudyOpened(iStudyData.getKey())) {
                        displaySetLabelGroup.open();
                    }
                    DisplaySetScrollPane.this.groups.put(iStudyData.getKey(), displaySetLabelGroup);
                    object = DisplaySetScrollPane.this.intersection(DisplaySetScrollPane.this.groups.keySet(), list2);
                    DisplaySetScrollPane.this.panel.add((Component)displaySetLabelGroup, object.indexOf(iStudyData.getKey()));
                }
                if (displaySetLabelGroup == null || displaySetLabelGroup.findDisplaySetLabel(iDisplaySet) != null) continue;
                displaySetLabelGroup.addDisplaySetLabel(displaySetLabel);
                hashSet.add(displaySetLabelGroup);
                displaySetLabel.postGUIInit();
            }
            DisplaySetScrollPane.this.updateDisplaySetLabelGroups(hashSet);
        }

        @Override
        public void repaintDisplaySets() {
            DisplaySetScrollPane.this.repaint();
        }
    }
}

